/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.InterruptedIOException;
import java.util.Enumeration;
import java.util.Iterator;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.DurableSubscriptionUtil;
import progress.message.broker.FlowToDiskMemoryManager;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.IClientContext;
import progress.message.broker.MsgSaver;
import progress.message.broker.OffloadedPubSubMessage;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.client.EUnsupportedMgramException;
import progress.message.db.EDatabaseException;
import progress.message.msg.IMgram;
import progress.message.util.server.EpochClock;
import progress.message.zclient.DebugThread;
import progress.message.zclient.ISubject;
import progress.message.zclient.SessionConfig;

public class OffloadedMsgRestorer
extends DebugThread {
    private IClientContext m_cc = null;
    private MsgSaver m_saver = null;
    private boolean m_restoreCancelled = false;
    private boolean m_restoreCompleted = true;
    private BrokerDatabase m_brokerDB = null;
    private boolean m_interruptable = false;
    private boolean m_exit = false;
    private int idleTimeout = 60000;

    synchronized void cancelRestoreAndWait(boolean exit) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("cancelRestoreAndWait called: exit = " + exit + ", m_restoreCompleted = " + this.m_restoreCompleted + ",  m_interruptable " + this.m_interruptable);
        }
        this.m_restoreCancelled = true;
        this.m_exit = exit;
        if (this.m_interruptable) {
            this.interrupt();
        }
        while (!this.m_restoreCompleted && this.isAlive()) {
            this.wait(60000L);
        }
        if (this.DEBUG) {
            this.debug("Leaving cancelRestoreAndWait: m_restoreCompleted = " + this.m_restoreCompleted);
        }
    }

    public synchronized boolean isRestorerExiting() {
        return this.m_exit;
    }

    private synchronized void makeInterruptable() {
        this.m_interruptable = true;
    }

    private synchronized boolean makeUninterruptable() {
        this.m_interruptable = false;
        return OffloadedMsgRestorer.interrupted();
    }

    private synchronized boolean isRestoreCancelled() {
        if (this.DEBUG && (Broker.exiting || this.m_restoreCancelled)) {
            this.debug("Broker exiting=true; restoreCancelled= " + this.m_restoreCancelled);
        }
        return this.m_restoreCancelled || Broker.exiting;
    }

    OffloadedMsgRestorer(IClientContext cc, MsgSaver saver) {
        super("OffloadedMsgRestorer " + cc.getUid() + "/" + cc.getAppid());
        this.m_cc = cc;
        this.m_saver = saver;
        this.m_brokerDB = AgentRegistrar.getAgentRegistrar().getBrokerDatabase();
    }

    private void acknowledge(long tracking, int size, boolean notify, boolean syncPersist) {
        if (this.DEBUG) {
            this.debug("restored offloaded message acknowledged");
        }
        this.m_saver.deleteMsg(this.m_cc, tracking, size, notify, syncPersist);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void threadMain() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[MONITOR]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processMessage(IMgram messageParam, long tracking, int trackedSize, OffloadedPubSubMessage offloadedMsg, boolean fromDB) throws EDatabaseException, EGeneralException, InterruptedException, InterruptedIOException {
        IMgram message = messageParam;
        if (message == null) {
            message = this.m_brokerDB.getOffloadedMgram(tracking, this.m_cc.getId());
            if (this.isRestoreCancelled()) {
                return true;
            }
            if (message == null) {
                return false;
            }
            message.getBrokerHandle().setTrackedSize(trackedSize);
            if (!this.m_cc.isGroupSubscription()) {
                message.setSuccessor(false);
            }
            message.getBrokerHandle().setFromDB(true);
            if (GroupSubscriptionClientContext.s_limitClusterHops) {
                message.getBrokerHandle().setSenderID(offloadedMsg.getSenderID());
            }
            if (message.isGuarenteed()) {
                if (!offloadedMsg.isGuaranteed()) {
                    message.getBrokerHandle().setGuarFormatIncorrect(true);
                }
            } else if (offloadedMsg.isGuaranteed()) {
                message.getBrokerHandle().setGuarFormatIncorrect(true);
            }
            if (message.isTTE() && message.getTTE() <= EpochClock.getTime()) {
                if (message.getBrokerHandle().isFromDB()) {
                    this.acknowledge(tracking, message.getBrokerHandle().getTrackedSize(), false, message.isGuarenteed());
                }
                return false;
            }
        }
        if (this.DEBUG) {
            this.debug("restoring offloaded message " + tracking + ", fromDB = " + fromDB);
        }
        try {
            this.makeInterruptable();
            if (!offloadedMsg.isGuaranteed() && fromDB && !this.isRestoreCancelled()) {
                if (message.getType() != 27) {
                    this.acknowledge(tracking, message.getBrokerHandle().getTrackedSize(), false, false);
                } else {
                    Iterator iter = message.getBatchHandle().getBatchIterator();
                    while (iter.hasNext()) {
                        IMgram subMgram = (IMgram)iter.next();
                        this.acknowledge(subMgram.getBrokerHandle().getDbTracking(), subMgram.getBrokerHandle().getTrackedSize(), false, false);
                    }
                }
            }
            if (this.isRestoreCancelled() || !this.m_cc.addRestoredMgram(message, false, false)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.makeUninterruptable();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOffloadedMsg(OffloadedPubSubMessage offloadedMsg, long trackingParam, IMgram message, boolean fromDB, boolean retrievedFromMsgSaver, boolean processBatchSubMgrams, boolean continuousBatch) throws EDatabaseException, EGeneralException, InterruptedException, InterruptedIOException {
        long tracking = trackingParam;
        boolean moreMessages = true;
        boolean restoreCancelled = false;
        int ii = 0;
        while (moreMessages) {
            int trackedSize = offloadedMsg.getBatchSize() > 1 ? offloadedMsg.getTrackedSizes()[ii] : offloadedMsg.getTrackedSize();
            boolean canceled = true;
            try {
                canceled = this.processMessage(message, tracking, trackedSize, offloadedMsg, fromDB);
            }
            finally {
                if (canceled) {
                    if (retrievedFromMsgSaver && offloadedMsg.isGuaranteed() && !fromDB) {
                        this.m_cc.notifySave(message, true);
                        this.m_saver.save(message, this.m_cc, message.isSuccessor(), false, true);
                    }
                    restoreCancelled = true;
                    break;
                }
            }
            if (!processBatchSubMgrams) {
                moreMessages = false;
                continue;
            }
            if (++ii < offloadedMsg.getBatchSize()) {
                if (continuousBatch) {
                    ++tracking;
                    tracking &= 0xFFFFFFFFFFFFL;
                    continue;
                }
                tracking = offloadedMsg.getTrackingNums()[ii];
                continue;
            }
            moreMessages = false;
        }
        return restoreCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRestore() {
        OffloadedPubSubMessage offloadedMsg = null;
        IMgram message = null;
        long tracking = -1L;
        boolean retrievedFromMsgSaver = false;
        boolean fromDB = false;
        boolean canceled = false;
        if (this.DEBUG) {
            this.debug("Entered doRestore");
        }
        try {
            if (this.isRestoreCancelled()) {
                return;
            }
            this.m_cc.setRestoringOffloaded(true);
            while (!this.isRestoreCancelled() && !canceled && (offloadedMsg = this.m_cc.dequeueOffloaded()) != null) {
                fromDB = false;
                canceled = true;
                try {
                    tracking = offloadedMsg.getTracking();
                    message = this.m_saver.retrieveMessageForRecipient(offloadedMsg.getMsgSaverOpIndx(), this.m_cc);
                    if (message == null) {
                        retrievedFromMsgSaver = false;
                        fromDB = true;
                    } else {
                        retrievedFromMsgSaver = true;
                        if (message.getType() != 27) {
                            fromDB = message.getBrokerHandle().isFromDB();
                        } else {
                            Iterator iter = message.getBatchHandle().getBatchIterator();
                            if (iter.hasNext()) {
                                IMgram firstSubMgram = (IMgram)iter.next();
                                fromDB = firstSubMgram.getBrokerHandle().isFromDB();
                            }
                        }
                    }
                    boolean processBatchSubMgrams = false;
                    boolean continuousBatch = true;
                    if (message == null && offloadedMsg.getBatchSize() > 1) {
                        processBatchSubMgrams = true;
                        if (offloadedMsg.getTrackingNums() == null) {
                            continuousBatch = true;
                        } else {
                            continuousBatch = false;
                            tracking = offloadedMsg.getTrackingNums()[0];
                        }
                    } else {
                        processBatchSubMgrams = false;
                    }
                    canceled = this.processOffloadedMsg(offloadedMsg, tracking, message, fromDB, retrievedFromMsgSaver, processBatchSubMgrams, continuousBatch);
                }
                finally {
                    int size = this.m_cc.completeOffloadedMessageRestore(offloadedMsg);
                    FlowToDiskMemoryManager.getFlowToDiskMemoryManager().updateMemorySize(-size, null, null);
                }
            }
            if (this.isRestoreCancelled() || canceled) {
                return;
            }
            this.m_cc.setMsgsInDb(false);
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        catch (InterruptedIOException e) {
            return;
        }
        catch (EDatabaseException e) {
            if (!Broker.exiting) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR220") + this.m_cc.getUid() + "/" + this.m_cc.getAppid() + ": " + e.getMessage(), (Throwable)e, 2);
                return;
            }
            return;
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR220") + this.m_cc.getUid() + "/" + this.m_cc.getAppid() + ": " + e.getMessage(), (Throwable)e, 2);
        }
        catch (EUnsupportedMgramException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 1);
        }
        finally {
            this.m_cc.setRestoringOffloaded(false);
        }
    }

    static void sendFlowToDiskStateChangeNotification(IClientContext cc, boolean ftdStarted) {
        String appid = cc.getAppid();
        String connectID = null;
        String user = cc.getUid();
        String durableClientID = null;
        String durableSubscriptionName = null;
        Enumeration subscribedSubjects = cc.getSubscriptions().keys();
        StringBuffer buf = new StringBuffer();
        boolean firstSubject = true;
        while (subscribedSubjects.hasMoreElements()) {
            ISubject subject = (ISubject)subscribedSubjects.nextElement();
            if (SessionConfig.isSystemSubject(subject)) continue;
            if (firstSubject) {
                firstSubject = false;
            } else {
                buf.append(',');
            }
            buf.append(subject.getSubjectString());
        }
        String topic = buf.toString();
        if (cc.isDurable()) {
            connectID = DurableSubscriptionUtil.getConnectID(appid, cc);
            durableClientID = DurableSubscriptionUtil.getJMSClientID(appid);
            durableSubscriptionName = DurableSubscriptionUtil.getSubscriptionName(appid);
            if (connectID == null) {
                connectID = "";
            }
            if (durableClientID == null) {
                durableClientID = "";
            }
            if (durableSubscriptionName == null) {
                durableSubscriptionName = "";
            }
        } else {
            try {
                connectID = SessionConfig.getConnectIDFromSubscriberAppid(appid);
            }
            catch (IllegalArgumentException iae) {
                connectID = appid;
            }
            durableClientID = "";
            durableSubscriptionName = "";
            if (connectID == null) {
                connectID = "";
            }
        }
        BrokerManagementNotificationsHelper.sendFlowToDiskNotification(connectID, user, durableClientID, durableSubscriptionName, topic, ftdStarted);
    }
}

