/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mq.components.BrokerComponent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.ClientContextCreator;
import progress.message.broker.EOperationCancelled;
import progress.message.broker.IClientContext;
import progress.message.broker.LogFile;
import progress.message.broker.LogStreamFile;
import progress.message.broker.SyncpointLoc;
import progress.message.client.EGeneralException;
import progress.message.db.DBFactory;
import progress.message.db.Db;
import progress.message.db.EDatabaseException;
import progress.message.dbq.DBQSetup;
import progress.message.dbq.IDupDetectDBQ;
import progress.message.dbq.IInitDbDBQ;
import progress.message.dbq.IRegDBQ;
import progress.message.dbq.IRoutingDBQ;
import progress.message.dbsc.data.IDbDataEnum;
import progress.message.dbsc.data.IDbDupDetectData;
import progress.message.dbsc.data.IDbQueueData;
import progress.message.dd.NoDupDetectDbConnection;
import progress.message.gr.RouteInfo;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.LongHashTable;
import progress.message.util.server.OStream;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.SessionConfig;

public class SyncBrokerDatabase
extends DebugObject {
    private IComponentContext m_context;
    private Properties m_props;
    private String m_sourceInstallDir;

    public SyncBrokerDatabase(IComponentContext context, Properties props, String sourceInstallDir) {
        super(DebugState.GLOBAL_DEBUG_ON ? "SyncBrokerDatabase" : null);
        this.m_sourceInstallDir = sourceInstallDir;
        this.m_context = context;
        this.m_props = props;
    }

    public void execute() throws Exception {
        Broker target = new Broker();
        target.loadTargetConfigProperties(this.m_props);
        if (target.REPLICATED) {
            Broker source = new Broker();
            source.loadSourceConfigProperties(this.m_props, this.m_sourceInstallDir, target.LOG_BLOCK_SIZE);
            this.sync(source, target);
        } else {
            this.m_context.logMessage("Broker not replicated, cannot synchronize.", 1);
        }
    }

    private void sync(Broker source, Broker target) throws Exception {
        try {
            this.log("Starting SonicMQ Storage Synchronization from: " + this.m_sourceInstallDir);
            source.initialize();
            target.initialize();
            this.initializeBrokerStates(source, target);
            this.log("Starting Recovery Log Synchronization...");
            this.syncLogFiles(source, target);
            this.syncBrokerInfo(source, target);
            this.log("Recovery Log Synchronization Complete.");
            this.log("Starting Queue Synchronization...");
            this.syncQueues(source, target);
            this.log("Queue Synchronization Complete.");
            this.log("Starting Client Registry Synchronization...");
            this.syncClientRegistry(source, target);
            this.log("Client Registry Synchronization Complete.");
            this.log("Starting PubSub Store Synchronization...");
            this.syncDurableSubStore(source, target);
            this.log("PubSub Store Synchronization Complete.");
            this.log("Starting DRA Registry Synchronization...");
            this.syncRBRegistry(source, target);
            this.syncRouteInfo(source, target);
            this.log("DRA Registry Synchronization Complete");
            this.log("Starting Transaction File Synchronization...");
            this.syncTxnFiles(source, target);
            this.log("Transaction File Synchronization Complete.");
            if (!target.INDEXED_TXN_DB_SHARED) {
                this.log("Starting Duplicate Detection Synchronization...");
                this.syncDupDetect(source, target);
                this.log("Duplicate Detection Synchronization Complete.");
            } else {
                this.log("Detected Shared Duplicate Detection Database ...  Synchronization Skipped...");
            }
            this.log("Completing SonicMQ Storage Synchronization...");
            this.finalizeBrokerStates(source, target);
            this.log("SonicMQ Storage Synchronization Complete.");
        }
        catch (EDatabaseException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new Exception("Unexpected EDatabaseException occurred while synchronizing the message store");
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new Exception("Unexpected IOException occurred while copying the log files");
        }
        catch (Throwable thrown) {
            BrokerComponent.getComponentContext().logMessage(thrown, 2);
            throw new Exception("Error occurred while synchronizing the message store");
        }
        finally {
            source.close();
            target.close();
        }
    }

    private void initializeBrokerStates(Broker source, Broker target) throws EDatabaseException, IllegalStateException {
        IRegDBQ sourceRegDBQ = source.getBrokerDatabase().getIRegDBQ();
        int sourceState = sourceRegDBQ.getBrokerLastKnownState();
        if (sourceState == 5) {
            throw new IllegalStateException("Cannot synchronize from a broker with a last known state of STANDBY_SYNC");
        }
        IRegDBQ targetRegDBQ = target.getBrokerDatabase().getIRegDBQ();
        targetRegDBQ.setBrokerLastKnownState(5);
    }

    private void finalizeBrokerStates(Broker source, Broker target) throws EDatabaseException {
        IRegDBQ sourceRegDBQ = source.getBrokerDatabase().getIRegDBQ();
        IRegDBQ targetRegDBQ = target.getBrokerDatabase().getIRegDBQ();
        sourceRegDBQ.setBrokerLastKnownState(0);
        targetRegDBQ.setBrokerLastKnownState(0);
    }

    private void syncLogFiles(Broker source, Broker target) throws IOException {
        source.m_log.copy(target.LOG_PATH);
        if (this.DEBUG) {
            this.debug("copied log files to " + target.LOG_PATH);
        }
        long sourceLogTime = source.m_log.getTimestamp();
        if (this.DEBUG) {
            this.debug("source log time is " + new Date(sourceLogTime));
        }
        target.m_initDBQ.initializeLogTime(sourceLogTime);
        if (this.DEBUG) {
            this.debug("target log time is now: " + new Date(target.getRegDBQ().getLogTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncBrokerInfo(Broker source, Broker target) throws EDatabaseException {
        IRegDBQ sourceRegDBQ = source.getBrokerDatabase().getIRegDBQ();
        IRegDBQ targetRegDBQ = target.getBrokerDatabase().getIRegDBQ();
        SyncpointLoc sourceLoc = null;
        sourceLoc = sourceRegDBQ.getSyncPtLoc();
        if (sourceLoc == null) {
            sourceLoc = new SyncpointLoc(-1, 0L);
        }
        boolean needRelease = false;
        try {
            targetRegDBQ.acquireLock();
            needRelease = true;
            targetRegDBQ.setSyncPtLoc(sourceLoc);
        }
        finally {
            if (needRelease) {
                targetRegDBQ.releaseLock();
            }
        }
        long lastConnId = sourceRegDBQ.getLastConnectionID();
        targetRegDBQ.setLastConnectionID(lastConnId);
    }

    private void syncRBRegistry(Broker source, Broker target) throws EDatabaseException {
        long cid;
        Object[] rb;
        Vector sourceRBs = source.getBrokerDatabase().getIRoutingDBQ().getRemoteBrokers();
        Vector targetRBs = target.getBrokerDatabase().getIRoutingDBQ().getRemoteBrokers();
        Enumeration enu = targetRBs.elements();
        while (enu.hasMoreElements()) {
            rb = (Object[])enu.nextElement();
            cid = (Long)rb[0];
            target.getBrokerDatabase().getIRoutingDBQ().deleteRemoteBroker(cid);
        }
        enu = sourceRBs.elements();
        while (enu.hasMoreElements()) {
            rb = (Object[])enu.nextElement();
            cid = (Long)rb[0];
            String url = (String)rb[1];
            String ftPeerURL = (String)rb[2];
            String user = (String)rb[3];
            String pass = (String)rb[4];
            String node = (String)rb[5];
            String broker = (String)rb[6];
            target.getBrokerDatabase().getIRoutingDBQ().addRemoteBroker(cid, url, ftPeerURL, node, broker, user, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncRouteInfo(Broker source, Broker target) throws EDatabaseException {
        Vector sourceRoutes = source.getBrokerDatabase().getIRoutingDBQ().getRoutes();
        IRoutingDBQ targetDB = target.getBrokerDatabase().getIRoutingDBQ();
        targetDB.acquireLock();
        try {
            RouteInfo route;
            Vector targetRoutes = targetDB.getRoutesTx();
            Enumeration enu = targetRoutes.elements();
            while (enu.hasMoreElements()) {
                route = (RouteInfo)enu.nextElement();
                targetDB.deleteRoutesByNodeGlobalBrokerTx(route.getNodeName(), route.getGlobalName(), route.getBrokerName());
            }
            enu = sourceRoutes.elements();
            while (enu.hasMoreElements()) {
                route = (RouteInfo)enu.nextElement();
                targetDB.addRouteTx(route);
            }
            targetDB.commit();
        }
        finally {
            targetDB.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncClientRegistry(Broker source, Broker target) throws EDatabaseException, IOException {
        Vector subs;
        IClientContext ctx;
        LongHashTable sourceClients = source.getBrokerDatabase().getAllClientAttributes();
        LongHashTable targetClients = target.getBrokerDatabase().getAllClientAttributes();
        Vector<BrokerDatabase.ClientAttributes> addList = new Vector<BrokerDatabase.ClientAttributes>();
        Vector<BrokerDatabase.ClientAttributes> updateList = new Vector<BrokerDatabase.ClientAttributes>();
        Enumeration<Long> enu = sourceClients.keys();
        while (enu.hasMoreElements()) {
            long cid = enu.nextElement();
            BrokerDatabase.ClientAttributes sourceClient = (BrokerDatabase.ClientAttributes)sourceClients.get(cid);
            if (this.DEBUG) {
                this.debug("Checking source client: " + sourceClient);
            }
            BrokerDatabase.ClientAttributes targetClient = (BrokerDatabase.ClientAttributes)targetClients.remove(cid);
            if (this.DEBUG) {
                this.debug("Found matching in target: " + targetClient);
            }
            if (targetClient == null) {
                if (this.DEBUG) {
                    this.debug("Client not in target: " + sourceClient);
                }
                addList.add(sourceClient);
                continue;
            }
            if (this.DEBUG) {
                this.debug("Client already in target: " + sourceClient);
            }
            updateList.add(sourceClient);
        }
        target.getBrokerDatabase().beginRegDBTran();
        try {
            enu = targetClients.keys();
            while (enu.hasMoreElements()) {
                Long cid = enu.nextElement();
                target.getBrokerDatabase().delClient(cid);
            }
            target.getBrokerDatabase().commitRegTran();
        }
        finally {
            target.getBrokerDatabase().releaseRegDBTran();
        }
        enu = updateList.elements();
        if (this.DEBUG) {
            this.debug("update list size = " + updateList.size());
        }
        while (enu.hasMoreElements()) {
            BrokerDatabase.ClientAttributes client = (BrokerDatabase.ClientAttributes)((Object)enu.nextElement());
            ctx = ClientContextCreator.createCC(client.cid, client.unserializeCsc(), null, false);
            ctx.setLastConnectedTime(client.lastConnectedTime);
            subs = source.getBrokerDatabase().getClientSubscriptions(client.cid);
            target.getBrokerDatabase().beginRegDBTran();
            try {
                target.getBrokerDatabase().saveClient(ctx, false);
                this.saveClientAndSubscriptions(client, subs, target);
            }
            finally {
                target.getBrokerDatabase().releaseRegDBTran();
            }
            if (!this.DEBUG) continue;
            this.debug("Updated client " + ctx);
        }
        enu = addList.elements();
        if (this.DEBUG) {
            this.debug("Add list size = " + addList.size());
        }
        while (enu.hasMoreElements()) {
            BrokerDatabase.ClientAttributes client = (BrokerDatabase.ClientAttributes)((Object)enu.nextElement());
            if (this.DEBUG) {
                this.debug(client.toString());
            }
            ctx = ClientContextCreator.createCC(client.cid, client.unserializeCsc(), null, false);
            ctx.setLastConnectedTime(client.lastConnectedTime);
            subs = source.getBrokerDatabase().getClientSubscriptions(client.cid);
            target.getBrokerDatabase().beginRegDBTran();
            try {
                target.getBrokerDatabase().saveClient(ctx, false);
                if (this.DEBUG) {
                    this.debug("Added client " + ctx);
                }
                this.saveClientAndSubscriptions(client, subs, target);
            }
            finally {
                target.getBrokerDatabase().releaseRegDBTran();
            }
        }
    }

    private void saveClientAndSubscriptions(BrokerDatabase.ClientAttributes client, Vector subs, Broker target) throws IOException {
        if (subs != null) {
            target.getBrokerDatabase().saveClientDBSubscriptions(client.cid, subs);
            if (this.DEBUG) {
                this.debug("Saving subscriptions for: " + client);
                Iterator it = subs.iterator();
                while (it.hasNext()) {
                    this.debug("" + it.next());
                }
            }
        }
        target.getBrokerDatabase().commitRegTran();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncDurableSubStore(Broker source, Broker target) throws EDatabaseException, IOException {
        LongHashTable sourceMsgIDs = source.getBrokerDatabase().getAllUndelMessageIDs();
        LongHashTable targetMsgIDs = target.getBrokerDatabase().getAllUndelMessageIDs();
        Enumeration<Long> enu = sourceMsgIDs.keys();
        while (enu.hasMoreElements()) {
            Long sourceMsgID = enu.nextElement();
            if (this.DEBUG) {
                this.debug("Enumerating source message: " + sourceMsgID);
            }
            Long targetMsgID = (Long)targetMsgIDs.remove(sourceMsgID);
            if (this.DEBUG) {
                this.debug("Checking target for message " + sourceMsgID + ", found " + targetMsgID);
            }
            if (targetMsgID == null) {
                IMgram msg = source.getBrokerDatabase().getMgram(sourceMsgID);
                String JMSMessageId = null;
                if (!SessionConfig.isSystemSubject(msg.getSubject())) {
                    JMSMessageId = Envelope.getMessageID(msg);
                }
                Date timestamp = new Date(System.currentTimeMillis());
                target.getBrokerDatabase().beginPubSubDBTran();
                try {
                    target.getBrokerDatabase().addMessage(msg, sourceMsgID, msg.getBrokerHandle().getSequenceNumber(), timestamp, JMSMessageId);
                    target.getBrokerDatabase().commitPubSubTran();
                }
                finally {
                    target.getBrokerDatabase().releasePubSubDBTran();
                }
                if (this.DEBUG) {
                    this.debug("Added Header for " + sourceMsgID);
                }
            }
            this.syncClientUndelivered(sourceMsgID, source, target);
        }
        Enumeration<Long> targetEnum = targetMsgIDs.keys();
        while (targetEnum.hasMoreElements()) {
            LongHashTable targetUndeliv;
            Enumeration delete;
            Long tracking = targetEnum.nextElement();
            if (this.DEBUG) {
                this.debug("Syncing target msg not present at source for msg id: " + tracking);
            }
            if (!(delete = (targetUndeliv = target.getBrokerDatabase().getUndelClientsByMsg(tracking)).elements()).hasMoreElements()) continue;
            boolean needsRelease = false;
            target.getBrokerDatabase().beginPubSubDBTran();
            needsRelease = true;
            try {
                this.removeTrackingFromTarget(delete, target, tracking);
            }
            finally {
                if (!needsRelease) continue;
                target.getBrokerDatabase().releasePubSubDBTran();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncClientUndelivered(Long tracking, Broker source, Broker target) throws EDatabaseException, EOperationCancelled {
        if (this.DEBUG) {
            this.debug("Synchronizing Undelivered list for: " + tracking);
        }
        LongHashTable sourceUndeliv = source.getBrokerDatabase().getUndelClientsByMsg(tracking);
        LongHashTable targetUndeliv = target.getBrokerDatabase().getUndelClientsByMsg(tracking);
        target.getBrokerDatabase().beginPubSubDBTran();
        try {
            Enumeration<Long> sourceClients = sourceUndeliv.keys();
            while (sourceClients.hasMoreElements()) {
                long sourceCID = sourceClients.nextElement();
                if (this.DEBUG) {
                    this.debug("Enumerating source undeliv. records - CID: " + sourceCID);
                }
                BrokerDatabase.ClientDeliveryInfo sourceInfo = (BrokerDatabase.ClientDeliveryInfo)sourceUndeliv.get(sourceCID);
                if (this.DEBUG) {
                    this.debug("Source Record for CID " + sourceCID + ": " + sourceInfo);
                }
                BrokerDatabase.ClientDeliveryInfo targetInfo = (BrokerDatabase.ClientDeliveryInfo)targetUndeliv.remove(sourceCID);
                if (this.DEBUG) {
                    this.debug("Target Record for CID " + sourceCID + ": " + targetInfo);
                }
                if (targetInfo == null) {
                    target.getBrokerDatabase().addUndeliveredHeader(sourceInfo.cid, tracking, sourceInfo.seqno, sourceInfo.redelivered, sourceInfo.expiration, sourceInfo.timestamp, sourceInfo.size, sourceInfo.fromRemote, sourceInfo.persistent, sourceInfo.undelSubjectIds);
                    if (!this.DEBUG) continue;
                    this.debug("Added " + tracking + " to target " + sourceInfo);
                    continue;
                }
                if (targetInfo.equals(sourceInfo)) continue;
                if (this.DEBUG && (sourceInfo.undelSubjectIds == null && targetInfo.undelSubjectIds != null || sourceInfo.undelSubjectIds != null && targetInfo.undelSubjectIds == null)) {
                    this.debug("UndelMsgs type mismatch: sourceInfo+ " + sourceInfo + " targetInfo= " + targetInfo);
                }
                target.getBrokerDatabase().updateDeliveryInfo(tracking, sourceCID, sourceInfo.redelivered, sourceInfo.seqno, sourceInfo.expiration, sourceInfo.timestamp, sourceInfo.size, sourceInfo.fromRemote, sourceInfo.persistent, sourceInfo.undelSubjectIds);
                if (!this.DEBUG) continue;
                this.debug("Updated " + tracking + " to target " + sourceInfo);
            }
            Enumeration delete = targetUndeliv.elements();
            this.removeTrackingFromTarget(delete, target, tracking);
        }
        finally {
            target.getBrokerDatabase().releasePubSubDBTran();
        }
    }

    private void removeTrackingFromTarget(Enumeration delete, Broker target, Long tracking) throws EDatabaseException, EOperationCancelled {
        while (delete.hasMoreElements()) {
            BrokerDatabase.ClientDeliveryInfo targetInfo = (BrokerDatabase.ClientDeliveryInfo)delete.nextElement();
            if (this.DEBUG) {
                this.debug("Removed " + tracking + " from target " + targetInfo);
            }
            target.getBrokerDatabase().delMsg(targetInfo.cid, tracking, -1);
        }
        target.getBrokerDatabase().commitPubSubTran();
    }

    public void syncTxnFiles(Broker source, Broker target) throws FileNotFoundException, IOException {
        if (this.DEBUG) {
            this.debug("entering syncTxnFiles");
        }
        target.deleteAllDiskResidentTxnFiles();
        source.copyDiskResidentTxnFiles(target.LOG_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncQueues(Broker source, Broker target) throws EDatabaseException, IOException {
        if (this.DEBUG) {
            this.debug("entering syncQueues");
        }
        Hashtable<String, IDbQueueData> sourceQueues = new Hashtable<String, IDbQueueData>();
        IDbDataEnum sourceQueueEnum = source.getBrokerDatabase().getIPtpDBQ().getQueuesDbDataEnum();
        while (sourceQueueEnum.hasMoreElements()) {
            IDbQueueData qdata = (IDbQueueData)sourceQueueEnum.nextElement();
            sourceQueues.put(qdata.getQueueName(), qdata);
        }
        Hashtable<String, IDbQueueData> targetQueues = new Hashtable<String, IDbQueueData>();
        IDbDataEnum targetQueueEnum = target.getBrokerDatabase().getIPtpDBQ().getQueuesDbDataEnum();
        while (targetQueueEnum.hasMoreElements()) {
            IDbQueueData qdata = (IDbQueueData)targetQueueEnum.nextElement();
            targetQueues.put(qdata.getQueueName(), qdata);
        }
        Vector<String> addList = new Vector<String>();
        Vector<String> updateList = new Vector<String>();
        Enumeration<Object> enu = sourceQueues.keys();
        while (enu.hasMoreElements()) {
            String queueName = (String)enu.nextElement();
            IDbQueueData targetQueue = (IDbQueueData)targetQueues.remove(queueName);
            if (targetQueue == null) {
                addList.add(queueName);
                continue;
            }
            updateList.add(queueName);
        }
        enu = targetQueues.keys();
        if (enu.hasMoreElements()) {
            boolean needRelease = false;
            try {
                target.getBrokerDatabase().getIPtpDBQ().acquireLock();
                needRelease = true;
                while (enu.hasMoreElements()) {
                    String qname = (String)enu.nextElement();
                    target.getBrokerDatabase().getIPtpDBQ().deleteQMsgs(qname);
                    target.getBrokerDatabase().getIPtpDBQ().commit();
                }
            }
            finally {
                SyncBrokerDatabase.releaseDBLockCheckingNeedRelease(needRelease, target);
            }
        }
        enu = addList.elements();
        while (enu.hasMoreElements()) {
            String qname = (String)enu.nextElement();
            LongHashTable sourceIDs = source.getBrokerDatabase().getIPtpDBQ().getMessageIDsInQueue(qname);
            Enumeration<Long> enumSourceIDs = sourceIDs.keys();
            boolean added = false;
            while (enumSourceIDs.hasMoreElements()) {
                long id = enumSourceIDs.nextElement();
                IMgram msg = source.getBrokerDatabase().getIPtpDBQ().getQMgram(qname, id);
                try {
                    target.getBrokerDatabase().getIPtpDBQ().acquireLock();
                    target.getBrokerDatabase().getIPtpDBQ().saveQMsg(qname, msg);
                    added = true;
                }
                finally {
                    target.getBrokerDatabase().getIPtpDBQ().releaseLock();
                }
            }
            if (!added) continue;
            try {
                target.getBrokerDatabase().getIPtpDBQ().acquireLock();
                target.getBrokerDatabase().getIPtpDBQ().commit();
            }
            finally {
                target.getBrokerDatabase().getIPtpDBQ().releaseLock();
            }
        }
        enu = updateList.elements();
        while (enu.hasMoreElements()) {
            String qname = (String)enu.nextElement();
            this.syncQueue(qname, source, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncQueue(String qname, Broker source, Broker target) throws EDatabaseException, IOException {
        Long id;
        if (this.DEBUG) {
            this.debug("synching queue " + qname);
        }
        LongHashTable sourceIDs = source.getBrokerDatabase().getIPtpDBQ().getMessageIDsInQueue(qname);
        LongHashTable targetIDs = target.getBrokerDatabase().getIPtpDBQ().getMessageIDsInQueue(qname);
        int sourceMsgCount = sourceIDs.size();
        if (this.DEBUG) {
            this.debug("Source " + qname + " contains " + sourceMsgCount + " msgs");
        }
        Vector<Long> toBeAdded = new Vector<Long>();
        Enumeration<Long> enumSourceIDs = sourceIDs.keys();
        while (enumSourceIDs.hasMoreElements()) {
            Long id2 = enumSourceIDs.nextElement();
            if (targetIDs.remove(id2) != null) continue;
            toBeAdded.addElement(id2);
        }
        if (!targetIDs.isEmpty()) {
            boolean needsRelease = false;
            try {
                target.getBrokerDatabase().getIPtpDBQ().acquireLock();
                needsRelease = true;
                Enumeration<Long> enumTargetIDs = targetIDs.keys();
                while (enumTargetIDs.hasMoreElements()) {
                    id = enumTargetIDs.nextElement();
                    if (this.DEBUG) {
                        this.debug("deleting message " + id + " from " + qname);
                    }
                    target.getBrokerDatabase().getIPtpDBQ().deleteQMsg(qname, id);
                }
                target.getBrokerDatabase().getIPtpDBQ().commit();
            }
            finally {
                SyncBrokerDatabase.releaseDBLockCheckingNeedRelease(needsRelease, target);
            }
        }
        int msgAddCount = toBeAdded.size();
        for (int i = 0; i < msgAddCount; ++i) {
            id = (Long)toBeAdded.elementAt(i);
            if (this.DEBUG) {
                this.debug("adding message " + id + " to " + qname);
            }
            IMgram m = source.getBrokerDatabase().getIPtpDBQ().getQMgram(qname, id);
            boolean needRelease = false;
            try {
                target.getBrokerDatabase().getIPtpDBQ().acquireLock();
                needRelease = true;
                target.getBrokerDatabase().getIPtpDBQ().saveQMsg(qname, m);
                continue;
            }
            finally {
                SyncBrokerDatabase.releaseDBLockCheckingNeedRelease(needRelease, target);
            }
        }
        boolean needRelease = false;
        try {
            target.getBrokerDatabase().getIPtpDBQ().acquireLock();
            needRelease = true;
            target.getBrokerDatabase().getIPtpDBQ().commit();
        }
        finally {
            SyncBrokerDatabase.releaseDBLockCheckingNeedRelease(needRelease, target);
        }
    }

    private static void releaseDBLockCheckingNeedRelease(boolean needRelease, Broker target) {
        if (needRelease) {
            target.getBrokerDatabase().getIPtpDBQ().releaseLock();
        }
    }

    public void syncDupDetect(Broker source, Broker target) throws EDatabaseException {
        target.getDupDetectDBQ().deleteAll();
        String[] limits = source.getDupDetectDBQ().getLimits();
        if (limits == null) {
            return;
        }
        String minid = limits[0];
        String maxid = limits[1];
        int requested = 1024;
        List sourceRecords = source.getDupDetectDBQ().getRecords(minid, maxid, requested, true);
        while (!sourceRecords.isEmpty()) {
            target.getDupDetectDbConnection().writeDupDetectData(sourceRecords);
            IDbDupDetectData last = (IDbDupDetectData)sourceRecords.get(sourceRecords.size() - 1);
            minid = last.getCommitID();
            sourceRecords = source.getDupDetectDBQ().getRecords(minid, maxid, requested, false);
        }
    }

    private void log(String out) {
        if (this.m_context != null) {
            this.m_context.logMessage(out, 3);
        } else {
            OStream.println(out);
        }
    }

    class Broker {
        String BROKER_NAME;
        String DATABASE_STORE_TYPE;
        String MQSTORE_DB_CONNECT;
        boolean INDEXED_TXN_DB_SHARED;
        boolean INDEXED_TXN;
        String INDEXED_TXN_JDBC_DRIVER;
        String INDEXED_TXN_DB_CONNECT;
        String INDEXED_TXN_DB_USER;
        String INDEXED_TXN_DB_PASSWORD;
        String INDEXED_TXN_DB_PROPERTIES;
        String INDEXED_TXN_TABLE_NAME;
        String LOG_PATH;
        String LOG_FILE_1;
        String LOG_FILE_2;
        int LOG_BLOCK_SIZE;
        String TXN_FILE_PREFIX;
        String DEBUG_NAME;
        boolean REPLICATED;
        Db m_db = null;
        Db m_dupDb = null;
        NoDupDetectDbConnection m_ndd = null;
        BrokerDatabase m_brokerDb = null;
        IInitDbDBQ m_initDBQ = null;
        LogFile m_log = null;

        Broker() {
        }

        void deleteAllDiskResidentTxnFiles() {
            Enumeration enu = this.getDiskResidentTxnFiles();
            while (enu.hasMoreElements()) {
                File f = (File)enu.nextElement();
                f.delete();
            }
        }

        IRegDBQ getRegDBQ() {
            return this.m_brokerDb.getIRegDBQ();
        }

        BrokerDatabase getBrokerDatabase() {
            return this.m_brokerDb;
        }

        NoDupDetectDbConnection getDupDetectDbConnection() {
            return this.m_ndd;
        }

        IDupDetectDBQ getDupDetectDBQ() {
            return this.m_ndd.getDupDetectDBQ();
        }

        Enumeration getDiskResidentTxnFiles() {
            File dir = new File(this.LOG_PATH);
            File[] files = dir.listFiles();
            Vector<File> fileList = new Vector<File>();
            if (files != null) {
                int size = files.length;
                for (int i = 0; i < size; ++i) {
                    String fileName = files[i].getName();
                    if (!fileName.startsWith(this.TXN_FILE_PREFIX)) continue;
                    fileList.addElement(files[i]);
                }
            }
            return fileList.elements();
        }

        void copyDiskResidentTxnFiles(String targetDirPath) throws FileNotFoundException, IOException {
            int BLOCK_SIZE = 8192;
            Enumeration enu = this.getDiskResidentTxnFiles();
            while (enu.hasMoreElements()) {
                File f = (File)enu.nextElement();
                String sourceFilePath = f.getAbsolutePath();
                String targetFilePath = this.composeTxnFilePath(targetDirPath, f.getName());
                LogStreamFile.copy(sourceFilePath, targetFilePath, BLOCK_SIZE);
            }
        }

        private String composeTxnFilePath(String txnFilePath, String txnFileName) {
            if (!txnFilePath.endsWith(File.separator)) {
                return txnFilePath + File.separator + txnFileName;
            }
            return txnFilePath + txnFileName;
        }

        void initialize() throws EDatabaseException, EGeneralException, IOException {
            this.createBrokerDb();
            this.m_brokerDb = new BrokerDatabase(this.m_db);
            this.m_initDBQ = DBQSetup.initDbInitDBQ(this.m_db);
            this.m_log = new LogFile();
            this.m_log.open(this.LOG_FILE_1, this.LOG_FILE_2, this.LOG_BLOCK_SIZE);
        }

        void loadTargetConfigProperties(Properties props) throws Exception {
            this.DATABASE_STORE_TYPE = props.getProperty("DATABASE_STORE_TYPE", "Embedded");
            this.MQSTORE_DB_CONNECT = props.getProperty("MQSTORE_DB_CONNECT", "./SonicMQStore");
            this.BROKER_NAME = props.getProperty("BROKER_NAME");
            Integer blockSize = (Integer)props.get("RECOVERY_LOG_BLOCK_SIZE");
            this.LOG_BLOCK_SIZE = blockSize != null ? blockSize : 8192;
            this.loadIndexedTxnProperties(props);
            this.LOG_PATH = props.getProperty("RECOVERY_LOG_PATH", "./log");
            this.setLogFilePaths();
            Object primary = props.get("PRIMARY_CONFIG_ELEMENT_REF");
            Object backup = props.get("BACKUP_CONFIG_ELEMENT_REF");
            this.REPLICATED = primary != null || backup != null;
        }

        void loadIndexedTxnProperties(Properties props) {
            Boolean indexedTxnShared = (Boolean)props.get("INDEXED_TXN_DB_SHARED");
            this.INDEXED_TXN_DB_SHARED = indexedTxnShared != null ? indexedTxnShared : false;
            Boolean indexedTxn = (Boolean)props.get("INDEXED_TXN");
            this.INDEXED_TXN = indexedTxn != null ? indexedTxn : false;
            this.INDEXED_TXN_DB_CONNECT = props.getProperty("INDEXED_TXN_DB_CONNECT");
            this.INDEXED_TXN_DB_USER = props.getProperty("INDEXED_TXN_DB_USER");
            this.INDEXED_TXN_DB_PASSWORD = props.getProperty("INDEXED_TXN_DB_PASSWORD");
            this.INDEXED_TXN_JDBC_DRIVER = props.getProperty("INDEXED_TXN_JDBC_DRIVER");
            this.INDEXED_TXN_DB_PROPERTIES = props.getProperty("INDEXED_TXN_DB_PROPERTIES");
            this.INDEXED_TXN_TABLE_NAME = props.getProperty("INDEXED_TXN_TABLE_NAME");
        }

        void loadSourceConfigProperties(Properties props, String sourceInstallDir, int logBlockSize) throws Exception {
            this.DATABASE_STORE_TYPE = props.getProperty("DATABASE_STORE_TYPE", "Embedded");
            this.MQSTORE_DB_CONNECT = props.getProperty("FTPEER_MQSTORE_DB_CONNECT", "./SonicMQStore");
            this.BROKER_NAME = props.getProperty("BROKER_NAME");
            this.loadIndexedTxnProperties(props);
            this.LOG_BLOCK_SIZE = logBlockSize;
            this.LOG_PATH = props.getProperty("FTPEER_RECOVERY_LOG_PATH", "./log");
            this.LOG_PATH = this.createSourceLogPath(this.LOG_PATH, sourceInstallDir);
            this.setLogFilePaths();
        }

        String createSourceLogPath(String configLogPath, String sourceInstallDirParam) throws IOException {
            File configPathFile;
            String sourceInstallDir = sourceInstallDirParam;
            if (!sourceInstallDir.endsWith(File.separator)) {
                sourceInstallDir = sourceInstallDir + File.separator;
            }
            if (!(configPathFile = new File(configLogPath)).isAbsolute()) {
                File sourceLogPath = new File(sourceInstallDir + configLogPath);
                return sourceLogPath.getCanonicalPath();
            }
            return configLogPath;
        }

        void setLogFilePaths() {
            this.LOG_FILE_1 = this.LOG_PATH + File.separator + "recoverylog1.bin";
            this.LOG_FILE_2 = this.LOG_PATH + File.separator + "recoverylog2.bin";
            this.TXN_FILE_PREFIX = "Txn";
        }

        void createBrokerDb() throws EDatabaseException {
            Properties dbprops = new Properties();
            dbprops.put("DATABASE_STORE_TYPE", this.DATABASE_STORE_TYPE);
            dbprops.put("BROKER_NAME", this.BROKER_NAME);
            dbprops.put("MQSTORE_DB_CONNECT", this.MQSTORE_DB_CONNECT);
            dbprops.put("INDEXED_TXN", new Boolean(this.INDEXED_TXN));
            if (this.INDEXED_TXN_TABLE_NAME != null) {
                dbprops.put("INDEXED_TXN_TABLE_NAME", this.INDEXED_TXN_TABLE_NAME);
                dbprops.put("INDEXED_TXN_JDBC_DRIVER", this.INDEXED_TXN_JDBC_DRIVER);
                dbprops.put("INDEXED_TXN_DB_CONNECT", this.INDEXED_TXN_DB_CONNECT);
                dbprops.put("INDEXED_TXN_DB_USER", this.INDEXED_TXN_DB_USER);
                dbprops.put("INDEXED_TXN_DB_PASSWORD", this.INDEXED_TXN_DB_PASSWORD);
                dbprops.put("INDEXED_TXN_DB_PROPERTIES", this.INDEXED_TXN_DB_PROPERTIES);
            }
            if (SyncBrokerDatabase.this.DEBUG) {
                SyncBrokerDatabase.this.debug("Loaded Database properties for " + this.BROKER_NAME + ":  " + dbprops.toString());
                SyncBrokerDatabase.this.debug("Log path: " + this.LOG_PATH);
            }
            this.m_db = DBFactory.createBrokerDb(dbprops);
            this.m_dupDb = DBFactory.createDupDetectDb(dbprops, this.m_db);
            this.m_ndd = new NoDupDetectDbConnection(this.m_dupDb);
        }

        void close() throws EDatabaseException, IOException {
            this.m_brokerDb = null;
            Db.shutdown();
            this.m_log.close();
        }
    }
}

