/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.util.Enumeration;
import progress.message.broker.Transaction;
import progress.message.broker.TxMsg;
import progress.message.util.DebugState;
import progress.message.util.LinkedList;
import progress.message.zclient.DebugObject;

abstract class TxnContentMgr
extends DebugObject {
    protected Transaction m_transaction;
    protected LinkedList m_msgQueue;
    private int m_qMemSize;
    private int m_totalSize;
    private boolean m_qCleared;

    TxnContentMgr(Transaction t) {
        super(DebugState.GLOBAL_DEBUG_ON ? "TxnContentMgr " + t.getTid() : null);
        this.m_transaction = t;
        this.m_msgQueue = new LinkedList();
    }

    TxnContentMgr(Transaction t, LinkedList msgQueue, int size) {
        super(DebugState.GLOBAL_DEBUG_ON ? "TxnContentMgr " + t.getTid() : null);
        this.m_transaction = t;
        this.m_msgQueue = msgQueue;
        this.m_qMemSize = size;
        this.m_totalSize = size;
    }

    protected Transaction getTxn() {
        return this.m_transaction;
    }

    protected int getMemoryQsize() {
        return this.m_qMemSize;
    }

    LinkedList getMsgQueue() {
        return this.m_msgQueue;
    }

    int getTotalSize() {
        return this.m_totalSize;
    }

    synchronized void addMsg(TxMsg m) {
        this.m_msgQueue.append(m);
        this.m_qMemSize += m.memoryLength();
        this.m_totalSize += m.memoryLength();
        if (this.DEBUG) {
            this.debug("qSize = " + this.m_msgQueue.count() + " qMemSize = " + this.m_qMemSize + " totalSize = " + this.m_totalSize);
        }
    }

    synchronized void cleanupMemoryQ() {
        this.m_msgQueue.clearList();
        this.m_qMemSize = 0;
        this.m_qCleared = true;
    }

    void closeMsgStore() {
    }

    void deleteMsgStore() {
        this.cleanupMemoryQ();
    }

    void flushMsgs() throws IOException {
    }

    void replicate() throws IOException {
    }

    void finalizeMsgsBeforeEventFlush() throws IOException {
    }

    void finalizeMsgsAfterEventFlush() {
    }

    void commitMsgs(int lastMsgSeqNo, boolean retry) throws Exception {
        int seq = 0;
        if (this.DEBUG) {
            this.debug("Committing msgs; starting seqno= " + lastMsgSeqNo);
        }
        int count = 0;
        Enumeration enu = this.m_msgQueue.elements();
        while (enu.hasMoreElements()) {
            if (++seq <= lastMsgSeqNo) continue;
            TxMsg m = (TxMsg)enu.nextElement();
            m.deliverMsg(seq, retry, this.m_transaction);
            ++count;
        }
        if (this.DEBUG) {
            this.debug("Committed " + count + " messages ");
        }
    }

    void cancelMsgs() throws InterruptedException {
        boolean seq = false;
        if (this.DEBUG) {
            this.debug("Canceling msgs");
        }
        Enumeration enu = this.m_msgQueue.elements();
        while (enu.hasMoreElements()) {
            TxMsg m = (TxMsg)enu.nextElement();
            m.cancelMsg();
        }
    }
}

