/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.Broker;
import progress.message.broker.IMonitoredObject;
import progress.message.broker.TimerHeap;
import progress.message.zclient.DebugThread;

public class WatchDogThread
extends DebugThread {
    public static final int DEFAULT_POLLING_INTERVAL = 60000;
    private int m_pollingInterval;
    private Hashtable m_monitoredObjects = null;
    private final TimerHeap m_timerHeap = new TimerHeap();
    private final Runnable m_monitoredObjectRunner = new Runnable(){

        @Override
        public void run() {
            try {
                WatchDogThread.this.executeMonitoredObjects();
            }
            finally {
                WatchDogThread.this.m_timerHeap.addRelative(WatchDogThread.this.m_monitoredObjectRunner, WatchDogThread.this.m_pollingInterval);
            }
        }
    };

    WatchDogThread(int pollingInterval) {
        super("WatchDogThread");
        this.m_monitoredObjects = new Hashtable();
        this.m_pollingInterval = pollingInterval;
    }

    public void register(IMonitoredObject monitoredObject) {
        if (this.DEBUG) {
            this.debug("register called");
        }
        this.m_monitoredObjects.put(monitoredObject, monitoredObject);
    }

    public boolean unregister(IMonitoredObject monitoredObject) {
        Object timer;
        if (this.DEBUG) {
            this.debug("unregister called");
        }
        return (timer = this.m_monitoredObjects.remove(monitoredObject)) != null;
    }

    public final void addAbsoluteTimer(Runnable runnable, long executionTimeMillis) {
        this.m_timerHeap.addAbsolute(runnable, executionTimeMillis);
    }

    public final void addRelativeTimer(Runnable runnable, long relativeTimeMillis) {
        this.m_timerHeap.addRelative(runnable, relativeTimeMillis);
    }

    @Override
    public void threadMain() {
        if (this.DEBUG) {
            this.debug("Watchdog thread started");
        }
        this.m_timerHeap.addRelative(this.m_monitoredObjectRunner, this.m_pollingInterval);
        while (!Thread.interrupted()) {
            Broker.getBroker();
            if (Broker.isInShutdown()) break;
            try {
                this.m_timerHeap.waitForNextTimer();
                this.m_timerHeap.executeReadyTimers();
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeMonitoredObjects() {
        if (this.DEBUG) {
            this.debug("Checking the expiration times");
        }
        Enumeration<Object> elements = null;
        IMonitoredObject monitoredObject = null;
        Vector<IMonitoredObject> timedOutObjects = null;
        Hashtable hashtable = this.m_monitoredObjects;
        synchronized (hashtable) {
            elements = this.m_monitoredObjects.elements();
            while (elements.hasMoreElements()) {
                monitoredObject = (IMonitoredObject)elements.nextElement();
                long expTime = monitoredObject.getExpirationTime();
                if (expTime > System.currentTimeMillis()) continue;
                if (this.DEBUG) {
                    this.debug("timeout expired");
                }
                this.unregister(monitoredObject);
                if (timedOutObjects == null) {
                    timedOutObjects = new Vector<IMonitoredObject>();
                }
                timedOutObjects.addElement(monitoredObject);
            }
        }
        if (timedOutObjects != null) {
            elements = timedOutObjects.elements();
            while (elements.hasMoreElements()) {
                monitoredObject = (IMonitoredObject)elements.nextElement();
                try {
                    monitoredObject.timeOutExpired();
                }
                catch (Throwable thrown) {
                    BrokerComponent.getComponentContext().logMessage(thrown, 2);
                }
            }
            timedOutObjects = null;
        }
    }
}

