/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.SubscribeEvtForSelector;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.util.EAssertFailure;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;

public class GSSubscribeEvt
extends SubscribeEvtForSelector {
    private GSVirtualClock m_virtualClock;

    public GSSubscribeEvt(Envelope req, long id, ISubject subject, Label label, String[] messageSelectors, boolean isSelectorAtBroker, GSVirtualClock virtualClock) {
        super(req, id, subject, label, messageSelectors, isSelectorAtBroker);
        this.m_virtualClock = virtualClock;
    }

    public GSSubscribeEvt(short type) {
        super(GSSubscribeEvt.convertEvtType(type));
    }

    private static final short convertEvtType(short type) {
        switch (type) {
            case 114: {
                return 113;
            }
            case 109: {
                return 108;
            }
            case 57: {
                return 60;
            }
        }
        throw new EAssertFailure("Invalid GSSubscribeEvt type.");
    }

    public GSVirtualClock getVirtualClock() {
        return this.m_virtualClock;
    }

    @Override
    public short type() {
        return 114;
    }

    @Override
    protected int memSizeBody() {
        return super.memSizeBody() + GSVirtualClock.serializedSize();
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return super.serializedSizeBody() + GSVirtualClock.serializedSize();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        super.writeBodyToLog(out, maxbytes);
        this.m_virtualClock.serialize(out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        super.writeBodyToStream(os, tteTTLConvert);
        this.m_virtualClock.serialize(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        super.readBodyFromStream(in, tteTTLConvert);
        this.m_virtualClock = GSVirtualClock.unserialize(in);
    }
}

