/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import progress.message.client.EConnectionNotResumable;
import progress.message.client.EExclusiveQueueOpen;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidSelectorException;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.ENetworkFailure;
import progress.message.client.ENotConnected;
import progress.message.client.EParameterIsNull;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ETransactionFailure;
import progress.message.client.EUnauthorizedToReceiveFromQueue;
import progress.message.client.EUnusableConnection;
import progress.message.client.prAccessor;
import progress.message.jimpl.Connection;
import progress.message.jimpl.DestUtil;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.MessageConsumer;
import progress.message.jimpl.Session;
import progress.message.zclient.Envelope;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subscription;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;

public class QueueReceiver
extends MessageConsumer
implements progress.message.jclient.QueueReceiver,
IDoubtResolver {
    Queue m_jqueue = null;
    String m_queueName = null;
    private IMessageHandler m_ihandler;
    private Subscription m_subscription = null;
    int m_outstandingRequested = 0;
    private int m_prefetchCount = 3;
    private int m_prefetchThreshold = 1;
    private boolean m_brokerQueueEmpty = false;
    private Object m_mutex = new Object();
    private boolean m_requestPending = false;
    private progress.message.zclient.Message m_getMessage = null;
    private Envelope m_getEnvelope = null;
    private Envelope m_getEnvelopeFT = null;
    private progress.message.zclient.Message m_getMessageNoWait = null;
    private Envelope m_getEnvelopeNoWait = null;
    private Envelope m_getEnvelopeNoWaitFT = null;
    boolean[] m_deliveryStarted = new boolean[]{false};
    private static long RX_NOWAIT_CONTINGENCY_TIMEOUT = 15000L;
    private Hashtable m_in_synchronous_receive = new Hashtable();
    IDoubtResolverCompletionListener m_doubtlistener = null;

    public QueueReceiver(Session session, Queue queue) throws JMSException {
        this(null, session, queue, null, null);
    }

    public QueueReceiver(Session session, Queue queue, String messageSelector) throws JMSException {
        this(null, session, queue, messageSelector, null);
    }

    public QueueReceiver(Connection connection, Session session, Queue queue, String messageSelector, IMessageHandler ihr) throws JMSException {
        super(session);
        if (queue == null) {
            throw new InvalidDestinationException(prAccessor.getString("DEST_Q_NULL"));
        }
        String routingNodeName = DestUtil.getRoutingName(queue);
        String localRoutingNodeName = session.m_jconnection.getRoutingNodeName();
        if (routingNodeName != null && !routingNodeName.equals(localRoutingNodeName) && !"".equals(routingNodeName)) {
            throw new InvalidDestinationException(prAccessor.getString("QUEUERECEIVER_CANNOT_USE_REMOTE_QUEUE"));
        }
        long parentID = 0L;
        String appID = null;
        if (connection == null) {
            this.m_jconnection = session.m_jconnection;
            parentID = session.m_zconnection.getClientId();
            appID = "$QR$";
        } else {
            this.m_isCC = true;
            this.m_jconnection = connection;
            parentID = connection.m_zconnection.getClientId();
            appID = "$CC$$QR$";
        }
        try {
            int prefetchThreshold;
            this.m_jqueue = queue;
            this.m_zmessageHandler = new DefaultHandler(!this.m_isCC);
            this.m_zmessageHandler.setGuaranteed(true);
            this.m_zconnection = new progress.message.zclient.Connection(appID, null, this.m_zmessageHandler);
            this.m_jconnection.addZConnection(this.m_zconnection);
            this.m_zconnection.setAckMode(this.m_jsession.getZAckMode());
            this.m_zconnection.connect(this.m_jconnection.m_zconnection, parentID);
            try {
                this.m_selectorString = messageSelector;
                this.makeOpenRequestThrowJMS(this.m_selectorString);
            }
            catch (JMSException e) {
                this.m_jconnection.removeZConnection(this.m_zconnection);
                this.m_zconnection.disconnect(true);
                throw e;
            }
            String subj = "$QSYS.client." + this.m_zconnection.getEffectiveUid() + "." + this.m_zconnection.getApplicationId() + ".*";
            this.m_zmessageHandler.bind(subj);
            this.m_ihandler = ihr != null ? ihr : new IHandler();
            this.m_queueName = DestUtil.getDestinationName(this.m_jqueue.getQueueName());
            String subject = this.deliverySubject(this.m_queueName);
            if (this.m_queueName.equals("SonicMQ.deadMessage")) {
                this.m_zmessageHandler.bind("$Q.#", this.m_ihandler);
            } else {
                this.m_zmessageHandler.bind(subject, this.m_ihandler);
            }
            int prefetchCount = this.m_jsession.getJconnection().getPrefetchCount();
            if (prefetchCount > 0) {
                this.m_prefetchCount = prefetchCount;
            }
            if ((prefetchThreshold = this.m_jsession.getJconnection().getPrefetchThreshold()) >= 0) {
                this.m_prefetchThreshold = prefetchThreshold;
            }
            if (this.m_jsession.isGetFromXASession()) {
                this.m_prefetchCount = 1;
                this.m_prefetchThreshold = 0;
            }
            this.prepareGetRequest();
            if (!this.m_isCC) {
                session.addQueueReceiver(this);
            } else {
                connection.addQueueReceiver(this);
            }
            if (this.m_jconnection.isFaultTolerant()) {
                this.m_zconnection.setApplicationLevelResolver(this);
            }
        }
        catch (ESecurityPolicyViolation espv) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSSecurityException(prAccessor.getString("NOT_AUTH_RECV") + this.m_jqueue.getQueueName(), espv);
        }
        catch (EParameterIsNull epis) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(epis);
        }
        catch (EInvalidSubjectSyntax eiss) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(eiss);
        }
        catch (ENetworkFailure enf) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(enf);
        }
        catch (EUnusableConnection euc) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(euc);
        }
        catch (EGeneralException ege) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw JMSExceptionUtil.createJMSException(ege);
        }
        catch (JMSException jmse) {
            if (this.m_zconnection != null) {
                this.m_zconnection.cleanUp();
            }
            throw jmse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeInternalConsumer() throws JMSException {
        block22: {
            if (!this.m_isCC) {
                if (!this.m_jsession.okToCloseConsumer(this)) {
                    this.stop();
                    this.m_pendingClose = true;
                    return;
                }
            } else if (!this.m_jconnection.isClosing()) {
                Enumeration<Session> sessions = this.m_jconnection.getSessions();
                while (sessions.hasMoreElements()) {
                    Session sess = sessions.nextElement();
                    if (sess.okToCloseConsumer(this)) continue;
                    this.stop();
                    this.m_pendingClose = true;
                    return;
                }
            }
            this.m_pendingClose = false;
            try {
                this.m_jsession.setDelayedAcknowledgeMessage(null);
            }
            catch (JMSException e) {
                Exception ex = e.getLinkedException();
                if (ex != null && ex instanceof ENotConnected) break block22;
                throw e;
            }
        }
        this.m_jconnection.removeZConnection(this.m_zconnection);
        try {
            try {
                if (this.m_subscription != null) {
                    this.m_subscription.cancel();
                }
            }
            catch (ENotConnected e) {
                // empty catch block
            }
            String subject = this.deliverySubject(this.m_jqueue.getQueueName());
            this.m_zmessageHandler.unbind(subject);
            this.m_zmessageHandler.unbind(subject, this.m_ihandler);
            this.stop(false);
            if (!this.m_isCC) {
                MessageConsumer.ReceivedMessagesQueue receivedMessagesQueue = this.getReceivedMessagesQueue();
                synchronized (receivedMessagesQueue) {
                    this.getReceivedMessagesQueue().removeAllMessages();
                    this.getReceivedMessagesQueue().notifyAll();
                }
                this.m_jsession.removeConsumer(this);
            } else {
                this.m_jconnection.removeNondurableCC(this);
            }
            try {
                this.m_zconnection.disconnect(false);
            }
            catch (ENotConnected eNotConnected) {}
        }
        catch (EParameterIsNull epin) {
            throw JMSExceptionUtil.createJMSException(epin);
        }
        catch (ENetworkFailure enf) {
            throw JMSExceptionUtil.createJMSException(enf);
        }
        catch (ESecurityPolicyViolation espv) {
            throw JMSExceptionUtil.createJMSSecurityException(espv);
        }
        catch (EGeneralException ege) {
            throw JMSExceptionUtil.createJMSException(ege);
        }
    }

    @Override
    void start() throws JMSException {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start_with_remote() throws JMSException {
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            boolean[] blArray = this.m_deliveryStarted;
            synchronized (this.m_deliveryStarted) {
                super.start();
                this.m_deliveryStarted[0] = true;
                this.m_deliveryStarted.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void start(boolean remote) throws JMSException {
        try {
            if (remote) {
                this.start_with_remote();
            } else {
                boolean[] blArray = this.m_deliveryStarted;
                // MONITORENTER : this.m_deliveryStarted
                this.m_started = true;
                this.m_deliveryStarted[0] = true;
                this.m_deliveryStarted.notifyAll();
                // MONITOREXIT : blArray
            }
            boolean requiresAGet = false;
            MessageConsumer.ReceivedMessagesQueue receivedMessagesQueue = this.m_rxQueue;
            // MONITORENTER : receivedMessagesQueue
            this.m_outstandingRequested = 0;
            requiresAGet = this.m_isCC || this.getMessageListener() != null || this.inSynchronousReceive() && this.m_rxQueue.isEmpty();
            // MONITOREXIT : receivedMessagesQueue
            if (!requiresAGet) return;
            this.makeGetRequest();
            return;
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    @Override
    void stop() throws JMSException {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(boolean remote) throws JMSException {
        try {
            boolean[] blArray = this.m_deliveryStarted;
            synchronized (this.m_deliveryStarted) {
                if (remote) {
                    this.m_zconnection.stopDelivery();
                }
                this.m_deliveryStarted[0] = false;
                this.m_deliveryStarted.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.m_outstandingRequested = 0;
            }
        }
        catch (EUnusableConnection e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    public Queue getQueue() throws JMSException {
        if (this.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        return this.m_jqueue;
    }

    @Override
    public void acknowledge(Envelope env) throws JMSException {
        try {
            if (this.m_jsession.getAckListEnabled() && this.m_jsession.getTransactedFlag()) {
                this.batchAck(env);
            } else {
                this.m_jsession.getAckSession().acknowledgeQmsg(env, this.m_zconnection.getClientId(), this.m_zconnection);
            }
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ETransactionFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    @Override
    void batchAck(Envelope env) throws JMSException {
        try {
            if (this.m_jsession.getTransactedFlag()) {
                this.m_jsession.getAckSession().batchAck(env, this.m_zconnection.getClientId());
            } else {
                this.m_zmessageHandler.getSession().batchAck(env, this.m_zconnection.getClientId());
            }
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    @Override
    public void release(Message msg) {
        msg.getEnvelope().handlerDone(this.m_zmessageHandler.isGuaranteed(), true);
    }

    @Override
    public void release(Envelope env) {
        env.handlerDone(this.m_zmessageHandler.isGuaranteed(), true);
    }

    private void setAckAsQMsgIfNecessary(Envelope env) {
        if (env != null && !env.isQueueMessage()) {
            env.setPubSubMsgAckedAsQMsg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public javax.jms.Message receive() throws JMSException {
        Message msg = null;
        this.m_jsession.checkDeliveryMode(1);
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        this.m_jsession.setDelayedAcknowledgeMessage(null);
        boolean[] blArray = this.m_deliveryStarted;
        synchronized (this.m_deliveryStarted) {
            while (!this.m_deliveryStarted[0] && !this.isClosing()) {
                try {
                    this.m_deliveryStarted.wait();
                }
                catch (InterruptedException e) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("STR006"), "-24", e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.doMakeGetRequest();
            if (this.isClosing()) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("Q_RECEIVER_CLOSED"), new Integer(-5).toString(), null);
            }
            while (true) {
                this.setInSynchronousReceive();
                try {
                    msg = this.getReceivedMessagesQueue().nextMessage();
                }
                finally {
                    this.clearInSynchronousReceive();
                }
                if (this.isClosing() || msg == null) {
                    return null;
                }
                if ((msg = this.checkUndeliverable(msg)) != null) break;
                this.doMakeGetRequest();
            }
            return this.receiveInternal(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public javax.jms.Message receive(long timeOutParam) throws JMSException {
        long timeOut = timeOutParam;
        if (timeOut == 0L) {
            return this.receive();
        }
        Message msg = this.getMessageCheckIsClosingAndUpdateSession();
        long epoc = System.currentTimeMillis();
        boolean[] blArray = this.m_deliveryStarted;
        synchronized (this.m_deliveryStarted) {
            long waitTime = timeOut;
            while (!this.m_deliveryStarted[0] && !this.isClosing()) {
                try {
                    this.m_deliveryStarted.wait(waitTime);
                    if (System.currentTimeMillis() - epoc >= timeOut) {
                        // ** MonitorExit[var8_5] (shouldn't be in output)
                        return null;
                    }
                }
                catch (InterruptedException e) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("STR006"), "-24", e);
                }
                waitTime = timeOut - (System.currentTimeMillis() - epoc);
            }
            // ** MonitorExit[var8_5] (shouldn't be in output)
            this.doMakeGetRequest();
            if ((timeOut -= System.currentTimeMillis() - epoc) <= 0L) {
                return null;
            }
            if (this.isClosing()) {
                return null;
            }
            epoc = System.currentTimeMillis();
            while (true) {
                this.setInSynchronousReceive();
                try {
                    msg = this.getReceivedMessagesQueue().nextMessage(timeOut);
                }
                finally {
                    this.clearInSynchronousReceive();
                }
                if (msg == null) {
                    return null;
                }
                if ((msg = this.checkUndeliverable(msg)) != null) break;
                if (this.isClosing()) {
                    return null;
                }
                if ((timeOut -= System.currentTimeMillis() - epoc) <= 0L) {
                    return null;
                }
                epoc = System.currentTimeMillis();
                this.doMakeGetRequest();
            }
            return this.receiveInternal(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public javax.jms.Message receiveNoWait() throws JMSException {
        Message msg = this.getMessageCheckIsClosingAndUpdateSession();
        boolean[] blArray = this.m_deliveryStarted;
        // MONITORENTER : this.m_deliveryStarted
        if (!this.m_deliveryStarted[0]) {
            // MONITOREXIT : blArray
            return null;
        }
        msg = this.getReceivedMessagesQueue().nextMessageIfAny();
        // MONITOREXIT : blArray
        while (true) {
            if (msg == null) {
                blArray = this.m_deliveryStarted;
                // MONITORENTER : this.m_deliveryStarted
                if (!this.m_deliveryStarted[0]) {
                    // MONITOREXIT : blArray
                    return null;
                }
                // MONITOREXIT : blArray
                try {
                    this.makeGetRequestNoWait();
                }
                catch (EGeneralException e) {
                    throw JMSExceptionUtil.createJMSException(e);
                }
                msg = this.m_brokerQueueEmpty ? this.getReceivedMessagesQueue().nextMessageIfAny() : this.getReceivedMessagesQueue().nextMessage(RX_NOWAIT_CONTINGENCY_TIMEOUT);
            }
            if (msg == null) {
                return this.receiveInternal(msg);
            }
            if ((msg = this.checkUndeliverable(msg)) != null) {
                return this.receiveInternal(msg);
            }
            msg = this.getReceivedMessagesQueue().nextMessageIfAny();
        }
    }

    private Message getMessageCheckIsClosingAndUpdateSession() throws JMSException {
        Message msg = null;
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        this.m_jsession.checkDeliveryMode(1);
        this.m_jsession.setDelayedAcknowledgeMessage(null);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        super.setMessageListener(listener);
        if (listener == null) return;
        boolean deliveryStarted = false;
        boolean[] blArray = this.m_deliveryStarted;
        synchronized (this.m_deliveryStarted) {
            deliveryStarted = this.m_deliveryStarted[0];
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!deliveryStarted) return;
            this.doMakeGetRequest();
            return;
        }
    }

    private void doMakeGetRequest() throws JMSException {
        try {
            this.makeGetRequest();
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefetchCount(int count) throws JMSException {
        if (this.m_jsession.isGetFromXASession() || this.m_isCC) {
            return;
        }
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        if (count < 1 || count < this.m_prefetchThreshold) {
            throw new JMSException(prAccessor.getString("INVALID_PREFETCH_COUNT"));
        }
        MessageConsumer.ReceivedMessagesQueue receivedMessagesQueue = this.m_rxQueue;
        synchronized (receivedMessagesQueue) {
            this.m_prefetchCount = count;
            this.prepareGetRequest();
        }
    }

    public int getPrefetchCount() {
        return this.m_prefetchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefetchThreshold(int threshold) throws JMSException {
        if (this.m_jsession.isGetFromXASession() || this.m_isCC) {
            return;
        }
        if (this.isClosing() || this.m_jsession.isClosing()) {
            throw this.m_jsession.getJMSObjectClosedException();
        }
        if (threshold > this.m_prefetchCount) {
            throw new JMSException(prAccessor.getString("INVALID_PREFETCH_THRESHOLD"));
        }
        MessageConsumer.ReceivedMessagesQueue receivedMessagesQueue = this.m_rxQueue;
        synchronized (receivedMessagesQueue) {
            this.m_prefetchThreshold = threshold;
        }
    }

    public int getPrefetchThreshold() {
        return this.m_prefetchThreshold;
    }

    private void makeOpenRequestThrowJMS(String selector) throws JMSException {
        try {
            this.makeOpenRequest(selector, DestUtil.getDestinationName(this.m_jqueue));
        }
        catch (EInvalidSelectorException ise) {
            throw new InvalidSelectorException(ise.getMessage() + " (Queue: " + DestUtil.getDestinationName(this.m_jqueue) + ", Selector: " + (this.m_selectorString == null ? "null" : "\"" + this.m_selectorString + "\"") + ")");
        }
        catch (EUnauthorizedToReceiveFromQueue urq) {
            throw JMSExceptionUtil.createJMSSecurityException(prAccessor.getString("NOT_AUTH_RECV") + DestUtil.getDestinationName(this.m_jqueue), null);
        }
        catch (EExclusiveQueueOpen eqo) {
            throw JMSExceptionUtil.createJMSException(eqo.getMessage(), null);
        }
        catch (EGeneralException ege) {
            if (ege.getErrorId() == 3005) {
                throw new InvalidDestinationException(ege.getMessage());
            }
            throw JMSExceptionUtil.createJMSException(ege.getMessage(), null);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    private void makeOpenRequest(String selector, String destName) throws EGeneralException, IOException {
        if (this.isClosing()) {
            return;
        }
        progress.message.zclient.Message openReq = new progress.message.zclient.Message(this.openSubject());
        openReq.writeUTF(destName);
        openReq.writeUTF(selector == null ? "" : selector);
        Envelope openEnvelope = new Envelope(openReq);
        progress.message.zclient.Connection openReceiverResolver = this.m_zmessageHandler.getSession().getConnection();
        progress.message.zclient.Message reply = this.m_zmessageHandler.getSession().request(openEnvelope, -1, (IJobResolver)openReceiverResolver);
        if (!reply.readBoolean()) {
            String errmsg = reply.readUTF();
            int errcode = reply.readInt();
            if (errcode == 1) {
                throw new EInvalidSelectorException(errmsg);
            }
            if (errcode == 2) {
                throw new EUnauthorizedToReceiveFromQueue(destName);
            }
            if (errcode == 3) {
                throw new EExclusiveQueueOpen(errmsg);
            }
            if (errcode == 3005) {
                throw new EGeneralException(errcode, errmsg);
            }
            throw new EGeneralException(0, errmsg);
        }
    }

    private void makeCloseRequest() throws JMSException, EGeneralException {
        progress.message.zclient.Message closeReq = new progress.message.zclient.Message(this.closeSubject());
        try {
            closeReq.writeUTF(DestUtil.getDestinationName(this.m_jqueue));
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        Envelope closeEnvelope = new Envelope(closeReq);
        progress.message.zclient.Session zs = this.m_zmessageHandler.getSession();
        if (zs == null) {
            throw JMSExceptionUtil.createJMSException(new ENotConnected());
        }
        progress.message.zclient.Connection closeReceiverResolver = zs.getConnection();
        progress.message.zclient.Message reply = zs.request(closeEnvelope, -1, (IJobResolver)closeReceiverResolver);
    }

    public void makeGetRequest() throws EGeneralException {
        this.makeGetRequest(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeGetRequest(int msgQsizeParam) throws EGeneralException {
        int msgQsize = msgQsizeParam;
        Object object = this.m_closeSyncObject;
        synchronized (object) {
            if (this.isClosing()) {
                return;
            }
            boolean requiresAGet = false;
            MessageConsumer.ReceivedMessagesQueue receivedMessagesQueue = this.m_rxQueue;
            synchronized (receivedMessagesQueue) {
                if (msgQsize == -1) {
                    msgQsize = this.m_rxQueue.size();
                }
                if (msgQsize + this.m_outstandingRequested <= this.m_prefetchThreshold) {
                    requiresAGet = true;
                    this.m_outstandingRequested += this.m_prefetchCount;
                }
            }
            this.publishData(requiresAGet, this.m_getEnvelope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeGetRequestNoWait() throws EGeneralException, JMSException {
        if (this.isClosing()) {
            return;
        }
        Object object = this.m_rxQueue;
        synchronized (object) {
            this.m_requestPending = true;
            ++this.m_outstandingRequested;
        }
        this.m_zmessageHandler.getSession().publish(this.m_getEnvelopeNoWait, 0, false);
        object = this.m_mutex;
        synchronized (object) {
            if (this.m_requestPending) {
                try {
                    this.m_mutex.wait();
                }
                catch (InterruptedException e) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("STR006"), "-24", e);
                }
            }
        }
    }

    long getClientID() {
        return this.m_zconnection.getClientId();
    }

    final String deliverySubject(String queueName) {
        return "$Q." + queueName;
    }

    String openSubject() {
        String userID = this.m_zconnection.getEffectiveUid();
        String appID = this.m_zconnection.getApplicationId();
        return SessionConfig.getAdminPrefix(userID, appID) + ".openReceiver";
    }

    String closeSubject() {
        String userID = this.m_zconnection.getEffectiveUid();
        String appID = this.m_zconnection.getApplicationId();
        return SessionConfig.getAdminPrefix(userID, appID) + ".closeReceiver";
    }

    final void prepareGetRequest() throws JMSException {
        String getSubject = null;
        try {
            getSubject = this.deliverySubject(DestUtil.getDestinationName(this.m_jqueue));
        }
        catch (JMSException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        this.m_getMessage = new progress.message.zclient.Message(getSubject);
        this.m_getMessage.writeShort(1);
        this.m_getMessage.writeInt(this.m_prefetchCount);
        this.m_getEnvelope = new Envelope(this.m_getMessage);
        this.m_getEnvelope.setPtp((byte)13);
        this.m_getMessageNoWait = new progress.message.zclient.Message(getSubject);
        this.m_getMessageNoWait.writeShort(2);
        this.m_getMessageNoWait.writeInt(this.m_prefetchCount);
        this.m_getEnvelopeNoWait = new Envelope(this.m_getMessageNoWait);
        this.m_getEnvelopeNoWait.setPtp((byte)13);
        this.m_getEnvelopeFT = (Envelope)this.m_getEnvelope.clone();
        this.m_getEnvelopeNoWaitFT = (Envelope)this.m_getEnvelopeNoWait.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementOutstandingRequested() {
        MessageConsumer.ReceivedMessagesQueue receivedMessagesQueue = this.m_rxQueue;
        synchronized (receivedMessagesQueue) {
            this.m_outstandingRequested = this.m_outstandingRequested >= 1 ? this.m_outstandingRequested - 1 : 0;
        }
    }

    private void setInSynchronousReceive() {
        this.m_in_synchronous_receive.put(Thread.currentThread(), new Integer(0));
    }

    private void clearInSynchronousReceive() {
        this.m_in_synchronous_receive.remove(Thread.currentThread());
    }

    private boolean inSynchronousReceive() {
        return !this.m_in_synchronous_receive.isEmpty();
    }

    @Override
    public void setCompletionListener(IDoubtResolverCompletionListener listener) {
        this.m_doubtlistener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initiateResolution() throws EGeneralException {
        block12: {
            if (this.isClosing() || this.isClosePending()) {
                if (this.m_doubtlistener != null) {
                    this.m_doubtlistener.completed(this, 0);
                }
                return;
            }
            this.m_outstandingRequested = 0;
            try {
                String dest = DestUtil.getDestinationName(this.m_jqueue);
                this.makeOpenRequest(this.m_selectorString, dest);
                if (!this.m_deliveryStarted[0]) break block12;
                this.publishData(this.m_requestPending, this.m_getEnvelopeNoWaitFT);
                boolean requiresAGet = false;
                MessageConsumer.ReceivedMessagesQueue receivedMessagesQueue = this.m_rxQueue;
                synchronized (receivedMessagesQueue) {
                    boolean bl = requiresAGet = this.m_isCC || this.m_jlistener != null || this.inSynchronousReceive() && this.m_rxQueue.isEmpty();
                    if (requiresAGet) {
                        this.m_outstandingRequested = this.m_prefetchCount;
                    }
                }
                this.publishData(requiresAGet, this.m_getEnvelopeFT);
            }
            catch (EExclusiveQueueOpen ege) {
                throw new EConnectionNotResumable(ege);
            }
            catch (EUnauthorizedToReceiveFromQueue eun) {
                throw new EConnectionNotResumable(eun);
            }
            catch (JMSException jmse) {
                throw new EGeneralException(0, jmse.getMessage(), jmse);
            }
            catch (IOException ioe) {
                throw new EGeneralException(0, ioe.getMessage(), ioe);
            }
        }
        if (this.m_doubtlistener != null) {
            this.m_doubtlistener.completed(this, 0);
        }
    }

    private void publishData(boolean requiresAGet, Envelope m_getEnvelopeFT) throws EGeneralException {
        if (requiresAGet) {
            this.m_zmessageHandler.getSession().publish(m_getEnvelopeFT, 0, false);
        }
    }

    @Override
    public void onDisconnectDuringResolution() {
    }

    @Override
    public void processUndeliverable(Envelope env, int errorCode) throws JMSException {
        try {
            this.m_zmessageHandler.getSession().processUndeliverable(env, errorCode, this.m_zconnection.getClientId());
            this.release(env);
        }
        catch (ENetworkFailure e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
        catch (ESecurityPolicyViolation e) {
            throw JMSExceptionUtil.createJMSSecurityException(e);
        }
        catch (EGeneralException e) {
            throw JMSExceptionUtil.createJMSException(e);
        }
    }

    private class DefaultHandler
    extends MessageHandler {
        DefaultHandler(boolean noThread) {
            super(null, true, noThread);
            this.setName("Queue Receiver msg handler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(progress.message.zclient.Session s, Envelope env) {
            ISubject isubj = env.getMessage().getSubject();
            if (!isubj.isAnySystem()) {
                QueueReceiver.this.m_ihandler.handleMessage(s, env);
                return;
            }
            String subject = isubj.getSubjectString();
            if (subject.endsWith(".queueEmpty")) {
                QueueReceiver.this.m_brokerQueueEmpty = true;
                Object object = QueueReceiver.this.m_rxQueue;
                synchronized (object) {
                    QueueReceiver.this.m_outstandingRequested = QueueReceiver.this.m_outstandingRequested >= 1 ? QueueReceiver.this.m_outstandingRequested - 1 : 0;
                }
                object = QueueReceiver.this.m_mutex;
                synchronized (object) {
                    QueueReceiver.this.m_requestPending = false;
                    QueueReceiver.this.m_mutex.notifyAll();
                }
            }
            if (subject.endsWith(".queueNotEmpty")) {
                QueueReceiver.this.m_brokerQueueEmpty = false;
                Object object = QueueReceiver.this.m_mutex;
                synchronized (object) {
                    QueueReceiver.this.m_requestPending = false;
                    QueueReceiver.this.m_mutex.notifyAll();
                }
            }
            if ("$SYS.client.brokerConnectionDropped".equals(subject)) {
                Object object = QueueReceiver.this.getReceivedMessagesQueue();
                synchronized (object) {
                    QueueReceiver.this.m_closing = true;
                    QueueReceiver.this.getReceivedMessagesQueue().notifyAll();
                }
                QueueReceiver.this.m_brokerQueueEmpty = true;
                object = QueueReceiver.this.m_mutex;
                synchronized (object) {
                    QueueReceiver.this.m_requestPending = false;
                    QueueReceiver.this.m_mutex.notifyAll();
                }
            }
            env.handlerDone(QueueReceiver.this.m_zmessageHandler.isGuaranteed(), false);
        }
    }

    private class IHandler
    implements IMessageHandler {
        private IHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(progress.message.zclient.Session session, Envelope env) {
            Message msg = null;
            QueueReceiver.this.setAckAsQMsgIfNecessary(env);
            try {
                msg = QueueReceiver.this.extract(env);
                MessageConsumer.ReceivedMessagesQueue receivedMessagesQueue = QueueReceiver.this.m_rxQueue;
                synchronized (receivedMessagesQueue) {
                    QueueReceiver.this.m_outstandingRequested = QueueReceiver.this.m_outstandingRequested >= 1 ? QueueReceiver.this.m_outstandingRequested - 1 : 0;
                    QueueReceiver.this.m_rxQueue.receiveMessage(msg);
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

