/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.server;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class ByteBufferInputStream
extends ByteArrayInputStream
implements DataInput {
    public ByteBufferInputStream(byte[] buf) {
        super(buf);
    }

    public ByteBufferInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public void setOffset(int offset) {
        this.pos = offset;
    }

    public int getOffset() {
        return this.pos;
    }

    @Override
    public void readFully(byte[] b) throws IOException, NullPointerException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.read(b, 0, b.length) == -1) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.read(b, off, len) == -1) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkCountIsPos();
        return this.read() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.checkCountIsPos();
        return (byte)this.read();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.checkCountIsPos();
        return this.read();
    }

    private void checkCountIsPos() throws EOFException {
        if (this.count == this.pos) {
            throw new EOFException();
        }
    }

    @Override
    public short readShort() throws IOException {
        byte a = this.checkAvailableAndRead();
        byte b = (byte)this.read();
        return (short)(a << 8 | b & 0xFF);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        byte a = this.checkAvailableAndRead();
        byte b = (byte)this.read();
        return (a & 0xFF) << 8 | b & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        byte a = this.checkAvailableAndRead();
        byte b = (byte)this.read();
        return (char)(a << 8 | b & 0xFF);
    }

    private byte checkAvailableAndRead() throws EOFException {
        if (this.available() < 2) {
            throw new EOFException();
        }
        byte a = (byte)this.read();
        return a;
    }

    @Override
    public int readInt() throws IOException {
        if (this.available() < 4) {
            throw new EOFException();
        }
        byte a = (byte)this.read();
        byte b = (byte)this.read();
        byte c = (byte)this.read();
        byte d = (byte)this.read();
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (c & 0xFF) << 8 | d & 0xFF;
    }

    @Override
    public long readLong() throws IOException {
        if (this.available() < 8) {
            throw new EOFException();
        }
        byte a = (byte)this.read();
        byte b = (byte)this.read();
        byte c = (byte)this.read();
        byte d = (byte)this.read();
        byte e = (byte)this.read();
        byte f = (byte)this.read();
        byte g = (byte)this.read();
        byte h = (byte)this.read();
        return (long)(a & 0xFF) << 56 | (long)(b & 0xFF) << 48 | (long)(c & 0xFF) << 40 | (long)(d & 0xFF) << 32 | (long)(e & 0xFF) << 24 | (long)(f & 0xFF) << 16 | (long)(g & 0xFF) << 8 | (long)(h & 0xFF);
    }

    @Override
    public float readFloat() throws IOException {
        int raw = this.readInt();
        return Float.intBitsToFloat(raw);
    }

    @Override
    public double readDouble() throws IOException {
        long raw = this.readLong();
        return Double.longBitsToDouble(raw);
    }

    @Override
    public String readLine() throws IOException {
        int c;
        StringBuffer input = new StringBuffer();
        while ((c = this.read()) != -1 && c != 10) {
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public String readUTF() throws IOException {
        int utflen = this.readShort() & 0xFFFF;
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        block5: while (count < utflen) {
            int c = this.readByte() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = this.readByte() & 0xFF;
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = this.readByte() & 0xFF;
                    int char3 = this.readByte() & 0xFF;
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str, 0, strlen);
    }

    public String readChars() throws IOException {
        int len = this.readShort();
        char[] str = new char[len];
        for (int i = 0; i < len; ++i) {
            str[i] = this.readChar();
        }
        return new String(str);
    }

    public String toString() {
        return "ByteBufferInputStream: pos = " + this.pos + ", count = " + this.count + "buf.length = " + this.buf.length;
    }

    private void debug(String s) {
        System.out.println("ByteBufferInputStream: " + s);
    }
}

