/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.interceptor.advisors;

import com.sonicsw.interceptor.IAdvisor;
import com.sonicsw.interceptor.IInterceptor;
import com.sonicsw.interceptor.SimpleContext;
import com.sonicsw.interceptor.pointcuts.HTTPPointCut;
import java.util.ArrayList;

public class HTTPAdvisor
extends HTTPPointCut
implements IAdvisor {
    private static HTTPAdvisor s_instance = null;
    private ArrayList m_interceptors = null;

    public static synchronized HTTPAdvisor getInstance() {
        if (s_instance == null) {
            s_instance = new HTTPAdvisor();
        }
        return s_instance;
    }

    private HTTPAdvisor() {
    }

    @Override
    public boolean addInterceptor(IInterceptor interceptor) {
        if (interceptor instanceof HTTPPointCut) {
            this.m_interceptors.add(interceptor);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterceptor(int type) throws UnsupportedOperationException {
        ArrayList arrayList = this.m_interceptors;
        synchronized (arrayList) {
            if (!this.m_interceptors.isEmpty()) {
                for (IInterceptor interceptor : this.m_interceptors) {
                    if (type != 2 || !(interceptor instanceof HTTPPointCut)) continue;
                    this.m_interceptors.remove(interceptor);
                }
            }
        }
    }

    @Override
    public int getAdvisorType() {
        return 2;
    }

    @Override
    public void onServerRequest(SimpleContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            HTTPPointCut interceptor = (HTTPPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onServerRequest(param);
        }
    }

    @Override
    public void onServerResponse(SimpleContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            HTTPPointCut interceptor = (HTTPPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onServerResponse(param);
        }
    }

    @Override
    public void onClientRequest(SimpleContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            HTTPPointCut interceptor = (HTTPPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onClientRequest(param);
        }
    }

    @Override
    public void onClientResponse(SimpleContext param) {
        for (int i = 0; i < this.m_interceptors.size(); ++i) {
            HTTPPointCut interceptor = (HTTPPointCut)this.m_interceptors.get(i);
            if (interceptor == null) continue;
            interceptor.onClientResponse(param);
        }
    }
}

