/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.info.INotificationInfo;
import com.sonicsw.mf.common.info.InfoFactory;
import com.sonicsw.mf.common.info.impl.NotificationInfo;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.impl.MetricsManager;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mq.components.BrokerComponent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentSender;
import progress.message.broker.BaseAgentQueue;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.Config;
import progress.message.broker.LogManager;

public final class BrokerMetricsHelper {
    private static IComponentContext m_mfContext;
    private static IMetricsRegistrar m_metricsRegistrar;
    private static final IMetricInfo[] EMPTY_METRIC_INFO_ARRAY;
    private static final Class[] DELEGATES;
    private static final String ENABLE_METRICS_PROPERTY = "sonicsw.mq.enableMetrics";
    private static boolean DEBUG;

    static synchronized void init(IComponentContext mfContext) {
        if (m_mfContext != null) {
            throw new IllegalStateException("Context already set");
        }
        m_mfContext = mfContext;
        IMetricInfo[] metricInfos = BrokerMetricsHelper.getMetricsInfo();
        m_metricsRegistrar = m_mfContext.initMetricsManagement(metricInfos);
        IElement config = m_mfContext.getConfiguration(true);
        IAttributeSet attrs = config.getAttributes();
        if (config.getIdentity().getType().equals("MQ_BACKUPBROKER")) {
            IAttributeSet bcers = (IAttributeSet)attrs.getAttribute("CONFIG_ELEMENT_REFERENCES");
            Reference pref = (Reference)bcers.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
            config = m_mfContext.getConfiguration(pref.getElementName(), true);
            attrs = config.getAttributes();
        }
        IAttributeSet cers = (IAttributeSet)attrs.getAttribute("CONFIG_ELEMENT_REFERENCES");
        Reference clusterReference = (Reference)cers.getAttribute("CLUSTER_CONFIG_ELEMENT_REF");
        String clusterNodeName = null;
        if (clusterReference != null) {
            IAttributeSet cattrs = m_mfContext.getConfiguration(clusterReference.getElementName(), false).getAttributes();
            clusterNodeName = (String)cattrs.getAttribute("ROUTING_NODE_NAME");
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("Broker", attrs.getAttribute("BROKER_NAME"));
        IAttributeSet routingAttrs = (IAttributeSet)attrs.getAttribute("BROKER_ROUTING_PARAMETERS");
        if (clusterNodeName != null) {
            attributes.put("Routing", clusterNodeName);
        } else if (routingAttrs != null) {
            attributes.put("Routing", routingAttrs.getAttribute("ROUTING_NODE_NAME"));
        }
        m_metricsRegistrar.registerAlertNotificationProperties((short)2, attributes);
        BrokerMetricsHelper.enableMetrics(BrokerMetricsHelper.getStaticMetricIDs(metricInfos));
        BrokerMetricsHelper.enableInternalMetrics();
    }

    public static IMetricsRegistrar getMetricsRegistrar() {
        return m_metricsRegistrar;
    }

    static void enableMetrics(IMetricIdentity[] ids) {
        if (Config.DEBUG) {
            String s = "";
            for (int i = 0; i < ids.length; ++i) {
                s = s + "\n - " + ids[i].getName();
            }
            BrokerComponent.getComponentContext().logMessage("BrokerMetricsHelper - enableMetrics : " + s, 3);
        }
        String method = "enableMetrics";
        BrokerMetricsHelper.passIdsToDelegates(ids, method);
    }

    static void disableMetrics(IMetricIdentity[] ids) {
        String method = "disableMetrics";
        BrokerMetricsHelper.passIdsToDelegates(ids, method);
    }

    private static void passIdsToDelegates(IMetricIdentity[] ids, String method) {
        for (int i = 0; i < DELEGATES.length; ++i) {
            Method m = null;
            try {
                m = DELEGATES[i].getMethod(method, IMetricsRegistrar.class, IMetricIdentity[].class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (m == null) continue;
            String err = "Error invoking method " + method + " on component " + DELEGATES[i].getName();
            try {
                m.invoke(null, m_metricsRegistrar, ids);
                continue;
            }
            catch (InvocationTargetException e) {
                m_mfContext.logMessage(err, (Throwable)e, 2);
                continue;
            }
            catch (IllegalAccessException e) {
                m_mfContext.logMessage(err, (Throwable)e, 2);
            }
        }
    }

    static String[] getInstanceMetricNames(IMetricIdentity id) {
        if (id.getName().startsWith("queue.")) {
            return BaseAgentQueue.getInstanceMetricNames(id);
        }
        if (id.getName().startsWith("connection.")) {
            return AgentConnection.getInstanceMetricNames(id);
        }
        throw new MFRuntimeException("No support for instances relating to metric " + id.getName());
    }

    static long getMetricsRefreshInterval() {
        return m_metricsRegistrar.getRefreshInterval();
    }

    static void setMetricsRefreshInterval(long interval) throws MFException {
        m_metricsRegistrar.setRefreshInterval(interval);
    }

    static long getMetricsCollectionInterval() {
        return m_metricsRegistrar.getCollectionInterval();
    }

    static void setMetricsCollectionInterval(long interval) throws MFException {
        m_metricsRegistrar.setCollectionInterval(interval);
    }

    static boolean getRepeatMetricAlerts() {
        return m_metricsRegistrar.getRepeatMetricAlerts();
    }

    static void setRepeatMetricAlerts(boolean repeat) throws MFException {
        m_metricsRegistrar.setRepeatMetricAlerts(repeat);
    }

    static INotificationInfo[] getManagementInfo() {
        ArrayList<INotificationInfo> infos = new ArrayList<INotificationInfo>();
        IMetricInfo[] metricsInfos = BrokerMetricsHelper.getMetricsInfo();
        for (int i = 0; i < metricsInfos.length; ++i) {
            if (!metricsInfos[i].supportsHighThresholdAlerts() && !metricsInfos[i].supportsLowThresholdAlerts()) continue;
            infos.add(InfoFactory.createNotificationInfo((short)2, (String)INotification.SUBCATEGORY_TEXT[4], (String)metricsInfos[i].getMetricIdentity().getName(), (String)("Alert for metric " + metricsInfos[i].getMetricIdentity().getName())));
        }
        INotificationInfo[] ret = infos.toArray(new INotificationInfo[0]);
        if (DEBUG) {
            for (int i = 0; i < ret.length; ++i) {
                NotificationInfo inf = (NotificationInfo)ret[i];
                System.out.println("INotification = " + i + "\n " + Arrays.toString(inf.getNotifTypes()) + " name = " + inf.getName() + " Description = " + inf.getDescription());
            }
        }
        return ret;
    }

    private static IMetricInfo[] getMetricsInfo() {
        ArrayList infos = new ArrayList();
        String method = "getMetricsInfo";
        for (int i = 0; i < DELEGATES.length; ++i) {
            Method m = null;
            try {
                m = DELEGATES[i].getMethod(method, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (m == null) continue;
            String err = "Error invoking method " + method + " on component " + DELEGATES[i].getName();
            try {
                List ret = (List)m.invoke(null, (Object[])null);
                infos.addAll(ret);
                continue;
            }
            catch (InvocationTargetException e) {
                m_mfContext.logMessage(err, (Throwable)e, 2);
                continue;
            }
            catch (IllegalAccessException e) {
                m_mfContext.logMessage(err, (Throwable)e, 2);
            }
        }
        IMetricInfo[] metricInfos = infos.toArray(EMPTY_METRIC_INFO_ARRAY);
        return metricInfos;
    }

    private static IMetricIdentity[] getStaticMetricIDs(IMetricInfo[] metricInfos) {
        ArrayList<IMetricIdentity> staticMetricsIDs = new ArrayList<IMetricIdentity>();
        for (int i = 0; i < metricInfos.length; ++i) {
            if (metricInfos[i].isDynamic()) continue;
            staticMetricsIDs.add(metricInfos[i].getMetricIdentity());
        }
        return staticMetricsIDs.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY);
    }

    private static void enableInternalMetrics() {
        String enableMetrics = System.getProperty(ENABLE_METRICS_PROPERTY);
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("BrokerMetricsHelper: enableInternalMetrics = " + enableMetrics, 3);
        }
        if (enableMetrics == null) {
            return;
        }
        try {
            ArrayList<IMetricIdentity> internalMetricIds = new ArrayList<IMetricIdentity>();
            StringTokenizer st = new StringTokenizer(enableMetrics, ";");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                IMetricIdentity id = MetricsFactory.createMetricIdentity((String)name);
                internalMetricIds.add(id);
            }
            IMetricIdentity[] intIds = ((MetricsManager)m_metricsRegistrar).enableAllMetrics(internalMetricIds.toArray(IMetricIdentity.EMPTY_METRIC_IDENTITY_ARRAY));
            if (DEBUG) {
                System.out.println("internal ids = " + intIds.length);
                for (int i = 0; i < intIds.length; ++i) {
                    System.out.println(" - " + intIds[i]);
                }
            }
            BrokerMetricsHelper.enableMetrics(intIds);
        }
        catch (Exception e) {
            String err = "Error enabling internal metrics: " + enableMetrics;
            m_mfContext.logMessage(err, (Throwable)e, 2);
            return;
        }
    }

    static {
        EMPTY_METRIC_INFO_ARRAY = new IMetricInfo[0];
        DELEGATES = new Class[]{AgentListener.class, AgentSender.class, AgentConnection.class, BaseAgentQueue.class, LogManager.class, BrokerDatabase.class};
        DEBUG = false;
    }
}

