/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.receiver.fsm;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.ws.HTTPSender;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.AddressingHandlerWrapper;
import com.sonicsw.ws.axis.handlers.LogHandler;
import com.sonicsw.ws.axis.handlers.NullifyRecorder;
import com.sonicsw.ws.axis.handlers.RMHandler;
import com.sonicsw.ws.axis.handlers.SOAPFixer;
import com.sonicsw.ws.axis.handlers.SecurityHandler;
import com.sonicsw.ws.rm.receiver.fsm.AxisMessageContextApplier;
import java.io.IOException;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;

public class ReceiverClient {
    private static ReceiverClient s_receiverClient = null;
    private AxisClient m_clientEngine;
    private SimpleTargetedChain m_axisRMControlChain = this.constructAxisClient();
    private LogHandler m_logHandler = null;

    public static synchronized ReceiverClient getReceiverClient() {
        if (s_receiverClient == null) {
            s_receiverClient = new ReceiverClient();
        }
        return s_receiverClient;
    }

    private SimpleTargetedChain constructAxisClient() {
        if (DebugObjects.getProtocolDebug().getDebug()) {
            this.m_logHandler = new LogHandler(BrokerComponent.getBrokerComponent().getBrokerName() + ".wscontrol.log");
        }
        this.m_clientEngine = new AxisClient();
        HTTPSender sender = new HTTPSender();
        SimpleChain controlRequestChain = new SimpleChain();
        controlRequestChain.addHandler((Handler)new NullifyRecorder());
        controlRequestChain.addHandler((Handler)new SecurityHandler());
        controlRequestChain.addHandler((Handler)new AddressingHandlerWrapper());
        controlRequestChain.addHandler((Handler)new SOAPFixer());
        if (this.m_logHandler != null) {
            controlRequestChain.addHandler((Handler)this.m_logHandler);
        }
        SimpleChain controlResponseChain = new SimpleChain();
        if (this.m_logHandler != null) {
            controlResponseChain.addHandler((Handler)this.m_logHandler);
        }
        controlResponseChain.addHandler((Handler)new AddressingHandlerWrapper());
        controlResponseChain.addHandler((Handler)new SecurityHandler());
        controlResponseChain.addHandler((Handler)new RMHandler());
        SimpleTargetedChain stc = new SimpleTargetedChain((Handler)controlRequestChain, (Handler)sender, (Handler)controlResponseChain);
        stc.init();
        return stc;
    }

    public AxisClient getAxisClient() {
        return this.m_clientEngine;
    }

    public void sendAxis(MessageContext mc) throws AxisFault, SOAPException, IOException {
        try {
            AxisMessageContextApplier.applyCurrentMessageContext(mc);
            this.m_axisRMControlChain.invoke(mc);
        }
        catch (AxisFault af) {
            if (mc.getProperty("COM_SONIC_WS_AXISFAULT_PROCESSED") != af) {
                throw af;
            }
            DebugObjects.getHandlerDebug().debug("Fault Handled");
        }
    }
}

