/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.util.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import net.sf.saxon.om.NamespaceResolver;

public class NamespaceContextImpl
implements NamespaceContext,
NamespaceResolver {
    private Hashtable namespacesByPrefix_ = new Hashtable();

    public NamespaceContextImpl() {
        this.clearNamespaces();
    }

    public final void clearNamespaces() {
        this.namespacesByPrefix_.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("", "");
    }

    public void declareNamespace(String prefix, String uri) throws IllegalArgumentException {
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("Namespace prefix or uri is null");
        }
        this.namespacesByPrefix_.put(prefix, uri);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String returnValue = (String)this.namespacesByPrefix_.get(prefix);
        if (returnValue == null) {
            // empty if block
        }
        return returnValue;
    }

    @Override
    public String getPrefix(String uri) {
        if (uri != null) {
            Enumeration prefixes = this.namespacesByPrefix_.keys();
            while (prefixes.hasMoreElements()) {
                String prefix = (String)prefixes.nextElement();
                String uriForPrefix = (String)this.namespacesByPrefix_.get(prefix);
                if (!uriForPrefix.equals(uri)) continue;
                return prefix;
            }
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        ArrayList<String> prefixList = new ArrayList<String>();
        if (uri != null) {
            Enumeration prefixes = this.namespacesByPrefix_.keys();
            while (prefixes.hasMoreElements()) {
                String prefix = (String)prefixes.nextElement();
                String uriForPrefix = (String)this.namespacesByPrefix_.get(prefix);
                if (!uriForPrefix.equals(uri)) continue;
                prefixList.add(prefix);
            }
        }
        return prefixList.iterator();
    }

    public Iterator iteratePrefixes() {
        ArrayList<String> prefixList = new ArrayList<String>();
        Enumeration prefixes = this.namespacesByPrefix_.keys();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            prefixList.add(prefix);
        }
        return prefixList.iterator();
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.length() == 0 && !useDefault) {
            return "";
        }
        return (String)this.namespacesByPrefix_.get(prefix);
    }
}

