/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mq.components.BrokerComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import progress.message.broker.AgentAdministrativelyCreatedQueue;
import progress.message.broker.AgentDelayedDeliveryQueue;
import progress.message.broker.AgentQueueDispatcher;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentRoutingQueue;
import progress.message.broker.AgentTemporaryQueue;
import progress.message.broker.Config;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IMessageGroupHandle;
import progress.message.broker.IMinEnqueuePriorityListener;
import progress.message.msg.IMgram;
import progress.message.zclient.DebugObject;
import progress.message.zclient.FastVector;

public abstract class BaseAgentQueue
extends DebugObject
implements IAgentQueue,
IMinEnqueuePriorityListener {
    protected AgentQueueDispatcher m_dispatcher = null;
    private FastVector m_remoteGetRequests = new FastVector();
    private final FastVector m_localGetRequests = new FastVector();
    private final Object m_dispatchMutex = new Object();
    private boolean m_dispatchStarted = false;
    private boolean m_pendingDispatch = false;
    private static Object m_metricsMutex = new Object();
    private static IMetricsRegistrar m_metricsRegistrar;
    protected IStatistic m_queueRecvdPerSecStat;
    protected IStatistic m_queueDelvdPerSecStat;
    protected IStatistic m_queueBytesRecvdPerSecStat;
    protected IStatistic m_queueBytesDelvdPerSecStat;
    protected IStatistic m_queueMaxDepthStat;
    private boolean m_queueMaxDepthInstanceEnabled;
    private boolean m_queueCountInstanceEnabled;
    protected IStatistic m_queueSizeStat;
    protected IStatistic m_maxAgeStat;
    protected IStatistic m_timeInQueueStat;

    public BaseAgentQueue() {
    }

    public BaseAgentQueue(String debugName) {
        super(debugName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean canLogFlushBeDelayed() {
        BaseAgentQueue baseAgentQueue = this;
        synchronized (baseAgentQueue) {
            return (this.getPercentageFull() < 5L || this.getTotalEnqueued() <= this.getRequestCount()) && this.getReceiverCount() > 0 && this.getNonDelayableReceiverCount() <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addRequest(long cid, int count, boolean isRemoteRequest) {
        if (isRemoteRequest && !this.isClustered()) {
            return;
        }
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            if (isRemoteRequest) {
                this.m_remoteGetRequests.addElement(new GetRequest(cid, count));
            } else {
                this.m_localGetRequests.addElement(new GetRequest(cid, count));
                this.generateRemoteGetsIfNeeded();
            }
            this.initiateDispatching(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void generateRemoteGetsIfNeeded() {
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            if (this.m_localGetRequests.m_count > 0 && this.isClustered() && this.getTotalEnqueued() == 0) {
                this.onOutstandingLocalClientGetRequests();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearAllRemoteRequests() {
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            this.m_remoteGetRequests = new FastVector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getRequestCount() {
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            return this.m_localGetRequests.m_count + this.m_remoteGetRequests.m_count;
        }
    }

    @Override
    public final void startDelivery(long cid) {
        this.initiateDispatching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearRemoteRequests(long cid) {
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            int i = 0;
            while (i < this.m_remoteGetRequests.m_count) {
                if (((GetRequest)this.m_remoteGetRequests.m_data[i]).m_client == cid) {
                    if (this.DEBUG) {
                        this.debug("AgentQueueDispatcher$RequestQueue.clearRemoteRequests: Removing REMOTE get request CID:" + ((GetRequest)this.m_remoteGetRequests.m_data[i]).m_client + ", count = " + ((GetRequest)this.m_remoteGetRequests.m_data[i]).m_count);
                    }
                    this.m_remoteGetRequests.removeElementAt(i);
                    continue;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearLocalRequests(long cid) {
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            int i = 0;
            while (i < this.m_localGetRequests.m_count) {
                if (((GetRequest)this.m_localGetRequests.m_data[i]).m_client == cid) {
                    if (this.DEBUG) {
                        this.debug("AgentQueueDispatcher$RequestQueue.clearRequests: Removing request CID:" + ((GetRequest)this.m_localGetRequests.m_data[i]).m_client + ", count = " + ((GetRequest)this.m_localGetRequests.m_data[i]).m_count);
                    }
                    this.m_localGetRequests.removeElementAt(i);
                    continue;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void dispatchStartup(AgentQueueDispatcher dispatcher) {
        this.m_dispatcher = dispatcher;
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            this.m_dispatchStarted = true;
            this.initiateDispatching();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void dispatchShutdown() {
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            this.m_dispatchStarted = false;
            this.cancelPendingDispatch();
        }
    }

    @Override
    public void notifyMinEnqueuePriorityChange() {
        if (this.DEBUG) {
            this.debug(" ++++++UNBLOCKING++++++ notifyMinEnqueuePriorityChange");
        }
        this.initiateDispatching();
    }

    protected final void initiateDispatching() {
        this.initiateDispatching(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void initiateDispatching(boolean sync) {
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            if (!this.m_dispatchStarted) {
                return;
            }
            if (!this.isDispatchNeeded()) {
                return;
            }
            if (sync) {
                try {
                    if (this.doSyncDispatchingInternal()) {
                        this.cancelPendingDispatch();
                        if (this.DEBUG) {
                            this.debug("Sync Dispatch success!");
                        }
                        return;
                    }
                    if (this.DEBUG) {
                        this.debug("Sync Dispatch was not successful.");
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.m_pendingDispatch) {
                return;
            }
            this.m_pendingDispatch = true;
            this.m_dispatcher.addQueueToDispatchList(this);
        }
    }

    private void cancelPendingDispatch() {
        if (this.m_pendingDispatch && this.m_dispatcher.removeQueueFromDispatchList(this)) {
            this.m_pendingDispatch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void processDispatchRequests() throws InterruptedException {
        Object object = this.m_dispatchMutex;
        synchronized (object) {
            this.m_pendingDispatch = false;
            if (this.DEBUG) {
                this.debug("AQD DISPATCH on queue: " + this.getDispatchDebugStats());
            }
            this.initiateDispatching(true);
            if (this.DEBUG) {
                this.debug("AQD DISPATCH FINISHED on queue: " + this.getDispatchDebugStats());
            }
        }
    }

    private final String getDispatchDebugStats() {
        return this.getQueueName() + "\n count: " + this.getTotalEnqueued() + " locReq: " + this.m_localGetRequests.m_count + " remReq: " + this.m_remoteGetRequests.m_count;
    }

    private final boolean doSyncDispatchingInternal() throws InterruptedException {
        if (this.DEBUG) {
            this.debug("Processing sync dispatches on queue: " + this.getDispatchDebugStats());
        }
        boolean reinitiateDispatching = false;
        if (this.m_localGetRequests.m_count > 0 && !this.processGetRequestsListInternal(this.m_localGetRequests, false)) {
            reinitiateDispatching = true;
        }
        if (this.m_remoteGetRequests.m_count > 0 && !this.processGetRequestsListInternal(this.m_remoteGetRequests, true)) {
            reinitiateDispatching = true;
        }
        if (this.DEBUG) {
            this.debug("Finished dispatches on queue: " + this.getDispatchDebugStats());
        }
        return !reinitiateDispatching || !this.canDispatch();
    }

    private final boolean processGetRequestsListInternal(FastVector getReqs, boolean remote) throws InterruptedException {
        int i = 0;
        GetRequest req = null;
        int dispatched = 0;
        boolean initFlag = false;
        while (i < getReqs.m_count) {
            if (this.DEBUG) {
                this.debug("AgentQueueDispatcher: dispatching while loop for remote=" + remote + " get request i:" + i + " rq.m_remoteRequests.m_count: " + getReqs.m_count);
            }
            req = (GetRequest)getReqs.m_data[i];
            if (this.getTotalEnqueued() == 0) break;
            if (this.DEBUG) {
                this.debug("dispatching to CID:" + req.m_client + "from queue " + this.getQueueName() + ", count = " + req.m_count);
            }
            if ((dispatched = this.dispatch(req.m_client, req.m_count, remote)) < 0) {
                initFlag = true;
            } else {
                req.m_count -= dispatched;
            }
            if (req.m_count == 0) {
                getReqs.removeElementAt(i);
                continue;
            }
            ++i;
        }
        if (!remote && getReqs.m_count > 0) {
            this.onOutstandingLocalClientGetRequests();
        }
        return !initFlag;
    }

    private final boolean isDispatchNeeded() {
        return !(this.m_localGetRequests.m_count <= 0 && this.m_remoteGetRequests.m_count <= 0 || !this.isClustered() && this.getTotalEnqueued() <= 0);
    }

    private final boolean canDispatch() {
        return (this.m_localGetRequests.m_count > 0 || this.m_remoteGetRequests.m_count > 0) && this.getTotalEnqueued() > 0;
    }

    @Override
    public IMessageGroupHandle getMessageGroupHandle() {
        return null;
    }

    public static List getMetricsInfo() {
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("BaseAgentQueue - getMetricsInfo ", 3);
        }
        ArrayList<IMetricInfo> infos = new ArrayList<IMetricInfo>();
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)QUEUE_MSGS_RECEIVEDPERSECOND_METRIC, (short)8, (String)"Messages received by a queue per second", null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)"messages per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)QUEUE_MSGS_DELIVEREDPERSECOND_METRIC, (short)8, (String)"Messages delivered to a queue per second (including rejected messages).", null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)"messages per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)QUEUE_BYTES_RECEIVEDPERSECOND_METRIC, (short)8, (String)"Bytes received by a queue per second", null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)"bytes per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)QUEUE_BYTES_DELIVEREDPERSECOND_METRIC, (short)8, (String)"Bytes delivered to a queue per second (including rejected messages).", null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)"bytes per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)QUEUE_MSGS_MAXDEPTH_METRIC, (short)4, (String)"Maximum number of messages in a queue during a collection interval.", null, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (String)"messages"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)QUEUE_MSGS_COUNT_METRIC, (short)0, (String)"Number of messages in a queue.", null, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (String)"messages"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)QUEUE_MSGS_SIZE_METRIC, (short)0, (String)"Size of messages in a queue.", null, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (String)"bytes"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)QUEUE_MSGS_MAXAGE_METRIC, (short)0, (String)"Age in seconds of the oldest message on the queue.", null, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (String)"seconds"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)QUEUE_MSGS_TIMEINQUEUE_METRIC, (short)5, (String)"Average time in the queue (in seconds) of messages dequeued during a collection interval.", null, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (String)"seconds"));
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        Object object = m_metricsMutex;
        synchronized (object) {
            if (Config.DEBUG) {
                String s = "";
                for (int i = 0; i < ids.length; ++i) {
                    s = s + "\n - " + ids[i].getName();
                }
                BrokerComponent.getComponentContext().logMessage("BaseAgentQueue - enableMetrics : " + s, 3);
            }
            m_metricsRegistrar = metricsRegistrar;
            BaseAgentQueue.checkEnabledMetrics(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        Object object = m_metricsMutex;
        synchronized (object) {
            if (Config.DEBUG) {
                BrokerComponent.getComponentContext().logMessage("BaseAgentQueue - disabling metrics = " + ids, 3);
            }
            BaseAgentQueue.checkEnabledMetrics(ids);
        }
    }

    private static void checkEnabledMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (!ids[i].equals((Object)QUEUE_MSGS_RECEIVEDPERSECOND_METRIC) && !ids[i].equals((Object)QUEUE_MSGS_DELIVEREDPERSECOND_METRIC) && !ids[i].equals((Object)QUEUE_BYTES_RECEIVEDPERSECOND_METRIC) && !ids[i].equals((Object)QUEUE_BYTES_DELIVEREDPERSECOND_METRIC) && !ids[i].equals((Object)QUEUE_MSGS_MAXDEPTH_METRIC) && !ids[i].equals((Object)QUEUE_MSGS_COUNT_METRIC) && !ids[i].equals((Object)QUEUE_MSGS_SIZE_METRIC) && !ids[i].equals((Object)QUEUE_MSGS_MAXAGE_METRIC) && !ids[i].equals((Object)QUEUE_MSGS_TIMEINQUEUE_METRIC)) continue;
            BaseAgentQueue.refreshInstanceMetrics(ids[i]);
        }
    }

    public static String[] getInstanceMetricNames(IMetricIdentity id) {
        IAgentQueue iaq2;
        ArrayList<String> names = new ArrayList<String>();
        Hashtable queues = (Hashtable)((Hashtable)AgentRegistrar.getAgentRegistrar().getQueueProc().getQueues()).clone();
        Collection values = queues.values();
        for (IAgentQueue iaq2 : values) {
            if (!(iaq2 instanceof AgentAdministrativelyCreatedQueue) && !(iaq2 instanceof AgentTemporaryQueue)) continue;
            String queueName = iaq2.getQueueName();
            names.add(queueName);
        }
        iaq2 = AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue();
        if (iaq2 != null) {
            names.add(iaq2.getQueueName());
        }
        return names.toArray(new String[names.size()]);
    }

    private static void refreshInstanceMetrics(IMetricIdentity id) {
        AgentRegistrar ar = AgentRegistrar.getAgentRegistrar();
        if (ar == null) {
            return;
        }
        AgentQueueProcessor aqp = ar.getQueueProc();
        if (aqp == null) {
            return;
        }
        Hashtable queues = (Hashtable)aqp.getQueues();
        if (queues != null) {
            Collection values = ((Hashtable)queues.clone()).values();
            for (IAgentQueue iaq : values) {
                if (!(iaq instanceof AgentAdministrativelyCreatedQueue) && !(iaq instanceof AgentTemporaryQueue) && !(iaq instanceof AgentRoutingQueue) && !(iaq instanceof AgentDelayedDeliveryQueue)) continue;
                String queueName = iaq.getQueueName();
                boolean enabled = BaseAgentQueue.checkInstanceMetricEnabled(id, queueName);
                if (Config.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage("BaseAgentQueue - refreshing instance metric = " + id.getName() + " for queue = " + queueName + " enabled = " + enabled, 3);
                }
                if (enabled) {
                    iaq.enableInstanceMetric(m_metricsRegistrar, id);
                    continue;
                }
                iaq.disableInstanceMetric(id);
            }
        }
    }

    private static boolean checkInstanceMetricEnabled(IMetricIdentity id, String child) {
        if (m_metricsRegistrar == null || child == null) {
            return false;
        }
        return m_metricsRegistrar.isInstanceEnabled(MetricsFactory.createMetricIdentity((IMetricIdentity)id, (String)child));
    }

    abstract long getOldestEnqueueTime();

    protected void updateQueueRcvdStats(IMgram mgram) {
        this.updateStatistics(this.m_queueRecvdPerSecStat, this.m_queueBytesRecvdPerSecStat, mgram);
    }

    protected void updateQueueDelvStats(IMgram mgram) {
        this.updateStatistics(this.m_queueDelvdPerSecStat, this.m_queueBytesDelvdPerSecStat, mgram);
    }

    private void updateStatistics(IStatistic m_queueDelvdPerSecStat, IStatistic m_queueBytesDelvdPerSecStat, IMgram mgram) {
        if (m_queueDelvdPerSecStat != null) {
            this.updateStatistic(m_queueDelvdPerSecStat, 1L);
        }
        if (m_queueBytesDelvdPerSecStat != null && mgram != null) {
            this.updateStatistic(m_queueBytesDelvdPerSecStat, mgram.networkLength());
        }
    }

    protected void updateQueueStats() {
        int ct = this.getTotalEnqueued();
        this.updateStatistic(this.m_queueMaxDepthStat, ct);
        this.updateStatistic(this.m_queueSizeStat, this.getTotalSize());
    }

    @Override
    public long getOldestMessageAge() {
        long ts = this.getOldestEnqueueTime();
        if (ts > 0L) {
            return System.currentTimeMillis() - ts;
        }
        return 0L;
    }

    protected void updateStatistic(IStatistic statistic, long value) {
        IStatistic s = statistic;
        long val = value;
        if (s != null) {
            if (val > 0L && (s == this.m_maxAgeStat || s == this.m_timeInQueueStat)) {
                val = (val + 500L) / 1000L;
            }
            s.updateValue(val);
        }
    }

    @Override
    public void enableInstanceMetric(IMetricsRegistrar metricsRegistrar, IMetricIdentity id) {
        IMetricIdentity instanceMetricId = this.createMetricIdentity(id);
        if (metricsRegistrar != null) {
            this.registerQueueRecvdPerSecStat(id, instanceMetricId);
            this.registerMetric(id, instanceMetricId);
            this.createAndRegister(id, instanceMetricId, metricsRegistrar);
            this.updateStatisticsAndRegisterMetric(id, instanceMetricId, metricsRegistrar);
        }
    }

    private void registerMetric(IMetricIdentity id, IMetricIdentity instanceMetricId) {
        if (id.equals((Object)QUEUE_MSGS_DELIVEREDPERSECOND_METRIC) && this.m_queueDelvdPerSecStat == null) {
            this.m_queueDelvdPerSecStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
            m_metricsRegistrar.registerMetric(instanceMetricId, this.m_queueDelvdPerSecStat);
        }
        if (id.equals((Object)QUEUE_BYTES_RECEIVEDPERSECOND_METRIC) && this.m_queueBytesRecvdPerSecStat == null) {
            this.m_queueBytesRecvdPerSecStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
            m_metricsRegistrar.registerMetric(instanceMetricId, this.m_queueBytesRecvdPerSecStat);
        }
        if (id.equals((Object)QUEUE_BYTES_DELIVEREDPERSECOND_METRIC) && this.m_queueBytesDelvdPerSecStat == null) {
            this.m_queueBytesDelvdPerSecStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
            m_metricsRegistrar.registerMetric(instanceMetricId, this.m_queueBytesDelvdPerSecStat);
        }
    }

    private void updateStatisticsAndRegisterMetric(IMetricIdentity id, IMetricIdentity instanceMetricId, IMetricsRegistrar metricsRegistrar) {
        if (id.equals((Object)QUEUE_MSGS_MAXAGE_METRIC) && this.m_maxAgeStat == null) {
            IStatisticProvider statisticProvider = new IStatisticProvider(){

                public void updateStatistic(ISampledStatistic statistic) {
                    if (statistic == BaseAgentQueue.this.m_maxAgeStat) {
                        BaseAgentQueue.this.updateStatistic((IStatistic)statistic, BaseAgentQueue.this.getOldestMessageAge());
                    }
                }

                public void resetStatistic(ISampledStatistic statistic) {
                }
            };
            this.m_maxAgeStat = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])new IStatisticProvider[]{statisticProvider}, (short)0);
            metricsRegistrar.registerMetric(instanceMetricId, this.m_maxAgeStat);
        }
        if (id.equals((Object)QUEUE_MSGS_TIMEINQUEUE_METRIC) && this.m_timeInQueueStat == null) {
            this.m_timeInQueueStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)2);
            metricsRegistrar.registerMetric(instanceMetricId, this.m_timeInQueueStat);
        }
    }

    private void createAndRegister(IMetricIdentity id, IMetricIdentity instanceMetricId, IMetricsRegistrar metricsRegistrar) {
        if (id.equals((Object)QUEUE_MSGS_MAXDEPTH_METRIC)) {
            this.createUpdateAndRegisterStatistic(instanceMetricId, metricsRegistrar);
            this.m_queueMaxDepthInstanceEnabled = true;
        }
        if (id.equals((Object)QUEUE_MSGS_COUNT_METRIC)) {
            this.createUpdateAndRegisterStatistic(instanceMetricId, metricsRegistrar);
            this.m_queueCountInstanceEnabled = true;
        }
        if (id.equals((Object)QUEUE_MSGS_SIZE_METRIC) && this.m_queueSizeStat == null) {
            this.m_queueSizeStat = StatisticsFactory.createStatistic((short)3, (boolean)false, null, (short)1);
            metricsRegistrar.registerMetric(instanceMetricId, this.m_queueSizeStat);
            this.updateStatistic(this.m_queueSizeStat, this.getTotalSize());
        }
    }

    private void registerQueueRecvdPerSecStat(IMetricIdentity id, IMetricIdentity instanceMetricId) {
        if (id.equals((Object)QUEUE_MSGS_RECEIVEDPERSECOND_METRIC) && this.m_queueRecvdPerSecStat == null) {
            this.m_queueRecvdPerSecStat = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
            m_metricsRegistrar.registerMetric(instanceMetricId, this.m_queueRecvdPerSecStat);
        }
    }

    private IMetricIdentity createMetricIdentity(IMetricIdentity id) {
        if (this.DEBUG) {
            this.debug("Enabling instance metric " + id.getName() + " for queue = " + this.getQueueName());
        }
        IMetricIdentity instanceMetricId = MetricsFactory.createMetricIdentity((IMetricIdentity)id, (String)this.getQueueName());
        return instanceMetricId;
    }

    private void createUpdateAndRegisterStatistic(IMetricIdentity instanceMetricId, IMetricsRegistrar metricsRegistrar) {
        if (this.m_queueMaxDepthStat == null) {
            this.m_queueMaxDepthStat = StatisticsFactory.createStatistic((short)3, (boolean)false, null, (short)1);
            this.updateStatistic(this.m_queueMaxDepthStat, this.getTotalEnqueued());
        }
        metricsRegistrar.registerMetric(instanceMetricId, this.m_queueMaxDepthStat);
    }

    @Override
    public void disableInstanceMetric(IMetricIdentity id) {
        IMetricIdentity instanceMetricId = this.retrieveMetricIdentity(id);
        this.unregisterAndReset(id, instanceMetricId);
        this.resetData(id);
    }

    private void unregisterAndReset(IMetricIdentity id, IMetricIdentity instanceMetricId) {
        if (m_metricsRegistrar != null) {
            m_metricsRegistrar.unregisterMetric(instanceMetricId);
        }
        if (id.equals((Object)QUEUE_MSGS_RECEIVEDPERSECOND_METRIC)) {
            this.m_queueRecvdPerSecStat = null;
        }
        if (id.equals((Object)QUEUE_MSGS_DELIVEREDPERSECOND_METRIC)) {
            this.m_queueDelvdPerSecStat = null;
        }
        if (id.equals((Object)QUEUE_BYTES_RECEIVEDPERSECOND_METRIC)) {
            this.m_queueBytesRecvdPerSecStat = null;
        }
        if (id.equals((Object)QUEUE_BYTES_DELIVEREDPERSECOND_METRIC)) {
            this.m_queueBytesDelvdPerSecStat = null;
        }
        if (id.equals((Object)QUEUE_MSGS_MAXDEPTH_METRIC)) {
            this.m_queueMaxDepthInstanceEnabled = false;
        }
        if (id.equals((Object)QUEUE_MSGS_COUNT_METRIC)) {
            this.m_queueCountInstanceEnabled = false;
        }
        if (!this.m_queueMaxDepthInstanceEnabled && !this.m_queueCountInstanceEnabled) {
            this.m_queueMaxDepthStat = null;
        }
        if (id.equals((Object)QUEUE_MSGS_SIZE_METRIC)) {
            this.m_queueSizeStat = null;
        }
    }

    private IMetricIdentity retrieveMetricIdentity(IMetricIdentity id) {
        if (this.DEBUG) {
            this.debug("Disabling instance metric " + id.getName() + " for queue = " + this.getQueueName());
        }
        IMetricIdentity instanceMetricId = MetricsFactory.createMetricIdentity((IMetricIdentity)id, (String)this.getQueueName());
        return instanceMetricId;
    }

    private void resetData(IMetricIdentity id) {
        if (id.equals((Object)QUEUE_MSGS_MAXAGE_METRIC)) {
            this.m_maxAgeStat = null;
        }
        if (id.equals((Object)QUEUE_MSGS_TIMEINQUEUE_METRIC)) {
            this.m_timeInQueueStat = null;
        }
    }

    protected void initMetrics() {
        if (BaseAgentQueue.checkInstanceMetricEnabled(QUEUE_MSGS_RECEIVEDPERSECOND_METRIC, this.getQueueName())) {
            this.enableInstanceMetric(m_metricsRegistrar, QUEUE_MSGS_RECEIVEDPERSECOND_METRIC);
        }
        if (BaseAgentQueue.checkInstanceMetricEnabled(QUEUE_MSGS_DELIVEREDPERSECOND_METRIC, this.getQueueName())) {
            this.enableInstanceMetric(m_metricsRegistrar, QUEUE_MSGS_DELIVEREDPERSECOND_METRIC);
        }
        if (BaseAgentQueue.checkInstanceMetricEnabled(QUEUE_BYTES_RECEIVEDPERSECOND_METRIC, this.getQueueName())) {
            this.enableInstanceMetric(m_metricsRegistrar, QUEUE_BYTES_RECEIVEDPERSECOND_METRIC);
        }
        if (BaseAgentQueue.checkInstanceMetricEnabled(QUEUE_BYTES_DELIVEREDPERSECOND_METRIC, this.getQueueName())) {
            this.enableInstanceMetric(m_metricsRegistrar, QUEUE_BYTES_DELIVEREDPERSECOND_METRIC);
        }
        if (BaseAgentQueue.checkInstanceMetricEnabled(QUEUE_MSGS_MAXDEPTH_METRIC, this.getQueueName())) {
            this.enableInstanceMetric(m_metricsRegistrar, QUEUE_MSGS_MAXDEPTH_METRIC);
        }
        if (BaseAgentQueue.checkInstanceMetricEnabled(QUEUE_MSGS_COUNT_METRIC, this.getQueueName())) {
            this.enableInstanceMetric(m_metricsRegistrar, QUEUE_MSGS_COUNT_METRIC);
        }
        if (BaseAgentQueue.checkInstanceMetricEnabled(QUEUE_MSGS_SIZE_METRIC, this.getQueueName())) {
            this.enableInstanceMetric(m_metricsRegistrar, QUEUE_MSGS_SIZE_METRIC);
        }
        if (BaseAgentQueue.checkInstanceMetricEnabled(QUEUE_MSGS_MAXAGE_METRIC, this.getQueueName())) {
            this.enableInstanceMetric(m_metricsRegistrar, QUEUE_MSGS_MAXAGE_METRIC);
        }
        if (BaseAgentQueue.checkInstanceMetricEnabled(QUEUE_MSGS_TIMEINQUEUE_METRIC, this.getQueueName())) {
            this.enableInstanceMetric(m_metricsRegistrar, QUEUE_MSGS_TIMEINQUEUE_METRIC);
        }
    }

    protected void cleanupMetrics() {
        if (this.m_queueRecvdPerSecStat != null) {
            this.disableInstanceMetric(QUEUE_MSGS_RECEIVEDPERSECOND_METRIC);
        }
        if (this.m_queueDelvdPerSecStat != null) {
            this.disableInstanceMetric(QUEUE_MSGS_DELIVEREDPERSECOND_METRIC);
        }
        if (this.m_queueBytesRecvdPerSecStat != null) {
            this.disableInstanceMetric(QUEUE_BYTES_RECEIVEDPERSECOND_METRIC);
        }
        if (this.m_queueBytesDelvdPerSecStat != null) {
            this.disableInstanceMetric(QUEUE_BYTES_DELIVEREDPERSECOND_METRIC);
        }
        if (this.m_queueMaxDepthStat != null) {
            this.disableInstanceMetric(QUEUE_MSGS_MAXDEPTH_METRIC);
            this.disableInstanceMetric(QUEUE_MSGS_COUNT_METRIC);
        }
        if (this.m_queueSizeStat != null) {
            this.disableInstanceMetric(QUEUE_MSGS_SIZE_METRIC);
        }
        if (this.m_maxAgeStat != null) {
            this.disableInstanceMetric(QUEUE_MSGS_MAXAGE_METRIC);
        }
        if (this.m_timeInQueueStat != null) {
            this.disableInstanceMetric(QUEUE_MSGS_TIMEINQUEUE_METRIC);
        }
    }

    private final class GetRequest
    implements Cloneable {
        long m_client;
        int m_count;

        GetRequest(long client, int count) {
            this.m_client = client;
            this.m_count = count;
        }

        public Object clone() throws CloneNotSupportedException {
            return new GetRequest(this.m_client, this.m_count);
        }
    }
}

