/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import progress.message.broker.AgentConnection;
import progress.message.broker.Config;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;

public class ConnectionCountTracker
extends DebugObject {
    private static final String MAX_CONN_PER_USER_ENTRY_SEP = ",";
    private static final String MAX_CONN_PER_USER_TOKEN = ":";
    private final LongHashTable m_connectionCountIds = new LongHashTable();
    private final Map<String, UserConnectionLimit> m_connectionLimits = new HashMap<String, UserConnectionLimit>();
    private int m_clientConnectionCount = 0;
    private SubResourceTracker m_centralSubResourceTracker = new SubResourceTracker();
    private int m_mfConnectionCount = 0;
    private boolean m_debugSetupDone;

    public ConnectionCountTracker() {
        super(null);
    }

    private void setupDebug() {
        if (!this.m_debugSetupDone) {
            this.debugName("ConnectionCountTracker");
            this.m_debugSetupDone = true;
        }
    }

    public void addPrimaryConnection(long cid, String appid, AgentConnection connection) {
        CountInfo countInfo;
        this.setupDebug();
        if (this.isExcludedFromCounting(appid)) {
            return;
        }
        if (cid == -1L) {
            BrokerComponent.getComponentContext().logMessage("Connection count tracking - addPrimaryConnection un-initialized cid(-1) for '" + appid + "'", 2);
            return;
        }
        if (!this.m_connectionCountIds.containsKey(cid)) {
            countInfo = new CountInfo(cid, appid);
            this.m_connectionCountIds.put(cid, countInfo);
            this.incrementPrimaryConnectionCounters(appid);
        } else {
            countInfo = (CountInfo)this.m_connectionCountIds.get(cid);
            if (countInfo != null && !countInfo.getAppid().equals(appid)) {
                BrokerComponent.getComponentContext().logMessage("Connection count tracking - expected '" + appid + "', found '" + countInfo.getAppid() + "', for cid " + cid, 2);
            }
        }
        if (countInfo != null) {
            countInfo.addConnection(connection);
        }
        if (this.checkDebugFlags(64)) {
            this.showCountedConnections("addPrimaryConnection " + cid + " (0x" + Integer.toHexString(ConnectionCountTracker.connectionHashCode(connection)) + ") - ");
        }
    }

    private boolean isExcludedFromCounting(String appid) {
        return "$GROUPSUBSCRIPTION$".equals(appid);
    }

    public void addSubResource(long cid, String appid, AgentConnection connection) {
        long primaryCid;
        this.setupDebug();
        if (cid == -1L) {
            BrokerComponent.getComponentContext().logMessage("Connection count tracking - addSubResource un-initialized cid(-1) for '" + appid + "'", 2);
            return;
        }
        long l = primaryCid = connection != null ? connection.getChan0Id() : -1L;
        if (primaryCid == -1L) {
            BrokerComponent.getComponentContext().logMessage("Connection count tracking - addSubResource un-initialized primary cid(-1) for '" + appid + "'", 2);
            return;
        }
        CountInfo countInfo = (CountInfo)this.m_connectionCountIds.get(primaryCid);
        if (countInfo == null) {
            BrokerComponent.getComponentContext().logMessage("Connection count tracking primary connection appears missing for  '" + appid + "', cid '" + cid + "', and primary connection cid '" + cid + "'", 2);
        } else if (ConnectionCountTracker.isClientConnection(countInfo.getAppid())) {
            countInfo.addSubResource(cid, appid);
        } else if (this.checkDebugFlags(64)) {
            this.debug("addSubResource skipping internal resource " + appid);
        }
    }

    public void removePrimaryConnection(long cid, AgentConnection connection) {
        this.setupDebug();
        CountInfo countInfo = (CountInfo)this.m_connectionCountIds.get(cid);
        if (countInfo != null) {
            countInfo.removeConnection(connection);
            if (countInfo.isEmpty()) {
                this.m_connectionCountIds.remove(cid);
                countInfo.removeAllSubresources();
                this.decrementPrimaryConnectionCounter(countInfo.getAppid());
                if (ConnectionCountTracker.isClientConnection(countInfo.getAppid())) {
                    this.removeConnectionFromUserSet(cid);
                }
            }
            if (this.checkDebugFlags(64)) {
                this.showCountedConnections("removeConnection " + cid + " (0x" + Integer.toHexString(ConnectionCountTracker.connectionHashCode(connection)) + ") - ");
            }
        } else if (this.checkDebugFlags(64)) {
            this.debug("removeConnection " + cid + " (0x" + Integer.toHexString(ConnectionCountTracker.connectionHashCode(connection)) + ") - not counted");
        }
    }

    public void removeSubResource(long cid, AgentConnection connection) {
        this.setupDebug();
        long parentCid = connection.getChan0Id();
        CountInfo countInfo = (CountInfo)this.m_connectionCountIds.get(parentCid);
        if (countInfo != null) {
            countInfo.removeSubResource(cid);
        }
    }

    private void removeConnectionFromUserSet(long cid) {
        for (Map.Entry<String, UserConnectionLimit> entry : this.m_connectionLimits.entrySet()) {
            entry.getValue().currentConnections.remove(cid);
        }
    }

    private void incrementPrimaryConnectionCounters(String appid) {
        if (ConnectionCountTracker.isClientConnection(appid)) {
            ++this.m_clientConnectionCount;
        }
        if (ConnectionCountTracker.isMFConnection(appid)) {
            ++this.m_mfConnectionCount;
        }
    }

    private void decrementPrimaryConnectionCounter(String appid) {
        if (ConnectionCountTracker.isClientConnection(appid)) {
            --this.m_clientConnectionCount;
        }
        if (ConnectionCountTracker.isMFConnection(appid)) {
            --this.m_mfConnectionCount;
        }
    }

    public boolean isAlreadyCounted(long cid) {
        return this.m_connectionCountIds.containsKey(cid);
    }

    public int getConnectionCount() {
        int count = this.m_connectionCountIds.size();
        return count == 0 ? 0 : count - 1;
    }

    public int getClientConnectionCount() {
        return this.m_clientConnectionCount;
    }

    public int getJMSSessionCount() {
        return this.m_centralSubResourceTracker.getJMSSessionCount();
    }

    public int getJMSSessionCount(long cid) {
        CountInfo countInfo = (CountInfo)this.m_connectionCountIds.get(cid);
        if (countInfo != null) {
            return countInfo.getJMSSessionCount();
        }
        return -1;
    }

    public int getNonDurableTopicSubscriberCount() {
        return this.m_centralSubResourceTracker.getNonDurableTopicSubscriberCount();
    }

    public int getNonDurableTopicSubscriberCount(long cid) {
        CountInfo countInfo = (CountInfo)this.m_connectionCountIds.get(cid);
        if (countInfo != null) {
            return countInfo.getNonDurableTopicSubscriberCount();
        }
        return -1;
    }

    public int getDurableTopicSubscriberCount() {
        return this.m_centralSubResourceTracker.getDurableTopicSubscriberCount();
    }

    public int getDurableTopicSubscriberCount(long cid) {
        CountInfo countInfo = (CountInfo)this.m_connectionCountIds.get(cid);
        if (countInfo != null) {
            return countInfo.getDurableTopicSubscriberCount();
        }
        return -1;
    }

    public int getQueueReceiverCount() {
        return this.m_centralSubResourceTracker.getQueueReceiverCount();
    }

    public int getQueueReceiverCount(long cid) {
        CountInfo countInfo = (CountInfo)this.m_connectionCountIds.get(cid);
        if (countInfo != null) {
            return countInfo.getQueueReceiverCount();
        }
        return -1;
    }

    public int getQueueBrowserCount() {
        return this.m_centralSubResourceTracker.getQueueBrowserCount();
    }

    public int getQueueBrowserCount(long cid) {
        CountInfo countInfo = (CountInfo)this.m_connectionCountIds.get(cid);
        if (countInfo != null) {
            return countInfo.getQueueBrowserCount();
        }
        return -1;
    }

    public int getMFConnectionCount() {
        return this.m_mfConnectionCount;
    }

    public static boolean isClientConnection(String appid) {
        return appid != null && appid.endsWith("$CONNECTION$");
    }

    public static boolean isMFConnection(String appid) {
        return appid != null && appid.indexOf("SonicMQ/mf/") >= 0;
    }

    public static boolean isJMSSession(String appid) {
        return appid != null && appid.indexOf("$SESSION$") >= 0;
    }

    public static boolean isNonDurableTopicSubscriber(String appid) {
        return appid != null && appid.indexOf("$NONDURABLE$") >= 0;
    }

    public static boolean isDurableTopicSubscriber(String appid) {
        return appid != null && appid.indexOf("$DURABLE$") >= 0 && appid.indexOf("$DURABLE$$CC$") < 0;
    }

    public static boolean isQueueReceiver(String appid) {
        return appid != null && appid.indexOf("$QR$") >= 0;
    }

    public static boolean isQueueBrowser(String appid) {
        return appid != null && appid.indexOf("$QB$") >= 0;
    }

    private void showCountedConnections(String prefix) {
        StringBuffer display = new StringBuffer(prefix);
        display.append("connection count: ");
        display.append(this.getConnectionCount()).append(" (reported), ");
        display.append(this.m_connectionCountIds.size()).append(" (internal), ");
        display.append(this.m_clientConnectionCount).append(" (client), ");
        display.append(this.m_mfConnectionCount).append(" (mgmt), ");
        display.append(this.m_centralSubResourceTracker.getJMSSessionCount()).append(" (sessions), ");
        display.append(this.m_centralSubResourceTracker.getDurableTopicSubscriberCount()).append(" (durs), ");
        display.append(this.m_centralSubResourceTracker.getNonDurableTopicSubscriberCount()).append(" (nondurs), ");
        display.append(this.m_centralSubResourceTracker.getQueueBrowserCount()).append(" (browsers), ");
        display.append(this.m_centralSubResourceTracker.getQueueReceiverCount()).append(" (receivers)");
        if (this.checkDebugFlags(128)) {
            Enumeration<Long> cids = this.m_connectionCountIds.keys();
            while (cids.hasMoreElements()) {
                Long cid = cids.nextElement();
                CountInfo countInfo = (CountInfo)this.m_connectionCountIds.get(cid);
                display.append("\n  ").append(cid).append(" - ");
                countInfo.appendDebug(display);
            }
        }
        this.debug(display.toString());
    }

    private static int connectionHashCode(AgentConnection connection) {
        if (connection == null) {
            return 0;
        }
        int hashCode = connection.hashCode();
        return hashCode == 0 ? 1 : hashCode;
    }

    public void setupPerUserConnectionLimits() {
        if (this.isPerUserConnectionLimitEnabled() && this.m_connectionLimits.isEmpty()) {
            try {
                String[] limits;
                for (String limit : limits = Config.MAX_CONNECTIONS_PER_USER.split(MAX_CONN_PER_USER_ENTRY_SEP)) {
                    String[] parts = limit.split(MAX_CONN_PER_USER_TOKEN);
                    if (parts.length != 2) {
                        throw new IllegalArgumentException("Entry does not comply with the format: '" + limit + "'");
                    }
                    String user = parts[0].trim();
                    String cLimit = parts[1].trim();
                    if (!cLimit.matches("\\d+")) {
                        throw new IllegalArgumentException("Connection count is not a number: '" + cLimit + "'");
                    }
                    this.m_connectionLimits.put(user, new UserConnectionLimit(Integer.parseInt(cLimit)));
                }
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 7);
                BrokerComponent.getComponentContext().logMessage("Invalid format for parameter 'MAX_CONNECTIONS_PER_USER', Use the form 'userA:10,userB:5,userC:50'", 1);
            }
        }
    }

    public boolean isPerUserConnectionLimitEnabled() {
        return Config.MAX_CONNECTIONS_PER_USER != null && !Config.MAX_CONNECTIONS_PER_USER.trim().isEmpty();
    }

    public Map<String, UserConnectionLimit> getUserConnectionLimits() {
        return this.m_connectionLimits;
    }

    private class SubResourceTracker {
        private int m_jmsSessionCount;
        private int m_nonDurableTopicSubscriberCount;
        private int m_durableTopicSubscriberCount;
        private int m_queueReceiverCount;
        private int m_queueBrowserCount;

        private SubResourceTracker() {
        }

        private void incrementSubResourcesCounter(String appid) {
            if (ConnectionCountTracker.isJMSSession(appid)) {
                ++this.m_jmsSessionCount;
            }
            if (ConnectionCountTracker.isNonDurableTopicSubscriber(appid)) {
                ++this.m_nonDurableTopicSubscriberCount;
            }
            if (ConnectionCountTracker.isDurableTopicSubscriber(appid)) {
                ++this.m_durableTopicSubscriberCount;
            }
            if (ConnectionCountTracker.isQueueReceiver(appid)) {
                ++this.m_queueReceiverCount;
            }
            if (ConnectionCountTracker.isQueueBrowser(appid)) {
                ++this.m_queueBrowserCount;
            }
        }

        private void decrementSubResourcesCounter(String appid) {
            if (ConnectionCountTracker.isJMSSession(appid)) {
                --this.m_jmsSessionCount;
            }
            if (ConnectionCountTracker.isNonDurableTopicSubscriber(appid)) {
                --this.m_nonDurableTopicSubscriberCount;
            }
            if (ConnectionCountTracker.isDurableTopicSubscriber(appid)) {
                --this.m_durableTopicSubscriberCount;
            }
            if (ConnectionCountTracker.isQueueReceiver(appid)) {
                --this.m_queueReceiverCount;
            }
            if (ConnectionCountTracker.isQueueBrowser(appid)) {
                --this.m_queueBrowserCount;
            }
        }

        public int getJMSSessionCount() {
            return this.m_jmsSessionCount;
        }

        public int getNonDurableTopicSubscriberCount() {
            return this.m_nonDurableTopicSubscriberCount;
        }

        public int getDurableTopicSubscriberCount() {
            return this.m_durableTopicSubscriberCount;
        }

        public int getQueueReceiverCount() {
            return this.m_queueReceiverCount;
        }

        public int getQueueBrowserCount() {
            return this.m_queueBrowserCount;
        }
    }

    private class CountInfo {
        private static final int MAX_ACS_PER_CONNECTION = 8;
        long m_cid;
        String m_appid;
        IntSet m_connections;
        Map<Long, String> m_subresources;
        SubResourceTracker m_subResourceTracker;

        public CountInfo(long cid, String appid) {
            this.m_cid = cid;
            this.m_appid = appid;
            this.m_subresources = new HashMap<Long, String>();
            this.m_connections = new IntSet(8);
            this.m_subResourceTracker = new SubResourceTracker();
        }

        public long getCid() {
            return this.m_cid;
        }

        public String getAppid() {
            return this.m_appid;
        }

        public void removeAllSubresources() {
            Long[] keys;
            Long[] longArray = keys = this.m_subresources.keySet().toArray(new Long[0]);
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                long cid = longArray[i];
                this.removeSubResource(cid);
            }
        }

        public void removeSubResource(long cid) {
            String appid = this.m_subresources.remove(cid);
            if (appid != null) {
                this.m_subResourceTracker.decrementSubResourcesCounter(appid);
                ConnectionCountTracker.this.m_centralSubResourceTracker.decrementSubResourcesCounter(appid);
            }
        }

        public void addSubResource(long cid, String appid) {
            String prior = this.m_subresources.put(cid, appid);
            if (prior == null && appid != null) {
                this.m_subResourceTracker.incrementSubResourcesCounter(appid);
                ConnectionCountTracker.this.m_centralSubResourceTracker.incrementSubResourcesCounter(appid);
            }
        }

        public void addConnection(AgentConnection connection) {
            if (this.m_connections.contains(0)) {
                this.m_connections.remove(0);
            }
            this.m_connections.add(ConnectionCountTracker.connectionHashCode(connection), this.m_appid);
        }

        public void removeConnection(AgentConnection connection) {
            this.m_connections.remove(ConnectionCountTracker.connectionHashCode(connection));
        }

        public boolean isEmpty() {
            return this.m_connections.isEmpty();
        }

        public void appendDebug(StringBuffer sb) {
            sb.append(this.m_appid).append(" -");
            this.m_connections.appendDebug(sb);
        }

        public int getJMSSessionCount() {
            return this.m_subResourceTracker.getJMSSessionCount();
        }

        public int getNonDurableTopicSubscriberCount() {
            return this.m_subResourceTracker.getNonDurableTopicSubscriberCount();
        }

        public int getDurableTopicSubscriberCount() {
            return this.m_subResourceTracker.getDurableTopicSubscriberCount();
        }

        public int getQueueReceiverCount() {
            return this.m_subResourceTracker.getQueueReceiverCount();
        }

        public int getQueueBrowserCount() {
            return this.m_subResourceTracker.getQueueBrowserCount();
        }

        private class IntSet {
            final int[] m_ints;
            int m_size;

            public IntSet(int maxSize) {
                this.m_ints = new int[maxSize];
                this.m_size = 0;
            }

            public void add(int value, String appid) {
                if (!this.contains(value) && this.m_size < this.m_ints.length) {
                    this.m_ints[this.m_size++] = value;
                    if (this.m_size == this.m_ints.length) {
                        BrokerComponent.getComponentContext().logMessage("Connection count tracking - max capacity reached for connection " + appid, 2);
                    }
                }
            }

            public void remove(int value) {
                int i = this.indexOf(value);
                if (i < 0) {
                    return;
                }
                for (int j = i; j < this.m_size - 1; ++j) {
                    this.m_ints[j] = this.m_ints[j + 1];
                }
                --this.m_size;
            }

            public boolean contains(int value) {
                return this.indexOf(value) >= 0;
            }

            public boolean isEmpty() {
                return this.m_size <= 0;
            }

            private int indexOf(int value) {
                int i;
                for (i = 0; i < this.m_size && this.m_ints[i] != value; ++i) {
                }
                return i < this.m_size ? i : -1;
            }

            public void appendDebug(StringBuffer sb) {
                for (int i = 0; i < this.m_size; ++i) {
                    sb.append(" 0x");
                    sb.append(Integer.toHexString(this.m_ints[i]));
                }
            }
        }
    }

    static final class UserConnectionLimit {
        Integer maxConnections;
        Set<Long> currentConnections;
        long lastWarning;

        UserConnectionLimit(Integer maxConnections) {
            this.maxConnections = maxConnections;
            this.currentConnections = new HashSet<Long>();
        }
    }
}

