/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Date;
import progress.message.broker.prAccessor;
import progress.message.resources.prMessageFormat;

final class Redirector
extends OutputStream {
    static Redirector redirector;
    private static String LINE_SEPARATOR;
    private File file;
    private RandomAccessFile raf;

    Redirector(File file) throws IOException {
        this.resetOutputStream(file);
        PrintStream ps = new PrintStream(this);
        System.setErr(ps);
        System.setOut(ps);
        redirector = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetOutputStream(File file) throws IOException {
        this.file = file;
        Redirector redirector = this;
        synchronized (redirector) {
            this.raf = new RandomAccessFile(this.file, "rw");
            this.raf.seek(this.raf.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void truncate() throws IOException {
        Redirector redirector = this;
        synchronized (redirector) {
            File oldFile = this.file;
            String path = oldFile.getPath();
            this.raf.close();
            oldFile.delete();
            this.resetOutputStream(new File(path));
            String msgf = prAccessor.getString("STR283");
            Object[] obj = new Object[]{new Date().toString()};
            System.out.println(prMessageFormat.format("[" + msgf + "]\n", obj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogExtract getLogExtract(int hash, long offsetParam, int lines) throws IOException {
        long offset = offsetParam;
        Redirector redirector = this;
        synchronized (redirector) {
            if (hash != this.raf.hashCode()) {
                offset = 0L;
            }
            this.raf.seek(offset);
            LogExtract logExtract = new LogExtract();
            logExtract.hash = this.raf.hashCode();
            logExtract.extract = "";
            logExtract.more = true;
            for (int i = 0; i < lines; ++i) {
                String s = null;
                try {
                    s = this.raf.readLine();
                }
                catch (Exception e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                if (s == null) continue;
                logExtract.extract = logExtract.extract + s + LINE_SEPARATOR;
            }
            logExtract.offset = this.raf.getFilePointer();
            try {
                this.raf.readByte();
            }
            catch (EOFException e) {
                logExtract.more = false;
            }
            this.raf.seek(this.raf.length());
            return logExtract;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int i) throws IOException {
        Redirector redirector = this;
        synchronized (redirector) {
            this.raf.write(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        Redirector redirector = this;
        synchronized (redirector) {
            this.raf.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int i, int j) throws IOException {
        Redirector redirector = this;
        synchronized (redirector) {
            this.raf.write(b, i, j);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Redirector redirector = this;
        synchronized (redirector) {
            this.raf.close();
        }
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
    }

    final class LogExtract {
        int hash;
        long offset;
        String extract;
        boolean more;

        LogExtract() {
        }
    }
}

