/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.IClientContext;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.Unsubscribe;
import progress.message.broker.UnsubscribeDurable;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.util.StreamUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;
import progress.message.zclient.Subject;

public class UnsubscribeEvt
extends LogEvent {
    protected long m_id;
    private ISubject m_subject;
    private Envelope m_req;
    private GSVirtualClock m_vc;
    private boolean m_localUnsubscribeDone;
    private boolean m_replyDone;
    private boolean m_suppressCWADS = false;
    private short m_eventType = (short)115;
    private UnsubscribeDurable m_replyHandler;

    public UnsubscribeEvt(Envelope req, long id, ISubject subject, GSVirtualClock vc) {
        this(req, id, subject, vc, null);
    }

    public UnsubscribeEvt(Envelope req, long id, ISubject subject, GSVirtualClock vc, UnsubscribeDurable ud) {
        this.m_req = req;
        this.m_id = id;
        this.m_subject = subject;
        this.m_replyDone = req == null;
        this.m_vc = vc;
        this.m_replyHandler = ud;
    }

    public UnsubscribeEvt(Envelope req, long id, ISubject subject) {
        this(req, id, subject, null, null);
    }

    UnsubscribeEvt(short type) {
        this.m_eventType = type;
    }

    public long getClientId() {
        return this.m_id;
    }

    public ISubject getSubject() {
        return this.m_subject;
    }

    public Envelope getRequest() {
        return this.m_req;
    }

    public GSVirtualClock getVirtualClock() {
        return this.m_vc;
    }

    public boolean getSuppressCWADSPropagation() {
        return this.m_suppressCWADS;
    }

    public void setSuppressCWADSPropagation(boolean suppressCWADS) {
        this.m_suppressCWADS = suppressCWADS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void localUnsubscribeDone() {
        boolean reply = false;
        UnsubscribeEvt unsubscribeEvt = this;
        synchronized (unsubscribeEvt) {
            this.m_localUnsubscribeDone = true;
            reply = !this.m_replyDone;
            if (reply) {
                this.m_replyDone = true;
            }
        }
        if (reply) {
            if (this.m_replyHandler != null) {
                UnsubscribeDurable.sendReply(this.m_req, 0);
                this.m_replyHandler = null;
                return;
            }
            IClientContext cc = null;
            try {
                cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_id);
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
            if (cc != null && cc.getRemoteNode() == null) {
                Unsubscribe.sendSuccessReply(this);
            }
        }
    }

    @Override
    protected void onFlush() {
        this.localUnsubscribeDone();
    }

    @Override
    public short type() {
        return 115;
    }

    @Override
    public boolean usesClientRegistry() {
        return true;
    }

    @Override
    public boolean usesSubscriptionTable() {
        return true;
    }

    @Override
    public long getClientID() {
        return this.m_id;
    }

    @Override
    protected int memSizeBody() {
        return 22 + this.m_subject.memoryLength() + (this.m_req == null ? 0 : this.m_req.length());
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        this.m_subject.writeToStream(os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_subject = this.m_eventType <= 18 ? new Subject(StreamUtil.readUTF(in)) : Subject.createFromStream(in);
        this.m_replyDone = true;
        this.setSuppressCWADSPropagation(true);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoUnsubscribe(this);
        AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().redoUnsubscribeEvt(this.m_id, this.getSeqNo(), this.isReplicateOnly());
    }

    @Override
    public String toString() {
        return super.toString() + "Client " + this.m_id + " unsubscribe to " + this.m_subject;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        Object utfsub = null;
        return 8 + this.m_subject.getSerializedLength();
    }
}

