/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.broker.fc.CCFlowControlTracker;
import progress.message.broker.fc.FCEvent;
import progress.message.gr.GRFCEvent;
import progress.message.gr.RouterManager;
import progress.message.util.DebugState;

public class GRFlowControlTracker
extends CCFlowControlTracker {
    private static short RESUMED_VERSION = 0;
    private static short BLOCKED_VERSION = 0;

    public GRFlowControlTracker(IClientContext cc) {
        super(DebugState.GLOBAL_DEBUG_ON ? "GRFlowControlTracker " + cc : null, cc);
    }

    @Override
    protected FCEvent createResumedFCEvent() {
        GRFCEvent fcevt = new GRFCEvent(true, RESUMED_VERSION);
        this.setCommonData(fcevt);
        return fcevt;
    }

    @Override
    protected FCEvent createBlockedFCEvent() {
        GRFCEvent fcevt = new GRFCEvent(false, BLOCKED_VERSION);
        this.setCommonData(fcevt);
        return fcevt;
    }

    @Override
    protected boolean isFCMonitoringEnabled() {
        return Config.BROKER_FC_MONITOR_INTERVAL > 0;
    }

    private void setCommonData(FCEvent fcevt) {
        fcevt.blockedRoutingNode = Config.ROUTING_NODE_NAME;
        fcevt.blockedBroker = Config.BROKER_NAME;
        fcevt.blockingRoutingNode = RouterManager.getRemoteNodeFromGRAppID(this.m_cc.getAppid());
        fcevt.receivingBroker = RouterManager.getRemoteBrokerFromAppID(this.m_cc.getAppid());
    }

    @Override
    public void sendFCReport(FCEvent evt) {
        AgentRegistrar.getAgentRegistrar().getFCMonitor().sendFCReport(this.m_cc, (GRFCEvent)evt);
    }
}

