/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.server;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import progress.message.broker.Config;
import progress.message.broker.HTTPDirectInboundHolder;
import progress.message.broker.HTTPDirectInboundProtocolHolder;
import progress.message.net.http.server.HttpXProtocolHandlerFactory;
import progress.message.net.http.server.IHttpRequestHandler;
import progress.message.net.http.server.SonicHttpServer;
import progress.message.net.http.server.direct.UnsupportedProtocolHandlerFactory;
import progress.message.net.http.server.prAccessor;
import progress.message.net.http.server.tunnel.HttpTunnelHandlerFactory;
import progress.message.resources.prMessageFormat;

public class HttpConnectionHandler {
    private HttpXProtocolHandlerFactory m_protocolHandlerFactory = null;
    String[] m_httpXProtocols = null;
    String[] m_httpXFactories = null;
    String[] m_httpXPropfiles = null;
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd kk:mm:ss");
        }
    };
    public static boolean DEBUG = false;

    public HttpConnectionHandler(HTTPDirectInboundHolder holder) {
        if (Config.DS_DEBUG) {
            System.out.println("SonicHttpServer.ctor: HTTP Direct Inbound holder = " + holder);
        }
        UnsupportedProtocolHandlerFactory last = new UnsupportedProtocolHandlerFactory(null, null);
        HttpXProtocolHandlerFactory next = new HttpTunnelHandlerFactory(null, last);
        if (Config.ENABLE_HTTP_DIRECT && holder != null) {
            Enumeration enumeration = holder.getHTTPDirectInboundProtocolHolders();
            while (enumeration.hasMoreElements()) {
                HTTPDirectInboundProtocolHolder protocolHolder = (HTTPDirectInboundProtocolHolder)enumeration.nextElement();
                next = this.loadHttpFactory(protocolHolder, next);
            }
        }
        this.m_protocolHandlerFactory = next;
    }

    public void insertProtocolFactory(HttpXProtocolHandlerFactory factory, int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be greater than or equal to zero.");
        }
        if (index == 0) {
            factory.setNext(this.m_protocolHandlerFactory);
            this.m_protocolHandlerFactory = factory;
        } else {
            this.m_protocolHandlerFactory.insertFactory(factory, index - 1);
        }
    }

    public IHttpRequestHandler loadMatchingHandler(SonicHttpServer server, HttpServletRequest request, HttpServletResponse response, Socket socket) throws IOException {
        IHttpRequestHandler handler = this.m_protocolHandlerFactory.getHandler(request, response, server, socket);
        handler = HttpConnectionHandler.createNullHandler(handler);
        return handler;
    }

    public void handle(SonicHttpServer server, HttpServletRequest request, HttpServletResponse response, Socket socket) throws IOException {
        IHttpRequestHandler handler = this.m_protocolHandlerFactory.getHandler(request, response, server, socket);
        handler = HttpConnectionHandler.createNullHandler(handler);
        handler.handle(request, response, server, socket);
    }

    private static IHttpRequestHandler createNullHandler(IHttpRequestHandler handlerParam) {
        IHttpRequestHandler handler = handlerParam;
        if (handler == null) {
            UnsupportedProtocolHandlerFactory factory = new UnsupportedProtocolHandlerFactory(null, null);
            handler = ((HttpXProtocolHandlerFactory)factory).createHandler(null, null, null, null);
        }
        return handler;
    }

    public final HttpXProtocolHandlerFactory loadHttpFactory(HTTPDirectInboundProtocolHolder protocolHolder, HttpXProtocolHandlerFactory next) {
        if (protocolHolder == null) {
            return null;
        }
        String protocol = protocolHolder.getInboundProtocol();
        String factoryName = protocolHolder.getInboundFactory();
        if (Config.DS_DEBUG) {
            System.out.println("HttpConnectionHandler.ctor: Http Direct inbound protocol = " + protocol + ", inbound factory name = " + factoryName);
        }
        Properties props = new Properties();
        props.put("HTTP_INBOUND_HOLDER", protocolHolder);
        try {
            Class<?> factory = Class.forName(factoryName);
            Constructor<?> constructor = factory.getConstructors()[0];
            Object[] args = new Object[]{props, next};
            return (HttpXProtocolHandlerFactory)constructor.newInstance(args);
        }
        catch (ClassNotFoundException cnfe) {
            Object[] obj = new Object[]{factoryName, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("HTTP_X_FACTORY_CLASS_NOT_FOUND");
            BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(msg, obj), 2);
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        return null;
    }
}

