/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.server;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.Config;
import progress.message.broker.HTTPAcceptor;
import progress.message.broker.HTTPDirectInboundHolder;
import progress.message.net.ProgressInetAddress;
import progress.message.net.http.client.tunnel.SafeQueue;
import progress.message.net.http.server.HttpConnectionHandler;
import progress.message.net.http.server.SonicHttpServerConnector;
import progress.message.net.http.server.SonicJettyHttpConnectionFactory;
import progress.message.net.http.server.SonicJettyHttpServer;
import progress.message.net.http.server.tunnel.HttpConnectionSocket;

public class SonicHttpServer {
    protected static boolean DEBUG = Config.HTTP_DEBUG_DEFAULT;
    protected static int HTTP_MAX_THREADS = 512;
    protected static int HTTP_MIN_THREADS = 2;
    protected static int HTTP_THREAD_IDLE_TIMEOUT = 60000;
    protected static int HTTP_BROKER_READ_TIMEOUT = 20000;
    protected static boolean TCP_NODELAY = true;
    protected transient Server m_server;
    private transient SonicHttpServerConnector sonicHttpServerConnector;
    private transient SonicJettyHttpConnectionFactory sonicJettyHttpConnectionFactory;
    protected transient QueuedThreadPool m_thread_pool;
    protected SafeQueue m_connectionQueue = new SafeQueue();
    protected Hashtable m_props = null;
    protected HttpConnectionHandler m_httpConnectionHandler;
    private static final long serialVersionUID = 3258135764704571445L;
    private boolean m_isSonicHttpServer;

    public SonicHttpServer(ProgressInetAddress bindAddr, int port, Properties properties) throws IOException {
        this(bindAddr, port, properties, true);
    }

    public SonicHttpServer(ProgressInetAddress bindAddr, int port, Properties properties, boolean isSonicHttpServer) throws IOException {
        this.m_isSonicHttpServer = isSonicHttpServer;
        if (Config.DS_DEBUG) {
            if (this.m_isSonicHttpServer) {
                System.out.println("SonicHttpServer.ctor: properties = " + properties);
            } else {
                System.out.println("SonicHttpsServer.ctor: properties = " + properties);
            }
        }
        int maxThreads = HTTP_MAX_THREADS;
        int minThreads = HTTP_MIN_THREADS;
        int idleTimeout = HTTP_THREAD_IDLE_TIMEOUT;
        String[] httpXProtocols = null;
        String[] httpXFactories = null;
        String[] httpXPropfiles = null;
        HTTPDirectInboundHolder holder = null;
        if (properties != null) {
            Boolean B;
            int v;
            this.m_props = properties;
            Object value = this.m_props.get("HTTP_DEBUG");
            if (value != null && ((String)value).equalsIgnoreCase("TRUE")) {
                DEBUG = true;
                HttpConnectionHandler.DEBUG = true;
            }
            if ((value = this.m_props.get("HTTP_MIN_THREADS")) != null && (v = ((Integer)value).intValue()) > 0) {
                minThreads = v;
            }
            if ((value = this.m_props.get("HTTP_MAX_THREADS")) != null && (v = ((Integer)value).intValue()) > 0) {
                int n = maxThreads = v < minThreads ? minThreads + 1 : v;
            }
            if ((value = this.m_props.get("HTTP_THREAD_IDLE_TIMEOUT")) != null && (v = ((Long)value).intValue()) >= 0) {
                idleTimeout = v;
            }
            if ((value = this.m_props.get("HTTP_CLIENT_IDLE_TIMEOUT")) != null && (v = ((Long)value).intValue()) > 0) {
                if (DEBUG) {
                    System.out.println("HTTP_CLIENT_IDLE_TIMEOUT = " + v);
                }
                HttpConnectionSocket.setClientIdleTimeout(v);
            }
            if ((value = this.m_props.get("HTTP_CLIENT_READ_TIMEOUT")) != null && (v = ((Long)value).intValue()) > 0) {
                if (DEBUG) {
                    System.out.println("HTTP_CLIENT_READ_TIMEOUT = " + v);
                }
                HttpConnectionSocket.setClientReadTimeout(v);
            }
            if ((value = this.m_props.get("HTTP_BROKER_READ_TIMEOUT")) != null && (v = ((Long)value).intValue()) > 0) {
                if (DEBUG) {
                    System.out.println("HTTP_BROKER_READ_TIMEOUT = " + v);
                }
                HTTP_BROKER_READ_TIMEOUT = v;
            }
            TCP_NODELAY = (B = (Boolean)this.m_props.get("TCP_NODELAY")) != null ? B : true;
            holder = (HTTPDirectInboundHolder)this.m_props.get("HTTP_DIRECT_INBOUND_HOLDER");
            if (Config.DS_DEBUG) {
                if (this.m_isSonicHttpServer) {
                    System.out.println("SonicHttpServer.ctor: HTTP Direct Inbound holder = " + holder);
                } else {
                    System.out.println("SonicHttpsServer.ctor: HTTPS Direct Inbound holder = " + holder);
                }
            }
            if (holder == null) {
                httpXProtocols = (String[])this.m_props.get("HTTP_X_PROTOCOLS");
                httpXFactories = (String[])this.m_props.get("HTTP_X_FACTORIES");
                httpXPropfiles = (String[])this.m_props.get("HTTP_X_PROPFILES");
            }
        }
        this.m_httpConnectionHandler = new HttpConnectionHandler(holder);
        HTTPAcceptor acceptor = AcceptorHolder.getAcceptorHolder().findHttpAcceptor(port);
        if (acceptor != null) {
            acceptor.registerConnectionHandler(this.m_httpConnectionHandler);
        }
        if (DEBUG) {
            System.out.println("HTTP_MAX_THREADS = " + maxThreads);
            System.out.println("HTTP_MIN_THREADS = " + minThreads);
            System.out.println("HTTP_THREAD_IDLE_TIMEOUT = " + idleTimeout);
            System.out.println("TCP_NODELAY = " + maxThreads);
            System.out.println("setDaemon() = true");
        }
        this.m_thread_pool = new QueuedThreadPool(maxThreads, minThreads, idleTimeout);
        if (this.m_isSonicHttpServer) {
            this.sonicJettyHttpConnectionFactory = new SonicJettyHttpConnectionFactory(this);
            this.m_server = new SonicJettyHttpServer(this, (ThreadPool)this.m_thread_pool);
            this.sonicHttpServerConnector = new SonicHttpServerConnector(this.m_server, this.sonicJettyHttpConnectionFactory);
            this.sonicHttpServerConnector.setPort(port);
            this.m_server.addConnector((Connector)this.sonicHttpServerConnector);
            if (bindAddr != null) {
                this.initHost(bindAddr);
            }
        }
    }

    private void initHost(ProgressInetAddress bindAddr) throws UnknownHostException {
        this.sonicHttpServerConnector.setHost(bindAddr.getHostAddress(false));
    }

    public static boolean getDebug() {
        return DEBUG;
    }

    public void addHttpConnection(HttpConnectionSocket socket) {
        if (this.m_connectionQueue != null) {
            this.m_connectionQueue.add(socket);
        }
    }

    public HttpConnectionSocket acceptHttpConnection() {
        try {
            HttpConnectionSocket socket = (HttpConnectionSocket)this.m_connectionQueue.remove();
            return socket;
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    public void stop() throws Exception {
        this.m_server.stop();
    }

    public SonicHttpServerConnector getSonicHttpServerConnector() {
        return this.sonicHttpServerConnector;
    }
}

