/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.ssl.jsafe.providers;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.net.ssl.CRLCache;
import progress.message.net.ssl.CRLCachePolicy;
import progress.message.net.ssl.CRLCacheUpdateException;
import progress.message.net.ssl.CRLStore;
import progress.message.net.ssl.InvalidCRLStoreParametersException;
import progress.message.net.ssl.prAccessor;
import progress.message.zclient.SessionConfig;

public final class MemoryDB
extends Provider
implements CRLCache,
Runnable {
    private static MemoryDB s_db = null;
    private static Object s_dbInitSync = new Object();
    private CRLStore m_crlStore = null;
    private Vector m_crls = new Vector();
    private Hashtable m_policies = null;
    private CRLCachePolicy[] m_policyList = null;
    private CRLCachePolicy m_nextUpdate = null;
    private Object m_nextUpdateSync = new Object();
    private boolean DEBUG = false;
    private Hashtable m_issuerByDP = new Hashtable();
    private Thread m_updateThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryDB getInstance() throws InvalidParameterException, InvalidCRLStoreParametersException, CRLCacheUpdateException {
        if (s_db != null) {
            return s_db;
        }
        Object object = s_dbInitSync;
        synchronized (object) {
            if (s_db == null) {
                CRLStore crlStore = CRLStore.getStore();
                crlStore.init();
                s_db = new MemoryDB(crlStore);
            }
        }
        return s_db;
    }

    private MemoryDB(CRLStore crlStore) throws InvalidParameterException, CRLCacheUpdateException {
        super(1, "CRLCache");
        this.m_crlStore = crlStore;
        crlStore.bind(this);
        this.init(CRLCachePolicy.register(this));
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException("MemeoryDB.instantiate: " + e.getMessage());
        }
    }

    @Override
    public void setDebug(boolean on) {
        this.DEBUG = on;
    }

    @Override
    public synchronized void init(CRLCachePolicy[] policies) throws CRLCacheUpdateException {
        this.m_policies = new Hashtable();
        if (policies == null || policies.length == 0) {
            return;
        }
        for (int i = 0; i < policies.length; ++i) {
            this.addPolicy(policies[i]);
        }
    }

    @Override
    public String populate(byte[] crlData) {
        String issuerName;
        block5: {
            issuerName = null;
            try {
                X509CRL crl = new X509CRL(crlData, 0, 0);
                boolean okToCache = true;
                if (this.m_policies != null && this.m_policies.get(crl.getIssuerName()) == null) {
                    okToCache = false;
                }
                if (okToCache) {
                    this.insert(crl);
                    issuerName = crl.getIssuerName().toString();
                    if (this.DEBUG) {
                        System.out.println("CRL by " + issuerName + " is cached.");
                    }
                }
            }
            catch (Exception ex) {
                if (!this.DEBUG) break block5;
                ex.printStackTrace();
            }
        }
        return issuerName;
    }

    @Override
    public String getIssuerName(byte[] crlData) {
        String issuerName = null;
        try {
            X509CRL crl = new X509CRL(crlData, 0, 0);
            issuerName = crl.getIssuerName().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return issuerName;
    }

    @Override
    public synchronized void addPolicy(CRLCachePolicy policy) throws CRLCacheUpdateException {
        String uri = null;
        uri = policy.getDistributionPoint();
        if (uri == null) {
            if (this.DEBUG) {
                System.out.println("Invalid cache policy - no URI specified.");
            }
            return;
        }
        if (this.m_policies == null) {
            this.m_policies = new Hashtable();
        }
        this.m_policies.put(uri, policy);
        this.m_policyList = this.newPolicyList();
        X509CRL crl = null;
        crl = this.refresh(policy);
        if (crl != null) {
            policy.setIssuerName(crl.getIssuerName().toString());
            this.m_issuerByDP.put(uri, crl.getIssuerName());
        }
        this.scheduleNextUpdate(policy);
        if (crl == null) {
            String err = prAccessor.getString("CRL_UPDATE_ERROR") + policy.getDistributionPoint();
            throw new CRLCacheUpdateException(err);
        }
    }

    @Override
    public synchronized void deletePolicy(CRLCachePolicy policy) {
        if (this.m_policies == null) {
            return;
        }
        String uri = null;
        uri = policy.getDistributionPoint();
        if (uri == null) {
            return;
        }
        this.delete((X500Name)this.m_issuerByDP.get(uri));
        CRLCachePolicy deleted = (CRLCachePolicy)this.m_policies.remove(uri);
        this.m_policyList = this.newPolicyList();
        if (deleted == this.m_nextUpdate) {
            this.scheduleNextUpdate(null);
        }
    }

    @Override
    public void forceUpdate(String distributionPoint) {
        CRLCachePolicy crl = (CRLCachePolicy)this.m_policies.get(distributionPoint);
        if (crl == null) {
            return;
        }
        this.refresh(crl);
        if (crl == this.m_nextUpdate) {
            this.scheduleNextUpdate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextUpdate(CRLCachePolicy next) {
        if (this.m_nextUpdate == null) {
            this.startUpdateThread();
        }
        Object object = this.m_nextUpdateSync;
        synchronized (object) {
            if (next == null) {
                this.m_nextUpdate = CRLCachePolicy.nextUpdate(this.m_policyList);
            } else if (this.m_nextUpdate == null || this.m_nextUpdate.getNextUpdate() > next.getNextUpdate()) {
                this.m_nextUpdate = next;
                this.m_nextUpdateSync.notifyAll();
            }
        }
    }

    @Override
    public void reset() {
        this.m_crls = new Vector();
        this.stopUpdateThread();
    }

    public boolean insert(X509CRL newCRL) {
        return this.update(newCRL, false);
    }

    public boolean update(X509CRL newCRL) {
        if (this.DEBUG) {
            System.out.println("Updating cache with CRL issued by " + newCRL.getIssuerName());
        }
        return this.update(newCRL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(X509CRL newCRL, boolean checkLatest) {
        if (newCRL == null) {
            return false;
        }
        try {
            newCRL = (X509CRL)newCRL.clone();
        }
        catch (CloneNotSupportedException e) {
            if (this.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        X500Name issuerName = newCRL.getIssuerName();
        Date thisUpdate = newCRL.getThisUpdate();
        boolean update = true;
        Vector vector = this.m_crls;
        synchronized (vector) {
            for (int i = 0; i < this.m_crls.size(); ++i) {
                try {
                    X509CRL crl = (X509CRL)this.m_crls.elementAt(i);
                    if (!crl.getIssuerName().equals((Object)issuerName)) continue;
                    if (!checkLatest || crl instanceof ExpiredCachedCRL) {
                        this.m_crls.removeElementAt(i);
                        break;
                    }
                    if (crl.getThisUpdate().before(thisUpdate)) {
                        this.m_crls.removeElementAt(i);
                        break;
                    }
                    update = false;
                    break;
                }
                catch (ClassCastException e) {
                    if (!this.DEBUG) continue;
                    e.printStackTrace();
                }
            }
            if (update) {
                this.m_crls.addElement(newCRL);
                if (this.DEBUG) {
                    System.out.println("Updated CRL by " + newCRL.getIssuerName() + " at " + new Date(System.currentTimeMillis()));
                }
            }
            return update;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expire(X500Name issuerName) {
        Vector vector = this.m_crls;
        synchronized (vector) {
            for (int i = 0; i < this.m_crls.size(); ++i) {
                try {
                    X509CRL crl = (X509CRL)this.m_crls.elementAt(i);
                    if (!crl.getIssuerName().equals((Object)issuerName)) continue;
                    this.m_crls.removeElementAt(i);
                    ExpiredCachedCRL expired = new ExpiredCachedCRL(crl.getIssuerName());
                    expired.setThisUpdate(crl.getThisUpdate());
                    this.m_crls.addElement(expired);
                    break;
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delete(X500Name issuerName) {
        if (issuerName == null) {
            if (this.DEBUG) {
                System.out.println("issuerName should not be null.");
            }
            return false;
        }
        Vector vector = this.m_crls;
        synchronized (vector) {
            for (int i = 0; i < this.m_crls.size(); ++i) {
                try {
                    X509CRL crl = (X509CRL)this.m_crls.elementAt(i);
                    if (!issuerName.equals((Object)crl.getIssuerName())) continue;
                    this.m_crls.removeElementAt(i);
                    return true;
                }
                catch (ClassCastException e) {
                    if (!this.DEBUG) continue;
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    private CRLCachePolicy[] newPolicyList() {
        CRLCachePolicy[] policyList = new CRLCachePolicy[this.m_policies.size()];
        int i = 0;
        Enumeration elms = this.m_policies.elements();
        while (elms.hasMoreElements()) {
            policyList[i] = (CRLCachePolicy)elms.nextElement();
            ++i;
        }
        return policyList;
    }

    private X509CRL refresh(CRLCachePolicy theCRL) {
        X509CRL crl;
        block11: {
            long currentTime;
            block10: {
                SessionConfig.logMessage(prAccessor.getString("CRL_UPDATING") + theCRL.getDistributionPoint(), SessionConfig.getLevelInfo());
                crl = null;
                byte[] crlData = this.m_crlStore.getCRLByDP(theCRL.getDistributionPoint());
                currentTime = System.currentTimeMillis();
                if (crlData != null) {
                    try {
                        crl = new X509CRL(crlData, 0, 0);
                    }
                    catch (Exception ex) {
                        if (!this.DEBUG) break block10;
                        ex.printStackTrace();
                    }
                }
            }
            if (crl != null) {
                this.update(crl);
                theCRL.setLastUpdated(currentTime);
                theCRL.setNextUpdate(Math.min(crl.getNextUpdate().getTime(), currentTime + theCRL.getRefreshInterval() * 1000L));
                if (this.DEBUG) {
                    System.out.println("Next update for CRL by " + crl.getIssuerName() + " is " + new Date(theCRL.getNextUpdate()));
                }
            } else {
                theCRL.setNextUpdate(currentTime + theCRL.getRefreshInterval() * 1000L);
                if (this.DEBUG) {
                    System.out.println("Failed to fetch CRL by " + theCRL.getIssuerName() + " from " + theCRL.getDistributionPoint());
                }
                SessionConfig.logMessage(prAccessor.getString("CRL_UPDATE_ERROR") + theCRL.getDistributionPoint(), SessionConfig.getLevelWarning());
                if (!theCRL.getIssuerName().equals(CRLCachePolicy.UNKNOWN_CA) && theCRL.getCacheLifeTime() != -1L && System.currentTimeMillis() - theCRL.getLastUpdated() > theCRL.getCacheLifeTime() * 1000L) {
                    try {
                        SessionConfig.logMessage(prAccessor.getString("CRL_EXPIRED_ERROR") + theCRL.getIssuerName(), SessionConfig.getLevelSevere());
                        this.expire(new X500Name(theCRL.getIssuerName()));
                    }
                    catch (Exception ex) {
                        if (!this.DEBUG) break block11;
                        System.out.println("Failed to expire CRL by " + theCRL.getIssuerName());
                    }
                }
            }
        }
        return crl;
    }

    private void startUpdateThread() {
        if (this.m_updateThread != null && this.m_updateThread.isAlive()) {
            return;
        }
        this.m_updateThread = new Thread((Runnable)this, "CRL update thread.");
        this.m_updateThread.setDaemon(true);
        this.m_updateThread.start();
    }

    private void stopUpdateThread() {
        Thread t = this.m_updateThread;
        this.m_updateThread = null;
        if (t != null) {
            t.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.DEBUG) {
            System.out.println(Thread.currentThread().getName() + " started.");
        }
        CRLCachePolicy theCRL = null;
        long waitTime = -1L;
        while (Thread.currentThread() == this.m_updateThread) {
            Object object = this.m_nextUpdateSync;
            synchronized (object) {
                try {
                    while (this.m_nextUpdate == null) {
                        this.m_nextUpdateSync.wait();
                    }
                    theCRL = this.m_nextUpdate;
                    waitTime = theCRL.getNextUpdate() - System.currentTimeMillis();
                    if (this.DEBUG) {
                        System.out.println("About to update CRL by " + theCRL.getIssuerName() + " in " + waitTime + " ms.");
                    }
                    if (waitTime > 0L) {
                        this.m_nextUpdateSync.wait(waitTime);
                    }
                }
                catch (InterruptedException ex) {
                    if (this.m_updateThread != Thread.currentThread()) {
                        return;
                    }
                    this.m_updateThread = null;
                    ex.printStackTrace();
                }
            }
            if (waitTime > 0L && theCRL.getNextUpdate() > System.currentTimeMillis()) continue;
            this.refresh(theCRL);
            this.scheduleNextUpdate(null);
        }
    }

    private final class Implementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private Vector crlStore;
        private int crlPointer;
        private Object crlIteratorLock;

        private Implementation(CertJ certJ, String name) throws InvalidParameterException {
            super(certJ, name);
            this.crlIteratorLock = new Object();
            this.crlStore = MemoryDB.this.m_crls;
            this.crlPointer = -1;
        }

        public void insertCRL(CRL crl) throws NotSupportedException {
            throw new NotSupportedException("Inserting CRL has to be done via the wrapper CRLCache object.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCRLByIssuerAndTime(X500Name issuerName, Date time, Vector crlList) throws DatabaseException {
            if (MemoryDB.this.DEBUG) {
                System.out.println("Selecting CRL(s) by " + issuerName.toString() + " and date " + time);
            }
            if (issuerName == null || time == null) {
                throw new DatabaseException("MemeoryDBProvider.selectCRLByIssuerAndTime: Neither issuerName nor time should be null.");
            }
            Date bestTime = new Date(0L);
            X509CRL bestCrl = null;
            Vector vector = this.crlStore;
            synchronized (vector) {
                for (int i = 0; i < this.crlStore.size(); ++i) {
                    try {
                        Date lastUpdate;
                        Object obj = this.crlStore.elementAt(i);
                        if (obj instanceof ExpiredCachedCRL) {
                            if (!((ExpiredCachedCRL)((Object)obj)).getIssuerName().equals((Object)issuerName)) continue;
                            if (MemoryDB.this.DEBUG) {
                                System.out.println("MemeoryDB: returning expired cached CRL issued by " + issuerName);
                            }
                            crlList.addElement(obj);
                            return 1;
                        }
                        X509CRL crl = (X509CRL)obj;
                        X500Name testName = crl.getIssuerName();
                        if (!issuerName.equals((Object)testName) || (lastUpdate = crl.getThisUpdate()).after(time) || !lastUpdate.after(bestTime)) continue;
                        bestTime = lastUpdate;
                        bestCrl = crl;
                        continue;
                    }
                    catch (ClassCastException e) {
                        e.printStackTrace();
                    }
                }
                if (bestCrl == null) {
                    return 0;
                }
                if (!crlList.contains(bestCrl)) {
                    try {
                        crlList.addElement((CRL)bestCrl.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemeoryDBProvider.selectCRLByIssuerAndTime: Unable to clone a CRL(" + e.getMessage() + ").");
                    }
                }
                return 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCRLIteratorSetup() {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                return this.crlPointer >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCRLIterator() {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                this.crlPointer = 0;
            }
        }

        public CRL firstCRL() throws DatabaseException {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                this.setupCRLIterator();
                Vector vector = this.crlStore;
                synchronized (vector) {
                    if (this.crlStore.size() == 0) {
                        this.crlPointer = -1;
                        return null;
                    }
                    try {
                        return (CRL)((X509CRL)this.crlStore.elementAt(this.crlPointer++)).clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemeoryDBProvider.firstCRL: Unable to clone a CRL(" + e.getMessage() + ").");
                    }
                }
            }
        }

        public CRL nextCRL() throws DatabaseException {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    throw new DatabaseException("MemeoryDB.nextCRL: crl iterator is not set up.");
                }
                Vector vector = this.crlStore;
                synchronized (vector) {
                    if (this.crlPointer >= this.crlStore.size()) {
                        this.crlPointer = -1;
                        return null;
                    }
                    try {
                        return (CRL)((X509CRL)this.crlStore.elementAt(this.crlPointer++)).clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new DatabaseException("MemeoryDBProvider.nextCRL: Unable to clone a CRL(" + e.getMessage() + ").");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCRLs() throws DatabaseException {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    throw new DatabaseException("MemeoryDB.hasMoreCRL: crl iterator is not set up.");
                }
                Vector vector = this.crlStore;
                synchronized (vector) {
                    return this.crlPointer < this.crlStore.size();
                }
            }
        }

        public void deleteCRL(X500Name issuerName, Date lastUpdate) throws NotSupportedException {
            throw new NotSupportedException("Deleting CRL has to be done via the wrapper CRLCache object.");
        }

        public String toString() {
            return "In-memory database provider named: " + super.getName();
        }

        public void insertCertificate(Certificate certificate) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public void insertPrivateKeyByCertificate(Certificate certificate, JSAFE_PrivateKey jSAFE_PrivateKey) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public int selectCertificateByIssuerAndSerialNumber(X500Name x500Name, byte[] byteArray, Vector vector) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public int selectCertificateBySubject(X500Name x500Name, Vector vector) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public int selectCertificateByExtensions(X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public boolean isCertificateIteratorSetup() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public void setupCertificateIterator() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public Certificate firstCertificate() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public Certificate nextCertificate() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public boolean hasMoreCertificates() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate certificate) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public boolean isPrivateKeyIteratorSetup() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public void setupPrivateKeyIterator() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public JSAFE_PrivateKey firstPrivateKey() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public JSAFE_PrivateKey nextPrivateKey() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public boolean hasMorePrivateKeys() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public void deleteCertificate(X500Name x500Name, byte[] byteArray) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public void deletePrivateKeyByCertificate(Certificate certificate) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }

        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException(" not supported.");
        }
    }

    public final class ExpiredCachedCRL
    extends X509CRL {
        ExpiredCachedCRL(X500Name issuerName) {
            try {
                this.setIssuerName(issuerName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

