/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import progress.message.broker.AgentSubjectSpace;
import progress.message.broker.SubjectAclEntry;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPrincipal;

public class DelPrincipalEvent
extends SecurityEvent {
    private ProgressPrincipal m_principal;
    private Vector m_deletedAclSubjects;

    DelPrincipalEvent(SecurityBean source, long starttime, int vtime, ProgressPrincipal prin, Vector deletedAclSubjects) {
        super(source, starttime, vtime);
        this.m_principal = prin;
        this.m_deletedAclSubjects = deletedAclSubjects;
    }

    DelPrincipalEvent() {
    }

    public Vector getDeletedAclSubjects() {
        return this.m_deletedAclSubjects;
    }

    public ProgressPrincipal getPrincipal() {
        return this.m_principal;
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
        cache.processDelPrincipalEvent(this);
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
        SubjectAclEntry sae = new SubjectAclEntry(this.m_principal);
        for (int i = this.m_deletedAclSubjects.size() - 1; i >= 0; --i) {
            ss.removeSubjectObject((String)this.m_deletedAclSubjects.elementAt(i), (ISubjectMatchObject)sae);
        }
        ss.resetCache();
    }

    @Override
    short getType() {
        return 8;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        super.serialize(out);
        out.writeUTF(this.m_principal.getName());
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        super.unserialize(in, cache);
        String pname = in.readUTF();
        this.m_principal = cache.getPrincipal(pname);
        if (this.m_principal == null) {
            this.m_principal = new ProgressGroup(pname);
        }
        this.m_deletedAclSubjects = (Vector)this.m_principal.getAclSubjects().clone();
    }
}

