/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http.soap;

import com.sonicsw.net.http.HttpConstants;
import java.io.IOException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.server.AxisServer;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAP12Constants;
import org.apache.axis.soap.SOAPConstants;

public class SOAPUtils {
    public static String writeFaultResponse(Throwable th) throws IOException {
        return SOAPUtils.writeFaultResponse(th, "SOAP 1.1");
    }

    public static String writeFaultResponse(String message) throws IOException {
        return SOAPUtils.writeFaultResponse(message, "SOAP 1.1");
    }

    public static String writeFaultResponse(String message, String soapVersion) throws IOException {
        try {
            Message axisMessage = SOAPUtils.buildFaultMessage(soapVersion, "Server", message);
            return SOAPUtils.writeFaultStr(axisMessage);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static String writeFaultResponse(Throwable th, String soapVersion) throws IOException {
        try {
            Message axisMessage = SOAPUtils.buildFaultMessage(soapVersion, "Server.Exception", th.getMessage());
            return SOAPUtils.writeFaultStr(axisMessage);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private static String writeFaultStr(Message axisMessage) throws AxisFault {
        SOAPEnvelope env = axisMessage.getSOAPEnvelope();
        String faultStr = env.toString();
        HttpConstants.DEBUG("SOAPUTIL.writeFaultResponse \n" + faultStr, 0);
        return faultStr;
    }

    public static Message createEmptyMessage(SOAPConstants soapConstants) {
        MessageContext msgContext = new MessageContext((AxisEngine)new AxisServer());
        msgContext.setSOAPConstants(soapConstants);
        SOAPEnvelope env = new SOAPEnvelope(soapConstants);
        Message axisMessage = new Message((Object)env);
        axisMessage.setMessageContext(msgContext);
        return axisMessage;
    }

    public static Message buildSuccessMessage(String soapVersion) throws Exception {
        Message axisMessage = SOAPUtils.createEmptyMessage(SOAPUtils.getSoapConstants(soapVersion));
        SOAPBody body = axisMessage.getSOAPBody();
        Name bodyName = SOAPFactory.newInstance().createName("nullResponse");
        SOAPBodyElement bodyElement = body.addBodyElement(bodyName);
        return axisMessage;
    }

    public static Message buildFaultMessage(String soapVersion, String faultCode, String faultString) throws SOAPException {
        Message axisMessage = SOAPUtils.createEmptyMessage(SOAPUtils.getSoapConstants(soapVersion));
        SOAPBody body = axisMessage.getSOAPBody();
        SOAPFault fault = body.addFault();
        fault.setFaultCode(faultCode);
        fault.setFaultString(faultString);
        return axisMessage;
    }

    public static Message buildFaultMessage(String soapVersion, Throwable th) throws Exception {
        Message axisMessage = SOAPUtils.createEmptyMessage(SOAPUtils.getSoapConstants(soapVersion));
        SOAPBody body = axisMessage.getSOAPBody();
        SOAPFault fault = body.addFault();
        fault.setFaultCode("Server.Exception");
        fault.setFaultString(th.getMessage());
        return axisMessage;
    }

    public static SOAPConstants getSoapConstants(String soapVersion) {
        SOAP11Constants sc = SOAPConstants.SOAP11_CONSTANTS;
        if (soapVersion != null && soapVersion.compareToIgnoreCase("SOAP 1.2") == 0) {
            sc = SOAPConstants.SOAP12_CONSTANTS;
        }
        return sc;
    }

    public static String getSOAP12ContentType() {
        SOAP12Constants sc = SOAPConstants.SOAP12_CONSTANTS;
        return sc.getContentType();
    }

    public static Message buildFaultMessage(AxisFault af, String soapVersion) throws Exception {
        Message axisMessage = SOAPUtils.createEmptyMessage(SOAPUtils.getSoapConstants(soapVersion));
        SOAPBody body = axisMessage.getSOAPBody();
        org.apache.axis.message.SOAPFault fault = (org.apache.axis.message.SOAPFault)body.addFault();
        fault.setFault(af);
        return axisMessage;
    }
}

