/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.action;

import javax.xml.namespace.QName;

public class MessagePart {
    private static final String CONTENT = "Content";
    private static final String ELEMENT = "Element";
    private QName m_qName;
    private boolean m_encryptElement = false;

    public MessagePart() {
        this.m_qName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    }

    public MessagePart(QName qname) {
        this.m_qName = new QName(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public MessagePart(String namespace, String name) {
        this.m_qName = new QName(namespace, name);
    }

    public MessagePart(String namespace, String name, boolean encryptElement) {
        this.m_qName = new QName(namespace, name);
        this.m_encryptElement = encryptElement;
    }

    public String getName() {
        return this.m_qName.getLocalPart();
    }

    public String getNamespace() {
        return this.m_qName.getNamespaceURI();
    }

    public QName getQName() {
        return this.m_qName;
    }

    public String getEncryptionModifier() {
        if (this.m_encryptElement) {
            return ELEMENT;
        }
        return CONTENT;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessagePart part = (MessagePart)obj;
        return this.getEncryptionModifier() == part.getEncryptionModifier() && this.getName().equals(part.getName()) && this.getNamespace().equals(part.getNamespace());
    }

    public int hashCode() {
        int hashCode = this.m_qName.hashCode();
        if (this.m_encryptElement) {
            ++hashCode;
        }
        return hashCode;
    }
}

