/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.wss4j;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.DomainTrustManager;
import com.sonicsw.ws.security.PasswordTrustManager;
import com.sonicsw.ws.security.TokenManager;
import com.sonicsw.ws.security.TokenReferenceException;
import com.sonicsw.ws.security.TrustManager;
import com.sonicsw.ws.security.X509TokenManager;
import com.sonicsw.ws.security.X509TrustManager;
import com.sonicsw.ws.security.provider.DefaultTrustManager;
import com.sonicsw.ws.security.provider.SonicWSProvider;
import com.sonicsw.ws.security.wss4j.SonicWSSConfig;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.processor.Processor;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import progress.message.broker.Config;

public class SonicWSSecurityEngine
extends WSSecurityEngine {
    private static SonicWSSecurityEngine s_engine = null;
    private static Object _sync = new Object();
    private static WSSConfig wssConfig = null;
    private DomainTrustManager m_domainTrustManager = null;
    private PasswordTrustManager m_passwordManager = null;
    private X509TrustManager m_X509TrustManager = null;
    private X509TokenManager m_X509TokenManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSSecurityEngine getInstance() {
        if (s_engine == null) {
            Object object = _sync;
            synchronized (object) {
                if (s_engine == null) {
                    s_engine = new SonicWSSecurityEngine();
                }
                wssConfig = new SonicWSSConfig();
                wssConfig.setWsiBSPCompliant(Config.WS_SECURITY_DSIG_PREFIXLIST_REQUIRED);
                SonicWSSecurityEngine.setWssConfig((WSSConfig)wssConfig);
            }
        }
        return s_engine;
    }

    private SonicWSSecurityEngine() {
        try {
            String Id = "SonicWS";
            if (Security.getProvider(Id) == null) {
                Security.addProvider(new SonicWSProvider());
            }
            this.m_X509TokenManager = (X509TokenManager)TokenManager.getInstance("X509", Id);
            this.m_X509TrustManager = (X509TrustManager)TrustManager.getInstance("X509", Id);
            this.m_passwordManager = (PasswordTrustManager)TrustManager.getInstance("Password", Id);
            this.m_domainTrustManager = this.m_passwordManager instanceof DefaultTrustManager ? (DomainTrustManager)((Object)this.m_passwordManager) : (DomainTrustManager)((Object)TrustManager.getInstance("Password", "SonicWS"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    X509TrustManager getX509TrustManager() {
        return this.m_X509TrustManager;
    }

    DomainTrustManager getDomainTrustManager() {
        return this.m_domainTrustManager;
    }

    PasswordTrustManager getPasswordTrustManager() {
        return this.m_passwordManager;
    }

    protected Vector processSecurityHeader(Element securityHeader, CallbackHandler cb, Crypto sigCrypto, Crypto decCrypto) throws WSSecurityException {
        WSDocInfo wsDocInfo = new WSDocInfo(securityHeader.getOwnerDocument().hashCode());
        wsDocInfo.setCrypto(sigCrypto);
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        Vector returnResults = new Vector();
        for (int i = 0; i < len; ++i) {
            Node elem = list.item(i);
            if (elem.getNodeType() != 1) continue;
            QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
            Processor p = wssConfig.getProcessor(el);
            if (p != null) {
                p.handleToken((Element)elem, sigCrypto, decCrypto, cb, wsDocInfo, returnResults, wssConfig);
                wsDocInfo.setProcessor(p);
                continue;
            }
            DebugObjects.getHandlerDebug().debug(((Object)((Object)this)).getClass().getName() + ": Unknown Element: " + elem.getLocalName() + " " + elem.getNamespaceURI());
        }
        return returnResults;
    }

    public X509Certificate[] getCertificatesByIssuerSerial(Element elem) throws WSSecurityException {
        if (elem == null) {
            return null;
        }
        X509Certificate[] certs = null;
        XMLX509IssuerSerial issuerSerial = null;
        try {
            issuerSerial = new XMLX509IssuerSerial(elem, "");
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException(7, "noToken", new Object[]{"Issuer/Serial data element missing"});
        }
        try {
            X509Certificate cert = this.m_X509TokenManager.findCertificateByIssuerAndSerialNumber(issuerSerial.getIssuerName(), issuerSerial.getSerialNumber());
            certs = new X509Certificate[]{cert};
        }
        catch (TokenReferenceException ex) {
            throw new WSSecurityException(7, "noToken", new Object[]{"Issuer/Serial data element missing"});
        }
        return certs;
    }
}

