/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.wsdl;

import com.sonicsw.wsdl.SOAPUtils;
import com.sonicsw.wsdl.WSDLUtils;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wspa.WSPAUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.SAXException;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;

public class WSDLContext {
    private Definition m_def = null;
    private byte[] m_serialized = null;
    private String m_uri = null;
    private boolean m_outMessagePolicyRequired = false;

    public Definition getDefinition() {
        return this.m_def;
    }

    public void setDefinition(Definition def) {
        this.m_def = def;
    }

    public byte[] getSerialized() {
        return this.m_serialized;
    }

    public String getWSDLUri() {
        return this.m_uri;
    }

    public void setOutMessagePolicyRequired(boolean b) {
        this.m_outMessagePolicyRequired = b;
    }

    public boolean getOutMessagePolicyRequired() {
        return this.m_outMessagePolicyRequired;
    }

    public WSDLContext(String wsdlURI, Definition def, byte[] serialized) {
        this.m_uri = wsdlURI;
        this.m_def = def;
        this.m_serialized = serialized;
    }

    public InputStream getWSDLInputStream() {
        return new ByteArrayInputStream(this.m_serialized);
    }

    public RequestDispatchContext getRequestDispatchContext(String endpointURL, String wsaActionURI, String soapActionURI, SOAPMessage soapm) throws WSDLException, SOAPException, ParserConfigurationException, SAXException, XmlException, PolicyException, IOException {
        Port[] ports = WSDLUtils.getPorts(endpointURL, this.m_def);
        if (ports == null || ports.length == 0) {
            throw new WSDLException("", "A port matching the location URL was not found");
        }
        RequestDispatchContext ctx = new RequestDispatchContext();
        for (int i = 0; i < ports.length; ++i) {
            if (this.dispatchAction((DispatchContext)ctx, ports[i], wsaActionURI, soapActionURI, soapm)) {
                return ctx;
            }
            if (!this.dispatchHeuristic(ctx, ports[i], soapm)) continue;
            return ctx;
        }
        throw new WSDLException("", "An operation matching the request was not found");
    }

    private boolean dispatchAction(DispatchContext ctx, Port port, String wsaActionURI, String soapActionURI, SOAPMessage soapm) throws SOAPException, ParserConfigurationException, SAXException, XmlException, PolicyException, IOException {
        Binding binding = port.getBinding();
        PortType type = binding.getPortType();
        for (BindingOperation bindingOp : binding.getBindingOperations()) {
            if (!this.dispatchAction(ctx, wsaActionURI, soapActionURI, binding, bindingOp)) continue;
            return this.configCtxPortAndEndpointPolicy(ctx, port);
        }
        return false;
    }

    private boolean dispatchHeuristic(DispatchContext ctx, Port port, SOAPMessage soapm) throws SOAPException, ParserConfigurationException, SAXException, XmlException, PolicyException, IOException {
        Binding binding = port.getBinding();
        PortType type = binding.getPortType();
        SOAPBodyElement[] bodyElements = SOAPUtils.getSOAPBodyElements(soapm.getSOAPBody());
        for (BindingOperation bindingOp : binding.getBindingOperations()) {
            if (!this.dispatchHeuristic(ctx, bodyElements, binding, bindingOp)) continue;
            return this.configCtxPortAndEndpointPolicy(ctx, port);
        }
        return false;
    }

    private boolean configCtxPortAndEndpointPolicy(DispatchContext ctx, Port port) throws IOException, ParserConfigurationException, PolicyException, SAXException, XmlException {
        ctx.setPort(port);
        ctx.setEndpointPolicy(WSPAUtils.getEndpointPolicy(this, port));
        return true;
    }

    public boolean dispatchHeuristic(DispatchContext ctx, SOAPBodyElement[] bodyElements, Binding binding, BindingOperation bindingOp) throws ParserConfigurationException, SAXException, XmlException, PolicyException, IOException {
        SOAPOperation soapOperation;
        Operation abstractOp = bindingOp.getOperation();
        SOAPBinding soapBinding = WSDLUtils.getSOAPBinding(binding);
        String soapStyle = WSDLUtils.getSoapStyle(soapBinding, soapOperation = WSDLUtils.getSOAPOperation(bindingOp));
        if (WSDLUtils.isRPCStyle(soapStyle)) {
            for (int idx = 0; idx < bodyElements.length; ++idx) {
                QName bopQName;
                Name bodyName = bodyElements[0].getElementName();
                if (WSDLUtils.isEqual(bodyName, bopQName = WSDLUtils.getRPCElementName(bindingOp, bindingOp.getBindingInput()))) {
                    this.setupDispatchContext(ctx, bindingOp, abstractOp);
                    return true;
                }
                if (bopQName.getNamespaceURI() != null && bopQName.getNamespaceURI().length() != 0 && !bopQName.getNamespaceURI().equals("\"\"") && bodyName.getURI() != null && bodyName.getURI().length() != 0 && !bodyName.getURI().equals("\"\"") || !bodyName.getLocalName().equals(bopQName.getLocalPart())) continue;
                this.setupDispatchContext(ctx, bindingOp, abstractOp);
                return true;
            }
        } else {
            SOAPBody soapBody = WSDLUtils.getSOAPBody(bindingOp.getBindingInput());
            List partsBoundToBody = WSDLUtils.getPartsBoundToSOAPBody(abstractOp.getInput().getMessage(), soapBody);
            if (partsBoundToBody.size() != bodyElements.length) {
                return false;
            }
            Iterator iter = partsBoundToBody.iterator();
            int bodyElementIndex = 0;
            while (iter.hasNext()) {
                Part part = (Part)iter.next();
                if (!WSDLUtils.comparePartElement(part, bodyElements[bodyElementIndex])) {
                    return false;
                }
                ++bodyElementIndex;
            }
            this.setupDispatchContext(ctx, bindingOp, abstractOp);
            return true;
        }
        return false;
    }

    public boolean dispatchAction(DispatchContext ctx, String wsaActionURIParam, String soapActionURIParam, Binding binding, BindingOperation bindingOp) throws ParserConfigurationException, SAXException, XmlException, PolicyException, IOException {
        String wsaActionURI = wsaActionURIParam;
        String soapActionURI = soapActionURIParam;
        Operation abstractOp = bindingOp.getOperation();
        SOAPOperation soapOperation = WSDLUtils.getSOAPOperation(bindingOp);
        String wsdlSoapActionURI = this.normalize(soapOperation.getSoapActionURI());
        String wsdlInputWSAOp = this.normalize(AddressingUtils.getInputAction((QName)binding.getPortType().getQName(), (Operation)abstractOp));
        soapActionURI = this.normalize(soapActionURI);
        MatchResult result = this.actionMatch(wsaActionURI = this.normalize(wsaActionURI), wsdlInputWSAOp, soapActionURI, wsdlSoapActionURI);
        if (result.getResult() != 0) {
            return false;
        }
        this.setupDispatchContext(ctx, bindingOp, abstractOp);
        return true;
    }

    private void setupDispatchContext(DispatchContext ctx, BindingOperation bindingOp, Operation abstractOp) throws ParserConfigurationException, XmlException, SAXException, PolicyException, IOException {
        ctx.setBindingOperation(bindingOp);
        ctx.setOperation(abstractOp);
        ctx.setOperationPolicy(WSPAUtils.getOperationPolicy(this, bindingOp));
        ctx.setMessagePolicy(WSPAUtils.getInputMessagePolicy(this, bindingOp.getBindingInput(), bindingOp.getOperation().getInput()));
        if (bindingOp.getBindingOutput() != null) {
            if (this.getOutMessagePolicyRequired()) {
                ctx.setOutMessagePolicy(WSPAUtils.getOutputMessagePolicy(this, bindingOp.getBindingOutput(), bindingOp.getOperation().getOutput()));
            }
        } else {
            ctx.setOneway(true);
        }
    }

    private MatchResult actionMatch(String wsaAction, String wsdlWSAAction, String soapAction, String wsdlSoapAction) {
        boolean soapActionSet = false;
        boolean wsaActionSet = false;
        boolean wsdlSoapActionSet = false;
        if (soapAction.length() > 0) {
            soapActionSet = true;
        }
        if (wsaAction.length() > 0) {
            wsaActionSet = true;
        }
        if (wsdlSoapAction.length() > 0) {
            wsdlSoapActionSet = true;
        }
        if (wsdlSoapActionSet && soapActionSet || wsaActionSet) {
            if (wsaActionSet) {
                if (wsaAction.equals(wsdlWSAAction)) {
                    return new MatchResult(0);
                }
                if (wsdlSoapActionSet) {
                    if (wsdlSoapAction.equals(wsaAction) || soapActionSet && wsdlSoapAction.equals(soapAction)) {
                        return new MatchResult(0);
                    }
                    return new MatchResult(1);
                }
                return new MatchResult(1);
            }
            if (wsdlSoapAction.equals(soapAction)) {
                return new MatchResult(0);
            }
            return new MatchResult(1);
        }
        return new MatchResult(2);
    }

    private String normalize(String stringParam) {
        String string = stringParam;
        if (string == null) {
            string = "";
        } else if (string.length() > 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static class RequestDispatchContext
    extends DispatchContext {
        public boolean hasResponse() {
            return this.getOperation().getOutput() != null;
        }
    }

    public static class DispatchContext {
        private Service m_service = null;
        private Port m_port = null;
        private PolicyDocument m_endpointPolicy = null;
        private PolicyDocument m_messagePolicy = null;
        private PolicyDocument m_outMessagePolicy = null;
        private Operation m_operation = null;
        private PolicyDocument m_operationPolicy = null;
        private BindingOperation m_bindingOperation = null;
        private boolean m_oneway = false;

        public Service getService() {
            return this.m_service;
        }

        public void setService(Service svc) {
            this.m_service = svc;
        }

        public Port getPort() {
            return this.m_port;
        }

        public void setPort(Port port) {
            this.m_port = port;
        }

        public PolicyDocument getEndpointPolicy() {
            return this.m_endpointPolicy;
        }

        public void setEndpointPolicy(PolicyDocument policy) {
            this.m_endpointPolicy = policy;
        }

        public PolicyDocument getMessagePolicy() {
            return this.m_messagePolicy;
        }

        public void setMessagePolicy(PolicyDocument policy) {
            this.m_messagePolicy = policy;
        }

        public PolicyDocument getOutMessagePolicy() {
            return this.m_outMessagePolicy;
        }

        public void setOutMessagePolicy(PolicyDocument policy) {
            this.m_outMessagePolicy = policy;
        }

        public Operation getOperation() {
            return this.m_operation;
        }

        public void setOperation(Operation operation) {
            this.m_operation = operation;
        }

        public PolicyDocument getOperationPolicy() {
            return this.m_operationPolicy;
        }

        public void setOperationPolicy(PolicyDocument policy) {
            this.m_operationPolicy = policy;
        }

        public BindingOperation getBindingOperation() {
            return this.m_bindingOperation;
        }

        public void setBindingOperation(BindingOperation bindingOp) {
            this.m_bindingOperation = bindingOp;
        }

        public boolean isOneway() {
            return this.m_oneway;
        }

        public void setOneway(boolean b) {
            this.m_oneway = b;
        }
    }

    private class MatchResult {
        static final short MATCH = 0;
        static final short DONT_MATCH = 1;
        static final short NOT_APPLICABLE = 2;
        private short m_result = (short)2;

        MatchResult(short result) {
            this.m_result = result;
        }

        short getResult() {
            return this.m_result;
        }
    }

    public static class FaultDispatchContext
    extends DispatchContext {
        private BindingFault m_fault = null;
    }

    public static class ResponseDispatchContext
    extends DispatchContext {
        private BindingOutput m_output = null;
    }
}

