/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.pcs.AbstractCipherSuite;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentRoutingQueue;
import progress.message.broker.AgentSender;
import progress.message.broker.Authorize;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.CCSizeTracker;
import progress.message.broker.ClientAckEvt;
import progress.message.broker.ClientContextMgramQueue;
import progress.message.broker.ClientContextTracker;
import progress.message.broker.Config;
import progress.message.broker.DurableCCTracker;
import progress.message.broker.DurableSubscriptionUtil;
import progress.message.broker.EAsyncOpNotSupported;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EConnectionNotResumable;
import progress.message.broker.ETrackingNumNotFound;
import progress.message.broker.FlowControllerP27;
import progress.message.broker.FlowControllerP28;
import progress.message.broker.FlowToDiskMemoryManager;
import progress.message.broker.GroupMsgAllocationEvt;
import progress.message.broker.GroupMsgDeallocationEvt;
import progress.message.broker.GroupSubscription;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.GroupSubscriptions;
import progress.message.broker.GroupXOnceMsgAllocationTracker;
import progress.message.broker.IActivityMonitorHandle;
import progress.message.broker.IAgentQueue;
import progress.message.broker.ICCGuarDoubtManager;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.IClientContextWrapper;
import progress.message.broker.IFlowController;
import progress.message.broker.IMinEnqueuePriorityListener;
import progress.message.broker.IProxyHandle;
import progress.message.broker.IProxyingHandle;
import progress.message.broker.IWindowAckManager;
import progress.message.broker.InDoubtQMsgReenqueueEvt;
import progress.message.broker.InitRestoreFlowController;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LogManager;
import progress.message.broker.MsgRestorePos;
import progress.message.broker.MsgRestorer;
import progress.message.broker.MsgRestorerBase;
import progress.message.broker.MsgSaver;
import progress.message.broker.OffloadedMsgRestorer;
import progress.message.broker.OffloadedPubSubMessage;
import progress.message.broker.PublishLimiter;
import progress.message.broker.PublishLimiterNotify;
import progress.message.broker.QueueMsgAckedEvt;
import progress.message.broker.QueueMsgSendEvt;
import progress.message.broker.SubscriptionsTable;
import progress.message.broker.Transaction;
import progress.message.broker.TransactionMgr;
import progress.message.broker.fc.CCFlowControlTracker;
import progress.message.broker.prAccessor;
import progress.message.client.EConnectFailure;
import progress.message.client.EGeneralException;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.ESecurityGeneralException;
import progress.message.gr.RouterManager;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.ISizedEnumeration;
import progress.message.util.IndexedList;
import progress.message.util.LongHashTable;
import progress.message.util.PriorityQueue;
import progress.message.util.server.EpochClock;
import progress.message.util.server.LongHolder;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.IExpirePrecheck;
import progress.message.zclient.IFlowControllableOutputQueue;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.IPTPFlowControlHandler;
import progress.message.zclient.IResumeCredentials;
import progress.message.zclient.IStateEvent;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.IMsgTracker;
import progress.message.zclient.xonce.IXOnceHandle;
import progress.message.zclient.xonce.MgramTrace;
import progress.message.zclient.xonce.ReleasedIndoubtQMsgs;

public class BaseClientContext
extends DebugObject
implements IClientContext {
    private static final boolean DEBUG_SECURITY_GUAR = false;
    private static final String SKIPPING_RESTORE_NO_MESSAGES_IN_DB = ": Skipping restore because no messages are in db";
    private static final int DEFAULT_SUBJECT = -1;
    private static final String SONIC_MQ_MF = "SonicMQ/mf/";
    private static final String SONIC_MQ_MF_JNDICLIENT = "SonicMQ/mf/JNDICLIENT/";
    private static final String SONIC_MQ_MF_JMXCLIENT = "SonicMQ/mf/JMXCLIENT/";
    private static final String OFFLOADING = "Offloading";
    private static final String COMMA_SPACE = ", ";
    private long m_disconnectTimerId;
    IClientContext m_delegator;
    protected static volatile AgentRegistrar s_reg;
    protected static volatile TransactionMgr s_txnmgr;
    private static volatile LogManager s_logmgr;
    private static volatile InitRestoreFlowController s_initRestoreFC;
    private boolean disconnectPending = false;
    protected volatile int m_state;
    private MsgRestorer m_msgRestorer;
    private OffloadedMsgRestorer m_offloadedMsgRestorer = null;
    private MsgRestorePos m_msgRestorePos;
    private boolean m_msgsInDb = true;
    private boolean m_restoreNonDurableMsgs = true;
    private boolean m_hasGuarMsgsInDB = true;
    protected int m_msgSavesInProgress;
    private int m_msgSavesBeforeWaitQueueInProgress;
    private long m_maxSeqNoSavedBeforeWaitQueue = -1L;
    protected int m_msgPostponedSavesInProgress;
    protected int m_msgSavesForRemoteBrokerInProgress;
    protected int m_msgsToBeAddedToOffloadedQueue;
    private MsgRestorePos m_remoteMsgRestorePos;
    private ClientConnectParms m_clientConnectParms;
    private Vector m_inDoubtTxns;
    protected ClientContextMgramQueue m_outQueue;
    private Vector m_startReqs = new Vector();
    protected IFlowController m_flowController = null;
    protected PublishLimiter m_pubLimiter = null;
    long m_id;
    Long m_idAsLong;
    protected ClientSecurityContext m_secctx;
    AgentConnection m_connection;
    private SubscriptionsTable m_subscriptions;
    Thread m_lockHolder;
    int m_lockCount;
    boolean m_disconnecting;
    int m_disconnectReason;
    boolean m_isInterbroker;
    boolean m_isRemoteBroker;
    boolean m_isJMSSession = false;
    boolean m_isJMSConnection = false;
    boolean m_isJMSQueueReceiver = false;
    boolean m_isJMSQueueBrowser = false;
    boolean m_isJMSTopicCC = false;
    boolean m_isJMSTopic = false;
    boolean m_isJMSDurable = false;
    boolean m_isRemoteNode = false;
    private LongHashTable m_mergeTable = new LongHashTable(10);
    private Map m_batchIDTable = new HashMap();
    private int m_dispatchCount = 0;
    private Object m_dispatchCountSyncObject = new Object();
    private IExpirePrecheck m_preChecker = null;
    protected Vector m_logMsgsExpectedIds = new Vector();
    protected Vector m_msgsToReenqueue = new Vector();
    private String m_remoteNode = null;
    private final long m_creationTime = System.currentTimeMillis();
    private long m_lastConnectedTime = -1L;
    private long m_lastStateChangeTime = -1L;
    private volatile long m_maxDeletedMsgId = -1L;
    private volatile short m_ackMode = (short)-1;
    private boolean m_restoringOffloaded = false;
    private boolean m_waitingForRestoreSpace = false;
    private GroupSubscriptionClientContext m_groupSubCC = null;
    private boolean m_groupOffloadCancelled = false;
    private IPTPFlowControlHandler m_ptpFlowControlHandler = null;
    private CCSizeTracker m_ccSizeTracker = null;
    private CCFlowControlTracker m_CCFlowControlTracker;
    private boolean DEBUG1;
    private final GuarDoubtManager m_guarDoubtManager = new GuarDoubtManager();
    private Vector m_resumableSocketIds = new Vector();
    private boolean m_sentOffloadingStartedEvent = false;
    private Object m_ftdNotificationSyncObj = new Object();
    private LongHashTable m_legacySubjectTrackingMap = new LongHashTable();
    private boolean m_rebuildSubjectAckMapOnResume = false;
    private ArrayList m_diagnostics = null;
    protected final Object m_syncObj;
    private static Object s_dummyObj;
    private int m_expiredMsgsPendingCount = 0;
    private long m_inDoubtTime = -1L;
    private boolean m_dirty;
    private boolean m_pinging;
    private volatile boolean m_preparedDisconnect = false;
    private volatile boolean m_isResumable = false;
    private boolean m_disconnectExpired = false;
    private IMessageProtection m_mp;
    private boolean m_flowToDiskIsSupported = false;
    private int m_flowToDisk = 0;
    private int m_dbOverflowChecks = 0;
    private volatile boolean m_completedDbOverflowChecks = false;
    private static Label[][] s_mergeLabels;
    private static DebugObject m_Sonic00027420;
    private static boolean m_done;
    private OffloadedMsgRestoreLock m_offloadedMsgRestoreLock = new OffloadedMsgRestoreLock();
    private boolean m_xonceUnsentQMsgsRestoreInProgress = false;
    private Object m_xonceUnsentQMsgsRestoreInProgressSyncObj = new Object();
    private static final long WORKING_INFINITE = Long.MAX_VALUE;
    private boolean m_resumeAttemptInProgress = false;
    private BrokerSubscription m_specialGroupSub = null;

    @Override
    public String getRemoteNode() {
        return this.m_remoteNode;
    }

    @Override
    public void setRemoteNode(String remoteNode) {
        this.m_remoteNode = remoteNode;
    }

    @Override
    public void setRestoringOffloaded(boolean restoringOffloaded) {
        this.m_restoringOffloaded = restoringOffloaded;
    }

    @Override
    public boolean getRestoringOffloaded() {
        return this.m_restoringOffloaded;
    }

    @Override
    public void setCWADSActiveBroker(IClientContext brokercc, boolean SMOtoNonSMODowngrade) {
    }

    @Override
    public IClientContext getCWADSActiveBroker() {
        return null;
    }

    @Override
    public final void setDurableBrokerSubscription(BrokerSubscription bs) {
        BrokerComponent.logMessage(new EAssertFailure("ATTEMPT to set durable subscription for a non durable client"), BrokerComponent.getLevelWarning());
    }

    @Override
    public final BrokerSubscription getDurableBrokerSubscription() {
        return null;
    }

    @Override
    public IClientContext getCWADSPreviousBroker() {
        return null;
    }

    @Override
    public void setCWADSPreviousBroker(IClientContext prevbroker) {
    }

    @Override
    public void setCWADSRestoringBroker(IClientContext brokercc) {
    }

    @Override
    public IClientContext getCWADSRestoringBroker() {
        return null;
    }

    @Override
    public void updateExpiredMsgsPending(int count) {
        this.m_expiredMsgsPendingCount += count;
    }

    @Override
    public BrokerSubscription getSelectorSubscription() {
        return null;
    }

    @Override
    public SubscriptionsTable getSubscriptions() {
        return this.m_subscriptions;
    }

    IMessageProtection getMessageProtection() {
        return this.m_mp;
    }

    @Override
    public int getFlowToDisk() {
        return this.m_flowToDisk;
    }

    @Override
    public void setFlowToDisk(int flowToDisk) {
        this.m_flowToDisk = flowToDisk;
    }

    @Override
    public boolean useFlowToDisk() {
        if (this.m_id == s_reg.getId() || this.m_delegator.isInterbroker()) {
            return false;
        }
        if (!this.m_flowToDiskIsSupported) {
            return false;
        }
        if (this.m_flowToDisk == 0) {
            return Config.FLOW_TO_DISK;
        }
        if (this.m_flowToDisk == 1) {
            return true;
        }
        if (this.m_flowToDisk == 2) {
            return false;
        }
        return Config.FLOW_TO_DISK;
    }

    @Override
    public int getDbOverflowChecks() {
        return this.m_dbOverflowChecks;
    }

    @Override
    public void setDbOverflowChecks(int value) {
        this.m_dbOverflowChecks = value;
    }

    @Override
    public void stopDbOverflowChecks() {
        this.m_completedDbOverflowChecks = true;
    }

    @Override
    public boolean performDbOverflowChecks() {
        if (!this.m_isJMSSession) {
            return false;
        }
        if (this.m_completedDbOverflowChecks) {
            return false;
        }
        if (!this.m_delegator.isActivelyConnected()) {
            return false;
        }
        if (this.m_dbOverflowChecks == 2) {
            return Config.CHECK_DB_SIZE_ON_PUBLISH;
        }
        if (this.m_dbOverflowChecks == 1) {
            return true;
        }
        if (this.m_dbOverflowChecks == 0) {
            return false;
        }
        return false;
    }

    static void initClass(AgentRegistrar reg) {
        s_reg = reg;
        s_logmgr = reg.getLogManager();
        s_txnmgr = reg.getTransactionMgr();
        s_initRestoreFC = reg.getInitRestoreFC();
        ClientContextMgramQueue.setMsgSaver(reg.getMsgSaver());
    }

    public BaseClientContext(long clientId, ClientSecurityContext csc, AgentConnection connection) {
        this(clientId, csc, connection, null);
    }

    public BaseClientContext(long clientId, ClientSecurityContext csc, AgentConnection connection, IClientContextWrapper delegator) {
        this.debugName("BaseClientContext");
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        this.m_subscriptions = new SubscriptionsTable();
        this.setDelegator(delegator);
        this.m_syncObj = this.m_delegator;
        this.m_state = 0;
        this.m_id = clientId;
        this.m_idAsLong = new Long(this.m_id);
        this.m_secctx = csc;
        this.assignConnection(connection);
        this.m_lockHolder = null;
        this.m_disconnecting = false;
        this.m_disconnectReason = -1;
        this.m_disconnectExpired = false;
        this.m_isRemoteBroker = false;
        if (csc != null) {
            String appId = csc.getAppid();
            this.m_remoteNode = RouterManager.getRemoteNodeFromGSAppID(appId);
            if (appId.startsWith("$DURABLE$")) {
                if (this.DEBUG) {
                    this.debug("CWADS_DEBUG: creating new BaseClientContext for Durable Subscription \n appid = " + csc.getAppid() + "\n uid   = " + csc.getUid());
                }
                this.m_isJMSDurable = true;
            } else if (appId.indexOf("$SESSION$") > 0) {
                this.m_isJMSSession = true;
            } else if (appId.indexOf("$QR$") >= 0) {
                this.m_isJMSQueueReceiver = true;
            } else if (appId.indexOf("$QB$") >= 0) {
                this.m_isJMSQueueBrowser = true;
            } else if (appId.indexOf("$CONNECTION$") >= 0) {
                this.m_isJMSConnection = true;
            } else if (appId.indexOf("$CC$$TS$") >= 0) {
                this.m_isJMSTopicCC = true;
            } else if (appId.indexOf("$NONDURABLE$") >= 0) {
                this.m_isJMSTopic = true;
            } else if (RouterManager.isRemoteNodeGSAppID(appId)) {
                this.m_isRemoteNode = true;
            }
            this.m_flowToDiskIsSupported = SessionConfig.isFlowToDiskSupported(appId);
        }
        this.m_outQueue = new ClientContextMgramQueue(this.m_delegator);
        this.m_msgRestorePos = new MsgRestorePos();
        this.m_remoteMsgRestorePos = new MsgRestorePos();
        if (Config.ENABLE_QOPSECURITY) {
            try {
                this.m_mp = AbstractCipherSuite.getNewMessageProtectionInstance();
            }
            catch (Exception e) {
                SessionConfig.logMessage(e, SessionConfig.getLevelSevere());
                throw new EAssertFailure(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setDelegator(IClientContextWrapper ccw) {
        IClientContext oldDelegator = this.m_delegator;
        this.m_delegator = ccw != null ? ccw : this;
        if (this.m_delegator == oldDelegator) {
            return;
        }
        if (this.m_outQueue != null) {
            this.m_outQueue.setCC(this.m_delegator);
        }
        if (this.m_ccSizeTracker != null) {
            this.m_ccSizeTracker.setCC(this.m_delegator);
        }
        SubscriptionsTable subscriptionsTable = this.m_subscriptions;
        synchronized (subscriptionsTable) {
            if (this.m_subscriptions != null) {
                Enumeration subs = this.m_subscriptions.elements();
                while (subs.hasMoreElements()) {
                    BrokerSubscription sub = (BrokerSubscription)subs.nextElement();
                    if (this.DEBUG) {
                        this.debug("Updating subsciption reference: " + sub + " to point to: " + this.m_delegator);
                    }
                    sub.setClient(this.m_delegator);
                }
            }
        }
    }

    @Override
    public IClientContextWrapper getDelegator() {
        return this.m_delegator == this ? null : (IClientContextWrapper)this.m_delegator;
    }

    @Override
    public boolean isConnected() {
        switch (this.m_state) {
            case -1: 
            case 0: {
                return false;
            }
            case 1: {
                return this.m_isResumable;
            }
        }
        return true;
    }

    @Override
    public boolean isActivelyConnected() {
        return this.m_state > 1;
    }

    @Override
    public int getState() {
        return this.m_state;
    }

    @Override
    public boolean isStarted() {
        return this.m_state == 8;
    }

    @Override
    public PublishLimiter getPublishLimiter() {
        return this.m_pubLimiter;
    }

    @Override
    public void setPublishLimiter(PublishLimiter pubLimiter) {
        this.m_pubLimiter = pubLimiter;
    }

    @Override
    public boolean isInterbroker() {
        return this.m_isInterbroker;
    }

    @Override
    public void setInterbroker(boolean val) {
        this.m_isInterbroker = false;
    }

    @Override
    public AgentConnection getConnection() {
        return this.m_connection;
    }

    @Override
    public boolean isRemoteBroker() {
        return this.m_isRemoteBroker;
    }

    @Override
    public boolean isJMSSession() {
        return this.m_isJMSSession;
    }

    @Override
    public boolean isJMSConnection() {
        return this.m_isJMSConnection;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public boolean isHTTPDirect() {
        return false;
    }

    @Override
    public boolean isRemoteNode() {
        return this.m_isRemoteNode;
    }

    @Override
    public boolean isJMSSubscriber() {
        return this.m_isJMSTopic || this.m_isJMSDurable;
    }

    @Override
    public String getTargetNodeName() {
        if (this.m_isRemoteNode) {
            return this.m_remoteNode;
        }
        return null;
    }

    @Override
    public String getNodeNameForRemoteBroker() {
        if (this.m_isRemoteBroker) {
            return s_reg.getRouterManager().getRemoteBroker(this.m_id).getNodeName();
        }
        return null;
    }

    @Override
    public IAgentQueue getLocalQueue() {
        if (this.m_isRemoteNode) {
            return s_reg.getQueueProc().getRoutingQueue();
        }
        return null;
    }

    @Override
    public String getLocalQueueName() {
        if (this.m_isRemoteNode) {
            AgentRoutingQueue iaq = s_reg.getQueueProc().getRoutingQueue();
            if (iaq != null) {
                return iaq.getQueueName();
            }
            return "SonicMQ.routingQueue";
        }
        return null;
    }

    @Override
    public boolean isQueueBrowser() {
        return this.m_isJMSQueueBrowser;
    }

    @Override
    public boolean isQueueReceiver() {
        return this.m_isJMSQueueReceiver;
    }

    @Override
    public void setRemoteBroker() {
        this.m_isRemoteBroker = true;
        this.m_preChecker = s_reg.getGSManager().getGSOrphanedMessageChecker();
        this.m_outQueue.setExpirePrecheck(this.m_preChecker);
        if (this.DEBUG) {
            this.debug(" is a RemoteBroker");
        }
    }

    @Override
    public boolean isDirty() {
        return this.m_dirty;
    }

    @Override
    public void setDirty(boolean d) {
        this.m_dirty = d;
    }

    @Override
    public Principal getPrincipal() {
        return this.m_secctx.getPrincipal();
    }

    @Override
    public ClientSecurityContext getCSC() {
        return this.m_secctx;
    }

    @Override
    public void setCSC(ClientSecurityContext csc) {
        this.m_secctx = csc;
    }

    @Override
    public IFlowController getFlowController() {
        return this.m_flowController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnregistered() {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_delegator.setState(-1);
            if (this.m_secctx != null) {
                String uid = this.retrieveUid();
                ClientContextTracker.getClientContextTracker().decreseClientContextUsageCount(uid);
            }
        }
        if (this.m_delegator.isGroupSubscriptionMember()) {
            this.m_groupSubCC.notifyGroup();
        }
    }

    @Override
    public void setRegistered() {
        if (this.m_secctx != null) {
            String uid = this.retrieveUid();
            ClientContextTracker.getClientContextTracker().increaseClientContextUsageCount(uid);
        }
        if ((this.m_isJMSTopic || this.m_isJMSTopicCC) && this.m_delegator.getCCSizeTracker() == null) {
            this.m_ccSizeTracker = new CCSizeTracker(this.m_delegator);
        }
    }

    private String retrieveUid() {
        String uid = this.m_secctx.getUid();
        return uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnregistered() {
        Object object = this.m_syncObj;
        synchronized (object) {
            return this.m_state == -1;
        }
    }

    @Override
    public boolean isDisconnected() {
        return !this.isConnected();
    }

    @Override
    public boolean isPendingReconnect() {
        return this.m_state == 1;
    }

    @Override
    public boolean isResumable() {
        return this.m_isResumable;
    }

    @Override
    public long getTimerId() {
        return this.m_disconnectTimerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSavesInProgress() {
        Object object = this.m_syncObj;
        synchronized (object) {
            return this.m_msgSavesInProgress;
        }
    }

    @Override
    public String getUid() {
        return this.m_secctx.getUid();
    }

    @Override
    public String getAppid() {
        return this.m_secctx.getAppid();
    }

    @Override
    public long getId() {
        return this.m_id;
    }

    public Long getIdAsLong() {
        return this.m_idAsLong;
    }

    @Override
    public int getDisconnectReason() {
        return this.m_disconnectReason;
    }

    @Override
    public void setDisconnectReason(int disconnectReason) {
        this.m_disconnectReason = disconnectReason;
    }

    @Override
    public void closeAgentConnection() {
        if (this.m_connection != null) {
            this.m_connection.close(this.getChannel());
        }
    }

    @Override
    public void killAgentConnection() {
        if (this.m_connection != null) {
            this.m_connection.kill(this.getChannel());
        }
    }

    @Override
    public String toString() {
        if (this.m_secctx != null) {
            return "BaseClientContext " + this.m_id + ":" + this.m_secctx.getUid() + ":" + this.m_secctx.getAppid();
        }
        return "BaseClientContext " + this.m_id;
    }

    private boolean maintainsPubDispatchCount() {
        return !this.m_delegator.isRemoteNode() && !this.m_delegator.isRemoteBroker();
    }

    @Override
    public final void notifyPubDispatch() {
        this.notifyPubDispatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyPubDispatch(int count) {
        if (!this.maintainsPubDispatchCount()) {
            return;
        }
        Object object = this.m_dispatchCountSyncObject;
        synchronized (object) {
            this.m_dispatchCount += count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoPubDispatch() {
        if (!this.maintainsPubDispatchCount()) {
            return;
        }
        Object object = this.m_dispatchCountSyncObject;
        synchronized (object) {
            int orig = this.m_dispatchCount--;
            if (this.m_dispatchCount < 0) {
                this.debugNegativeDispatchCount(orig, 1, null, null);
                this.m_dispatchCount = 0;
            }
            this.notifyDispatchCountSyncObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForPubDispatches() {
        boolean interrupted = false;
        if (!this.maintainsPubDispatchCount()) {
            return;
        }
        Object object = this.m_dispatchCountSyncObject;
        synchronized (object) {
            while (this.m_dispatchCount > 0) {
                try {
                    this.m_dispatchCountSyncObject.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForOffloadedMsgs(int timeout) throws InterruptedException {
        boolean moreMessages = true;
        Object object = this.m_syncObj;
        synchronized (object) {
            long start = System.currentTimeMillis();
            while (this.m_outQueue.getOffloadedPubSubQueue().isEmpty() || !this.okToRestoreOffloadedMessages() || this.m_offloadedMsgRestoreLock.isLocked()) {
                if (this.m_delegator.isGroupSubscription() && (this.m_groupOffloadCancelled || this.m_offloadedMsgRestorer == null || this.m_offloadedMsgRestorer.isRestorerExiting())) {
                    return false;
                }
                this.m_syncObj.wait(timeout);
                long now = System.currentTimeMillis();
                if (now - start < (long)timeout) continue;
                break;
            }
            if (this.m_delegator.isGroupSubscription() && (this.m_groupOffloadCancelled || this.m_offloadedMsgRestorer == null || this.m_offloadedMsgRestorer.isRestorerExiting())) {
                return false;
            }
            moreMessages = !this.m_outQueue.getOffloadedPubSubQueue().isEmpty() && this.okToRestoreOffloadedMessages();
        }
        return moreMessages;
    }

    @Override
    public final Object getSyncObj() {
        return this.m_syncObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        boolean interrupted = false;
        Object object = this.m_syncObj;
        synchronized (object) {
            Thread t = Thread.currentThread();
            if (this.m_lockHolder == t) {
                ++this.m_lockCount;
                return;
            }
            while (this.m_lockHolder != null) {
                try {
                    this.m_syncObj.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.m_lockHolder = t;
            this.m_lockCount = 1;
        }
        s_reg.lockContext();
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() throws IllegalMonitorStateException {
        boolean unlockRegistrarContext = false;
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.DEBUG) {
                this.debug(this.m_delegator + " unlock() called");
            }
            if (this.m_lockHolder == Thread.currentThread()) {
                if (--this.m_lockCount == 0) {
                    this.m_lockHolder = null;
                    unlockRegistrarContext = true;
                    this.m_syncObj.notifyAll();
                }
            } else {
                throw new IllegalMonitorStateException("ClientContext.unlock() without lock(), id " + this.m_id);
            }
        }
        if (unlockRegistrarContext) {
            s_reg.unlockContext();
        }
        if (this.DEBUG) {
            this.debug(this.m_delegator + " unlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock() {
        Object object = this.m_syncObj;
        synchronized (object) {
            Thread t = Thread.currentThread();
            if (this.m_lockHolder == t) {
                ++this.m_lockCount;
                return true;
            }
            if (this.m_lockHolder != null || !s_reg.tryLockContext()) {
                return false;
            }
            this.m_lockHolder = t;
            this.m_lockCount = 1;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int xOnceQSend(IMgram m, Label opts, boolean isTempQueue) {
        if (m.isJMSPersistent() && (this.m_delegator.isRemoteBroker() || this.m_delegator.isInterbroker() || this.m_delegator.isXOnce())) {
            if (this.DEBUG) {
                this.debug(this + ": in xOnceQSend(Mgram), persistent, " + m.getGuarenteedTrackingNum());
            }
            boolean deliverOnFlush = true;
            if (this.m_delegator.isXOnce() && !Config.XONCE_RECOVERY) {
                deliverOnFlush = false;
            }
            switch (this.m_delegator.getState()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 2: {
                    if (opts.isNonStop()) break;
                }
                default: {
                    if (this.DEBUG) {
                        this.debug(this + ": xonceQSend rejecting message guar= " + m.getGuarenteedTrackingNum() + " because cc state is: " + this.m_delegator.getState());
                    }
                    return 1;
                }
            }
            Vector vector = this.m_logMsgsExpectedIds;
            synchronized (vector) {
                if (!this.m_msgsToReenqueue.isEmpty()) {
                    if (this.DEBUG) {
                        this.debug(this + ": xonceQSend rejecting message guar= " + m.getGuarenteedTrackingNum() + " because we already have messages to reenqueue.");
                    }
                    return 1;
                }
                if (this.m_logMsgsExpectedIds.contains(new Long(m.getGuarenteedTrackingNum()))) {
                    if (this.DEBUG) {
                        this.debug("Queue message already expected from log flush thread: " + m.getGuarenteedTrackingNum() + " for " + this.m_delegator + "(XOCCW)");
                    }
                    return 0;
                }
                this.m_logMsgsExpectedIds.add(new Long(m.getGuarenteedTrackingNum()));
            }
            AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(m.getGuarenteedTrackingNum());
            if (tracker == null) {
                try {
                    tracker = new AgentQueueMsgTracker(m.getGuarenteedTrackingNum(), m.getBrokerHandle().getLocalQueueName(), m.getPriority(), m.getTTE(), m.getEnqueuedSize());
                }
                catch (EDuplicateKey eDuplicateKey) {
                    // empty catch block
                }
            }
            if (tracker == null) {
                throw new NullPointerException("AgentQueueMsgTracker tracker is null at " + this.getClass().getName() + ".xOnceQSend(IMgram m, Label opts, boolean isTempQueue)");
            }
            tracker.setReceiverId(this.m_delegator.getId());
            tracker.setReplicateOnly(m.isNonPersistentReplicated());
            QueueMsgSendEvt evt = new QueueMsgSendEvt(this.m_delegator, m.getGuarenteedTrackingNum(), m, isTempQueue, deliverOnFlush);
            if (deliverOnFlush) {
                s_reg.getLogManager().addEvent(evt, true);
            } else {
                s_reg.getLogManager().addEvent(evt, false);
                evt.deliverMsg();
            }
            return 0;
        }
        if (this.DEBUG) {
            this.debug("in send(Mgram), " + m.getGuarenteedTrackingNum() + " m_cc = " + this.m_delegator);
        }
        return this.m_delegator.send(m, opts);
    }

    @Override
    public boolean hasRoomForMgram(IMgram msg) {
        return this.m_outQueue.hasRoomForMgram(msg, msg.memoryLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int xOnceQSendFromLog(IMgram m, Label opts) {
        Vector vector = this.m_logMsgsExpectedIds;
        synchronized (vector) {
            this.m_logMsgsExpectedIds.remove(new Long(m.getGuarenteedTrackingNum()));
            if (this.m_logMsgsExpectedIds.isEmpty()) {
                this.m_logMsgsExpectedIds.notifyAll();
            }
            int status = 1;
            if (!this.m_msgsToReenqueue.isEmpty()) {
                if (this.DEBUG) {
                    this.debug(this + ": Adding new message to log msg reenqueue list. guar = " + m.getGuarenteedTrackingNum());
                }
                this.m_msgsToReenqueue.add(m);
                status = 1;
            } else {
                status = this.m_delegator.send(m, opts);
                switch (status) {
                    case 0: 
                    case 2: {
                        break;
                    }
                    default: {
                        this.m_msgsToReenqueue.add(m);
                        status = 1;
                    }
                }
            }
            if (!this.m_logMsgsExpectedIds.isEmpty()) {
                return 0;
            }
            if (!this.m_msgsToReenqueue.isEmpty()) {
                return 1;
            }
            return status;
        }
    }

    @Override
    public final int send(IMgram mg, Label opts) {
        if (this.m_isRemoteNode) {
            throw new EAssertFailure(this.m_delegator + ": send(IMgram, Label) called for remote node CC");
        }
        return this.m_delegator.send(mg, opts, null);
    }

    @Override
    public int send(IMgram mg, Label opts, PublishLimiter pubLimiter) {
        if (this.m_isRemoteNode) {
            throw new EAssertFailure(this.m_delegator + ": send(IMgram, Label, PublishLimiter) called for remote node CC");
        }
        boolean qMsg = mg.isQueueMessage();
        int retval = 0;
        boolean canDelay = false;
        if (qMsg) {
            retval = this.sendQmsg(mg, opts, pubLimiter);
        } else {
            retval = this.sendInternal(mg, opts, pubLimiter, false, null);
            if (!(mg.isGuarenteed() || mg.isRequest() || mg.isReply() || mg.getPriority() > 9)) {
                canDelay = true;
            }
        }
        this.informAgentSender(canDelay);
        try {
            if (!s_logmgr.isEventPostProcessorThread(Thread.currentThread())) {
                this.m_delegator.processExpiredMsgs();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enqueueOffloaded(IMgram message, long msgSaverOpIndx) {
        int size = 0;
        if (this.m_groupSubCC != null) {
            Object object = this.m_syncObj;
            synchronized (object) {
                --this.m_msgsToBeAddedToOffloadedQueue;
            }
            return this.m_groupSubCC.enqueueOffloaded(message, msgSaverOpIndx);
        }
        Object object = this.m_syncObj;
        synchronized (object) {
            --this.m_msgsToBeAddedToOffloadedQueue;
            if (!this.m_delegator.okToOffloadMessages()) {
                this.m_delegator.checkFTDNotifyEventRequired(false);
                return 0;
            }
            size = this.m_outQueue.getOffloadedPubSubQueue().enqueue(message, msgSaverOpIndx);
            this.startOffloadedMsgRestorer();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startOffloadedMsgRestorer() {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.okToRestoreOffloadedMessages()) {
                this.checkAndReplaceThread();
                if (this.m_offloadedMsgRestorer == null) {
                    this.m_offloadedMsgRestorer = new OffloadedMsgRestorer(this.m_delegator, s_reg.getMsgSaver());
                    this.m_offloadedMsgRestorer.start();
                    this.m_groupOffloadCancelled = false;
                }
                this.m_syncObj.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OffloadedPubSubMessage dequeueOffloaded() {
        OffloadedPubSubMessage offloadedMsg = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            offloadedMsg = this.m_outQueue.getOffloadedPubSubQueue().dequeue();
            if (offloadedMsg == null) {
                this.m_delegator.checkFTDNotifyEventRequired(false);
            }
            if (this.m_outQueue.getOffloadedPubSubQueue().isEmpty()) {
                this.m_syncObj.notifyAll();
            }
        }
        return offloadedMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int completeOffloadedMessageRestore(OffloadedPubSubMessage offloadedMsg) {
        Object object = this.m_syncObj;
        synchronized (object) {
            return this.m_outQueue.getOffloadedPubSubQueue().completeMessageRestore(offloadedMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClientContext.MsgInfo retrieveBatch(long batchId) {
        Map map = this.m_batchIDTable;
        synchronized (map) {
            IClientContext.MsgInfo result = (IClientContext.MsgInfo)this.m_batchIDTable.remove(new Long(batchId));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int batch(IMgram m, Label opts, PublishLimiter pubLimiter) {
        if (this.m_delegator.isRemoteNode() || this.m_delegator.isRemoteBroker() || this.m_delegator.isInterbroker()) {
            return this.m_delegator.send(m, opts, pubLimiter);
        }
        long batchId = m.getBrokerHandle().getBatchId();
        if (batchId != -1L) {
            Map map = this.m_batchIDTable;
            synchronized (map) {
                Long longBatchId = new Long(batchId);
                IClientContext.MsgInfo info = (IClientContext.MsgInfo)this.m_batchIDTable.get(longBatchId);
                if (info == null) {
                    info = new IClientContext.MsgInfo();
                    info.m_mgram = MgramFactory.getMgramFactory().buildBatchMgram(m);
                    info.m_mgram.getBatchHandle().setAtomic(false);
                    info.m_opts = opts;
                    info.m_pubLimiter = pubLimiter;
                    if (m.isGuarenteed()) {
                        info.m_mgram.setGuarenteed(s_reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL);
                    }
                    this.m_batchIDTable.put(new Long(batchId), info);
                } else {
                    info.m_mgram.getOperationHandle().addMgram(m);
                }
            }
        } else {
            return this.m_delegator.send(m, opts, pubLimiter);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processExpiredMsgs() throws InterruptedException {
        Vector expiredMsgs = null;
        Vector tempExpiredMsgs = null;
        Vector vector = expiredMsgs = this.m_outQueue.getExpiredMsgs();
        synchronized (vector) {
            if (!expiredMsgs.isEmpty()) {
                tempExpiredMsgs = (Vector)expiredMsgs.clone();
                expiredMsgs.removeAllElements();
            }
        }
        if (tempExpiredMsgs != null) {
            this.m_delegator.handleExpiredMsgs(tempExpiredMsgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendQmsg(IMgram m, Label opts, PublishLimiter pubLimiter) {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (m == null) {
                return 2;
            }
            if (this.DEBUG) {
                this.debug(this.m_delegator + "got queue message to " + (m.isSecure() ? m.getBrokerHandle().getLocalQueueName() : m.getSubject().toString()));
            }
            try {
                switch (this.m_state) {
                    case -1: 
                    case 0: {
                        if (this.DEBUG) {
                            this.debug(this.m_delegator + " DISCONNECTED or UNREGISTERED - rejecting the sent queue message");
                        }
                        return 1;
                    }
                    case 1: 
                    case 2: {
                        if (this.DEBUG) {
                            this.debug(this.m_delegator + " STOPPED or PENDING_RECONNECT - rejecting the sent queue message");
                        }
                        if (opts.isNonStop()) {
                            this.m_outQueue.enqueue(m, pubLimiter);
                            break;
                        }
                        return 1;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        if (this.DEBUG) {
                            this.debug(this.m_delegator + " STARTED - sending the queue message to out queue");
                        }
                        this.m_outQueue.enqueue(m, pubLimiter);
                        break;
                    }
                    default: {
                        throw new EAssertFailure(this.m_delegator + ": invalid state in send(): " + this.m_state);
                    }
                }
                if (this.DEBUG) {
                    this.debug(this.m_delegator + " accepted mgram" + (m.isSecure() ? m.getBrokerHandle().getLocalQueueName() : " to " + m.getSubject().toString()));
                }
                return 0;
            }
            catch (EDuplicateKey e) {
                EAssertFailure t = new EAssertFailure(this.m_delegator + ": duplicate tracking number: " + m.getGuarenteedTrackingNum(), e);
                BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
                return 2;
            }
        }
    }

    @Override
    public int canBeSent(IMgram m, Label opts, PublishLimiter pubLimiter) {
        return this.sendInternal(m, opts, pubLimiter, true, null);
    }

    /*
     * Exception decompiling
     */
    private int sendInternal(IMgram m, Label opts, PublishLimiter pubLimiter, boolean checkRoomOnly, GroupMsgAllocationEvt xoGroupEvt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK]], but top level block is 112[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Integer verifyAndNotifySave(int ret, IMgram m) {
        if (ret != 0) {
            if (ret == 4) {
                this.setDbTracking(m);
                this.m_delegator.notifySave(m, false);
                ++this.m_msgsToBeAddedToOffloadedQueue;
                this.m_delegator.checkFTDNotifyEventRequired(true);
            }
            return ret;
        }
        return null;
    }

    private void delegatorNotifySave(boolean checkRoomOnly, IMgram m) {
        if (!checkRoomOnly) {
            this.m_delegator.notifySave(m, false);
        }
    }

    private int debugInitRestoreDiscardingMgram() {
        if (this.DEBUG) {
            this.debug("INIT_RESTORE - discarding mgram");
        }
        return 2;
    }

    private int debugStoppedDiscardingMgram() {
        if (this.DEBUG) {
            this.debug("STOPPED - discarding mgram");
        }
        return 2;
    }

    private int debugFinalRestoreDiscardingMgram() {
        if (this.DEBUG) {
            this.debug("FINAL_RESTORE - discarding mgram");
        }
        return 2;
    }

    private void notifyDispatchCountSyncObject() {
        if (this.m_dispatchCount == 0) {
            this.m_dispatchCountSyncObject.notifyAll();
        }
    }

    private void updateInitRestorePubCount(IMgram m, PublishLimiter pubLimiter) {
        if (m.getType() != 27) {
            s_initRestoreFC.updatePubCount(this.m_delegator, pubLimiter, 1);
        } else {
            s_initRestoreFC.updatePubCount(this.m_delegator, pubLimiter, m.getBatchHandle().getBatchSize());
        }
    }

    private int performInterbrokerDelivery(IMgram m, PublishLimiter pubLimiter, boolean checkRoomOnly, GroupMsgAllocationEvt xoGroupEvt) throws EDuplicateKey {
        IMgram subMgram;
        boolean isBatchAtomic = false;
        boolean isLB = false;
        boolean isBatch = false;
        if (m.getType() == 27) {
            isBatchAtomic = m.getBatchHandle().isAtomic();
            isBatch = true;
        } else if (m.getType() == 25 && (m.getOperationHandle().getOperationType() == 14 || m.getOperationHandle().getOperationType() == 13) && (subMgram = (IMgram)m.getOperationHandle().getMgramList().get(0)).getType() == 27) {
            isBatchAtomic = subMgram.getBatchHandle().isAtomic();
            isLB = true;
            isBatch = true;
        }
        if (xoGroupEvt != null) {
            if (isBatch && this.DEBUG_UNEXPECTED) {
                this.debug("Unexpected xo group batch send: " + MgramTrace.diagnosticString(m));
            }
            return this.m_outQueue.enqueueXOnceGroupMessage(m, pubLimiter, null, xoGroupEvt);
        }
        if (isBatch && !isBatchAtomic) {
            IMgram batchMgram = null;
            batchMgram = isLB ? (IMgram)m.getOperationHandle().getMgramList().get(0) : m;
            Iterator iter = batchMgram.getBatchHandle().getBatchIterator();
            while (iter.hasNext()) {
                int res;
                IMgram result = null;
                if (isLB) {
                    IMgram subMgram2 = (IMgram)iter.next();
                    result = MgramFactory.getMgramFactory().buildLBSTargetMessage(subMgram2, m.getOperationHandle().getOperationType(), m.getRawBody(), m.getBodyLength());
                    long gscc = m.getBrokerHandle().getGroupSubscriptionCC();
                    if (gscc != -1L) {
                        result.getBrokerHandle().setGroupSubscriptionCC(gscc);
                    }
                    result.getOperationHandle().setOperationType(m.getOperationHandle().getOperationType());
                    if (m.isGuarenteed()) {
                        result.setGuarenteed(s_reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL);
                    }
                    result.setRouteLimit(m.getRouteLimit());
                } else {
                    result = (IMgram)iter.next();
                }
                if ((res = this.m_outQueue.enqueueOrOffload(result, pubLimiter, null, checkRoomOnly)) == 0) continue;
                return res;
            }
        } else {
            return this.m_outQueue.enqueueOrOffload(m, pubLimiter, null, checkRoomOnly);
        }
        return 0;
    }

    protected void setDbTracking(IMgram msg) {
        boolean needsDbTracking = false;
        boolean needsSubjectTracking = false;
        int trackingNumbersNeeded = 0;
        if (msg.getType() != 27) {
            needsDbTracking = !msg.getBrokerHandle().isDbTrackingSet();
            needsSubjectTracking = this.checkSubject(msg);
            trackingNumbersNeeded = this.incrementTrackingNumbersNeeded(needsDbTracking, trackingNumbersNeeded, needsSubjectTracking, msg);
            long logSeqNo = this.populateTrackingNumbers(trackingNumbersNeeded, needsDbTracking, msg, needsSubjectTracking);
        } else {
            Iterator iter = msg.getBatchHandle().getBatchIterator();
            IMgram subMgram = null;
            while (iter.hasNext()) {
                trackingNumbersNeeded = 0;
                subMgram = (IMgram)iter.next();
                needsDbTracking = !subMgram.getBrokerHandle().isDbTrackingSet();
                needsSubjectTracking = this.checkSubject(subMgram);
                trackingNumbersNeeded = this.incrementTrackingNumbersNeeded(needsDbTracking, trackingNumbersNeeded, needsSubjectTracking, msg);
                long logSeqNo = this.populateTrackingNumbers(trackingNumbersNeeded, needsDbTracking, subMgram, needsSubjectTracking);
            }
        }
    }

    private boolean checkSubject(IMgram subMgram) {
        return subMgram.hasSubject() && subMgram.getSubject().isMultiSubject() && !subMgram.getSubject().hasSubjectTracking();
    }

    private int incrementTrackingNumbersNeeded(boolean needsDbTracking, int trackingNumbersNeededParam, boolean needsSubjectTracking, IMgram msg) {
        int trackingNumbersNeeded = trackingNumbersNeededParam;
        if (needsDbTracking) {
            ++trackingNumbersNeeded;
        }
        if (needsSubjectTracking) {
            trackingNumbersNeeded += msg.getSubject().getMultiSubjectCount();
        }
        return trackingNumbersNeeded;
    }

    private long populateTrackingNumbers(int trackingNumbersNeeded, boolean needsDbTracking, IMgram subMgram, boolean needsSubjectTracking) {
        long logSeqNo = 0L;
        if (trackingNumbersNeeded > 0) {
            logSeqNo = s_reg.getLogManager().allocMultipleSeqNos(trackingNumbersNeeded);
            if (needsDbTracking) {
                subMgram.getBrokerHandle().setDbTracking(logSeqNo & 0xFFFFFFFFFFFFL);
            }
            if (needsSubjectTracking) {
                subMgram.getBrokerHandle().assignSubjectTrackingNumbers(logSeqNo & 0xFFFFFFFFFFFFL);
            }
        }
        return logSeqNo;
    }

    @Override
    public void sendPriorityPush(IMgram m, int prio, int pushPrio) {
        this.m_outQueue.enqueuePriorityPush(m, prio, pushPrio);
        this.informAgentSender();
    }

    @Override
    public void sendThrough(IMgram mg) {
        if (this.m_isRemoteNode) {
            throw new EAssertFailure(this.m_delegator + ": sendThrough(IMgram) called for remote node CC");
        }
        this.sendInternal(mg);
        this.informAgentSender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendInternal(IMgram im) {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (!this.m_delegator.isActivelyConnected()) {
                return;
            }
            this.m_outQueue.enqueue(im);
        }
    }

    @Override
    public boolean okToOffloadMessages() {
        int state = this.m_state;
        return state == 8 || state == 7 || state == 5 || state == 4;
    }

    private boolean okToRestoreOffloadedMessages() {
        int state = this.m_state;
        return state == 8 || state == 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean okToUnregister() {
        Object object = this.m_syncObj;
        synchronized (object) {
            boolean okToUnreg;
            boolean bl = okToUnreg = this.m_state == 0 && this.m_subscriptions.isEmpty() && this.m_expiredMsgsPendingCount == 0 && !s_txnmgr.isParticipantOfTxn(this.m_id);
            if (okToUnreg && s_reg.getQueueProc() != null) {
                if (this.DEBUG) {
                    this.debug("-------> About to Unregister; Restoring pending queue messages " + this.m_delegator);
                }
                this.m_outQueue.restorePendingQmsgs();
                s_reg.getQueueProc().disconnectClient(this.m_id);
            }
            return okToUnreg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePublishersBlockedOnDbSpace() {
        boolean releasePublishers = false;
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_subscriptions.isEmpty()) {
                releasePublishers = true;
                this.m_outQueue.dbSpaceReleaseBlockedPublishers();
            }
        }
        if (releasePublishers) {
            s_reg.getBrokerDatabase().releaseClientBlockedOnDbSpace(this.m_delegator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dbSpaceFlowControlPublisher(PublishLimiter pubLimiter) {
        IClientContext publisher;
        if (pubLimiter != null && (publisher = pubLimiter.getPublisherCC()) != null) {
            Object object = this.m_syncObj;
            synchronized (object) {
                if (!(BrokerComponent.isManagementAppId(publisher.getAppid()) || this.m_delegator.okToOffloadMessages() && this.m_outQueue.getOffloadedPubSubQueue().isEmpty(publisher.getId()))) {
                    this.m_outQueue.dbSpaceFlowControlPublisher(pubLimiter);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flowToDiskFlowControlPublisher(PublishLimiter pubLimiter) {
        IClientContext publisher;
        if (pubLimiter != null && (publisher = pubLimiter.getPublisherCC()) != null) {
            Object object = this.m_syncObj;
            synchronized (object) {
                if (!BrokerComponent.isManagementAppId(publisher.getAppid()) && this.m_delegator.okToOffloadMessages() && !this.m_outQueue.getOffloadedPubSubQueue().isEmpty(publisher.getId())) {
                    this.m_outQueue.flowToDiskFlowControlPublisher(pubLimiter);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int msgSaveDone(IMgram message, boolean postponedSave) {
        if (this.m_delegator.isGroupSubscriptionMember() || message.getBrokerHandle().getGroupSubscriptionCC() != -1L && !this.m_delegator.isGroupSubscription()) {
            return this.m_msgSavesInProgress;
        }
        boolean forRemoteBroker = InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(message.getBrokerHandle().getSenderID());
        Object object = this.m_syncObj;
        synchronized (object) {
            if (postponedSave) {
                --this.m_msgPostponedSavesInProgress;
            }
            if (forRemoteBroker && this.m_delegator.isDurable()) {
                --this.m_msgSavesForRemoteBrokerInProgress;
            }
            if (this.m_msgSavesBeforeWaitQueueInProgress > 0) {
                int state = this.m_state;
                boolean relevant = false;
                if (state == 7) {
                    --this.m_msgSavesBeforeWaitQueueInProgress;
                    relevant = true;
                } else if (state == 4 && forRemoteBroker) {
                    --this.m_msgSavesBeforeWaitQueueInProgress;
                    relevant = true;
                }
                if (relevant) {
                    long seqNo = -1L;
                    if (message.getType() != 27) {
                        seqNo = message.getBrokerHandle().getSequenceNumber();
                    } else {
                        IMgram lastSubMgram = (IMgram)message.getOperationHandle().getMgramList().getLast();
                        seqNo = lastSubMgram.getBrokerHandle().getSequenceNumber();
                    }
                    this.m_maxSeqNoSavedBeforeWaitQueue = Math.max(this.m_maxSeqNoSavedBeforeWaitQueue, seqNo);
                }
                if (this.m_msgSavesBeforeWaitQueueInProgress == 0 && (state == 7 || state == 4) && this.m_msgRestorer != null) {
                    this.m_msgRestorer.setMaxDBSequenceNumber(this.m_maxSeqNoSavedBeforeWaitQueue);
                    this.m_maxSeqNoSavedBeforeWaitQueue = -1L;
                }
            }
            --this.m_msgSavesInProgress;
            this.m_syncObj.notifyAll();
            if (this.m_msgSavesInProgress < 0) {
                throw new EAssertFailure(this.m_delegator + ": Negative message save count");
            }
            return this.m_msgSavesInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitToStartRestore() throws InterruptedException {
        this.recheckPendingReconnectGuars();
        Object object = this.m_syncObj;
        synchronized (object) {
            this.waitForPostponedMessageSaves();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recheckPendingReconnectGuars() {
        Iterator prgList = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_outQueue.getPendingReconnectCount() == 0) {
                return;
            }
            ArrayList list = new ArrayList(this.m_outQueue.getPendingReconnectCount());
            Iterator i = this.m_outQueue.getPendingReconnectGuars();
            while (i.hasNext()) {
                list.add(i.next());
            }
            prgList = list.iterator();
        }
        Iterator i = prgList;
        while (i.hasNext()) {
            IMgram m = (IMgram)i.next();
            if (this.m_delegator.recheckRestoredMgram(m)) continue;
            Object object2 = this.m_syncObj;
            synchronized (object2) {
                this.m_outQueue.removePendingReconnectGuar(m.getGuarenteedTrackingNum());
            }
        }
    }

    @Override
    public void waitToStartFinalRestore() throws InterruptedException {
        this.waitForPendingBeforeWaitQueueMessageSaves();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitToStartFinalRemoteRestore() throws InterruptedException {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.waitForPendingBeforeWaitQueueMessageSaves();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPendingBeforeWaitQueueMessageSaves() throws InterruptedException {
        Object object = this.m_syncObj;
        synchronized (object) {
            while (this.m_msgSavesBeforeWaitQueueInProgress > 0) {
                this.m_syncObj.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPostponedMessageSaves() throws InterruptedException {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.DEBUG_UNEXPECTED && this.m_msgPostponedSavesInProgress > 0) {
                this.debug("waitForPostponedMessageSaves: count= " + this.m_msgPostponedSavesInProgress + " cc= " + this.m_delegator);
            }
            while (this.m_msgPostponedSavesInProgress > 0) {
                this.m_syncObj.wait();
            }
        }
    }

    @Override
    public synchronized long getPostponedMessageSaves() {
        return this.m_msgPostponedSavesInProgress;
    }

    @Override
    public void deletingAllMsgs(long maxMessageId) {
        this.m_maxDeletedMsgId = maxMessageId;
        this.m_msgRestorePos.reset();
        this.m_remoteMsgRestorePos.reset();
        this.m_msgRestorePos.update(this.m_maxDeletedMsgId, this.m_msgRestorePos.getSeqno());
        this.m_remoteMsgRestorePos.update(this.m_maxDeletedMsgId, this.m_remoteMsgRestorePos.getSeqno());
    }

    @Override
    public long maxDeletedMsgId() {
        return this.m_maxDeletedMsgId;
    }

    @Override
    public boolean preparedToSend(long dispatchId) {
        return this.m_mergeTable.containsKey(dispatchId);
    }

    @Override
    public final boolean prepareToSend(IMgram mg, Label label, boolean targeted, long dispatchId, ISubject matchSubject) {
        ISubject subject = mg.getSubject();
        MergeScratchPad msp = (MergeScratchPad)this.m_mergeTable.get(dispatchId);
        boolean merge = true;
        boolean checkPermission = false;
        if (msp == null) {
            msp = new MergeScratchPad();
            merge = false;
            if (subject.isMultiSubject()) {
                msp.m_subjectFilter = new HashSet();
            }
            checkPermission = Config.ENABLE_SECURITY;
        } else if (Config.ENABLE_SECURITY && subject.isMultiSubject() && !msp.m_subjectFilter.contains(matchSubject)) {
            checkPermission = true;
        }
        if (checkPermission) {
            Principal principal = null;
            if (this.m_remoteNode != null) {
                principal = s_reg.getGSManager().getRemoteNodePrincipal(this.m_remoteNode);
                if (principal == null) {
                    return false;
                }
            } else {
                principal = this.m_secctx.getPrincipal();
                if (principal == null) {
                    EAssertFailure t = new EAssertFailure("Null principal for client " + this.m_secctx.getUid());
                    BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
                    return false;
                }
            }
            if (!Authorize.checkPermission(principal, matchSubject, 2)) {
                if (this.DEBUG) {
                    this.debug("Subscribe not allowed on: " + matchSubject);
                }
                return false;
            }
        }
        if (!merge) {
            msp.m_nextMsgGuarState = label.isGuaranteed() ? 2 : (label.isPersistent() ? 1 : 0);
            msp.m_nextMsgNonStop = label.isNonStop() ? 1 : 0;
            this.m_mergeTable.put(dispatchId, msp);
        } else {
            if (msp.m_nextMsgNonStop == 0 && label.isNonStop()) {
                msp.m_nextMsgNonStop = 1;
            }
            if (msp.m_nextMsgGuarState < 2 && label.isGuaranteed()) {
                msp.m_nextMsgGuarState = 2;
            }
            if (msp.m_nextMsgGuarState == 0 && !label.isGuaranteed() && label.isPersistent()) {
                msp.m_nextMsgGuarState = 1;
            }
        }
        if (subject.isMultiSubject()) {
            msp.m_subjectFilter.add(matchSubject);
        }
        return !merge;
    }

    @Override
    public final MergeScratchPad getMergeScratchPad(long dispatchId) {
        MergeScratchPad msp = (MergeScratchPad)this.m_mergeTable.remove(dispatchId);
        if (msp != null) {
            msp.m_deliveryLabel = s_mergeLabels[msp.m_nextMsgNonStop][msp.m_nextMsgGuarState];
            return msp;
        }
        throw new EAssertFailure(this + ": Merged delivery label not found!");
    }

    @Override
    public ClientContextMgramQueue getOutQueue() {
        return this.m_outQueue;
    }

    @Override
    public IMgram getPendingGuar(long tracking) {
        return this.m_outQueue.getPendingGuar(tracking);
    }

    @Override
    public boolean addRestoredMgram(IMgram mParam, boolean durableSMORestore, boolean fromRemoteBroker) throws EDuplicateKey, InterruptedException {
        IMgram m;
        IMgram mgToSend = m = mParam;
        boolean fromdb = m.getBrokerHandle().isFromDB();
        if (!this.m_delegator.isInterbroker()) {
            m = MsgSaver.removeLBSWrapper(m);
        }
        if (mgToSend.isSecure()) {
            try {
                if (SecurityLogic.isMKeyMacHeader(mgToSend.getSecurity()) && fromdb) {
                    mgToSend.getBrokerHandle().macHeaderWithMessageKey(this.m_mp);
                }
            }
            catch (ESecurityGeneralException e) {
                throw new EAssertFailure("Caught ESecurityGeneralException while remac'ing the header", e);
            }
        }
        boolean retval = this.addRestoredMgramInternal(mgToSend, durableSMORestore, fromRemoteBroker);
        this.informAgentSender();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addRestoredMgramInternal(IMgram msgParam, boolean durableSMORestore, boolean fromRemoteBroker) throws EDuplicateKey, InterruptedException {
        boolean bl;
        boolean isDNR;
        IMgram msg = msgParam;
        try {
            this.freezeProxy();
            if (!this.m_delegator.waitForRestoreSpace(msg)) {
                boolean bl2 = false;
                this.unfreezeProxy();
                return bl2;
            }
            Object object = this.m_syncObj;
            synchronized (object) {
                if (!this.checkRestoringState()) {
                    boolean bl3 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 17, 6] lbl12 : MonitorExitStatement: MONITOREXIT : var5_6
                    this.unfreezeProxy();
                    return bl3;
                }
                IXOnceHandle xoh = this.m_delegator.getXOnceHandle();
                isDNR = false;
                if (xoh != null) {
                    isDNR = xoh.isDNR(msg);
                }
                if (!this.DEBUG) break block19;
            }
        }
        catch (Throwable throwable) {
            this.unfreezeProxy();
            throw throwable;
        }
        {
            block19: {
                this.debug(this + ": Restoring " + msg.getGuarenteedTrackingNum() + " from db");
            }
            boolean onlyReleaseRemoteMsgs = false;
            switch (this.m_state) {
                case 3: 
                case 4: {
                    onlyReleaseRemoteMsgs = true;
                    break;
                }
            }
            if (!(isDNR || msg.isGuarenteed() && msg.getType() != 27 && !this.m_restoringOffloaded && this.releasePendingReconnectGuars(msg, onlyReleaseRemoteMsgs) || this.sendRestored(msg = this.m_delegator.getGuarDoubtManager().makeSuccessorClone(msg)))) {
                boolean bl4 = false;
                // MONITOREXIT @DISABLED, blocks:[6, 15] lbl29 : MonitorExitStatement: MONITOREXIT : var5_6
                this.unfreezeProxy();
                return bl4;
            }
            if (this.DEBUG) {
                this.debug("Restore updated durableSMORestore: " + durableSMORestore + "fromRemoteBroker: " + fromRemoteBroker + " msg.getID(): " + msg.getID());
            }
            if (!this.m_restoringOffloaded) {
                if (!durableSMORestore || durableSMORestore && !fromRemoteBroker) {
                    this.m_msgRestorePos.update(msg);
                } else {
                    this.m_remoteMsgRestorePos.update(msg);
                }
            }
            bl = true;
        }
        this.unfreezeProxy();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean waitForRestoreSpace(IMgram m) throws InterruptedException {
        Object object = this.m_syncObj;
        synchronized (object) {
            try {
                while (!this.m_outQueue.hasRoomForMgram(m, m.getLimiterSize())) {
                    if (!this.checkRestoringState()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.m_waitingForRestoreSpace = true;
                    this.m_syncObj.wait();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.m_waitingForRestoreSpace = false;
            }
        }
    }

    @Override
    public final boolean checkRestoringState() {
        if (this.m_restoringOffloaded) {
            switch (this.m_state) {
                case 5: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        switch (this.m_state) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void releasePendingReconnectGuars(boolean onlyFromRemote) {
        ICCGuarDoubtManager dm = this.m_delegator.getGuarDoubtManager();
        boolean releasedSome = false;
        Iterator msgs = null;
        msgs = !onlyFromRemote ? this.m_outQueue.clearPendingReconnectGuars().values().iterator() : this.m_outQueue.getPendingReconnectGuars();
        while (msgs.hasNext()) {
            IMgram m = (IMgram)msgs.next();
            if (onlyFromRemote && !m.getBrokerHandle().isFromRemoteBroker()) {
                if (!this.DEBUG) continue;
                this.debug(this + ": Skipping release of non remote message during full release: " + m.getGuarenteedTrackingNum());
                continue;
            }
            try {
                if (this.DEBUG) {
                    this.debug(this + ":" + m.getGuarenteedTrackingNum() + " Released from PRQ, succ=" + m.isSuccessor());
                }
                m = dm.makeSuccessorClone(m);
                this.m_outQueue.enqueueRestored(m);
                releasedSome = true;
            }
            catch (EDuplicateKey eDuplicateKey) {
                // empty catch block
            }
            msgs.remove();
        }
        if (releasedSome) {
            this.informAgentSender();
        }
    }

    private boolean releasePendingReconnectGuars(IMgram msg, boolean onlyFromRemote) {
        IMgram m;
        long maxTracking = msg.getGuarenteedTrackingNum();
        boolean trackingFound = false;
        boolean restore = false;
        ICCGuarDoubtManager dm = this.m_delegator.getGuarDoubtManager();
        Iterator msgs = this.m_outQueue.getPendingReconnectGuars();
        while (msgs.hasNext() && (m = (IMgram)msgs.next()).getGuarenteedTrackingNum() <= maxTracking) {
            if (onlyFromRemote && !m.getBrokerHandle().isFromRemoteBroker()) {
                if (!this.DEBUG) continue;
                this.debug(this + ": Skipping release of non remote message: " + m.getGuarenteedTrackingNum());
                continue;
            }
            int size = m.getLimiterSize();
            byte prio = m.getPriority();
            if (this.DEBUG) {
                this.debug(this + ":" + m.getGuarenteedTrackingNum() + " Released from PRQ");
            }
            restore = true;
            if (m.getType() != 27) {
                if (m.getGuarenteedTrackingNum() == maxTracking) {
                    trackingFound = true;
                }
            } else {
                long batchTracking = m.getGuarenteedTrackingNum();
                if (maxTracking > batchTracking && maxTracking <= batchTracking + (long)m.getBatchHandle().getBatchSize()) {
                    trackingFound = true;
                    if (maxTracking < batchTracking + (long)m.getBatchHandle().getBatchSize()) {
                        restore = false;
                    }
                }
            }
            if (!restore) continue;
            if (trackingFound && m.getType() != 27) {
                msg.getBrokerHandle().setLogEvent(m.getBrokerHandle().getLogEvent());
                m = msg;
            }
            m = dm.makeSuccessorClone(m);
            try {
                if (!this.sendRestored(m)) {
                    return false;
                }
            }
            catch (EDuplicateKey batchTracking) {
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
            msgs.remove();
            this.m_outQueue.freePendingReconnectSpace(size, prio);
        }
        return trackingFound;
    }

    private final boolean sendRestored(IMgram msg) throws EDuplicateKey, InterruptedException {
        if (msg.isGuarenteed() && msg.getType() != 27) {
            if (this.m_delegator.getGuarDoubtManager().wasMessageAcknowledged(msg.getGuarenteedTrackingNum())) {
                return true;
            }
            if (msg.hasSubject() && msg.getSubject().isMultiSubject()) {
                this.m_delegator.getGuarDoubtManager().filterAckedSubjectTrackings(msg);
            }
        }
        if (this.m_delegator.getProxyingHandle() == null || !this.m_delegator.getProxyingHandle().forwardRestored(msg)) {
            IClientContext proxy;
            if (this.DEBUG) {
                this.debug("restored message " + msg.getGuarenteedTrackingNum());
            }
            if (!this.checkRestoringState()) {
                return false;
            }
            if (this.m_delegator.getProxyingHandle() != null && (proxy = this.m_delegator.getCWADSActiveBroker()) != null && proxy.getProxyHandle() != null && (proxy.isDisconnecting() || !proxy.isConnected())) {
                return false;
            }
            this.m_outQueue.enqueueRestored(msg);
            this.informAgentSender();
            if (this.DEBUG) {
                this.debug("\nCWADS_DEBUG --- " + this.getAppid() + " enqueued restored mgram ******* " + msg);
            }
        }
        if (!this.m_restoringOffloaded && Config.THROTTLE_PUBS_DURING_RESTORE && this.m_state == 6) {
            s_initRestoreFC.updateSubCount(this.m_delegator);
        }
        return true;
    }

    @Override
    public final void acknowledge(IMgram ack) throws InterruptedException {
        try {
            this.m_delegator.acknowledge(ack.getAckHandle().getTrackingNumber(), false, ack, null);
        }
        catch (IndexOutOfBoundsException e) {
            BrokerComponent.getComponentContext().logMessage(this.m_delegator + prAccessor.getString("STR061"), (Throwable)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMgram getPendingQMessage(long tracking) {
        Object object = this.m_syncObj;
        synchronized (object) {
            return this.m_outQueue.getPendingQmsg(tracking);
        }
    }

    @Override
    public IClientContext redirectAckForward(long clientID) {
        if (clientID != -1L && this.m_id != clientID) {
            try {
                return s_reg.getClient(clientID);
            }
            catch (EClientNotRegistered e) {
                return null;
            }
        }
        return this.m_delegator;
    }

    @Override
    public void txnAcknowledge(long tracking, IMgram ack) throws InterruptedException {
        this.m_delegator.acknowledge(tracking, true, ack, null);
    }

    @Override
    public void addLegacySubjectAckMapping(long newTracking, long mgramTracking) {
        if (this.DEBUG) {
            this.debug(this.m_secctx.getAppid() + ":Adding Legacy Subject Ack: " + newTracking + " -> " + mgramTracking);
        }
        this.m_legacySubjectTrackingMap.put(newTracking, new Long(mgramTracking));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLegacySubjectAckMappings(LongHashTable mappings) {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_legacySubjectTrackingMap.isEmpty()) {
                this.m_legacySubjectTrackingMap = mappings;
                if (this.DEBUG) {
                    this.debug("Retrieved " + this.m_legacySubjectTrackingMap.size() + " mt trackings");
                }
            } else {
                Enumeration<Long> e = mappings.keys();
                while (e.hasMoreElements()) {
                    Long key = e.nextElement();
                    Long value = (Long)mappings.get(key);
                    this.m_legacySubjectTrackingMap.put((long)key, value);
                }
                if (this.DEBUG) {
                    this.debug("Joined legacy subject trackings " + this.m_legacySubjectTrackingMap.size() + " mt trackings");
                }
            }
            this.m_rebuildSubjectAckMapOnResume = false;
            this.m_syncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertLegacySubjectAck(IMgram ack) throws InterruptedException {
        long clientID = -1L;
        long tracking = ack.getAckHandle().getTrackingNumber();
        if (ack != null) {
            clientID = ack.getAckHandle().getClientID();
        }
        if (clientID != -1L && this.m_id != clientID && !this.m_delegator.isGroupSubscription()) {
            try {
                if ((this.debugFlags & 0x100) != 0) {
                    this.debug("Redirecting ack conversion for " + tracking + " to ClientContext " + clientID);
                }
                IClientContext cc = s_reg.getClient(clientID);
                cc.convertLegacySubjectAck(ack);
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
            return;
        }
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_rebuildSubjectAckMapOnResume) {
                while (this.m_rebuildSubjectAckMapOnResume) {
                    if (this.DEBUG) {
                        this.debug("Waiting for legacy subject retrieval");
                    }
                    this.m_syncObj.wait();
                }
            }
            if (this.m_legacySubjectTrackingMap.isEmpty()) {
                return;
            }
            Long realTracking = (Long)this.m_legacySubjectTrackingMap.remove(tracking);
            long subjectTracking = -1L;
            if (realTracking != null) {
                subjectTracking = tracking - realTracking;
            }
            if (subjectTracking > 0L) {
                if (this.DEBUG) {
                    this.debug(this.getAppid() + ": Found bc subject tracking trk: " + realTracking + " sTrk: " + subjectTracking);
                }
                if (ack != null) {
                    ack.getAckHandle().setSubjectTracking((short)subjectTracking);
                    ack.setType((byte)36);
                    if (realTracking != null) {
                        throw new NullPointerException("realTracking is null at " + this.getClass().getName() + ".convertLegacySubjectAck(IMgram ack)");
                    }
                    tracking = realTracking;
                    ack.getAckHandle().setTrackingNumber(tracking);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void acknowledge(long tracking, boolean txnCommit, IMgram ack, IMgram ackedMgramParam) throws InterruptedException {
        IMgram ackedMgram = ackedMgramParam;
        long clientID = -1L;
        if (ack != null) {
            clientID = ack.getAckHandle().getClientID();
        }
        if (clientID != -1L && this.m_id != clientID && !this.m_delegator.isGroupSubscription()) {
            try {
                if ((this.debugFlags & 0x100) != 0) {
                    this.debug("Redirecting ack for " + tracking + " to ClientContext " + clientID);
                }
                IClientContext cc = s_reg.getClient(clientID);
                cc.acknowledge(tracking, txnCommit, ack, ackedMgram);
            }
            catch (EClientNotRegistered e) {
                this.m_delegator.sendAckAck(ack);
            }
            return;
        }
        if (this.m_state == -1) {
            EAssertFailure t = new EAssertFailure(this.m_delegator + ": acknowledge of msg " + tracking + " while unregistered");
            BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
            return;
        }
        if (this.handleAckAck(ack, tracking)) {
            return;
        }
        if (ack != null && ack.getType() == 14) {
            this.m_delegator.acknowledgeQueue(tracking, txnCommit, ack);
            return;
        }
        GroupSubscriptionClientContext groupcc = null;
        if (this.m_delegator.isInterbroker()) {
            groupcc = this.m_outQueue.getGroupSubGuarPendingCC(tracking);
        }
        if (ackedMgram == null) {
            if (ack != null && ack.getAckHandle().isSubjectAck()) {
                Object object = this.m_delegator.getSyncObj();
                synchronized (object) {
                    ackedMgram = this.m_delegator.getPendingGuar(tracking);
                    if (ackedMgram == null && this.m_delegator.isGroupSubscriptionMember()) {
                        ackedMgram = this.m_delegator.getGroupSubscriptionCC().getPendingGuar(tracking);
                    }
                    if (ackedMgram == null && this.getClientSessionVer() < 28) {
                        ackedMgram = this.m_outQueue.getPendingGuar(tracking);
                    }
                    if (ackedMgram != null) {
                        LongHashTable sfTable;
                        LongHashTable longHashTable = sfTable = ackedMgram.getBrokerHandle().getSubjectFilters();
                        synchronized (longHashTable) {
                            ISubjectFilter sf = (ISubjectFilter)sfTable.get(this.m_delegator.getSubjectFilterId());
                            if (sf != null) {
                                sf.removeTrackingNum(ackedMgram.getSubject(), ack.getAckHandle().getSubjectTracking());
                                if (sf.filterSize() == 0) {
                                    if (this.DEBUG) {
                                        this.debug(this.getAppid() + ": Swapping subject ack for real ack " + tracking + " sTrk: " + ack.getAckHandle().getSubjectTracking());
                                    }
                                    this.m_delegator.removeMsgPendingAck(tracking);
                                    sfTable.remove(this.m_delegator.getSubjectFilterId());
                                    ack.getAckHandle().setSubjectTracking((short)-1);
                                }
                            } else {
                                this.m_delegator.removeMsgPendingAck(tracking);
                            }
                        }
                    }
                }
            }
            Object object = this.m_delegator.getSyncObj();
            synchronized (object) {
                ackedMgram = this.m_delegator.removeMsgPendingAck(tracking);
            }
        }
        this.m_delegator.handleNormalAck(tracking, txnCommit, ack, ackedMgram);
        if (groupcc != null) {
            groupcc.notifyGroupRestoreThreads();
        }
    }

    @Override
    public void handleNewPreviousBrokerNotification(long senderID) {
    }

    @Override
    public void handleRemoteRestoreDone() {
    }

    private boolean handleAckAck(IMgram ack, long tracking) {
        if (ack == null) {
            if (this.m_delegator.handleGuarQAckAck(tracking) || this.m_delegator.handleGuarAckAck(tracking) || this.m_delegator.handleXOReplyAck(tracking)) {
                return true;
            }
        } else {
            switch (ack.getType()) {
                case 3: 
                case 14: {
                    if (!this.m_delegator.handleGuarQAckAck(tracking) && !this.m_delegator.handleGuarAckAck(tracking) && !this.m_delegator.handleXOReplyAck(tracking)) break;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public final void handleNormalAck(long tracking, boolean txnCommit, IMgram ack, IMgram ackedMgramParameter) {
        ClientAckEvt ackevt;
        IMgram ackedMgram = ackedMgramParameter;
        if (this.m_delegator.isGroupSubscriptionMember()) {
            this.handleGroupSubscriptionAck(tracking, txnCommit, ack, ackedMgram);
            return;
        }
        if (this.m_delegator.isInterbroker()) {
            ackedMgram = this.handleInterBrokerAck(tracking, txnCommit, ack, ackedMgram);
        }
        AgentGuarMsgTracker tracker = null;
        boolean subjectAck = ack != null && ack.getAckHandle().isSubjectAck();
        short subjectTracking = -1;
        if (subjectAck) {
            subjectTracking = ack.getAckHandle().getSubjectTracking();
        }
        this.logTracking(tracking, subjectAck);
        if (ackedMgram != null) {
            HandleAckParameters params = new HandleAckParameters(ackedMgram);
            this.removeMessageInDoubt(tracking, subjectAck);
            if (params.fromDb || params.fromLog) {
                this.initializeTrackDbDelete(txnCommit, ack, params);
                this.acknowledge(tracking, ack, subjectAck, params.trackDbDelete);
                this.deleteMessage(tracking, subjectAck, subjectTracking, params);
                tracker = this.getTracker(tracking, params.fromLog);
            } else {
                tracker = this.getTrackerForLiveMessage(tracking);
            }
            ackevt = this.getClientAckEvt(tracking, ack, params);
        } else if (txnCommit) {
            ackevt = this.createCommitClientAckEvent(tracking, ack, subjectAck, subjectTracking);
        } else {
            this.logMessageNotInQueue(tracking);
            ackevt = new ClientAckEvt(this.m_id, tracking, ack, true);
            this.acknowledge(tracking, ack, subjectAck, true);
            tracker = this.getTracker(tracking, tracker);
            s_reg.getMsgSaver().deleteMsg(this.m_delegator, tracking, -1, true, true, subjectAck, subjectTracking);
        }
        this.setNotifyDelete(ackevt);
        ackevt = this.flushEvent(ackevt, tracker, subjectAck);
        if (ackevt != null) {
            if (ackedMgram != null) {
                ackevt.setReplicateOnly(ackedMgram.isNonPersistentReplicated());
            } else if (tracker != null) {
                ackevt.setReplicateOnly(tracker.isReplicateOnly());
            }
            BaseClientContext.addEvent(txnCommit, ack, ackevt, tracker);
        }
    }

    private void logMessageNotInQueue(long tracking) {
        if (this.DEBUG) {
            this.debug("acknowledged message " + tracking + " not in pending queue and not in a transaction.");
        }
    }

    private void setNotifyDelete(ClientAckEvt ackevt) {
        if (ackevt != null && this.m_delegator.isGroupSubscription()) {
            ackevt.setNotifyDelete(!ackevt.hasDelete());
        }
    }

    private ClientAckEvt flushEvent(ClientAckEvt ackevt, AgentGuarMsgTracker tracker, boolean subjectAck) {
        if (tracker != null && !tracker.msgAcknowledged(this.m_delegator, subjectAck) && ackevt != null) {
            ackevt.onFlush();
            return null;
        }
        return ackevt;
    }

    private void logTracking(long tracking, boolean subjectAck) {
        if (this.DEBUG) {
            this.debug("Received ack for tracking # " + tracking + ", subjectAckTrk: " + subjectAck);
        }
    }

    private static void addEvent(boolean txnCommit, IMgram ack, ClientAckEvt ackevt, AgentGuarMsgTracker tracker) {
        boolean logHP;
        boolean flush = !txnCommit && ack != null && ack.isGuarenteed();
        boolean bl = logHP = tracker != null && (tracker.getEvent().removedFromLog() || tracker.getEvent().isLogged());
        if (flush && logHP) {
            s_reg.getLogManager().addHighPriorityEvt(ackevt, true);
        } else {
            s_reg.getLogManager().addEvent(ackevt, flush);
        }
    }

    private AgentGuarMsgTracker getTracker(long tracking, AgentGuarMsgTracker tracker) {
        try {
            return AgentGuarMsgTracker.getTracker(tracking);
        }
        catch (ETrackingNumNotFound e) {
            this.debug("Got ETrackingNumNotFound exception", e);
            return tracker;
        }
    }

    private void initializeTrackDbDelete(boolean txnCommit, IMgram ack, HandleAckParameters params) {
        params.trackDbDelete = params.persisted || this.m_delegator.isGroupSubscription() || !txnCommit && ack != null && this.m_ackMode != 3;
    }

    private AgentGuarMsgTracker getTrackerForLiveMessage(long tracking) {
        AgentGuarMsgTracker tracker;
        if (this.DEBUG) {
            this.debug("acknowledging live message " + tracking);
        }
        if ((tracker = BaseClientContext.getTracker(tracking)) == null && this.DEBUG) {
            this.debug("tracker " + tracking + " not found");
        }
        return tracker;
    }

    private AgentGuarMsgTracker getTracker(long tracking, boolean fromLog) {
        if (fromLog) {
            return this.getTracker(tracking, null);
        }
        return null;
    }

    private void deleteMessage(long tracking, boolean subjectAck, short subjectTracking, HandleAckParameters params) {
        if (params.ackedMgram.getType() == 27) {
            s_reg.getMsgSaver().deleteMsg(this.m_delegator, params.ackedMgram, params.trackDbDelete, true);
        } else {
            s_reg.getMsgSaver().deleteMsg(this.m_delegator, tracking, params.ackedMgram.getBrokerHandle().getTrackedSize(), params.trackDbDelete, true, subjectAck, subjectTracking);
        }
    }

    private void acknowledge(long tracking, IMgram ack, boolean subjectAck, boolean trackDbDelete) {
        if (subjectAck) {
            this.m_delegator.getGuarDoubtManager().msgSubjectAcked(tracking, ack.getAckHandle().getSubjectTracking());
        } else {
            this.m_delegator.getGuarDoubtManager().msgAcknowledged(tracking, trackDbDelete);
        }
    }

    private void removeMessageInDoubt(long tracking, boolean subjectAck) {
        if (!subjectAck) {
            this.m_delegator.getGuarDoubtManager().removeMessageInDoubt(tracking);
        }
    }

    private ClientAckEvt getClientAckEvt(long tracking, IMgram ack, HandleAckParameters params) {
        ClientAckEvt ackevt;
        block7: {
            ackevt = null;
            if (params.persisted) {
                ackevt = new ClientAckEvt(this.m_id, tracking, ack, params.fromDb || params.fromLog);
            } else if (this.m_delegator.isGroupSubscription()) {
                ackevt = new ClientAckEvt(this.m_id, tracking, ack, params.fromDb || params.fromLog);
            } else if (ack != null && ack.isGuarenteed()) {
                try {
                    s_reg.getClient(ack.getBrokerHandle().getSenderID()).sendAckAck(ack);
                }
                catch (EClientNotRegistered ecnr) {
                    if (!this.DEBUG) break block7;
                    SessionConfig.logMessage(ecnr, SessionConfig.getLevelWarning());
                }
            }
        }
        return ackevt;
    }

    private ClientAckEvt createCommitClientAckEvent(long tracking, IMgram ack, boolean subjectAck, short subjectTracking) {
        this.acknowledge(tracking, ack, subjectAck, true);
        s_reg.getMsgSaver().deleteMsg(this.m_delegator, tracking, -1, true, true, subjectAck, subjectTracking);
        return new ClientAckEvt(this.m_id, tracking, ack, true);
    }

    private static AgentGuarMsgTracker getTracker(long tracking) {
        return AgentGuarMsgTracker.getTrackerIfExists(tracking);
    }

    private IMgram handleInterBrokerAck(long tracking, boolean txnCommit, IMgram ack, IMgram ackedMgramParam) {
        IMgram ackedMgram = ackedMgramParam;
        if (GroupSubscriptions.isLBSWrappedMessage(ackedMgram)) {
            this.m_outQueue.removeInDoubtXOGroupSend(ackedMgram.getGuarenteedTrackingNum());
            long clientId = ackedMgram.getBrokerHandle().getGroupSubscriptionCC();
            if (clientId == -1L) {
                IMgram wrappedMgram = (IMgram)ackedMgram.getOperationHandle().getMgramList().get(0);
                wrappedMgram.getBrokerHandle().setFromDB(ackedMgram.getBrokerHandle().isFromDB());
                ackedMgram = wrappedMgram;
                this.m_delegator.removeLBSWrapperInfo(ackedMgram.getGuarenteedTrackingNum());
            } else {
                try {
                    IMgram wrappedMgram;
                    IClientContext groupcc = s_reg.getClient(clientId);
                    if (groupcc instanceof GroupSubscriptionClientContext && (wrappedMgram = (IMgram)ackedMgram.getOperationHandle().getMgramList().get(0)).isGuarenteed()) {
                        groupcc.removeMsgPendingAck(wrappedMgram.getGuarenteedTrackingNum());
                        groupcc.handleNormalAck(wrappedMgram.getGuarenteedTrackingNum(), txnCommit, ack, wrappedMgram);
                        this.m_delegator.getGuarDoubtManager().msgAcknowledged(tracking, false);
                    }
                }
                catch (EClientNotRegistered e) {
                    this.debug("Got EClientNotRegistered exception", e);
                }
            }
        }
        return ackedMgram;
    }

    private void handleGroupSubscriptionAck(long tracking, boolean txnCommit, IMgram ack, IMgram ackedMgram) {
        this.m_groupSubCC.handleNormalAck(tracking, txnCommit, ack, ackedMgram);
        this.m_delegator.getGuarDoubtManager().msgAcknowledged(tracking, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMgram acknowledgeQueue(long tracking, boolean txnCommit, IMgram ack) throws InterruptedException {
        s_reg.getQMsgStateMgr().msgAcknowledged(tracking);
        IMgram m = null;
        if (!txnCommit) {
            IXOnceHandle xoh;
            if (this.DEBUG) {
                this.debug(this.m_delegator + " Live acknowledge for " + tracking);
            }
            Object object = this.m_delegator.getSyncObj();
            synchronized (object) {
                m = this.m_outQueue.removePendingQmsg(tracking);
            }
            if (m != null || (xoh = this.m_delegator.getXOnceHandle()) == null || (m = xoh.removeInDoubtQMsg(tracking)) == null) {
                // empty if block
            }
            short status = ack.getAckHandle().getErr();
            switch (status) {
                case -16: {
                    s_reg.getQueueProc().processUndelivered(m, 9, true);
                    return null;
                }
                case -7: {
                    s_reg.getQueueProc().processUndelivered(m, 19, true);
                    return null;
                }
                case -41: {
                    if (m != null) {
                        Hashtable<String, String> errorInfo = new Hashtable<String, String>();
                        String msg = prAccessor.getString("MAX_DELIVERY_LIMIT_CLIENT_DMQ_EXPLAIN");
                        errorInfo.put("JMS_SonicMQ_undeliveredExplanationText", msg);
                        s_reg.getQueueProc().processUndelivered(m, 28, true, errorInfo);
                    }
                    return null;
                }
            }
            AgentQueueMsgTracker tracker = null;
            if (m == null || m.isJMSPersistent()) {
                tracker = AgentQueueMsgTracker.getTracker(tracking);
            }
            if (tracker != null) {
                this.debugFoundMessageTracker(ack, tracker, tracking);
            } else {
                if ((this.debugFlags & 0x100) != 0) {
                    this.debug("Tracker not found " + tracking);
                }
                if (ack != null && ack.isGuarenteed()) {
                    try {
                        s_reg.getClient(ack.getBrokerHandle().getSenderID()).sendAckAck(ack);
                    }
                    catch (EClientNotRegistered eClientNotRegistered) {
                        // empty catch block
                    }
                }
                if (m == null || m.getBrokerHandle().isFromDB() || m.getBrokerHandle().isDBSaveRequested()) {
                    s_reg.getQueueMsgSaver().deleteMsg(tracking, m == null ? true : m.isJMSPersistent());
                }
            }
        } else {
            AgentQueueMsgTracker tracker;
            IXOnceHandle xoh;
            if ((this.debugFlags & 0x100) != 0) {
                this.debug(this.m_delegator + " Commiting acknowledgement for " + tracking);
            }
            Object status = this.m_syncObj;
            synchronized (status) {
                m = this.m_outQueue.removePendingQmsg(tracking);
            }
            if (m == null && (xoh = this.m_delegator.getXOnceHandle()) != null) {
                m = xoh.removeInDoubtQMsg(tracking);
            }
            if ((tracker = AgentQueueMsgTracker.getTracker(tracking)) != null) {
                this.debugFoundMessageTracker(ack, tracker, tracking);
            } else {
                if ((this.debugFlags & 0x100) != 0) {
                    this.debug(this.m_delegator + " Tracker not found " + tracking);
                }
                s_reg.getQueueMsgSaver().deleteMsg(tracking, m == null || m.isJMSPersistent());
                if (m != null && !m.isJMSPersistent()) {
                    if ((this.debugFlags & 0x100) != 0) {
                        this.debug(this.m_delegator + " Ack for " + tracking + " NON_PERSISTENT message");
                    }
                    if (ack.isGuarenteed() && !ack.getBrokerHandle().isAckNoReply()) {
                        if ((this.debugFlags & 0x100) != 0) {
                            this.debug(this.m_delegator + " Ack " + ack.getGuarenteedTrackingNum() + " for " + tracking + " is synchronous, replying to " + ack.getAckHandle().getClientID());
                        }
                        try {
                            IClientContext cc = s_reg.getClient(ack.getBrokerHandle().getSenderID());
                            cc.sendThrough(MgramFactory.getMgramFactory().buildAck(ack.getGuarenteedTrackingNum(), (short)0, ack.getChannel()));
                        }
                        catch (EClientNotRegistered cc) {}
                    }
                } else {
                    QueueMsgAckedEvt evt = new QueueMsgAckedEvt(tracking, ack, m == null || m.isJMSPersistent());
                    evt.setReplicateOnly(m != null && m.isNonPersistentReplicated());
                    s_reg.getLogManager().addEvent(evt, false);
                }
            }
        }
        return m;
    }

    private void debugFoundMessageTracker(IMgram ack, AgentQueueMsgTracker tracker, long tracking) {
        if ((this.debugFlags & 0x100) != 0) {
            this.debug(this.m_delegator + " Found message tracker for " + tracking);
        }
        tracker.acknowledged(ack, ack.isGuarenteed());
    }

    @Override
    public void sendSecurityError(int errorCode) {
        this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildErrorMgram(errorCode, 0, null, this.getChannel()));
    }

    @Override
    public boolean isAdminGroup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pingIfIdle(long preemptingRootId) throws InterruptedException {
        boolean fatal = false;
        AgentSender sender = null;
        AgentListener listener = null;
        AgentConnection connection = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            boolean badConnection = false;
            connection = this.m_connection;
            if (connection == null) {
                badConnection = true;
            } else {
                sender = connection.getAgentSender();
                listener = connection.getAgentListener();
                if (sender == null || listener == null) {
                    badConnection = true;
                }
            }
            if (badConnection) {
                if (this.m_delegator.isActivelyConnected()) {
                    Config.logMessage("Assertion failure pinging client: " + s_reg.getClientFullName(this) + ": invalid connection for state: " + this.m_state + " connection: " + connection + " sender: " + sender + " listener: " + listener, 2);
                }
                return;
            }
            boolean senderIsAlive = sender.isAlive();
            if (this.DEBUG_UNEXPECTED && this.m_outQueue.isMgramAvailable()) {
                this.debug("pingIfIdle for " + s_reg.getClientFullName(this.m_delegator) + " ping with non empty outqueue");
            }
            IMgram pingRequest = MgramFactory.getMgramFactory().buildPingRequest(new byte[0], this.m_delegator.getChannel());
            this.m_pinging = true;
            if (senderIsAlive) {
                this.m_delegator.sendThrough(pingRequest);
            } else {
                try {
                    sender.sendThrough(pingRequest);
                }
                catch (IOException ioe) {
                    fatal = true;
                }
                catch (ClassCastException cce) {
                    if (this.DEBUG_UNEXPECTED) {
                        Config.logMessage(cce, 2);
                    }
                    fatal = true;
                }
                catch (NullPointerException npe) {
                    if (this.DEBUG_UNEXPECTED) {
                        Config.logMessage(npe, 2);
                    }
                    fatal = true;
                }
                catch (RuntimeException re) {
                    Config.logMessage(re, 1);
                    fatal = true;
                }
            }
            int timeLeft = Config.CONNECT_PING_TIMEOUT;
            while (!fatal && this.m_pinging && this.m_delegator.isActivelyConnected()) {
                if (timeLeft == 0) {
                    fatal = true;
                    continue;
                }
                if (timeLeft > 0) {
                    long currentTime = System.currentTimeMillis();
                    this.m_syncObj.wait(timeLeft);
                    currentTime = System.currentTimeMillis() - currentTime;
                    timeLeft = (int)((long)timeLeft - currentTime);
                    if (!this.m_pinging || timeLeft > 0) continue;
                    fatal = true;
                    continue;
                }
                this.m_syncObj.wait();
            }
        }
        if (fatal) {
            ClientSecurityContext csc;
            String connectId = null;
            String userId = null;
            String ipAddress = null;
            ClientSecurityContext clientSecurityContext = csc = connection == null ? null : connection.getSecurityContext(0);
            if (csc != null) {
                connectId = csc.getAppid();
                if (connectId != null && connectId.endsWith("$CONNECTION$")) {
                    connectId = connectId.substring(0, connectId.lastIndexOf("$CONNECTION$"));
                }
                if (csc.getPrincipal() != null) {
                    userId = csc.getPrincipal().getName();
                }
                ipAddress = csc.getClientIPAddress();
            }
            Object[] args = new Object[]{Integer.toString(Config.CONNECT_PING_TIMEOUT), connectId, userId, ipAddress};
            BrokerComponent.logMessage(MessageFormat.format(prAccessor.getString("DISCONNECTING_UNRESPONSIVE_DUPLICATE_CONNECTION"), args), BrokerComponent.getLevelWarning());
            listener.fatalError(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pingReplyRcvd() {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_pinging = false;
            this.m_syncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(AgentConnection conn, boolean isInterbroker, short ackMode) throws EConnectFailure {
        if (this.m_isRemoteNode) {
            throw new EAssertFailure(this.m_delegator + ": connect() called for remote node CC");
        }
        if (this.m_state != 0 && this.m_delegator.getDurableCCTracker() != null) {
            this.m_delegator.getDurableCCTracker().isSubscriptionTrimInProgress(true);
        }
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_state != 1 && this.m_state != 0) {
                throw new EAssertFailure(this.m_delegator + ": connect() called while already connected: " + this.m_state);
            }
            this.resetResumeAndNotify();
            long msgId = this.findMaxDeleteMsgIdAndUpdateRestorePos();
            if (this.m_isJMSTopic || this.m_isJMSTopicCC) {
                this.m_restoreNonDurableMsgs = false;
                this.m_hasGuarMsgsInDB = this.resetAndRetrieveNonDurableMsgs(msgId);
            }
            this.m_delegator.setAckMode(ackMode);
            this.m_delegator.setState(2);
            this.assignConnection(conn);
            if (conn != null) {
                this.m_secctx = conn.getSecurityContextFromId(this.m_id);
                this.m_clientConnectParms = conn.getClientConnectParms();
                this.configFaultTolerantReconnectTimeout();
            }
            this.m_delegator.setInterbroker(isInterbroker);
            if (isInterbroker) {
                this.m_preChecker = s_reg.getGSManager().getGSOrphanedMessageChecker();
                this.m_outQueue.setExpirePrecheck(this.m_preChecker);
            }
            this.m_inDoubtTxns = s_txnmgr.getInDoubtTxns(this.m_id);
            this.m_disconnecting = false;
            this.m_disconnectReason = -1;
            this.m_disconnectExpired = false;
            this.setupPTPFlowController();
            this.m_ptpFlowControlHandler = SessionConfig.createPTPFlowControlHandler(this.m_delegator);
            if (this.DEBUG) {
                this.debug("state set to STOPPED");
            }
        }
        if (this.m_delegator.isGroupSubscriptionMember()) {
            this.m_groupSubCC.notifyGroup();
        }
        if (this.m_delegator.isGroupSubscription()) {
            this.m_groupOffloadCancelled = false;
        }
    }

    private void assignConnection(AgentConnection connection) {
        this.m_connection = connection;
        if (connection != null) {
            this.m_resumableSocketIds.add(new Long(connection.getSocketId()));
        } else {
            this.m_resumableSocketIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean goodResumeCredentials(IResumeCredentials credentials) {
        Vector vector = this.m_resumableSocketIds;
        synchronized (vector) {
            if (this.m_resumableSocketIds.isEmpty()) {
                return true;
            }
            long presentedSocketId = credentials.getResumeSocketId();
            boolean found = false;
            int idx = 0;
            for (idx = 0; idx < this.m_resumableSocketIds.size(); ++idx) {
                if (presentedSocketId != (Long)this.m_resumableSocketIds.elementAt(idx)) continue;
                found = true;
                break;
            }
            if (found) {
                for (int i = 0; i < idx - 1; ++i) {
                    this.m_resumableSocketIds.removeElementAt(0);
                }
            }
            return found;
        }
    }

    @Override
    public final void resumePreempted() {
        this.setResumable(false);
        this.m_disconnectExpired = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(AgentConnection conn, boolean isInterbroker, short ackMode) throws EAssertFailure, InterruptedException, EConnectionNotResumable {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (!this.m_isResumable) {
                if (m_Sonic00027420.getDebug() && !m_done) {
                    try {
                        m_done = true;
                        System.out.println("Resumable flag is not set for:" + (this.m_secctx != null ? this.m_secctx.getAppid() : "??") + " " + this.m_id);
                        Class<?> clz = Class.forName("qa.sonicmq.faulttolerance.callbacks.LogTraceCallback");
                        clz.getMethod("printCaptureBuffer", new Class[0]).invoke(null, new Object[0]);
                        Class<?> clz2 = Class.forName("qa.sonicmq.faulttolerance.callbacks.FailoverTestCallback");
                        clz2.getMethod("printCaptureBuffer", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Exception pe) {
                        pe.printStackTrace();
                    }
                }
                throw new EConnectionNotResumable("Resumable flag is not set for:" + (this.m_secctx != null ? this.m_secctx.getAppid() : "??"));
            }
            if (this.m_state <= 0) {
                throw new EConnectionNotResumable("Invalid state to resume:" + this.m_state + " for:" + (this.m_secctx != null ? this.m_secctx.getAppid() : "??"));
            }
            this.setResumable(false);
            if (this.DEBUG) {
                this.debug("Resuming " + this.m_delegator.toString());
            }
            this.assignConnection(conn);
            this.m_clientConnectParms = conn.getClientConnectParms();
            this.m_secctx = conn.getSecurityContextFromId(this.m_id);
            this.configFaultTolerantReconnectTimeout();
            this.m_delegator.setInterbroker(isInterbroker);
            this.m_delegator.setAckMode(ackMode);
            this.setupPTPFlowController();
            this.m_ptpFlowControlHandler = SessionConfig.createPTPFlowControlHandler(this.m_delegator);
            this.setState(2);
            this.m_disconnectExpired = false;
            if (this.getClientSessionVer() >= 28 && this.m_rebuildSubjectAckMapOnResume) {
                this.m_rebuildSubjectAckMapOnResume = false;
            }
            this.m_syncObj.notifyAll();
            if (this.DEBUG) {
                this.debug("client context resumed !");
            }
        }
    }

    private void configFaultTolerantReconnectTimeout() {
        if (this.m_clientConnectParms != null) {
            this.m_secctx.setFaultTolerantReconnectTimeout(this.m_clientConnectParms.getFaultTolerantReconnectTimeout());
        }
    }

    @Override
    public ClientConnectParms getClientConnectParms() {
        return this.m_clientConnectParms;
    }

    @Override
    public void setClientConnectParms(ClientConnectParms parms) {
        this.m_clientConnectParms = parms;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean startDelivery(Envelope req) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startDeliveryInternal(boolean restoring) {
        if (s_reg.getQueueProc() != null && s_reg.getQueueProc().getDispatcher() != null) {
            s_reg.getQueueProc().startDelivery(this.m_id);
        }
        if (!restoring && InterbrokerHook.isSet() && this.m_delegator.getProxyingHandle() != null) {
            s_reg.getRemoteRestoreManager().remoteRestoreDone(this.m_delegator);
        }
        if (this.m_CCFlowControlTracker != null) {
            this.m_CCFlowControlTracker.startFCMonitor();
        }
        if (this.isGroupSubscriptionMember()) {
            this.m_delegator.restoreComplete(this.m_msgRestorePos);
            this.m_groupSubCC.notifyGroup();
        }
    }

    private boolean processInitRestoreState(Envelope req) {
        if (req != null) {
            this.m_startReqs.addElement(req);
        }
        Vector reqs = this.m_startReqs;
        this.m_startReqs = new Vector();
        this.m_syncObj.notifyAll();
        this.sendStartDeliveryReplies(reqs);
        return true;
    }

    private boolean processStoppedState() {
        if (this.checkIfAbleToStart()) {
            return true;
        }
        boolean doRemoteRestorePhases = false;
        boolean durableSMO = false;
        if (this.m_delegator.isDurable()) {
            durableSMO = this.m_delegator.getDurableBrokerSubscription().getDurableStrictMessageOrder();
            boolean bl = doRemoteRestorePhases = durableSMO && this.m_delegator.getCWADSActiveBroker() != null && this.m_delegator.getCWADSActiveBroker().getId() == this.m_delegator.getId();
        }
        if (!(this.m_msgsInDb || InterbrokerHook.isSet() || this.m_groupOffloadCancelled)) {
            return this.dumpPRQandWQsets();
        }
        this.createMsgRestorerAndStart(durableSMO, doRemoteRestorePhases, false);
        this.m_syncObj.notifyAll();
        return false;
    }

    private boolean checkIfAbleToStart() {
        if (this.DEBUG) {
            this.debug("starting delivery");
        }
        if (this.m_isJMSConnection || this.m_isJMSQueueReceiver || this.m_isJMSQueueBrowser || SessionConfig.isJMSSession(this.m_delegator.getAppid())) {
            this.m_delegator.setState(8);
            if (this.DEBUG) {
                this.debug("state set to STARTED");
                this.debug("JMS connection, session, queue receiver or browser - do not start MsgRestore thread");
            }
            this.m_syncObj.notifyAll();
            return true;
        }
        if ((this.m_isJMSTopic || this.m_isJMSTopicCC) && !this.m_restoreNonDurableMsgs) {
            return this.dumpPRQandWQsets();
        }
        if (this.m_delegator.isRemoteBroker()) {
            this.m_delegator.setState(8);
            if (this.DEBUG) {
                this.debug("remote broker CC, state set to STARTED");
            }
            this.m_syncObj.notifyAll();
            return true;
        }
        if (this.m_delegator.isGroupSubscriptionMember()) {
            if (this.DEBUG) {
                this.debug(this + ": Skipping restorer creation because member is part of group");
            }
            this.m_syncObj.notifyAll();
            return true;
        }
        return false;
    }

    private boolean dumpPRQandWQsets() {
        if (this.DEBUG) {
            this.debug(this + SKIPPING_RESTORE_NO_MESSAGES_IN_DB);
        }
        this.m_delegator.restoreComplete(this.m_msgRestorePos);
        this.m_syncObj.notifyAll();
        return true;
    }

    private boolean processRestoringBrokerStartedState() {
        IClientContext activeCC = this.m_delegator.getCWADSActiveBroker();
        if (activeCC != null && activeCC.getId() != this.m_delegator.getId()) {
            this.createMsgRestorerAndStart(true, false, false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDelivery() {
        Vector reqs = null;
        boolean deleteMsgs = false;
        long maxMsgIdToDelete = 0L;
        LinkedList waitQGuars = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            switch (this.m_state) {
                case 4: 
                case 7: {
                    this.m_msgSavesBeforeWaitQueueInProgress = 0;
                    this.m_maxSeqNoSavedBeforeWaitQueue = -1L;
                    waitQGuars = this.m_outQueue.dumpWaitQueue();
                    this.notifySave(waitQGuars, true);
                }
                case 3: 
                case 5: 
                case 6: {
                    reqs = this.m_startReqs;
                    this.m_startReqs = new Vector();
                }
                case 8: {
                    this.m_delegator.setState(2);
                    if ((this.m_isJMSTopic || this.m_isJMSTopicCC) && this.m_restoreNonDurableMsgs && !this.m_hasGuarMsgsInDB) {
                        deleteMsgs = true;
                        maxMsgIdToDelete = s_reg.getLogManager().getSeqNo();
                        this.m_restoreNonDurableMsgs = this.resetAndRetrieveNonDurableMsgs(maxMsgIdToDelete);
                    }
                    this.m_outQueue.informStoppedPublishers();
                    if (this.m_delegator.getActivityMonitorHandle() != null) {
                        this.m_delegator.getActivityMonitorHandle().stopActivityMonitoring();
                    }
                    this.m_syncObj.notifyAll();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.stopFCMonitorForControlTracker();
        this.saveMgramList(waitQGuars, false, false, false);
        if (this.m_delegator.isGroupSubscriptionMember()) {
            this.m_groupSubCC.notifyGroup();
        }
        s_reg.getQueueProc().clearGetRequests(this.m_id);
        if (reqs != null) {
            this.sendStartDeliveryReplies(reqs);
        }
        this.m_delegator.cancelMsgRestore();
        if (deleteMsgs) {
            s_reg.getDeleteSubscriptionManager().beginDeleteSubscription(this.m_delegator, maxMsgIdToDelete, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMsgRestoreCancelled() {
        Object object = this.m_syncObj;
        synchronized (object) {
            return this.m_msgRestorer == null || ((MsgRestorerBase)this.m_msgRestorer).isRestoreCancelled() || !this.m_msgRestorer.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelMsgRestore() {
        block29: {
            if (this.m_msgRestorer != null) {
                if (Thread.currentThread() == this.m_msgRestorer) {
                    if (this.DEBUG) {
                        this.debug("cancelMsgRestore called by m_msgRestorer thread for m_cc: " + this.getAppid());
                    }
                    this.m_delegator.setDisconnectAfterFinalRemoteRestore(false);
                    return;
                }
                this.m_msgRestorer.cancelRestore();
                boolean interrupted = false;
                while (this.m_msgRestorer.isAlive() && !this.m_msgRestorer.isDisconnecting()) {
                    try {
                        if (this.DEBUG) {
                            this.debug(this.getAppid() + "Waiting for MsgRestorer to stop " + new Date());
                        }
                        this.m_msgRestorer.join();
                        if (!this.DEBUG) continue;
                        this.debug(this.getAppid() + "Wait for MsgRestorer join has exited " + new Date());
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            OffloadedMsgRestorer offloadedMsgRestorer = null;
            boolean exit = false;
            Object object = this.m_syncObj;
            synchronized (object) {
                offloadedMsgRestorer = this.m_offloadedMsgRestorer;
                this.m_offloadedMsgRestoreLock.lock();
                if (this.m_state == 0) {
                    exit = true;
                    this.m_offloadedMsgRestorer = null;
                }
            }
            try {
                if (offloadedMsgRestorer != null) {
                    boolean interrupted = false;
                    try {
                        offloadedMsgRestorer.cancelRestoreAndWait(exit);
                        if (exit) {
                            while (offloadedMsgRestorer.isAlive()) {
                                offloadedMsgRestorer.join();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                long offloadedQueueMemoryLen = 0L;
                Object object2 = this.m_syncObj;
                synchronized (object2) {
                    offloadedQueueMemoryLen = this.m_outQueue.getOffloadedPubSubQueue().getMemoryLength();
                    if (this.m_delegator.isGroupSubscription() && offloadedMsgRestorer != null) {
                        this.m_groupOffloadCancelled = true;
                    }
                    this.m_outQueue.getOffloadedPubSubQueue().reset();
                    this.m_syncObj.notifyAll();
                }
                if (offloadedQueueMemoryLen > 0L) {
                    FlowToDiskMemoryManager.getFlowToDiskMemoryManager().updateMemorySize(-offloadedQueueMemoryLen, null, null);
                }
                FlowToDiskMemoryManager.getFlowToDiskMemoryManager().releasePublishersBlockedOnMemoryForSubscriber(this.m_delegator);
                if (offloadedMsgRestorer == null) break block29;
                object2 = this.m_syncObj;
                synchronized (object2) {
                    this.m_delegator.checkFTDNotifyEventRequired(false);
                }
            }
            finally {
                this.m_offloadedMsgRestoreLock.unlock();
            }
        }
    }

    @Override
    public void joinInDoubtTxns() throws InterruptedException {
        if (this.m_inDoubtTxns != null) {
            for (int i = this.m_inDoubtTxns.size() - 1; i >= 0; --i) {
                ((Transaction)this.m_inDoubtTxns.elementAt(i)).join();
            }
            this.m_inDoubtTxns = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForStart() throws InterruptedException {
        Object object = this.m_syncObj;
        synchronized (object) {
            int state = this.m_state;
            while (state != 8) {
                this.m_syncObj.wait();
                state = this.m_state;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialRemoteRestoreComplete(MsgRestorePos pos) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("called initialRemoteRestoreComplete(pos) " + this.toString());
        }
        if (this.m_msgSavesBeforeWaitQueueInProgress != 0) {
            EAssertFailure t = new EAssertFailure(this + " Overwriting non-zero  m_msgSavesBeforeWaitQueueInProgress");
            BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
        }
        this.m_msgSavesBeforeWaitQueueInProgress = this.m_msgSavesForRemoteBrokerInProgress;
        this.m_maxSeqNoSavedBeforeWaitQueue = -1L;
        this.m_delegator.setState(4);
        if (this.DEBUG) {
            this.debug("setting state to FINAL_REMOTE_RESTORE");
        }
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            this.m_delegator.getSyncObj().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finalRemoteRestoreComplete(MsgRestorePos pos) {
        if (this.DEBUG) {
            this.debug(" called finalRemoteRestoreComplete(pos) " + this.toString());
        }
        this.m_remoteMsgRestorePos.update(pos);
        this.m_delegator.releasePendingReconnectGuars(true);
        this.m_delegator.releaseWaitQueue();
        this.informAgentSender();
        this.m_delegator.setState(5);
        if (this.DEBUG) {
            this.debug("state set to RESTORING_BROKER_STARTED");
        }
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            this.m_delegator.getSyncObj().notifyAll();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialRestoreComplete(MsgRestorePos pos) {
        Vector reqs = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_state != 6) {
                return;
            }
            if (this.DEBUG) {
                this.debug("initial restore complete");
            }
            this.m_msgSavesBeforeWaitQueueInProgress = this.m_msgSavesInProgress;
            this.m_maxSeqNoSavedBeforeWaitQueue = -1L;
            this.m_delegator.setState(7);
            this.m_msgRestorePos.update(pos);
            if (this.DEBUG) {
                this.debug(s_reg.getClientFullName(this.m_delegator) + " Initial restored complete: " + this.m_msgSavesInProgress + "/" + this.m_msgPostponedSavesInProgress + "/" + this.m_msgSavesBeforeWaitQueueInProgress + " - " + this.m_msgRestorePos);
            }
            reqs = this.m_startReqs;
            this.m_startReqs = new Vector();
            this.m_syncObj.notifyAll();
            if (this.DEBUG) {
                this.debug("state set to FINAL_RESTORE");
            }
        }
        this.sendStartDeliveryReplies(reqs);
    }

    private void sendStartDeliveryReplies(Vector reqs) {
        block3: {
            try {
                int size = reqs.size();
                for (int i = 0; i < size; ++i) {
                    s_reg.getAdminSession().reply(new Message(), (Envelope)reqs.elementAt(i), false);
                }
            }
            catch (EGeneralException e) {
                if (Broker.isInShutdown()) break block3;
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR062") + this.m_id + ": ", (Throwable)e, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreComplete(MsgRestorePos pos) {
        try {
            this.freezeProxy();
            Object object = this.m_syncObj;
            synchronized (object) {
                if (this.DEBUG) {
                    this.debug("restore complete");
                }
                switch (this.m_state) {
                    case 2: 
                    case 7: {
                        BrokerSubscription bs;
                        this.m_msgSavesBeforeWaitQueueInProgress = 0;
                        this.m_maxSeqNoSavedBeforeWaitQueue = -1L;
                        this.m_msgRestorePos.update(pos);
                        if (Config.ENABLE_INTERBROKER && this.m_delegator.isDurable() && (bs = this.m_delegator.getDurableBrokerSubscription()) != null && bs.getDurableStrictMessageOrder()) {
                            this.m_delegator.releasePendingReconnectGuars(true);
                        }
                        this.m_delegator.releasePendingReconnectGuars(false);
                        this.m_delegator.releaseWaitQueue();
                        this.informAgentSender();
                    }
                    case 6: {
                        if (this.DEBUG) {
                            this.debug(this + ": Setting msgsInDb = false");
                        }
                        if (this.m_outQueue.getOffloadedPubSubQueue().isEmpty() && this.m_msgsToBeAddedToOffloadedQueue == 0 && this.m_msgSavesInProgress == 0) {
                            this.m_msgsInDb = false;
                            if (this.m_isJMSTopic || this.m_isJMSTopicCC) {
                                this.m_restoreNonDurableMsgs = false;
                                this.m_hasGuarMsgsInDB = false;
                                ICCSizeTracker trk = this.m_delegator.getCCSizeTracker();
                                if (trk != null) {
                                    trk.reset();
                                }
                            }
                        }
                        this.m_delegator.setState(8);
                        this.m_syncObj.notifyAll();
                        if (!this.DEBUG) break;
                        this.debug("state set to STARTED");
                        break;
                    }
                }
            }
        }
        finally {
            this.unfreezeProxy();
        }
    }

    @Override
    public void releaseWaitQueue() {
        this.m_outQueue.releaseWaitQueue();
    }

    @Override
    public void waitForLogQMsgFlush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForRemoteRestoreDone() throws InterruptedException {
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            while (!this.m_outQueue.getOffloadedPubSubQueue().isEmpty()) {
                this.m_delegator.getSyncObj().wait();
            }
            this.m_delegator.setState(6);
            if (this.DEBUG) {
                this.debug("state set to INIT_RESTORE");
            }
            this.informAgentSender();
            this.m_delegator.getSyncObj().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LinkedList removeUnsentGuarMsgs(IndexedList pending) {
        LinkedList<IMgram> ret = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            boolean outQueueEmpty = this.m_outQueue.isOutQueueEmpty();
            Enumeration pendingGuars = pending.elements();
            while (pendingGuars.hasMoreElements()) {
                IMgram m = (IMgram)pendingGuars.nextElement();
                if (!outQueueEmpty && this.m_outQueue.containsOutgoingMsg(m)) {
                    if (ret == null) {
                        ret = new LinkedList<IMgram>();
                    }
                    ret.add(m);
                    if (pending == this.m_outQueue.getPendingGuars()) {
                        this.m_outQueue.removePendingGuar(m.getGuarenteedTrackingNum());
                        this.m_outQueue.removeGroupSubGuarPending(m.getGuarenteedTrackingNum());
                        continue;
                    }
                    pending.remove(m.getGuarenteedTrackingNum());
                    continue;
                }
                this.m_delegator.getGuarDoubtManager().setMessageInDoubt(m.getGuarenteedTrackingNum());
            }
            if (this.m_outQueue.countWaitQEnqueued() != 0) {
                PriorityQueue waitQGuars = this.m_outQueue.clearWaitQueue();
                while (waitQGuars.getEnqueued() > 0) {
                    if (ret == null) {
                        ret = new LinkedList();
                    }
                    IMgram m = (IMgram)waitQGuars.dequeue();
                    ret.add(m);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginXonceUnsentQMsgsRestore() {
        Object object = this.m_xonceUnsentQMsgsRestoreInProgressSyncObj;
        synchronized (object) {
            if (this.m_xonceUnsentQMsgsRestoreInProgress) {
                return false;
            }
            this.m_xonceUnsentQMsgsRestoreInProgress = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endXonceUnsentQMsgsRestore() {
        Object object = this.m_xonceUnsentQMsgsRestoreInProgressSyncObj;
        synchronized (object) {
            this.m_xonceUnsentQMsgsRestoreInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void restoreUnsentQMsgs(boolean sync) {
        InDoubtQMsgReenqueueEvt idmrEvt;
        Vector<IMgram> toRestore;
        IAgentQueue q;
        block33: {
            Enumeration qMsgsToRestore;
            int removed;
            InDoubtQMsgReenqueueEvt replOnlyIdmrEvt;
            block34: {
                Vector vector;
                block32: {
                    block31: {
                        if (!this.m_delegator.isRemoteBroker() && !this.m_delegator.isInterbroker() && (!this.m_delegator.isXOnce() || !this.isQueueReceiver())) break block31;
                        if (this.DEBUG) {
                            this.debug(this + ": Restoring unsent queueu messages, sync = " + sync);
                        }
                        vector = this.m_logMsgsExpectedIds;
                        // MONITORENTER : vector
                        break block32;
                    }
                    q = s_reg.getQueueProc().getQueueFromClientId(this.m_delegator.getId());
                    if (q == null) {
                        return;
                    }
                    toRestore = new Vector<IMgram>();
                    idmrEvt = new InDoubtQMsgReenqueueEvt();
                    replOnlyIdmrEvt = new InDoubtQMsgReenqueueEvt();
                    replOnlyIdmrEvt.setReplicateOnly(true);
                    idmrEvt.setReplOnlyEvt(replOnlyIdmrEvt);
                    removed = 0;
                    Object object = this.m_delegator.getSyncObj();
                    // MONITORENTER : object
                    if (this.m_state > 1) break block33;
                    qMsgsToRestore = this.m_outQueue.getPendingQMsgs();
                    break block34;
                }
                while (sync && !this.m_msgsToReenqueue.isEmpty()) {
                    if (this.DEBUG) {
                        this.debug(this + "AgentListener waiting for LogFlushThread to flush and re-enqueue messages,no of messages to re-enqueue-:" + this.m_msgsToReenqueue.size());
                    }
                    try {
                        this.m_logMsgsExpectedIds.wait();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        // MONITOREXIT : vector
                        return;
                    }
                }
                // MONITOREXIT : vector
                if (!this.beginXonceUnsentQMsgsRestore()) return;
                try {
                    vector = this.m_logMsgsExpectedIds;
                    // MONITORENTER : vector
                    while (sync && !this.m_logMsgsExpectedIds.isEmpty()) {
                        try {
                            this.m_logMsgsExpectedIds.wait();
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            // MONITOREXIT : vector
                            this.endXonceUnsentQMsgsRestore();
                            return;
                        }
                    }
                    int count = this.m_msgsToReenqueue.size();
                    if (this.m_logMsgsExpectedIds.isEmpty()) {
                        AgentSender reenqueuer;
                        AgentConnection c = this.m_delegator.getConnection();
                        AgentSender agentSender = reenqueuer = c != null ? c.getAgentSender() : null;
                        if (count > 0) {
                            try {
                                s_reg.getQMsgStateMgr().restoreXOnceMsgsToQueues(this.m_msgsToReenqueue, sync, reenqueuer);
                            }
                            catch (EAsyncOpNotSupported eaonp) {
                                SessionConfig.logMessage(eaonp, SessionConfig.getLevelSevere());
                                throw new EAssertFailure(this + " Unable to reenqueue queue messages.");
                            }
                            this.m_msgsToReenqueue = new Vector();
                        } else if (sync && reenqueuer != null) {
                            reenqueuer.flushReenqueues();
                        }
                    }
                    if (this.m_msgsToReenqueue.isEmpty()) {
                        this.m_logMsgsExpectedIds.notifyAll();
                    }
                    // MONITOREXIT : vector
                    return;
                }
                finally {
                    this.endXonceUnsentQMsgsRestore();
                }
            }
            while (qMsgsToRestore.hasMoreElements()) {
                IMgram msg = (IMgram)qMsgsToRestore.nextElement();
                if (!this.m_outQueue.containsOutgoingMsg(msg)) continue;
                this.m_outQueue.removePendingQmsg(msg.getGuarenteedTrackingNum());
                toRestore.add(msg);
                ++removed;
                if (msg.isNonPersistentReplicated()) {
                    replOnlyIdmrEvt.addTracking(msg.getGuarenteedTrackingNum());
                    continue;
                }
                idmrEvt.addTracking(msg.getGuarenteedTrackingNum());
            }
        }
        // MONITOREXIT : object
        for (int i = 0; i < toRestore.size(); ++i) {
            AgentQueueMsgTracker tracker;
            IMgram qMsg = (IMgram)toRestore.elementAt(i);
            if (!qMsg.isJMSPersistent() || (tracker = AgentQueueMsgTracker.getTracker(qMsg.getGuarenteedTrackingNum())) == null) continue;
            tracker.setReceiverId(0L);
        }
        if (toRestore.isEmpty()) return;
        if (this.DEBUG) {
            this.debug("Restoring " + toRestore.size() + " Queue Msgs to " + q + " sync=" + sync);
        }
        if (this.m_delegator.getConnection().getAgentSender() == null) return;
        this.m_delegator.getConnection().getAgentSender().notifyReenqueue(q, toRestore, sync, idmrEvt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postponeDisconnect() {
        LinkedList unsentGuars;
        if (this.m_preparedDisconnect) {
            return false;
        }
        if (this.m_connection == null || !this.m_connection.getFaultTolerant()) {
            return false;
        }
        if (this.m_disconnectExpired) {
            return false;
        }
        LinkedList<IMgram> inDoubtGuars = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_state == 1) {
                return true;
            }
            try {
                this.m_disconnectTimerId = this.m_delegator.isDurable() ? this.m_id : this.getRootId();
            }
            catch (EClientNotRegistered ignored) {
                return false;
            }
            this.moveMessagesToPendingReconnectQueue();
            unsentGuars = this.removeUnsentGuarMsgs(this.m_outQueue.getPendingGuars());
            this.notifySave(unsentGuars, true);
            IndexedList remainingGuars = this.m_outQueue.newPendingGuarsList();
            if (remainingGuars != null && remainingGuars.count() > 0) {
                inDoubtGuars = new LinkedList<IMgram>();
                Enumeration elements = remainingGuars.elements();
                while (elements.hasMoreElements()) {
                    IMgram nextElement = (IMgram)elements.nextElement();
                    inDoubtGuars.add(nextElement);
                }
                this.notifySave(inDoubtGuars, true);
            }
            this.setMinSendPriority(0);
            this.m_completedDbOverflowChecks = false;
            this.m_startReqs.clear();
            this.m_syncObj.notifyAll();
        }
        this.clearP2PRequests();
        this.saveMgramList(unsentGuars, false, false, false);
        this.saveMgramList(inDoubtGuars, true, true, false);
        this.informAgentSender();
        this.cancelMessageRestore();
        this.startPostponeDisconnect();
        return true;
    }

    private void moveMessagesToPendingReconnectQueue() {
        if (this.m_secctx.isFaultTolerant()) {
            this.setResumable(true);
        }
        this.m_delegator.setState(1);
        if (this.m_delegator.getActivityMonitorHandle() != null) {
            this.m_delegator.getActivityMonitorHandle().stopActivityMonitoring();
        }
        boolean pendingQueueDumped = true;
        Enumeration pendingGuars = this.m_outQueue.getPendingGuars().elements();
        while (pendingGuars.hasMoreElements()) {
            IMgram iMgram = (IMgram)pendingGuars.nextElement();
            if (this.m_groupSubCC != null || this.m_outQueue.hasRoomForPendingReconnect(iMgram)) {
                if (this.DEBUG) {
                    this.debug(this + "postponeDisconnect moving " + iMgram.getGuarenteedTrackingNum() + " from PQ to PRQ");
                }
                if (!this.m_outQueue.containsOutgoingMsg(iMgram)) {
                    this.m_delegator.getGuarDoubtManager().setMessageInDoubt(iMgram.getGuarenteedTrackingNum());
                }
                this.m_outQueue.addPendingReconnect(iMgram);
                this.m_outQueue.removePendingGuar(iMgram.getGuarenteedTrackingNum());
                continue;
            }
            pendingQueueDumped = false;
        }
        if (pendingQueueDumped) {
            this.m_outQueue.releaseWaitQueueToPRQ();
        }
        if (this.DEBUG) {
            this.debug(this + ": saving unsent guar messages.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearP2PRequests() {
        s_reg.getQueueProc().clearGetRequests(this.m_id);
        try {
            s_logmgr.flush(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_delegator.restoreUnsentQMsgs(true);
        IXOnceHandle xOnceHandle = this.m_delegator.getXOnceHandle();
        if (xOnceHandle != null) {
            Object object = this.m_syncObj;
            synchronized (object) {
                Enumeration inDoubtQMsgs = this.m_outQueue.newPendingQMsgsList().elements();
                while (inDoubtQMsgs.hasMoreElements()) {
                    IMgram nextElement = (IMgram)inDoubtQMsgs.nextElement();
                    xOnceHandle.addInDoubtQMsg(nextElement);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelMessageRestore() {
        this.m_delegator.cancelMsgRestore();
        Object object = this.m_syncObj;
        synchronized (object) {
            if ((this.m_isJMSTopic || this.m_isJMSTopicCC) && this.m_restoreNonDurableMsgs && !this.m_hasGuarMsgsInDB) {
                long maxMsgIdToDelete = s_reg.getLogManager().getSeqNo();
                s_reg.getDeleteSubscriptionManager().beginDeleteSubscription(this.m_delegator, maxMsgIdToDelete, false, false);
                this.m_restoreNonDurableMsgs = this.resetAndRetrieveNonDurableMsgs(maxMsgIdToDelete);
            }
        }
    }

    private boolean resetAndRetrieveNonDurableMsgs(long maxMsgIdToDelete) {
        boolean m_restoreNonDurableMsgs = false;
        ICCSizeTracker trk = this.m_delegator.getCCSizeTracker();
        if (trk != null) {
            trk.reset(maxMsgIdToDelete);
        }
        return m_restoreNonDurableMsgs;
    }

    private void startPostponeDisconnect() {
        this.m_outQueue.informStoppedPublishers();
        this.m_outQueue.dumpOutQueue();
        this.disconnectFlowController();
        this.configFlowControlHandlerToNull();
        this.startTimerForPendingReconnect();
        if (this.m_delegator.isGroupSubscriptionMember()) {
            this.m_groupSubCC.notifyGroup();
        }
        if (this.DEBUG) {
            this.debug(this.m_delegator + " starting postponement of disconnect.");
        }
    }

    @Override
    public void recoveryComplete() {
        if (this.m_secctx.isFaultTolerant()) {
            if (!this.m_delegator.isDurable() || this.m_delegator.getLastConnectedTime() == -1L) {
                this.setResumable(true);
            }
            if (this.m_delegator.isDurable() || this.m_isJMSTopicCC || this.m_isJMSTopic) {
                if (this.DEBUG) {
                    this.debug("Setting rebuild subject map for " + this.m_delegator);
                }
                this.m_rebuildSubjectAckMapOnResume = true;
            }
        }
        try {
            this.m_disconnectTimerId = this.m_delegator.isDurable() ? this.m_id : this.getRootId();
        }
        catch (EClientNotRegistered e) {
            this.m_disconnectTimerId = !this.m_secctx.isFaultTolerant() ? this.m_id : this.m_id;
        }
        if (this.m_state == 1) {
            this.startTimerForPendingReconnect();
        }
    }

    private void startTimerForPendingReconnect() {
        if (this.m_secctx.getParentId() == -1L && !this.m_delegator.isDurable()) {
            AgentConnection.reserveConnectionCounts(this.getId(), this.getAppid(), this.m_secctx.getClientIPAddress());
        }
        this.startDisconnectTimer(this.getDisconnectTimeout());
    }

    private final void startDisconnectTimer(long to) {
        if (this.m_state != 1) {
            throw new EAssertFailure(this.getAppid() + "/" + this.getUid() + " ERROR: Attempting to start pending reconnect timer in state: " + this.m_state);
        }
        long expiry = System.currentTimeMillis();
        s_reg.getDisconnectTimerManager().register(this.m_disconnectTimerId, this.m_id, expiry += to, true);
    }

    private long getDisconnectTimeout() {
        long configuredBrokerLimit = Config.CLIENT_RECONNECT_TIMEOUT;
        long brokerLimit = configuredBrokerLimit <= 0L ? Long.MAX_VALUE : configuredBrokerLimit * 1000L;
        if (this.m_secctx != null) {
            long presented = this.m_secctx.getFaultTolerantReconnectTimeout();
            if (presented <= 0L) {
                return brokerLimit;
            }
            if (brokerLimit < presented) {
                return brokerLimit;
            }
            return presented;
        }
        return brokerLimit;
    }

    @Override
    public long getRootId() throws EClientNotRegistered {
        long parentId = this.m_secctx.getParentId();
        long rootId = -1L;
        if (parentId == this.m_id) {
            throw new EAssertFailure("Error obtaining root id. Parent id equals child id: " + this);
        }
        while (parentId != -1L) {
            rootId = parentId;
            IClientContext parent = s_reg.getClient(parentId);
            parentId = parent.getCSC().getParentId();
        }
        if (rootId == -1L) {
            rootId = this.m_id;
        }
        return rootId;
    }

    private final void setResumable(boolean resumable) {
        this.m_isResumable = resumable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect(boolean sync) {
        try {
            this.freezeProxy();
            Object object = this.m_syncObj;
            synchronized (object) {
                if (this.DEBUG) {
                    this.debug("disconnecting");
                }
                this.resetResumeAndNotify();
                this.m_legacySubjectTrackingMap.clear();
                switch (this.m_state) {
                    case -1: 
                    case 0: {
                        return;
                    }
                    case 3: {
                        this.m_startReqs.setSize(0);
                    }
                    case 4: {
                        this.m_msgSavesBeforeWaitQueueInProgress = 0;
                        this.m_maxSeqNoSavedBeforeWaitQueue = -1L;
                        this.m_remoteMsgRestorePos.update(this.m_remoteMsgRestorePos);
                        this.m_delegator.releaseWaitQueue();
                        this.informAgentSender();
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        this.m_startReqs.setSize(0);
                    }
                    case 7: {
                        this.m_msgSavesBeforeWaitQueueInProgress = 0;
                        this.m_maxSeqNoSavedBeforeWaitQueue = -1L;
                        this.m_msgRestorePos.update(this.m_msgRestorePos);
                        this.informAgentSender();
                    }
                    case 1: {
                        this.setResumable(false);
                    }
                    case 2: 
                    case 8: {
                        this.m_delegator.setState(0);
                        this.m_outQueue.setMinDequeuePriority(0);
                        if (this.m_delegator.getActivityMonitorHandle() != null) {
                            this.m_delegator.getActivityMonitorHandle().stopActivityMonitoring();
                        }
                        this.informAgentSender();
                        if (!this.DEBUG) break;
                        this.debug("state set to DISCONNECTED");
                        break;
                    }
                    default: {
                        throw new EAssertFailure(this.m_delegator + ": invalid state " + this.m_state);
                    }
                }
            }
        }
        finally {
            this.unfreezeProxy();
        }
        IClientContext proxy = null;
        boolean proxyMessageDoubt = false;
        if (InterbrokerHook.isSet() && this.m_delegator.getProxyingHandle() != null && this.m_delegator.getCWADSActiveBroker() != null && this.m_delegator.getCWADSActiveBroker() != this.m_delegator) {
            proxy = this.m_delegator.getCWADSActiveBroker();
            this.m_delegator.getProxyingHandle().saveUnsentProxyMessages();
        }
        this.disconnectFlowController();
        this.stopFCMonitorForControlTracker();
        if (this.m_isJMSQueueBrowser) {
            s_reg.getQueueProc().disconnectBrowserClient(this.m_id);
        }
        System.out.print("");
        s_reg.getQueueProc().closeReceiver(this.m_id);
        this.m_delegator.restoreUnsentQMsgs(true);
        try {
            if (this.m_connection != null && this.m_connection.getAgentSender() != null) {
                this.m_connection.getAgentSender().kill(this.m_delegator, sync);
            }
            s_reg.getQueueProc().removeTemporaryQueues(this.m_id);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.m_delegator.isInterbroker()) {
            s_reg.getClusteredQueueManager().disconnectAllClusteredQueueInstances(this.m_idAsLong);
        }
        boolean okToDisconnectClient = false;
        boolean txnParticipant = false;
        ReleasedIndoubtQMsgs releasedQMsgs = null;
        IndexedList xoGroupSends = null;
        LinkedList unsentPRQGuars = null;
        LinkedList unsentGuars = null;
        LinkedList<IMgram> inDoubtGuars = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.DEBUG) {
                this.debug(" -----> CC.disconnect() m_id=" + this.m_id + " appId=" + this.getAppid() + " parentId=" + this.m_secctx.getParentId());
            }
            xoGroupSends = this.m_outQueue.resetUnflushedXOnceGroupSends();
            IXOnceHandle xoh = this.m_delegator.getXOnceHandle();
            if (xoh != null) {
                releasedQMsgs = xoh.releaseInDoubtQMsgs();
            }
            if (!s_txnmgr.isParticipantOfTxn(this.m_id)) {
                this.m_outQueue.restorePendingQmsgs();
                okToDisconnectClient = true;
                if (this.DEBUG) {
                    this.debug(" -----> Restored Messages to Q; no Tx Pending  " + this.m_delegator);
                }
            } else if (s_txnmgr.hasTxns(this.m_delegator.getId())) {
                try {
                    this.disconnectPending = true;
                    s_txnmgr.abortTxns(this.m_id);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                this.disconnectPending = true;
                txnParticipant = true;
                if (this.DEBUG) {
                    this.debug(" -----> Failed to restore, transactions pending " + this.m_delegator);
                }
            }
            if (this.m_delegator.isRemoteBroker() || this.m_delegator.isInterbroker()) {
                if (this.DEBUG) {
                    this.debug(" is routing broker or neighbor");
                }
                s_reg.getRouterManager().disconnect(this.m_id, this.m_disconnectReason);
            }
            unsentPRQGuars = this.m_outQueue.emptySaveablePendingReconnectGuars(!this.m_isJMSTopic && !this.m_isJMSTopicCC);
            this.notifySave(unsentPRQGuars, true);
            IndexedList pendingGuars = this.m_outQueue.newPendingGuarsList();
            unsentGuars = this.removeUnsentGuarMsgs(pendingGuars);
            this.notifySave(unsentGuars, true);
            if (pendingGuars != null && pendingGuars.count() > 0) {
                inDoubtGuars = new LinkedList<IMgram>();
                Enumeration enu = pendingGuars.elements();
                while (enu.hasMoreElements()) {
                    IMgram m = (IMgram)enu.nextElement();
                    inDoubtGuars.add(m);
                }
                this.notifySave(inDoubtGuars, true);
            }
            if (proxy != null && !proxy.isDisconnecting() && !proxy.isDisconnected()) {
                this.m_delegator.getProxyingHandle().addInDoubtProxyMessages(proxy, pendingGuars);
            }
            this.m_outQueue.dumpOutQueue();
            this.m_syncObj.notifyAll();
        }
        this.deallocateXOGroupSends(xoGroupSends);
        try {
            this.handleReleasedIndoubtQMsgs(releasedQMsgs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.saveMgramList(unsentGuars, false, false, false);
        this.saveMgramList(unsentPRQGuars, false, true, false);
        if (inDoubtGuars == null || inDoubtGuars.isEmpty()) {
            this.m_outQueue.dumpOutQueue();
        } else {
            Iterator msgs = inDoubtGuars.iterator();
            if (this.checkDebugFlags(64) && !inDoubtGuars.isEmpty()) {
                this.debug("Disconnect: " + this.m_delegator + " (in-doubt) PendingGuars size= " + inDoubtGuars.size());
            }
            boolean needsLogFlush = false;
            while (msgs.hasNext()) {
                IMgram m = (IMgram)msgs.next();
                if (!m.getBrokerHandle().isFromDB() || this.m_delegator.isGroupSubscriptionMember()) {
                    if (this.DEBUG) {
                        this.debug(this.m_delegator + ": Saving in-doubt message: GUAR:" + m.getGuarenteedTrackingNum());
                    }
                    if (needsLogFlush || m.getBrokerHandle().getProxyRecipsTable() == null || this.m_delegator.getProxyHandle() == null || !m.getBrokerHandle().getProxyRecipsTable().containsKey(this.m_delegator.getId())) continue;
                    if (this.DEBUG) {
                        this.debug(this + " Flushing log before saving in doubt messages for proxying clients.");
                    }
                    needsLogFlush = true;
                    continue;
                }
                if (m.getBrokerHandle().isFromLog()) {
                    try {
                        long tracking = m.getGuarenteedTrackingNum();
                        AgentGuarMsgTracker tracker = AgentGuarMsgTracker.getTracker(tracking);
                        tracker.msgSavedForXOnceClient(this.m_delegator.getId(), false);
                    }
                    catch (ETrackingNumNotFound eTrackingNumNotFound) {
                        // empty catch block
                    }
                }
                msgs.remove();
                this.msgSaveDone(m, true);
            }
            if (!inDoubtGuars.isEmpty()) {
                if (needsLogFlush) {
                    try {
                        s_reg.getLogManager().flush(true);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                proxyMessageDoubt = true;
                this.saveMgramList(inDoubtGuars, true, true, txnParticipant);
            }
        }
        if (proxyMessageDoubt && proxy != null && (proxy.isDisconnecting() || proxy.isDisconnected())) {
            this.m_delegator.getProxyingHandle().notifyProxyInDoubt(proxy);
        }
        this.configFlowControlHandlerToNull();
        this.m_delegator.cancelMsgRestore();
        this.m_delegator.getGuarDoubtManager().syncRedeliveries();
        s_reg.getMsgRestoreMgr().clearRestoreState(this.m_id);
        if (okToDisconnectClient) {
            s_reg.getQueueProc().disconnectClient(this.m_id);
        }
        if (!txnParticipant && (this.m_delegator.isGroupSubscriptionMember() || this.m_delegator.isInterbroker())) {
            this.m_outQueue.clearGroupSubGuarPending();
        }
        this.assignConnection(null);
        if (!this.DEBUG) return;
        this.debug("disconnect complete");
    }

    private void freezeProxy() {
        if (this.m_delegator.getProxyingHandle() != null) {
            this.m_delegator.getProxyingHandle().freezeProxy();
        }
    }

    private void unfreezeProxy() {
        if (this.m_delegator.getProxyingHandle() != null) {
            this.m_delegator.getProxyingHandle().unfreezeProxy();
        }
    }

    private void resetResumeAndNotify() {
        if (this.m_rebuildSubjectAckMapOnResume) {
            this.m_rebuildSubjectAckMapOnResume = false;
            this.m_syncObj.notifyAll();
        }
    }

    private void stopFCMonitorForControlTracker() {
        if (this.m_CCFlowControlTracker != null) {
            this.m_CCFlowControlTracker.stopFCMonitor();
        }
    }

    private void configFlowControlHandlerToNull() {
        if (this.m_ptpFlowControlHandler != null) {
            this.m_ptpFlowControlHandler = null;
        }
    }

    private void handleReleasedIndoubtQMsgs(ReleasedIndoubtQMsgs released) throws InterruptedException {
        if (released != null) {
            LinkedList ll;
            IStateEvent indoubtEvt = released.getReenqueueEvt();
            if (indoubtEvt != null) {
                if (indoubtEvt.getReplOnlyEvt() != null) {
                    s_reg.getLogManager().addEvent(indoubtEvt.getReplOnlyEvt(), false);
                }
                s_reg.getLogManager().addEvent(indoubtEvt, false);
            }
            if ((ll = released.getCancelledList()) != null) {
                Iterator iter = ll.iterator();
                while (iter.hasNext()) {
                    long id = (Long)iter.next();
                    AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(id);
                    if (tracker == null) continue;
                    tracker.canceled(false);
                }
            }
        }
    }

    @Override
    public void setDisconnectAfterFinalRemoteRestore(boolean flag) {
    }

    @Override
    public boolean getDisconnectAfterFinalRemoteRestore() {
        return false;
    }

    @Override
    public boolean isDisconnectPending() {
        return this.disconnectPending;
    }

    @Override
    public void setDisconnecting(boolean val) {
        this.m_disconnecting = val;
        if (!val) {
            this.m_preparedDisconnect = val;
        } else if (!this.isDurable()) {
            this.m_delegator.checkFTDNotifyEventRequired(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMsgsInDb(boolean msgsInDb) {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (!msgsInDb && this.okToRestoreOffloadedMessages()) {
                if (!this.m_outQueue.getOffloadedPubSubQueue().isEmpty() || this.m_msgsToBeAddedToOffloadedQueue > 0 || this.m_msgSavesInProgress > 0) {
                    return;
                }
                if (this.m_isJMSTopic || this.m_isJMSTopicCC) {
                    this.m_restoreNonDurableMsgs = false;
                    this.m_hasGuarMsgsInDB = false;
                }
            }
            this.m_msgsInDb = msgsInDb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMsgsInDb() {
        Object object = this.m_syncObj;
        synchronized (object) {
            return this.m_msgsInDb;
        }
    }

    @Override
    public boolean isDisconnecting() {
        return this.m_disconnecting;
    }

    @Override
    public boolean isMgramQueueEmpty() {
        return this.m_outQueue.isOutQueueEmpty();
    }

    @Override
    public IMgram getNextMgram() {
        IMgram m = null;
        try {
            m = this.getNextMgram(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMgram getNextMgram(boolean wait) throws InterruptedException {
        IMgram m = null;
        boolean expired = false;
        Vector<IMgram> expiredMsgs = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            do {
                if (wait) {
                    while (this.m_state == 1) {
                        this.m_syncObj.wait();
                    }
                    m = (IMgram)this.m_outQueue.dequeueWait();
                } else {
                    if (this.m_state == 1) {
                        return null;
                    }
                    m = (IMgram)this.m_outQueue.dequeue();
                }
                expired = false;
                if (m == null || this.m_isJMSQueueReceiver || this.m_isJMSQueueBrowser || this.m_delegator.isUnregistered()) continue;
                if (m.getType() != 27) {
                    if (!this.hasExpired(m)) continue;
                    if (m.isGuarenteed()) {
                        this.m_outQueue.removeMsgFromGuar(m);
                    }
                    if (expiredMsgs == null) {
                        expiredMsgs = new Vector<IMgram>();
                    }
                    expiredMsgs.addElement(m);
                    expired = true;
                    continue;
                }
                IMgram batch = m;
                if (!batch.isTTE() || batch.getTTE() >= System.currentTimeMillis()) continue;
                expired = true;
                if (expiredMsgs == null) {
                    expiredMsgs = new Vector();
                }
                if (batch.getBatchHandle().isAtomic()) {
                    this.m_outQueue.removeMsgFromGuar(batch);
                    expiredMsgs.addElement(batch);
                    continue;
                }
                Iterator iter = batch.getBatchHandle().getBatchIterator();
                while (iter.hasNext()) {
                    IMgram sub = (IMgram)iter.next();
                    this.m_outQueue.removeMsgFromGuar(sub);
                    expiredMsgs.addElement(sub);
                }
            } while (m != null && expired);
            if (expiredMsgs != null) {
                this.m_expiredMsgsPendingCount += expiredMsgs.size();
            }
        }
        this.handleExpiredMessagesAndRemoveElements(expiredMsgs);
        return m;
    }

    @Override
    public Object waitNextMgram() throws InterruptedException {
        return this.getNextMgram(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMinSendPriority(int prio) {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_outQueue.setMinDequeuePriority(prio);
        }
        if (this.m_CCFlowControlTracker != null) {
            this.m_CCFlowControlTracker.checkTopicResume(prio);
        }
        this.informAgentSender();
    }

    @Override
    public int getMinSendPriority(PublishLimiterNotify notifyLimiter) {
        return this.m_outQueue.getMinEnqueuePriority(notifyLimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean okToDispatchQueueMsgs(IMinEnqueuePriorityListener listener) {
        if (!Config.PTP_GUAR_MSG_BUFFER_LIMIT_CHECK) {
            return this.m_state > 2;
        }
        boolean okToDispatch = true;
        Object object = this.m_outQueue.getMinEnqueuePriorityListenerLock();
        synchronized (object) {
            int prio = this.m_outQueue.getQmsgMinEnqueuePriority(null);
            okToDispatch = this.populateMinEnqueueListenerAndRetrieveDispatch(prio, listener, okToDispatch);
        }
        return okToDispatch &= this.m_state > 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean okToDispatch(IMinEnqueuePriorityListener iMinEnqueueListener) {
        boolean okToDispatch = true;
        Object object = this.m_outQueue.getMinEnqueuePriorityListenerLock();
        synchronized (object) {
            int prio = this.m_outQueue.getMinEnqueuePriority(null);
            okToDispatch = this.populateMinEnqueueListenerAndRetrieveDispatch(prio, iMinEnqueueListener, okToDispatch);
        }
        return okToDispatch;
    }

    private boolean populateMinEnqueueListenerAndRetrieveDispatch(int prio, IMinEnqueuePriorityListener iMinEnqueueListener, boolean okToDispatchParam) {
        boolean okToDispatch = okToDispatchParam;
        if (prio > 9) {
            this.m_outQueue.addIMinEnqueuePriorityListener(iMinEnqueueListener);
            okToDispatch = false;
        }
        return okToDispatch;
    }

    @Override
    public boolean okToDispatchRemote() {
        return this.m_state == 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearExpiredMsgs() throws InterruptedException {
        Vector v = null;
        if (this.m_delegator.isUnregistered()) {
            return;
        }
        Object object = this.m_syncObj;
        synchronized (object) {
            v = this.m_outQueue.clearExpiredMsgs();
            if (v != null) {
                this.m_expiredMsgsPendingCount += v.size();
            }
        }
        this.handleExpiredMessagesAndRemoveElements(v);
    }

    private void handleExpiredMessagesAndRemoveElements(Vector v) throws InterruptedException {
        if (v != null) {
            this.m_delegator.handleExpiredMsgs(v);
            v.removeAllElements();
        }
    }

    @Override
    public void clearDbExpiredMsg(long tracking) {
        if (this.m_delegator.isUnregistered()) {
            return;
        }
        this.m_delegator.removeMsgPendingAck(tracking);
        this.m_delegator.getGuarDoubtManager().msgAcknowledged(tracking, false);
        this.m_outQueue.removeGroupSubGuarPending(tracking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void handleExpiredMsgs(Vector v) throws InterruptedException {
        qproc = AgentRegistrar.getAgentRegistrar().getQueueProc();
        block12: for (i = 0; i < v.size(); ++i) {
            m = (IMgram)v.elementAt(i);
            if (m.getType() != 25) ** GOTO lbl-1000
            switch (m.getOperationHandle().getOperationType()) {
                case 3: {
                    try {
                        clientID = m.getPayloadInputStreamHandle().readLong();
                        target = BaseClientContext.s_reg.getClient(clientID);
                        m = (IMgram)m.getOperationHandle().getMgramList().getFirst();
                        target.removeMsgPendingAck(m.getGuarenteedTrackingNum());
                        target.handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
                        continue block12;
                    }
                    catch (EClientNotRegistered clientID) {
                    }
                    catch (IOException clientID) {
                        // empty catch block
                    }
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (m.isQueueMessage()) {
                        reason = this.narrowExpiryReason(m);
                        qproc.processUndelivered(m, reason, true);
                        continue block12;
                    }
                    this.delegatorHandleNormalAck(m);
                }
            }
        }
        unregister = false;
        var4_4 = this.m_syncObj;
        synchronized (var4_4) {
            this.m_expiredMsgsPendingCount -= v.size();
            if (this.m_expiredMsgsPendingCount == 0 && this.m_delegator.okToUnregister()) {
                unregister = true;
            }
        }
        if (unregister) {
            this.m_delegator.lock();
            try {
                BaseClientContext.s_reg.checkUnregister(this.m_delegator);
            }
            finally {
                this.m_delegator.unlock();
            }
        }
    }

    private int narrowExpiryReason(IMgram m) {
        int preCheckReason;
        if (this.m_preChecker != null && (preCheckReason = this.m_preChecker.precheck(m)) != 0) {
            return preCheckReason;
        }
        return 1;
    }

    private boolean hasExpired(IMgram m) {
        if (m.getNoOutqueueExpire()) {
            return false;
        }
        if (m.isTTE() && m.getTTE() < System.currentTimeMillis()) {
            return true;
        }
        return this.m_preChecker != null && this.m_preChecker.precheck(m) != 0;
    }

    private void informAgentSender() {
        this.informAgentSender(false);
    }

    private void informAgentSender(boolean canDelay) {
        AgentConnection connection = this.m_connection;
        if (connection == null) {
            return;
        }
        AgentSender as = connection.getAgentSender();
        if (as != null) {
            connection.getAgentSender().notifyEnqueue(this, canDelay);
        }
    }

    @Override
    public final void notifyMsgEnqueued() {
        this.informAgentSender();
    }

    @Override
    public final void notifyPTPFlowControlRelease() {
        this.informAgentSender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAcknowledgment(long tracking) {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_delegator.getGuarDoubtManager().msgAcknowledged(tracking, true);
        }
    }

    @Override
    public int getChannel() {
        AgentConnection connection = this.m_connection;
        if (connection == null) {
            return -1;
        }
        return connection.getChannel(this.m_id);
    }

    @Override
    public byte getClientSessionVer() {
        return this.m_connection == null ? (byte)32 : this.m_connection.getClientSessionVer();
    }

    @Override
    public void prepareDisconnect(int reason) {
        this.m_disconnecting = true;
        this.m_preparedDisconnect = true;
        this.setDisconnectReason(reason);
    }

    @Override
    public boolean onStateChanged(int currentState) {
        if (this.DEBUG) {
            this.debug("state changed to " + currentState + ", cid = " + this.m_id);
        }
        return true;
    }

    @Override
    public boolean setState(int currentState) {
        if (this.DEBUG) {
            this.debug("changing state to " + currentState + ", cid = " + this.m_id);
        }
        this.m_state = currentState;
        this.m_lastStateChangeTime = System.currentTimeMillis();
        switch (currentState) {
            case 8: {
                if (this.m_delegator.isRemoteBroker() || this.m_delegator.isInterbroker()) {
                    s_reg.getQueueProc().getRemoteBrokerHelper().wakeUpConnectThread();
                }
                this.delegatorStartActivityMonitoring();
            }
            case 5: {
                if (this.m_outQueue.getOffloadedPubSubQueue().isEmpty()) break;
                this.checkAndReplaceThread();
                if (this.m_offloadedMsgRestorer == null) {
                    this.m_offloadedMsgRestorer = new OffloadedMsgRestorer(this.m_delegator, s_reg.getMsgSaver());
                    this.m_offloadedMsgRestorer.start();
                }
                this.m_syncObj.notifyAll();
                break;
            }
            case 7: {
                this.m_outQueue.dbSpaceReleaseBlockedPublishers();
                break;
            }
            case 4: {
                if (this.m_delegator.getCWADSRestoringBroker() == null) break;
                this.m_outQueue.dbSpaceReleaseBlockedPublisher(this.m_delegator.getCWADSRestoringBroker().getId(), true);
                break;
            }
        }
        return true;
    }

    private void checkAndReplaceThread() {
        if (this.m_offloadedMsgRestorer != null && !this.m_offloadedMsgRestorer.isAlive()) {
            this.m_offloadedMsgRestorer = null;
            this.m_delegator.checkFTDNotifyEventRequired(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForPendingResumeAttempt() throws InterruptedException {
        Object object = this.m_syncObj;
        synchronized (object) {
            while (this.m_resumeAttemptInProgress && this.m_state > -1) {
                this.m_syncObj.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttemptingResume(boolean flag) {
        this.m_resumeAttemptInProgress = flag;
        if (!flag) {
            Object object = this.m_syncObj;
            synchronized (object) {
                this.m_syncObj.notifyAll();
            }
        }
    }

    @Override
    public boolean isResumeAttemptInProgress() {
        return this.m_resumeAttemptInProgress;
    }

    @Override
    public void createMsgRestorerAndStart(boolean durableSMO, boolean doRemoteRestorePhases, boolean isRestoringBroker) {
        if (this.DEBUG) {
            this.debug(" m_id: " + this.m_id + " doRemoteRestorePhases: " + doRemoteRestorePhases + " isRestoringBroker: " + isRestoringBroker);
        }
        if (this.m_delegator.isGroupSubscriptionMember()) {
            this.m_delegator.restoreComplete(this.m_msgRestorePos);
            this.m_delegator.getGroupSubscriptionCC().notifyGroupRestoreThreads();
            return;
        }
        if (doRemoteRestorePhases) {
            this.setState(3);
            if (this.DEBUG) {
                this.debug("state set to INIT_REMOTE_RESTORE");
            }
        } else {
            this.m_delegator.setState(6);
            if (this.DEBUG) {
                this.debug("state set to INIT_RESTORE getId(): " + this.getId());
            }
        }
        if (this.m_delegator.isGroupSubscription()) {
            long l = this.findMaxDeleteMsgIdAndUpdateRestorePos();
        }
        this.m_msgRestorer = new MsgRestorerBase(this.m_delegator, this.m_msgRestorePos, durableSMO, doRemoteRestorePhases, isRestoringBroker, this.m_remoteMsgRestorePos);
        this.m_msgRestorer.start();
        if (this.m_delegator.isGroupSubscription()) {
            this.m_groupOffloadCancelled = false;
        }
        this.delegatorStartActivityMonitoring();
    }

    private void delegatorStartActivityMonitoring() {
        if (this.m_delegator.getActivityMonitorHandle() != null) {
            this.m_delegator.getActivityMonitorHandle().startActivityMonitoring();
        }
    }

    private long findMaxDeleteMsgIdAndUpdateRestorePos() {
        this.m_msgRestorePos.reset();
        this.m_remoteMsgRestorePos.reset();
        long msgId = AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().getMaxDeleteMsgId(this.m_id);
        if (msgId > -1L) {
            this.m_msgRestorePos.update(msgId, this.m_msgRestorePos.getSeqno());
            this.m_remoteMsgRestorePos.update(msgId, this.m_remoteMsgRestorePos.getSeqno());
        }
        return msgId;
    }

    @Override
    public void reconnectTimeOutExpired(boolean sync) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("posponed disconnect period expired !");
        }
        if (this.m_secctx.getParentId() == -1L && !this.m_delegator.isDurable()) {
            AgentConnection.releaseConnectionCounts(this.getId(), this.getConnection());
        }
        this.m_disconnectExpired = true;
        s_reg.disconnect(this.m_id, sync);
    }

    @Override
    public IActivityMonitorHandle getActivityMonitorHandle() {
        return null;
    }

    @Override
    public boolean hasStoppedPublishers() {
        return this.m_outQueue.hasFlowControlledPublishers();
    }

    @Override
    public boolean isWaitingForRestoreSpace() {
        return this.m_waitingForRestoreSpace;
    }

    @Override
    public boolean needsGuarAck() {
        return false;
    }

    @Override
    public void rcvdGuarQMsg(long backTracking, IMsgTracker tracker) {
    }

    @Override
    public final void rcvdGuarMsg(long backTracking, IMsgTracker tracker) {
    }

    @Override
    public List getGuarQMsgTrkNums() {
        return null;
    }

    @Override
    public List getGuarMsgTrkNums() {
        return null;
    }

    @Override
    public void setQAckPendingConfirm(long acktracking, long tracking) {
    }

    @Override
    public List getUnconfirmedGuarQAcks() {
        return new Vector();
    }

    @Override
    public void sendAckAck(IMgram ack) {
        if (ack != null && ack.isGuarenteed() && !ack.getBrokerHandle().isTransactionalPublish() && !ack.getBrokerHandle().isAckNoReply()) {
            if (this.DEBUG) {
                this.debug("Sending Ack Confirm: ack tracking: " + ack.getGuarenteedTrackingNum());
            }
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildAck(ack.getGuarenteedTrackingNum(), (short)0, ack.getChannel()));
        }
    }

    @Override
    public final void sendAck(IMgram m) {
        this.m_delegator.sendAck(m.getGuarenteedTrackingNum(), m, -1L);
    }

    @Override
    public final void sendAck(long backTracking, IMgram m) {
        this.m_delegator.sendAck(backTracking, m, -1L);
    }

    @Override
    public final void sendErrorAck(IMgram m, short errorCode, boolean queueAckParam) {
        boolean queueAck = queueAckParam;
        if (!m.isGuarenteed() && m.isRejectable()) {
            if (m.isSecure() && Config.ENABLE_SECURITY) {
                try {
                    Boolean val;
                    byte sa = s_reg.getMsgProc().handleQopSecurity(m, true, true);
                    if (SecurityLogic.getPubAttr(sa) != 2 && m.hasSidebandData() && (val = (Boolean)m.getSidebandData().getProperty("JMS_SonicMQ_perMessageEncryption")) != null && val.booleanValue()) {
                        try {
                            sa = SecurityLogic.AttribsFromPublic((byte)4, (byte)2);
                        }
                        catch (ESecurityInvalidLogistics e) {
                            throw new EAssertFailure(e);
                        }
                    }
                    m.setSecurityAttribute(sa);
                }
                catch (EIntegrityCompromised e) {
                    throw new EAssertFailure(e);
                }
            }
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildRejectionAckOp(m, errorCode, null, this.m_delegator.getChannel()));
            return;
        }
        boolean bl = queueAck = queueAck || this.m_delegator.isRemoteBroker() && m.getRouting() != null;
        if (queueAck) {
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildQAck(m.getGuarenteedTrackingNum(), -1L, errorCode, false, 0L, false, 0, this.m_delegator.getChannel()));
        } else {
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildAck(m.getGuarenteedTrackingNum(), errorCode, this.m_delegator.getChannel()));
        }
    }

    @Override
    public final void sendAck(long backTracking, IMgram m, long redirectClient) {
        if (this.m_delegator.isRemoteBroker() && (m == null || m.getRouting() != null)) {
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildQAck(backTracking, redirectClient, (short)0, false, 0L, false, 0, this.m_delegator.getChannel()));
        } else {
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildAck(backTracking, redirectClient, (short)0, false, 0L, false, 0, this.m_delegator.getChannel()));
        }
    }

    @Override
    public final void sendQAck(long backTracking, IMgram m) {
        if (this.m_delegator.isInterbroker() && InterbrokerHook.isSet() || this.m_delegator.isRemoteBroker()) {
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildQAck(backTracking, -1L, (short)0, false, 0L, false, 0, this.m_delegator.getChannel()));
        } else {
            this.m_delegator.sendThrough(MgramFactory.getMgramFactory().buildAck(backTracking, (short)0, false, 0L, false, 0, this.m_delegator.getChannel()));
        }
    }

    @Override
    public void setGuarAckPendingConfirm(long acktracking, long tracking) {
    }

    @Override
    public List getUnconfirmedGuarAcks() {
        return new Vector();
    }

    @Override
    public boolean handleGuarQAckAck(long ackTracking) {
        return false;
    }

    @Override
    public boolean handleGuarAckAck(long ackTracking) {
        return false;
    }

    @Override
    public void guarQAcksDone(List acked) {
    }

    @Override
    public void guarAcksDone(List acked) {
    }

    @Override
    public void notifyRequestsPendingReply(List pending) {
    }

    @Override
    public void rcvdXORequest(long reqId, IMgram mgram) {
    }

    @Override
    public void prepareXOReply(long reqId, IMgram mgram) {
    }

    @Override
    public void sendReply(int reqId, IMgram mgram) {
        this.sendThrough(mgram);
    }

    @Override
    public boolean handleXOReplyAck(long replyAckTracking) {
        return false;
    }

    @Override
    public List getPendingReplies() {
        return new Vector();
    }

    @Override
    public ICCSizeTracker getCCSizeTracker() {
        return this.m_ccSizeTracker;
    }

    @Override
    public boolean isXOnce() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setRecoveredGroupDNRPending(IMgram msg) {
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            if (!this.isConnected()) {
                return false;
            }
            if (this.m_outQueue.isGroupSubGuarPending(msg.getGuarenteedTrackingNum())) {
                try {
                    this.m_outQueue.setGuarMsgPending(msg);
                }
                catch (EDuplicateKey eDuplicateKey) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMgram removeQMsgPendingAck(long tracking) {
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            return this.m_outQueue.removePendingQmsg(tracking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IMgram removeMsgPendingAck(long tracking) {
        IMgram ret = null;
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            ret = this.m_outQueue.removePendingGuar(tracking);
            if (ret == null) {
                ret = this.m_outQueue.removePendingReconnectGuar(tracking);
            }
        }
        if (this.m_delegator.isGroupSubscriptionMember()) {
            IMgram groupPendingMgram = null;
            groupPendingMgram = this.m_delegator.getGroupSubscriptionCC().removeMsgPendingAck(tracking);
            if (groupPendingMgram != null && ret == null) {
                ret = groupPendingMgram;
            }
        }
        return ret;
    }

    @Override
    public void inDoubtQMsgAcked(long tracking) {
        throw new UnsupportedOperationException(this + "inDoubtQMsgAcked(long tracking)");
    }

    @Override
    public void inDoubtMsgAcked(long tracking) {
        throw new UnsupportedOperationException(this + "inDoubtMsgAcked(long tracking)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allInDoubtMsgsAcked(List leavePendingQ, List leavePendingGuar, List leavePendingRsp) {
        if (this.getClientSessionVer() >= 28) {
            return;
        }
        Object object = this.m_syncObj;
        synchronized (object) {
            if (leavePendingGuar == null || leavePendingGuar.isEmpty()) {
                if (this.m_rebuildSubjectAckMapOnResume) {
                    this.debugWithCheck("No DNR messages so subject ack mappings not being rebuilt for " + this.getAppid());
                    this.m_rebuildSubjectAckMapOnResume = false;
                    this.m_syncObj.notifyAll();
                }
                return;
            }
            TreeSet<Long> dnrs = new TreeSet<Long>(leavePendingGuar);
            List<Long> setPending = this.findPendings(dnrs);
            this.movePendingMessages(setPending);
            if (this.m_rebuildSubjectAckMapOnResume) {
                if (dnrs.isEmpty()) {
                    this.debugWithCheck("All required subject ack mapping dnrs found in PRQ for " + this.getAppid());
                    this.m_rebuildSubjectAckMapOnResume = false;
                    this.m_syncObj.notifyAll();
                } else {
                    this.debugWithCheck("Retrieving remaining subject ack mappings from DB for " + this.getAppid() + ": " + dnrs);
                    Long highestDnr = dnrs.last();
                    s_reg.getMsgSaver().retrieveSubjectAckMappings(this.m_delegator, highestDnr);
                }
            }
        }
    }

    private List<Long> findPendings(Set<Long> dnrs) {
        Iterator msgs = this.m_outQueue.getPendingReconnectGuars();
        ArrayList<Long> setPending = null;
        while (msgs.hasNext()) {
            IMgram mgram = (IMgram)msgs.next();
            if (!mgram.hasSubject() || !mgram.getSubject().isMultiSubject()) continue;
            ISubjectFilter filter = mgram.getBrokerHandle().getSubjectFilter(this.m_delegator.getSubjectFilterId());
            Collection undelSubjects = filter.filterTrackingNums(mgram.getSubject());
            Iterator sTrackings = undelSubjects.iterator();
            while (sTrackings.hasNext()) {
                Long sTracking = mgram.getGuarenteedTrackingNum() + (long)((Short)sTrackings.next()).shortValue();
                if (this.m_rebuildSubjectAckMapOnResume) {
                    this.debugWithCheck("Adding legacy subject ack mapping for " + this.getAppid() + ": " + sTracking + "/" + mgram.getGuarenteedTrackingNum());
                    this.m_legacySubjectTrackingMap.put((long)sTracking, Long.valueOf(mgram.getGuarenteedTrackingNum()));
                }
                if (!dnrs.remove(sTracking)) continue;
                sTrackings.remove();
            }
            if (undelSubjects.isEmpty()) {
                if (setPending == null) {
                    setPending = new ArrayList<Long>();
                }
                setPending.add(mgram.getGuarenteedTrackingNum());
                this.debugWithCheck("Found MT message that needs removal: " + this.getAppid() + ": " + mgram.getGuarenteedTrackingNum() + " - " + filter.filterSize());
                continue;
            }
            this.debugWithCheck("Found MT message with undel subjects: " + undelSubjects);
        }
        return setPending;
    }

    private void movePendingMessages(List<Long> setPending) {
        if (setPending != null) {
            for (Long tracking : setPending) {
                try {
                    this.m_outQueue.setGuarMsgPending(this.m_outQueue.removePendingReconnectGuar(tracking));
                }
                catch (EDuplicateKey eDuplicateKey) {}
            }
        }
    }

    private void debugWithCheck(String message) {
        if (this.DEBUG) {
            this.debug(message);
        }
    }

    @Override
    public void expireInDoubt() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasInDoubtState() {
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            return this.m_outQueue.countPending() > 0;
        }
    }

    @Override
    public int getPendingQCount() {
        return this.m_outQueue.countQPending();
    }

    @Override
    public int getPendingGuarCount() {
        return this.m_outQueue.countGuarPending();
    }

    @Override
    public void setInDoubtTime() {
        this.m_inDoubtTime = System.currentTimeMillis();
    }

    @Override
    public long getInDoubtTime() {
        return this.m_inDoubtTime;
    }

    @Override
    public List getPendingRequests() {
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initRestoreFlowControlPublisher(PublishLimiter pubLimiter) {
        if (pubLimiter != null) {
            Object object = this.m_syncObj;
            synchronized (object) {
                this.m_outQueue.initRestoreFlowControlPublisher(pubLimiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseInitRestoreBlockedPublishers() {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_outQueue.initRestoreReleaseBlockedPublishers();
        }
    }

    @Override
    public BrokerSubscription getSpecialGroupSubscription() {
        return this.m_specialGroupSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkSpecialGroupSubscription() {
        if (this.getClientSessionVer() >= 25) {
            this.m_specialGroupSub = null;
        } else {
            SubscriptionsTable subscriptionsTable = this.m_subscriptions;
            synchronized (subscriptionsTable) {
                Enumeration brokerSubs = this.m_subscriptions.elements();
                this.m_specialGroupSub = null;
                int subCount = 0;
                while (brokerSubs.hasMoreElements()) {
                    BrokerSubscription bs = (BrokerSubscription)brokerSubs.nextElement();
                    ISubject bsSubject = bs.getSubject();
                    if (SessionConfig.isSystemSubject(bsSubject)) continue;
                    ++subCount;
                    if (bsSubject.hasGroup()) {
                        this.m_specialGroupSub = bs;
                    }
                    if (subCount <= 1 || this.m_specialGroupSub == null) continue;
                    if (this.DEBUG) {
                        this.debug("Found EXTRA BrokerSubscription in pre-5.0 BaseClientContext -- removing it from Group");
                    }
                    AgentRegistrar.getAgentRegistrar().getGroupSubscriptions().removeSubscription(this.m_specialGroupSub);
                    this.m_specialGroupSub = null;
                }
                if (this.DEBUG) {
                    this.debug("Setting special Group Subscription for pre-Tahiti clients: " + this.m_specialGroupSub);
                }
            }
        }
    }

    @Override
    public void rcvdSingleTargetMsg(IMgram msg) {
        throw new EAssertFailure("ERROR: " + this.m_delegator.toString() + " shouldn't receive targeted messages!");
    }

    private void notifySave(LinkedList msgList, boolean postponedSave) {
        if (msgList == null || msgList.isEmpty()) {
            return;
        }
        for (IMgram m : msgList) {
            this.notifySave(m, postponedSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySave(IMgram message, boolean postponedSave) {
        if (this.m_delegator.isGroupSubscriptionMember() || message.getBrokerHandle().getGroupSubscriptionCC() != -1L && !this.m_delegator.isGroupSubscription()) {
            return;
        }
        boolean forRemoteBroker = InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(message.getBrokerHandle().getSenderID());
        Object object = this.m_syncObj;
        synchronized (object) {
            ++this.m_msgSavesInProgress;
            if (this.DEBUG) {
                this.debug(this + ": Setting msgsInDb = true");
            }
            this.m_msgsInDb = true;
            if (this.m_isJMSTopic || this.m_isJMSTopicCC) {
                this.m_restoreNonDurableMsgs = true;
                if (message.isGuarenteed()) {
                    this.m_hasGuarMsgsInDB = true;
                }
            }
            if (postponedSave) {
                ++this.m_msgPostponedSavesInProgress;
            }
            if (forRemoteBroker && this.m_delegator.isDurable()) {
                ++this.m_msgSavesForRemoteBrokerInProgress;
            }
        }
    }

    @Override
    public long getLastConnectedTime() {
        return this.m_lastConnectedTime;
    }

    @Override
    public void setLastConnectedTime(long connectionTime) {
        this.m_lastConnectedTime = connectionTime;
    }

    @Override
    public IProxyHandle getProxyHandle() {
        return null;
    }

    @Override
    public IProxyingHandle getProxyingHandle() {
        return null;
    }

    @Override
    public short getAckMode() {
        return this.m_ackMode;
    }

    @Override
    public void setAckMode(short mode) {
        short oldMode = this.m_ackMode;
        this.m_ackMode = mode;
        if (this.m_delegator.isDurable() && oldMode != this.m_ackMode) {
            GroupSubscription group;
            BaseClientContext.s_reg.m_regSub.batchFlagsDirty();
            BrokerSubscription durableSub = this.m_delegator.getDurableBrokerSubscription();
            if (durableSub != null && durableSub.isGroupMember() && (group = s_reg.getGroupSubscriptions().getGroup(durableSub.getSubject())) != null) {
                group.resetDupsOK();
            }
        }
    }

    @Override
    public IXOnceHandle getXOnceHandle() {
        return null;
    }

    @Override
    public IWindowAckManager getWindowAckManager() {
        return null;
    }

    @Override
    public ICCGuarDoubtManager getGuarDoubtManager() {
        return this.m_guarDoubtManager;
    }

    @Override
    public void msgDeleteDone(long tracking) {
        this.m_guarDoubtManager.msgDeleteDone(tracking);
    }

    @Override
    public void addLBSWrapperInfo(long tracking, FastVector groupMemberIds) {
        Config.logMessage(new IllegalStateException(), 1);
    }

    @Override
    public void removeLBSWrapperInfo(long tracking) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFTDNotifyEventRequired(boolean starting) {
        Object object = this.m_ftdNotificationSyncObj;
        synchronized (object) {
            if (Config.FLOW_TO_DISK_NOTIFY) {
                if (this.m_sentOffloadingStartedEvent && !starting) {
                    this.m_sentOffloadingStartedEvent = false;
                    OffloadedMsgRestorer.sendFlowToDiskStateChangeNotification(this.m_delegator, false);
                } else if (!this.m_sentOffloadingStartedEvent && starting) {
                    this.m_sentOffloadingStartedEvent = true;
                    OffloadedMsgRestorer.sendFlowToDiskStateChangeNotification(this.m_delegator, true);
                }
            }
        }
    }

    private void saveMgramList(LinkedList msgList, boolean jmsRedelivery, boolean checkDoubt, boolean groupTxnParticipant) {
        if (msgList != null) {
            for (IMgram m : msgList) {
                boolean inDoubt = false;
                if (checkDoubt) {
                    inDoubt = this.m_guarDoubtManager.isMessageInDoubt(m.getGuarenteedTrackingNum());
                }
                this.saveMgram(m, m.isSuccessor() || jmsRedelivery || inDoubt, inDoubt, groupTxnParticipant);
            }
        }
    }

    private void saveMgram(IMgram m, boolean jms_redelivery, boolean inDoubt, boolean groupTxnParticipant) {
        ClientContextMgramQueue.InDoubtXOGroupSend idgs = this.m_outQueue.getInDoubtXOGroupSend(m.getGuarenteedTrackingNum());
        if (idgs != null) {
            this.msgSaveDone(m, true);
            idgs.groupcc.saveInDoubtXOGroupMessage(m, this.m_delegator, jms_redelivery, inDoubt);
        } else if (m.getBrokerHandle().getGroupSubscriptionCC() != -1L) {
            try {
                IClientContext cc = s_reg.getClient(m.getBrokerHandle().getGroupSubscriptionCC());
                if (cc.isGroupSubscription()) {
                    ((GroupSubscriptionClientContext)cc).processGroupMemberMgram(m, null, this.m_delegator, jms_redelivery, inDoubt, true);
                }
            }
            catch (EClientNotRegistered eClientNotRegistered) {}
        } else if (this.m_delegator.isGroupSubscriptionMember()) {
            if (groupTxnParticipant) {
                this.m_delegator.getGuarDoubtManager().addPendingGroupTxnMessage(m.getGuarenteedTrackingNum());
                try {
                    this.m_groupSubCC.getOutQueue().setGuarMsgPending(m);
                }
                catch (EDuplicateKey eDuplicateKey) {}
            } else {
                this.m_delegator.getGuarDoubtManager().removeMessageInDoubt(m.getGuarenteedTrackingNum());
                this.m_groupSubCC.processGroupMemberMgram(m, null, this.m_delegator, jms_redelivery, inDoubt, true);
            }
        } else if (!m.getBrokerHandle().isFromDB()) {
            s_reg.getMsgSaver().save(m, this.m_delegator, jms_redelivery, inDoubt, true);
        } else {
            this.msgSaveDone(m, true);
        }
    }

    @Override
    public boolean isGroupSubscriptionMember() {
        return this.m_groupSubCC != null;
    }

    @Override
    public boolean isGroupSubscription() {
        return false;
    }

    @Override
    public void setGroupSubscriptionCC(GroupSubscriptionClientContext cc) {
        this.m_groupSubCC = cc;
    }

    @Override
    public GroupSubscriptionClientContext getGroupSubscriptionCC() {
        return this.m_groupSubCC;
    }

    @Override
    public void processGroupMemberMgram(IMgram msg, PublishLimiter pubLimiter, IClientContext cc, boolean jms_redelivery, boolean inDoubt, boolean postpone) {
    }

    @Override
    public DurableCCTracker getDurableCCTracker() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IPTPFlowControlHandler getPTPFlowControlHandler() {
        if (this.m_ptpFlowControlHandler == null) {
            Object object = this.m_syncObj;
            synchronized (object) {
                if (this.m_ptpFlowControlHandler == null && this.m_connection != null) {
                    this.m_ptpFlowControlHandler = SessionConfig.createPTPFlowControlHandler(this.m_delegator);
                }
            }
        }
        return this.m_ptpFlowControlHandler;
    }

    @Override
    public final IFlowControllableOutputQueue getFlowControllableOutputQueue() {
        return this.m_outQueue.m_senderQueue;
    }

    @Override
    public final byte getPeerSessionVer() {
        return this.m_delegator.getClientSessionVer();
    }

    @Override
    public final void notifyPTPResumed(String dest) {
        if (this.m_CCFlowControlTracker != null) {
            this.m_CCFlowControlTracker.checkQueueResumed(dest);
        }
    }

    protected final void setupPTPFlowController() {
        this.disconnectFlowController();
        this.m_flowController = this.m_connection != null && this.getClientSessionVer() < 28 ? new FlowControllerP27(s_reg.getFlowControlManager(), this.m_delegator) : new FlowControllerP28(s_reg.getFlowControlManager(), this.m_delegator);
    }

    private void disconnectFlowController() {
        if (this.m_flowController != null) {
            this.m_flowController.disconnect();
        }
    }

    @Override
    public long getSubjectFilterId() {
        if (this.m_groupSubCC != null) {
            return this.m_groupSubCC.getId();
        }
        return this.m_id;
    }

    @Override
    public boolean recheckRestoredMgram(IMgram m) {
        if (m.isTTE() && m.getTTE() <= EpochClock.getTime()) {
            this.delegatorHandleNormalAck(m);
            return false;
        }
        if (Config.ENABLE_SECURITY && Config.ENABLE_ACCESS_MEDIATION && Config.ENABLE_ACL_CHECK_AT_RESTORE && !Authorize.checkPermission(this.m_delegator.getPrincipal(), m.getSubject(), 2)) {
            this.delegatorHandleNormalAck(m);
            return false;
        }
        return true;
    }

    private void delegatorHandleNormalAck(IMgram m) {
        if (m.isGuarenteed()) {
            this.m_delegator.handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
        }
    }

    @Override
    public boolean waitForRegistryUpdate() throws InterruptedException {
        return false;
    }

    @Override
    public boolean beginRegistryUpdate() {
        return true;
    }

    @Override
    public void endRegistryUpdate() {
    }

    @Override
    public long getCreationTime() {
        return this.m_creationTime;
    }

    @Override
    public long getLastStateChangeTime() {
        return this.m_lastStateChangeTime;
    }

    @Override
    public void appendConnectionMemberProperties(Map properties) {
        String appId = this.m_secctx == null ? null : this.m_secctx.getAppid();
        this.addConnectionProperties(properties, appId);
        this.addSessionProperties(properties);
        this.addConsumerProperties(properties, appId);
        this.addCommonProperties(properties);
        this.flowControlPubSub(properties);
        this.flowControlInfoPtp(properties);
    }

    private void addConnectionProperties(Map<String, String> properties, String appId) {
        if (this.m_isJMSConnection || this.m_delegator.isInterbroker() || this.m_isRemoteBroker) {
            if (this.m_connection != null) {
                this.m_connection.appendConnectionMemberProperties(properties);
            }
            if (appId != null && appId.startsWith(SONIC_MQ_MF)) {
                String type = appId.startsWith(SONIC_MQ_MF_JNDICLIENT) ? "JNDI" : (appId.startsWith(SONIC_MQ_MF_JMXCLIENT) ? "Management Client" : "Management Container");
                properties.put("ConnectionType", type);
            }
        }
    }

    private void addSessionProperties(Map<String, String> properties) {
        if (this.m_isJMSSession) {
            String ackMode = null;
            switch (this.m_ackMode) {
                case 2: {
                    ackMode = "AUTO_ACKNOWLEDGE";
                    break;
                }
                case 3: {
                    ackMode = "DUPS_OK_ACKNOWLEDGE";
                    break;
                }
                case 4: {
                    ackMode = "CLIENT_ACKNOWLEDGE";
                    break;
                }
                case 5: {
                    ackMode = "SINGLE_MESSAGE_ACKNOWLEDGE";
                    break;
                }
                case 6: {
                    ackMode = "TRANSACTED";
                    break;
                }
            }
            if (ackMode != null) {
                properties.put("AcknowledgeMode", ackMode);
            }
        }
    }

    private void addConsumerProperties(Map<String, String> properties, String appId) {
        BrokerSubscription subscription = this.m_subscriptions.getUserSubscription();
        if (subscription != null) {
            if (this.m_isJMSTopic || this.m_isJMSTopicCC || this.m_isJMSQueueReceiver || this.m_isJMSQueueBrowser || this.m_delegator.isDurable()) {
                String selector = subscription.getSelectorString();
                if (selector != null && !selector.isEmpty()) {
                    properties.put("Selector", selector);
                    properties.put("SelectorAtBroker", Boolean.toString(subscription.getSelectorAtBroker()));
                }
                if (subscription.getDurableStrictMessageOrder()) {
                    properties.put("DurableMessageOrder", Boolean.toString(true));
                }
            }
            if (this.m_isJMSTopic || this.m_isJMSTopicCC || this.m_delegator.isDurable()) {
                String jmsClientID;
                if (this.m_delegator.isDurable() && appId != null && (jmsClientID = DurableSubscriptionUtil.getJMSClientID(appId)) != null && !jmsClientID.isEmpty()) {
                    properties.put("ClientID", jmsClientID);
                }
                properties.put("FlowToDiskEnabled", Boolean.toString(this.useFlowToDisk()));
                if (this.m_msgsToBeAddedToOffloadedQueue > 0 || this.m_outQueue != null && !this.m_outQueue.getOffloadedPubSubQueue().isEmpty() || this.m_groupSubCC != null && this.m_groupSubCC.getOutQueue() != null && !this.m_groupSubCC.getOutQueue().getOffloadedPubSubQueue().isEmpty()) {
                    properties.put("FlowToDiskStatus", OFFLOADING);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonProperties(Map<String, String> properties) {
        if (this.getOutQueue() != null) {
            Set blockedSenders;
            int minDequeuePriority;
            long[] countSize = this.getOutQueue().getCountSizeOutgoingMsgs(true, true);
            if (countSize[0] > 0L) {
                properties.put("MessagesOutgoingCount", Long.toString(countSize[0]));
            }
            if (countSize[1] > 0L) {
                properties.put("MessagesOutgoingSize", Long.toString(countSize[1]));
            }
            countSize = this.getOutQueue().getCountSizePendingGuars(true, true);
            long pendingCount = countSize[0];
            long pendingSize = countSize[1];
            countSize = this.getOutQueue().getCountSizePendingQMsgs();
            pendingSize += countSize[1];
            if ((pendingCount += countSize[0]) > 0L) {
                properties.put("MessagesPendingCount", Long.toString(pendingCount));
            }
            if (pendingSize > 0L) {
                properties.put("MessagesPendingSize", Long.toString(pendingSize));
            }
            if ((minDequeuePriority = this.getOutQueue().getMinDequeuePriority()) > 0) {
                properties.put("FlowControlByPeerMinPriority", Integer.toString(minDequeuePriority));
            }
            Object object = this.m_syncObj;
            synchronized (object) {
                blockedSenders = this.getOutQueue().getBlockedSenders();
            }
            if (!blockedSenders.isEmpty()) {
                StringBuilder blockedSendersString = new StringBuilder();
                boolean first = true;
                for (Object sender : blockedSenders) {
                    IClientContext blockedSender;
                    if (first) {
                        first = false;
                    } else {
                        blockedSendersString.append(COMMA_SPACE);
                    }
                    if ((blockedSender = (IClientContext)sender) == null) continue;
                    blockedSendersString.append(blockedSender.getId());
                }
                properties.put("FlowControlBlockedSenderRefs", blockedSendersString.toString());
            }
        }
    }

    private void flowControlPubSub(Map<String, String> properties) {
        if (this.m_pubLimiter != null) {
            ArrayList blockingSubs;
            int minPubPriority = this.m_pubLimiter.getMinPublishPriority();
            if (minPubPriority > 0) {
                properties.put("FlowControlMinPublishPriority", Integer.toString(minPubPriority));
            }
            if (!(blockingSubs = this.m_pubLimiter.getBlockingSubscribers()).isEmpty()) {
                StringBuilder blockingSubsString = new StringBuilder();
                for (int i = 0; i < blockingSubs.size(); ++i) {
                    IClientContext blockingSub;
                    if (i > 0) {
                        blockingSubsString.append(COMMA_SPACE);
                    }
                    if ((blockingSub = (IClientContext)blockingSubs.get(i)) == null) continue;
                    blockingSubsString.append(blockingSub.getId());
                }
                properties.put("FlowControlBlockingConsumerRefs", blockingSubsString.toString());
            }
        }
    }

    private void flowControlInfoPtp(Map<String, String> properties) {
        String blockedDestinations;
        if (this.m_flowController != null && (blockedDestinations = this.m_flowController.getBlockedDestinationsAsString()) != null) {
            properties.put("FlowControlBlockingDestinations", blockedDestinations);
        }
    }

    @Override
    public CCFlowControlTracker getCCFlowControlTracker() {
        return this.m_CCFlowControlTracker;
    }

    @Override
    public void setCCFlowControlTracker(CCFlowControlTracker ccfct) {
        this.m_CCFlowControlTracker = ccfct;
    }

    private void debugNegativeDispatchCount(int origCount, int dispatchIncrement, IClientContext publisher, IMgram m) {
        String errorInfo = "; dispatchIncrement= " + dispatchIncrement;
        if (m != null) {
            errorInfo = errorInfo + " mtype= " + m.getType();
        }
        String pubInfo = publisher == null ? "" : publisher.getDelegator().toString();
        EAssertFailure t = new EAssertFailure(this.m_delegator + ": Negative dispatch count! currentCount= " + origCount + errorInfo + " Thread: " + Thread.currentThread().getName());
        StackTraceElement[] st = t.getStackTrace();
        if (this.m_diagnostics == null || this.m_diagnostics.isEmpty()) {
            this.m_diagnostics = new ArrayList();
            this.m_diagnostics.add(new LongHolder(1L));
        }
        boolean found = false;
        ListIterator ii = this.m_diagnostics.listIterator(1);
        while (ii.hasNext() && !found) {
            StackTraceElement[] stes;
            boolean match = true;
            String obj = (String)ii.next();
            if (!obj.equals(pubInfo)) {
                match = false;
            }
            if ((stes = (StackTraceElement[])ii.next()).length != st.length) {
                match = false;
            }
            if (match) {
                for (int i = 0; i < stes.length; ++i) {
                    if (stes[i].equals(st[i])) continue;
                    match = false;
                    break;
                }
            }
            String s = (String)ii.next();
            if (match && !s.equals(errorInfo)) {
                match = false;
            }
            LongHolder count = (LongHolder)ii.next();
            if (!match) continue;
            count.set(count.get() + 1L);
            found = true;
        }
        LongHolder totalLH = (LongHolder)this.m_diagnostics.get(0);
        totalLH.set(totalLH.get() + 1L);
        if (!found && this.m_diagnostics.size() <= 21) {
            this.m_diagnostics.add(pubInfo);
            this.m_diagnostics.add(st);
            this.m_diagnostics.add(errorInfo);
            this.m_diagnostics.add(new LongHolder(1L));
            t = new EAssertFailure(t.getMessage() + (m != null ? MgramTrace.diagnosticString(" ", null, m) : " Mgram Unavailable"));
            BrokerComponent.getComponentContext().logMessage((Throwable)t, 2);
        } else if ((totalLH.get() - 1L) % 100L == 0L) {
            String s = t.getMessage() + " (" + (totalLH.get() - 1L) + ") previous occurrences";
            BrokerComponent.getComponentContext().logMessage(s, 2);
        }
    }

    @Override
    public int xOnceGroupSend(IMgram m, PublishLimiter pubLimiter, Label opts, GroupMsgAllocationEvt xoGroupResult) {
        return this.sendInternal(m, opts, pubLimiter, false, xoGroupResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void xOnceGroupSendRelease(GroupMsgAllocationEvt evt) {
        Object object = this.m_syncObj;
        synchronized (object) {
            if (this.m_outQueue.releaseXOnceGroupMessage(evt.getRecipientTracking())) {
                this.informAgentSender();
            } else if (this.DEBUG_UNEXPECTED) {
                this.debug("Failed to release xonce to remote " + this.getAppid() + " - " + evt.getMessageTracking());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInDoubtXOGroupSend(GroupXOnceMsgAllocationTracker.GroupMsgAllocation gma, GroupSubscriptionClientContext gscc) {
        if (this.DEBUG) {
            this.debug("Adding in doubt xo group send " + gscc.getAppid() + " - " + gma.msgTracking);
        }
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_outQueue.addInDoubtXOGroupSend(gma, gscc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientContextMgramQueue.InDoubtXOGroupSend removeInDoubtXOnceGroupSend(long tracking) {
        Object object = this.m_syncObj;
        synchronized (object) {
            return this.m_outQueue.removeInDoubtXOGroupSend(tracking);
        }
    }

    public void deallocateXOGroupSends(IndexedList xoGroupSends) {
        if (xoGroupSends != null && xoGroupSends.count() > 0) {
            Enumeration deallocations = xoGroupSends.elements();
            while (deallocations.hasMoreElements()) {
                GroupMsgAllocationEvt toUndo = (GroupMsgAllocationEvt)deallocations.nextElement();
                boolean interrupted = false;
                while (!toUndo.isInQueue() && !toUndo.isFlushed()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
                toUndo.getGroupCC().removeXOnceAllocation(toUndo.getMessageTracking());
                GroupMsgDeallocationEvt evt = new GroupMsgDeallocationEvt(this.m_delegator, toUndo.getGroupCC(), toUndo.getMessageTracking(), toUndo.getMessage());
                s_reg.getLogManager().addEvent(evt, !deallocations.hasMoreElements());
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInDoubtXOGroupSendsResolved() {
        IndexedList resolvedList = null;
        Object object = this.m_syncObj;
        synchronized (object) {
            resolvedList = this.m_outQueue.resetInDoubtXOGroupSends();
        }
        if (resolvedList != null && resolvedList.count() > 0) {
            Enumeration resolved = resolvedList.elements();
            while (resolved.hasMoreElements()) {
                ClientContextMgramQueue.InDoubtXOGroupSend idgs = (ClientContextMgramQueue.InDoubtXOGroupSend)resolved.nextElement();
                IMgram m = idgs.groupcc.getPendingGuar(idgs.gma.msgTracking);
                if (m != null) {
                    m.getBrokerHandle().setFromDB(true);
                }
                idgs.groupcc.removeXOnceAllocation(idgs.gma.msgTracking);
                GroupMsgDeallocationEvt evt = new GroupMsgDeallocationEvt(idgs, this.m_delegator, m);
                s_reg.getLogManager().addEvent(evt, !resolved.hasMoreElements());
            }
        }
    }

    static {
        s_dummyObj = new Object();
        s_mergeLabels = new Label[2][3];
        BaseClientContext.s_mergeLabels[0][0] = new Label();
        s_mergeLabels[0][0].setPersistent(false);
        BaseClientContext.s_mergeLabels[0][1] = new Label();
        s_mergeLabels[0][1].setPersistent(true);
        BaseClientContext.s_mergeLabels[0][2] = new Label();
        s_mergeLabels[0][2].setGuaranteed(true);
        for (int i = 0; i < 3; ++i) {
            BaseClientContext.s_mergeLabels[1][i] = (Label)s_mergeLabels[0][i].clone();
            s_mergeLabels[1][i].setNonStop(true);
        }
        m_Sonic00027420 = new DebugObject("Sonic00027420");
        m_done = false;
    }

    private class GuarDoubtManager
    implements ICCGuarDoubtManager {
        private final LongHashTable m_inDoubtList = new LongHashTable();
        private final LongHashTable m_restoredFromDb = new LongHashTable();
        private final LongHashTable m_subjectAcks = new LongHashTable();
        private final LongHashTable m_ackedTrackingNums = new LongHashTable();
        private LongHashTable m_ackedTrackingNumsSnapshot;
        private final LongHashTable m_groupIndoubtTrackingNums = new LongHashTable();
        private final LongHashTable m_groupDeletedTrackingNums = new LongHashTable();
        private LongHashTable m_recoverdGroupMemberDNRs;

        private GuarDoubtManager() {
        }

        @Override
        public synchronized boolean isMessageInDoubt(long tracking) {
            GroupSubscriptionClientContext groupcc = null;
            groupcc = BaseClientContext.this.getOutQueue().getGroupSubGuarPendingCC(tracking);
            if (groupcc != null) {
                return groupcc.getGuarDoubtManager().isMessageInDoubt(tracking);
            }
            if (this.m_recoverdGroupMemberDNRs != null && this.m_recoverdGroupMemberDNRs.containsKey(tracking)) {
                return true;
            }
            return this.m_inDoubtList.containsKey(tracking);
        }

        @Override
        public synchronized void setMessageInDoubt(long tracking) {
            GroupSubscriptionClientContext groupcc = null;
            groupcc = BaseClientContext.this.getOutQueue().getGroupSubGuarPendingCC(tracking);
            if (groupcc != null) {
                groupcc.getGuarDoubtManager().setMessageInDoubt(tracking);
                return;
            }
            this.m_inDoubtList.put(tracking, s_dummyObj);
        }

        @Override
        public synchronized void removeMessageInDoubt(long tracking) {
            GroupSubscriptionClientContext groupcc = null;
            groupcc = BaseClientContext.this.getOutQueue().getGroupSubGuarPendingCC(tracking);
            if (groupcc != null) {
                groupcc.getGuarDoubtManager().removeMessageInDoubt(tracking);
            }
            this.m_inDoubtList.remove(tracking);
            this.m_restoredFromDb.remove(tracking);
            if (this.m_recoverdGroupMemberDNRs != null) {
                this.m_recoverdGroupMemberDNRs.remove(tracking);
            }
        }

        @Override
        public synchronized void removeRestoredFromDb(long tracking) {
            GroupSubscriptionClientContext groupcc = null;
            groupcc = BaseClientContext.this.getOutQueue().getGroupSubGuarPendingCC(tracking);
            if (groupcc != null) {
                groupcc.getGuarDoubtManager().removeRestoredFromDb(tracking);
            }
            this.m_restoredFromDb.remove(tracking);
        }

        @Override
        public synchronized void clearDoubtList() {
            this.m_inDoubtList.clear();
        }

        @Override
        public synchronized void setDoubtList(List inDoubtMsgIds) {
            if (BaseClientContext.this.m_ackMode != 3 && BaseClientContext.this.m_ackMode != 0 && BaseClientContext.this.m_ackMode != -1) {
                ISizedEnumeration<Long> enu = this.m_inDoubtList.keyList();
                while (enu.hasMoreElements()) {
                    long k = (Long)enu.nextElement();
                    this.m_restoredFromDb.remove(k);
                }
                this.clearDoubtList();
            }
            Iterator i = inDoubtMsgIds.iterator();
            while (i.hasNext()) {
                this.m_inDoubtList.put((long)((Long)i.next()), s_dummyObj);
            }
            if (BaseClientContext.this.DEBUG1 && inDoubtMsgIds.size() != 0) {
                BaseClientContext.this.debug("ICCGuarDoubtManager.setDoubtList; added inDoubtIds; size=: " + inDoubtMsgIds.size());
            }
        }

        @Override
        public synchronized void msgAcknowledged(long tracking, boolean trackDbDeletion) {
            GroupSubscriptionClientContext groupcc = null;
            groupcc = BaseClientContext.this.getOutQueue().getGroupSubGuarPendingCC(tracking);
            if (groupcc != null) {
                groupcc.getGuarDoubtManager().msgAcknowledged(tracking, trackDbDeletion);
            }
            this.msgAcknowledgedInternal(new Long(tracking), trackDbDeletion, false, (short)-1);
        }

        @Override
        public synchronized void msgSubjectAcked(long tracking, short subjectTracking) {
            GroupSubscriptionClientContext groupcc = null;
            groupcc = BaseClientContext.this.getOutQueue().getGroupSubGuarPendingCC(tracking);
            if (groupcc != null) {
                groupcc.getGuarDoubtManager().msgSubjectAcked(tracking, subjectTracking);
            }
            this.msgAcknowledgedInternal(new Long(tracking), false, true, subjectTracking);
        }

        private final synchronized void msgAcknowledgedInternal(Long tracking, boolean trackDbDeletion, boolean subjectAck, short subjectTracking) {
            if (subjectAck) {
                ArrayList<Short> ackedSubs = (ArrayList<Short>)this.m_subjectAcks.get(tracking);
                if (ackedSubs == null) {
                    ackedSubs = new ArrayList<Short>();
                    this.m_subjectAcks.put((long)tracking, ackedSubs);
                }
                ackedSubs.add(new Short(subjectTracking));
                return;
            }
            BaseClientContext.this.m_delegator.getGuarDoubtManager().removePendingGroupTxnMessage(tracking);
            if (BaseClientContext.this.m_delegator.isGroupSubscription() && BaseClientContext.this.m_delegator.checkRestoringState() && !BaseClientContext.this.m_delegator.isMsgRestoreCancelled()) {
                this.m_groupDeletedTrackingNums.put(tracking, s_dummyObj);
            }
            BaseClientContext.this.m_delegator.getOutQueue().removeGroupSubGuarPending(tracking);
            if (!this.m_subjectAcks.isEmpty()) {
                this.m_subjectAcks.remove(tracking);
            }
            this.m_inDoubtList.remove(tracking);
            this.m_restoredFromDb.remove(tracking);
            if (trackDbDeletion) {
                this.m_ackedTrackingNums.put(tracking, s_dummyObj);
            }
        }

        @Override
        public synchronized boolean wasMessageAcknowledged(long tracking) {
            boolean ret = false;
            GroupSubscriptionClientContext groupcc = null;
            groupcc = BaseClientContext.this.getOutQueue().getGroupSubGuarPendingCC(tracking);
            if (groupcc != null) {
                ret = groupcc.getGuarDoubtManager().wasMessageAcknowledged(tracking);
            }
            if (BaseClientContext.this.m_delegator.isGroupSubscription()) {
                if (this.m_ackedTrackingNumsSnapshot != null) {
                    ret |= this.m_ackedTrackingNumsSnapshot.containsKey(tracking);
                }
                ret |= this.m_ackedTrackingNums.containsKey(tracking);
                ret |= this.m_groupDeletedTrackingNums.containsKey(tracking);
            } else {
                ret = this.m_ackedTrackingNumsSnapshot != null ? (ret |= this.m_ackedTrackingNumsSnapshot.containsKey(tracking)) : (ret |= this.m_ackedTrackingNums.containsKey(tracking));
            }
            return ret;
        }

        @Override
        public synchronized void filterAckedSubjectTrackings(IMgram m) {
            Collection c = (Collection)this.m_subjectAcks.get(m.getGuarenteedTrackingNum());
            ISubjectFilter sf = m.getBrokerHandle().getSubjectFilter(BaseClientContext.this.m_delegator.getSubjectFilterId());
            if (c != null) {
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    sf.removeTrackingNum(m.getSubject(), (Short)i.next());
                }
            }
        }

        @Override
        public synchronized void takeAcknowledgeSnapshot() {
            this.m_ackedTrackingNumsSnapshot = (LongHashTable)this.m_ackedTrackingNums.clone();
        }

        @Override
        public synchronized void clearAcknowledgeSnapshot() {
            this.m_ackedTrackingNumsSnapshot = null;
        }

        @Override
        public synchronized void msgDeleteDone(long tracking) {
            GroupSubscriptionClientContext groupcc = null;
            groupcc = BaseClientContext.this.getOutQueue().getGroupSubGuarPendingCC(tracking);
            if (groupcc != null) {
                groupcc.getGuarDoubtManager().msgDeleteDone(tracking);
            }
            if (BaseClientContext.this.m_delegator.isGroupSubscription() && this.m_ackedTrackingNums.containsKey(tracking)) {
                if (BaseClientContext.this.m_delegator.checkRestoringState()) {
                    this.m_groupDeletedTrackingNums.put(tracking, s_dummyObj);
                } else if (!BaseClientContext.this.m_delegator.getRestoringOffloaded() && BaseClientContext.this.m_outQueue.getOffloadedPubSubQueue().isEmpty()) {
                    this.m_groupDeletedTrackingNums.clear();
                }
            }
            this.m_ackedTrackingNums.remove(tracking);
            if (!this.m_subjectAcks.isEmpty()) {
                this.m_subjectAcks.remove(tracking);
            }
        }

        @Override
        public synchronized IMgram makeSuccessorClone(IMgram mParam) {
            IMgram m = mParam;
            boolean changeSuccessor = false;
            if (!m.isGuarenteed() || m.getType() == 27) {
                return m;
            }
            if (!m.isSuccessor() && this.isMessageInDoubt(m.getGuarenteedTrackingNum())) {
                if (BaseClientContext.this.DEBUG1) {
                    BaseClientContext.this.debug(this + ": Setting successor for in doubt msg: " + m.getGuarenteedTrackingNum());
                }
                changeSuccessor = true;
            } else if (m.isSuccessor() && m.getBrokerHandle().isFromDB()) {
                long maxStartUpSeqNo;
                long msgSeqNo = m.getBrokerHandle().getSequenceNumber();
                if (msgSeqNo > (maxStartUpSeqNo = s_reg.getBrokerDatabase().getStartupMaxSeqNoUsed())) {
                    if (!this.isMessageInDoubt(m.getGuarenteedTrackingNum())) {
                        if (BaseClientContext.this.DEBUG1) {
                            BaseClientContext.this.debug(this + ": UnSetting successor for not-in-doubt msg: " + m.getGuarenteedTrackingNum());
                        }
                        changeSuccessor = true;
                    }
                } else if (this.m_restoredFromDb.containsKey(m.getGuarenteedTrackingNum())) {
                    changeSuccessor = true;
                }
            }
            if (changeSuccessor) {
                if (BaseClientContext.this.DEBUG) {
                    BaseClientContext.this.debug(this + ": Clearing successor for msg not in doubt: " + m.getGuarenteedTrackingNum());
                }
                if (!m.getBrokerHandle().isFromDB()) {
                    if (BaseClientContext.this.DEBUG) {
                        BaseClientContext.this.debug(this + ": Making succsessor clone: " + m.getGuarenteedTrackingNum());
                    }
                    try {
                        m = (IMgram)m.protectedClone();
                    }
                    catch (CloneNotSupportedException cnse) {
                        SessionConfig.logMessage(cnse, SessionConfig.getLevelWarning());
                    }
                }
                m.setSuccessor(!m.isSuccessor());
                if (m.isSecure()) {
                    try {
                        if (SecurityLogic.isMKeyMacHeader(m.getSecurity())) {
                            m.getBrokerHandle().macHeaderWithMessageKey(BaseClientContext.this.m_mp);
                        }
                    }
                    catch (ESecurityGeneralException e) {
                        throw new EAssertFailure("Caught ESecurityGeneralException while remac'ing the header", e);
                    }
                }
            }
            return m;
        }

        @Override
        public synchronized void addRestoredFromDb(long tracking) {
            GroupSubscriptionClientContext groupcc = null;
            groupcc = BaseClientContext.this.getOutQueue().getGroupSubGuarPendingCC(tracking);
            if (groupcc != null) {
                groupcc.getGuarDoubtManager().addRestoredFromDb(tracking);
                return;
            }
            this.m_restoredFromDb.put(tracking, s_dummyObj);
        }

        @Override
        public synchronized void syncRedeliveries() {
            ISizedEnumeration<Long> updateTrkNums = ((LongHashTable)this.m_restoredFromDb.clone()).keyList();
            int strtSize = this.m_restoredFromDb.size();
            int updated = 0;
            while (updateTrkNums.hasMoreElements()) {
                long tracking = (Long)updateTrkNums.nextElement();
                ++updated;
                s_reg.getMsgSaver().updateMsg(BaseClientContext.this.m_delegator.getId(), tracking, tracking, null, true);
                this.m_restoredFromDb.remove(tracking);
            }
            if (BaseClientContext.this.DEBUG1 && strtSize > 0) {
                BaseClientContext.this.debug("ICCGuarDoubtManager.syncRedeliveries  strtsize= " + strtSize + " updatedRedeliv=" + updated + " remaining= " + this.m_restoredFromDb.size() + " inDoubtSize= " + this.m_inDoubtList.size() + " " + BaseClientContext.this.m_delegator);
            }
        }

        @Override
        public int getRestoredFromDbCount() {
            return this.m_restoredFromDb.size();
        }

        @Override
        public synchronized LongHashTable clearPendingGroupTxnMessages() {
            if (!BaseClientContext.this.m_delegator.isGroupSubscriptionMember()) {
                return null;
            }
            LongHashTable keys = (LongHashTable)this.m_groupIndoubtTrackingNums.clone();
            this.m_groupIndoubtTrackingNums.clear();
            return keys;
        }

        @Override
        public synchronized void addPendingGroupTxnMessage(long tracking) {
            if (BaseClientContext.this.m_delegator.isGroupSubscriptionMember()) {
                this.m_groupIndoubtTrackingNums.put(tracking, s_dummyObj);
            }
        }

        @Override
        public synchronized boolean isPendingGroupTxnMessage(long tracking) {
            return this.m_groupIndoubtTrackingNums.containsKey(tracking);
        }

        @Override
        public synchronized void removePendingGroupTxnMessage(long tracking) {
            if (BaseClientContext.this.m_delegator.isGroupSubscriptionMember()) {
                this.m_groupIndoubtTrackingNums.remove(tracking);
            }
        }

        @Override
        public synchronized void addRecoveredGroupMemberDNRs(IClientContext member, List dnrs) {
            if (this.m_recoverdGroupMemberDNRs == null) {
                this.m_recoverdGroupMemberDNRs = new LongHashTable();
            }
            Iterator i = dnrs.iterator();
            while (i.hasNext()) {
                this.m_recoverdGroupMemberDNRs.put((long)((Long)i.next()), member);
            }
        }

        @Override
        public synchronized void clearRecoveredGroupMemberDNRs(List dnrs) {
            if (this.m_recoverdGroupMemberDNRs == null) {
                return;
            }
            Iterator i = dnrs.iterator();
            while (i.hasNext()) {
                this.m_recoverdGroupMemberDNRs.remove((Long)i.next());
            }
            if (this.m_recoverdGroupMemberDNRs.isEmpty()) {
                this.m_recoverdGroupMemberDNRs = null;
            }
        }

        @Override
        public synchronized IClientContext getRecoveredGroupMemberDNR(long tracking) {
            if (this.m_recoverdGroupMemberDNRs == null) {
                return null;
            }
            return (IClientContext)this.m_recoverdGroupMemberDNRs.get(tracking);
        }
    }

    private static class OffloadedMsgRestoreLock {
        private int count = 0;

        private OffloadedMsgRestoreLock() {
        }

        public synchronized void lock() {
            ++this.count;
        }

        public synchronized void unlock() {
            if (this.count <= 0) {
                throw new IllegalMonitorStateException();
            }
            --this.count;
        }

        public synchronized boolean isLocked() {
            return this.count > 0;
        }
    }

    final class MergeScratchPad {
        int m_nextMsgGuarState;
        int m_nextMsgNonStop;
        HashSet<ISubject> m_subjectFilter;
        Label m_deliveryLabel;

        MergeScratchPad() {
        }
    }

    private static class HandleAckParameters {
        private final IMgram ackedMgram;
        private final boolean fromDb;
        private final boolean fromLog;
        private final boolean persisted;
        private boolean trackDbDelete;

        private HandleAckParameters(IMgram ackedMgram) {
            this.ackedMgram = ackedMgram;
            this.fromDb = ackedMgram.getBrokerHandle().isFromDB();
            this.fromLog = ackedMgram.getBrokerHandle().isFromLog();
            this.persisted = this.fromDb || this.fromLog || ackedMgram.isJMSPersistent() && (!ackedMgram.isNonPersistentReplicated() || Config.REPLICATED);
        }
    }
}

