/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.ClientContextMgramQueue;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.ECounterFrozenException;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class CCSizeTracker
extends DebugObject
implements ICCSizeTracker {
    private IClientContext m_cc;
    private long m_messageRestorableCount;
    private long m_messageRestorableSize;
    private boolean m_queryPending;
    private long m_maxQueriedMessageId = -1L;
    private long m_maxMessageIdToQuery = -1L;
    private long m_maxMessageIdToSkip = -1L;
    private boolean m_isRecovered = false;
    private boolean m_isFrozen = false;

    CCSizeTracker(IClientContext cc) {
        super(DebugState.GLOBAL_DEBUG_ON ? "CCSizeTracker " + cc : null);
        this.m_cc = cc;
        if (this.checkDebugFlags(64)) {
            this.debug("*****************Created");
        }
    }

    @Override
    public IClientContext getCC() {
        return this.m_cc;
    }

    public void setCC(IClientContext cc) {
        this.m_cc = cc;
    }

    @Override
    public void messageAdded(int count, int size) {
    }

    @Override
    public void messageRemoved(int count, int size) {
    }

    public synchronized void freeze() {
        this.m_isFrozen = true;
    }

    @Override
    public synchronized void messageSaved(int oldSize, int newSize, long trackingNum) throws ECounterFrozenException {
        if (this.m_isFrozen) {
            throw new ECounterFrozenException();
        }
        if (this.m_queryPending && trackingNum > this.m_maxQueriedMessageId && trackingNum <= this.m_maxMessageIdToQuery) {
            if (this.DEBUG) {
                this.debug("Not accounting for TrkNum: " + trackingNum + " with size: " + newSize);
            }
            return;
        }
        if (trackingNum <= this.m_maxMessageIdToSkip) {
            return;
        }
        ++this.m_messageRestorableCount;
        this.m_messageRestorableSize += (long)newSize;
        if (this.DEBUG) {
            this.debug("Message saved, DbCount:" + this.m_messageRestorableCount + ", DbSize:" + this.m_messageRestorableSize + ", TrkNum: " + trackingNum);
        }
    }

    @Override
    public synchronized void messageProxySaved(int size, long trackingNum) throws ECounterFrozenException {
        if (this.m_isFrozen) {
            throw new ECounterFrozenException();
        }
        if (this.m_queryPending && trackingNum > this.m_maxQueriedMessageId && trackingNum <= this.m_maxMessageIdToQuery) {
            if (this.DEBUG) {
                this.debug("Not accounting for TrkNum: " + trackingNum + " with size: " + size);
            }
            return;
        }
        if (trackingNum <= this.m_maxMessageIdToSkip) {
            return;
        }
        ++this.m_messageRestorableCount;
        this.m_messageRestorableSize += (long)size;
    }

    @Override
    public synchronized void messageDeleted(int size, long trackingNum) throws ECounterFrozenException {
        if (this.m_isFrozen) {
            throw new ECounterFrozenException();
        }
        if (this.m_queryPending && trackingNum > this.m_maxQueriedMessageId && trackingNum <= this.m_maxMessageIdToQuery) {
            if (this.DEBUG) {
                this.debug("Not accounting for TrkNum: " + trackingNum + " with size: " + size);
            }
            return;
        }
        if (trackingNum <= this.m_maxMessageIdToSkip) {
            return;
        }
        --this.m_messageRestorableCount;
        this.m_messageRestorableSize -= (long)size;
        if (this.DEBUG) {
            this.debug("MessageDeleted, DbCount:" + this.m_messageRestorableCount + ", DbSize:" + this.m_messageRestorableSize + ", TrkNum: " + trackingNum);
        }
        if (this.checkDebugFlags(64) && this.m_messageRestorableCount < 0L) {
            this.debug("messageDeleted: *****Negative dbcount count  dbCount= " + this.m_messageRestorableCount + " dbSize= " + this.m_messageRestorableSize);
        }
    }

    @Override
    public synchronized long getRestorableMessageCount() {
        return this.m_messageRestorableCount;
    }

    @Override
    public synchronized long getRestorableMessageSize() {
        return this.m_messageRestorableSize;
    }

    @Override
    public synchronized void updateQueryMsgs(long size, long count, long maxQueriedMessageId) throws ECounterFrozenException {
        if (this.m_isFrozen) {
            throw new ECounterFrozenException();
        }
        if (!this.m_queryPending) {
            throw new EAssertFailure("Attempt to update query count/size while not in query state!");
        }
        this.m_messageRestorableCount += count;
        this.m_messageRestorableSize += size;
        this.m_maxQueriedMessageId = maxQueriedMessageId;
        if (this.DEBUG) {
            this.debug("Message query update, Count:" + this.m_messageRestorableCount + ", Size:" + this.m_messageRestorableSize + ", Max queried message id: " + this.m_maxQueriedMessageId + ", Max message id: " + this.m_maxMessageIdToQuery);
        }
    }

    @Override
    public synchronized void setQueryPending(boolean value, long maxMessageId) {
        this.m_queryPending = value;
        this.m_maxMessageIdToQuery = maxMessageId;
    }

    public synchronized boolean isQueryPending() {
        return this.m_queryPending;
    }

    @Override
    public long getMessageCount() {
        long[] result = this.getMessageCountAndSize();
        return result[0];
    }

    @Override
    public long getMessageSize() {
        long[] result = this.getMessageCountAndSize();
        return result[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getMessageCountAndSize() {
        long ct = 0L;
        long size = 0L;
        long[] result = new long[2];
        Object object = this;
        synchronized (object) {
            if (this.m_queryPending) {
                result[0] = -1L;
                result[1] = -1L;
                return result;
            }
        }
        object = this.m_cc.getSyncObj();
        synchronized (object) {
            ClientContextMgramQueue ccmq = this.m_cc.getOutQueue();
            long[] dat1 = ccmq.getCountSizePendingQMsgs();
            long[] dat2 = ccmq.getCountSizePendingGuars(this.m_cc.hasMsgsInDb(), true);
            long[] dat3 = ccmq.getCountSizeOutgoingMsgs(true, true);
            long[] dat4 = ccmq.getCountSizePendingReconnectGuars(this.m_cc.hasMsgsInDb(), true);
            ct = dat1[0] + dat2[0] + dat3[0] + dat4[0];
            size = dat1[1] + dat2[1] + dat3[1] + dat4[1];
            CCSizeTracker cCSizeTracker = this;
            synchronized (cCSizeTracker) {
                result[0] = this.m_messageRestorableCount + ct;
                result[1] = this.m_messageRestorableSize + size;
            }
        }
        if (this.checkDebugFlags(64)) {
            this.debug("getMessageCountAndSize: totCt = " + result[0] + " totSize= " + result[1] + " ccCount= " + ct + " ccSize= " + size + " dbCount= " + this.m_messageRestorableCount + " dbSize= " + this.m_messageRestorableSize);
        }
        return result;
    }

    @Override
    public synchronized void reset() {
        if (this.checkDebugFlags(64)) {
            this.debug("**reset: oldValues are:  dbCount= " + this.m_messageRestorableCount + " dbSize= " + this.m_messageRestorableSize);
        }
        this.m_messageRestorableCount = 0L;
        this.m_messageRestorableSize = 0L;
        this.m_maxMessageIdToSkip = -1L;
    }

    @Override
    public synchronized void reset(long maxIdToSkip) {
        if (this.checkDebugFlags(64)) {
            this.debug("**reset w. id: oldValues are:  dbCount= " + this.m_messageRestorableCount + " dbSize= " + this.m_messageRestorableSize);
        }
        this.m_messageRestorableCount = 0L;
        this.m_messageRestorableSize = 0L;
        this.m_maxMessageIdToSkip = maxIdToSkip;
    }

    @Override
    public synchronized void recover(long count, long size) {
        this.m_messageRestorableCount += count;
        this.m_messageRestorableSize += size;
        this.m_isRecovered = true;
    }

    @Override
    public synchronized boolean isRecovered() {
        return this.m_isRecovered;
    }
}

