/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BaseClientContextWrapper;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.DurableCCTracker;
import progress.message.broker.DurableDisconnectEvt;
import progress.message.broker.DurableManager;
import progress.message.broker.DurableSMOUpdateEvt;
import progress.message.broker.DurableSubscriptionUtil;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EConnectionNotResumable;
import progress.message.broker.EGeneralCWADSException;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.IActivityMonitorHandle;
import progress.message.broker.ICCGuarDoubtManager;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.IClientContextWrapper;
import progress.message.broker.IProxyingHandle;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.MsgRestorePos;
import progress.message.broker.PublishLimiter;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.SubscriptionsTable;
import progress.message.broker.prAccessor;
import progress.message.client.EConnectFailure;
import progress.message.client.ENotConnected;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.ISizedEnumeration;
import progress.message.util.IndexedList;
import progress.message.util.Lock;
import progress.message.util.LongHashTable;
import progress.message.util.PriorityQueue;
import progress.message.util.server.LongHolder;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.Label;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.MgramTrace;

public class DurableClientContext
extends BaseClientContextWrapper
implements IProxyingHandle {
    private DurableManager m_manager;
    private IClientContext m_CWADSPreviousBroker = null;
    private IClientContext m_CWADSActiveBroker = null;
    private IClientContext m_CWADSRestoringBroker = null;
    private HashSet m_liveInboundProxies;
    private HashSet m_startedInboundProxies;
    private DurableCCTracker m_tracker;
    private Object m_dispatchSwitchLock = new Object();
    private Lock m_proxyLock;
    private final HashMap m_proxyFreezeHolders;
    private int m_proxyFreezeCount;
    private SubscribeEvt m_lastSubscribeEvt;
    private HashSet m_disconnectingProxies = new HashSet();
    private boolean m_restoreDeferred = false;
    private boolean m_restoreDeferredForProxyAcks = false;
    private boolean m_sendingLive = false;
    private boolean m_disconnectAfterFinalRemoteRestore = false;
    private InDoubtProxyMessageTracker m_inDoubtProxyTracker;
    private IActivityMonitorHandle m_activityTracker;
    private Thread m_regUpdateThread = null;
    private final Object m_registryUpdateMutex = new Object();
    private int m_regUpdateCount = 0;
    private BrokerSubscription m_durableSubscription = null;
    private Object m_rrdWaitLock;
    private boolean m_waitingForRestoreSpace = false;
    private final boolean DEBUG0;
    private final boolean DEBUG1;
    private final boolean DEBUG_UNEXPECTED;

    DurableClientContext(IClientContext delegate, IClientContextWrapper delegator) {
        super(delegate, delegator);
        this.debugName("DurableClientContext");
        this.DEBUG0 = this.checkDebugFlags(32);
        this.DEBUG1 = this.checkDebugFlags(64);
        this.m_liveInboundProxies = new HashSet();
        this.m_startedInboundProxies = new HashSet();
        this.m_proxyLock = new Lock();
        this.m_activityTracker = new ActivityTracker();
        if (Config.ENABLE_INTERBROKER) {
            this.m_inDoubtProxyTracker = new InDoubtProxyMessageTracker();
        }
        this.m_rrdWaitLock = new Object();
        this.DEBUG_UNEXPECTED = super.checkDebugFlags(8192);
        this.m_proxyFreezeHolders = this.DEBUG_UNEXPECTED ? new HashMap() : null;
    }

    @Override
    public void setUnregistered() {
        this.getDurableManager().unregister(this.getDelegator());
        this.m_delegate.setUnregistered();
    }

    @Override
    public void setRegistered() {
        this.m_tracker = this.getDurableManager().register(this.getDelegator());
        this.m_delegate.setRegistered();
    }

    private DurableManager getDurableManager() {
        if (this.m_manager == null) {
            this.m_manager = AgentRegistrar.getAgentRegistrar().getDurableManager();
        }
        return this.m_manager;
    }

    @Override
    public final boolean isDurable() {
        return true;
    }

    @Override
    public boolean isJMSSubscriber() {
        return true;
    }

    @Override
    public void sendThrough(IMgram m) {
        try {
            this.m_delegator.getProxyingHandle().freezeProxy();
            if (this.isRemotelyConnected()) {
                if (this.DEBUG) {
                    this.debug("Discarding message sent through to remotely connected durable: " + MgramTrace.diagnosticString("DurableClientContext", null, m));
                }
                return;
            }
            this.m_delegate.sendThrough(m);
        }
        finally {
            this.m_delegator.getProxyingHandle().unfreezeProxy();
        }
    }

    @Override
    public int send(IMgram mg, Label opts, PublishLimiter pubLimiter) {
        boolean fromDb = false;
        if (mg.getBrokerHandle() != null) {
            fromDb = mg.getBrokerHandle().isFromDB();
        }
        if (mg.isPubSub() && !mg.isDiscardable() && opts.isPersistent() && !fromDb) {
            int size;
            int count;
            if (mg.getType() == 27) {
                count = mg.getBatchHandle().getBatchSize();
                size = mg.getBatchHandle().getDurableBatchSerializedLength();
            } else {
                count = 1;
                size = mg.getBrokerHandle().getTrackedSize();
            }
            this.getDurableCCTracker().messageAdded(count, size);
        }
        return this.m_delegate.send(mg, opts, pubLimiter);
    }

    @Override
    public void setCWADSActiveBroker(IClientContext newActiveBrokerCC, boolean SMOtoNonSMODowngrade) {
        if (this.DEBUG_UNEXPECTED && this.m_delegate.getState() > 2) {
            BrokerComponent.logMessage(new EAssertFailure("Unexpected attempt to change active location of durable" + this.getUid() + "/" + this.getAppid() + " to " + newActiveBrokerCC + " while in state: " + this.m_delegate.getState()), BrokerComponent.getLevelWarning());
        }
        this.waitForProxyUnfreeze();
        IClientContext oldActiveBrokerCC = this.m_CWADSActiveBroker;
        IClientContext oldPreviousBrokerCC = this.m_CWADSPreviousBroker;
        IClientContext oldRestoringBrokerCC = this.m_CWADSRestoringBroker;
        BrokerSubscription bs = this.getDurableBrokerSubscription();
        boolean isSMO = false;
        if (bs != null) {
            isSMO = bs.getDurableStrictMessageOrder();
        }
        if (this.DEBUG0) {
            this.debug("setCWADSActiveBroker for \n newActiveBrokerCC is " + this.getBrokerFromCC(newActiveBrokerCC) + "\n oldActiveBrokerCC is " + this.getBrokerFromCC(oldActiveBrokerCC) + "\n oldPreviousBrokerCC is " + this.getBrokerFromCC(oldPreviousBrokerCC) + "\n oldRestoringBrokerCC is " + this.getBrokerFromCC(oldRestoringBrokerCC) + "\n bs = " + bs);
        }
        if (newActiveBrokerCC != null) {
            if (oldActiveBrokerCC != null) {
                if (newActiveBrokerCC.getId() != oldActiveBrokerCC.getId()) {
                    if (this.DEBUG1) {
                        this.debug("oldActiveBrokerCC: " + this.getBrokerFromCC(oldActiveBrokerCC) + " not equal to newActiveBrokerCC: " + this.getBrokerFromCC(newActiveBrokerCC));
                    }
                    return;
                }
                if (SMOtoNonSMODowngrade) {
                    if (this.DEBUG0) {
                        this.debug("We're already connected as far as cwads is concerned, but there's been a local SMOtoNonSMODowngrade so we reassert setCWADSActiveBroker for newActiveBrokerCC: " + newActiveBrokerCC);
                    }
                } else {
                    if (this.DEBUG0) {
                        this.debug("No active broker change in setCWADSActiveBroker");
                    }
                    return;
                }
            }
            if (newActiveBrokerCC.getId() == this.m_delegator.getId()) {
                if (oldPreviousBrokerCC == null) {
                    if (this.DEBUG1) {
                        this.debug("ConCase 1: Locally connecting, no previous, and smo/non-SMO setting doesn't matter. bs.getDurableStrictMessageOrder() = " + isSMO);
                    }
                    this.populateBrokers(newActiveBrokerCC);
                } else if (oldPreviousBrokerCC.getId() == this.m_delegator.getId()) {
                    if (oldRestoringBrokerCC == null) {
                        if (this.DEBUG1) {
                            this.debug("ConCase 2: Locally connecting, I'm the previous, no ongoing restore. Treat smo/non-smo the same as non-SMO bs.getDurableStrictMessageOrder() = " + isSMO);
                        }
                        this.m_CWADSActiveBroker = newActiveBrokerCC;
                        this.m_CWADSPreviousBroker = newActiveBrokerCC;
                    } else if (isSMO) {
                        this.m_CWADSActiveBroker = newActiveBrokerCC;
                        this.m_CWADSPreviousBroker = newActiveBrokerCC;
                        if (this.DEBUG1) {
                            this.debug("ConCase 3: Locally connecting, I'm the previous, ongoing restore. bs.getDurableStrictMessageOrder() = " + isSMO);
                        }
                    } else {
                        if (this.DEBUG1) {
                            this.debug("ConCase 4: Locally connecting, I'm the previous, ongoing restore and no i'm downgrading from smo to non-smo. bs.getDurableStrictMessageOrder() = " + isSMO);
                        }
                        this.populateBrokers(newActiveBrokerCC);
                    }
                } else if (oldRestoringBrokerCC == null) {
                    if (isSMO) {
                        if (this.DEBUG1) {
                            this.debug("ConCase 5: Locally connecting, I'm NOT the previous, and SMO set and no ongoing restore");
                        }
                        this.m_CWADSRestoringBroker = this.m_CWADSPreviousBroker;
                        this.m_CWADSActiveBroker = newActiveBrokerCC;
                        this.m_CWADSPreviousBroker = newActiveBrokerCC;
                    } else {
                        if (this.DEBUG1) {
                            this.debug("ConCase 6: Locally connecting, I'm NOT the previous, and non-SMO set and no ongoing restore");
                        }
                        this.m_CWADSActiveBroker = newActiveBrokerCC;
                        this.m_CWADSPreviousBroker = newActiveBrokerCC;
                    }
                } else if (isSMO) {
                    if (this.DEBUG0) {
                        this.debug("ConCase 7: Locally connecting, I'm NOT the previous,  SMO set, and there is an ongoing restore. oldRestoringBrokerCC: " + this.getBrokerFromCC(oldRestoringBrokerCC));
                    }
                    this.m_CWADSActiveBroker = newActiveBrokerCC;
                } else {
                    if (this.DEBUG0) {
                        this.debug("ConCase 8: Locally connecting, I'm NOT the previous,  non-SMO set, and there is an ongoing restore. oldRestoringBrokerCC: " + this.getBrokerFromCC(oldRestoringBrokerCC) + " will be aborted so we can proceed with non-SMO.");
                    }
                    this.populateBrokers(newActiveBrokerCC);
                }
                s_reg.getCWADSMsgHandler().sendCWADSUpdate(this.m_delegator);
            } else {
                this.m_CWADSActiveBroker = newActiveBrokerCC;
                if (this.DEBUG0) {
                    this.debug("Set CWADS Active Broker to " + this.getBrokerFromCC(this.m_CWADSActiveBroker) + " used to be: " + this.getBrokerFromCC(oldActiveBrokerCC));
                }
            }
        } else if (this.isRemotelyConnected()) {
            this.m_CWADSActiveBroker = null;
            if (this.DEBUG1) {
                this.debug("Remotely disconnecting  m_CWADSPreviousBroker: " + this.getBrokerFromCC(this.m_CWADSPreviousBroker));
            }
        } else {
            this.m_CWADSActiveBroker = newActiveBrokerCC;
            if (SMOtoNonSMODowngrade) {
                this.m_CWADSRestoringBroker = null;
            }
            if (this.DEBUG1) {
                this.debug("Locally disconnecting m_CWADSActiveBroker= " + this.getBrokerFromCC(this.m_CWADSActiveBroker) + "\n m_CWADSPreviousBroker: " + this.getBrokerFromCC(this.m_CWADSPreviousBroker));
            }
        }
        if (bs != null) {
            if (this.m_CWADSPreviousBroker != null) {
                bs.setPreviousBrokerCID(this.m_CWADSPreviousBroker.getId());
            } else {
                bs.setPreviousBrokerCID(-1L);
            }
            if (this.m_CWADSRestoringBroker != null) {
                bs.setRestoreToBrokerCID(this.m_CWADSRestoringBroker.getId());
            } else {
                bs.setRestoreToBrokerCID(-1L);
            }
        }
    }

    private void populateBrokers(IClientContext newActiveBrokerCC) {
        this.m_CWADSActiveBroker = newActiveBrokerCC;
        this.m_CWADSPreviousBroker = newActiveBrokerCC;
        this.m_CWADSRestoringBroker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void waitForProxyAcks() throws InterruptedException {
        if (!InterbrokerHook.isSet()) {
            return;
        }
        try {
            this.m_delegator.getProxyingHandle().freezeProxy();
            if (!this.isRemotelyConnected()) return;
            if (this.DEBUG0) {
                this.debug("waitForProxyAcks Remotely connected!!! ");
            }
            while (!this.m_CWADSActiveBroker.isDisconnecting()) {
                if (this.m_CWADSActiveBroker.getState() == 0) return;
                Object object = this.m_delegator.getSyncObj();
                synchronized (object) {
                    if (this.m_delegator.getOutQueue().countPending() <= 0) return;
                    this.m_delegator.getSyncObj().wait();
                }
            }
            return;
        }
        finally {
            this.m_delegator.getProxyingHandle().unfreezeProxy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveUnsentProxyMessages() {
        block13: {
            if (!InterbrokerHook.isSet()) {
                return;
            }
            try {
                this.m_delegator.getProxyingHandle().freezeProxy();
                if (!this.isRemotelyConnected()) break block13;
                if (this.DEBUG1) {
                    this.debug("saveUnsectProxyMessages ... Remotely connected!!! ");
                }
                Iterator unsentForwards = null;
                Object object = this.m_CWADSActiveBroker.getSyncObj();
                synchronized (object) {
                    unsentForwards = this.m_CWADSActiveBroker.getOutQueue().removeForwardedMsgs(this.m_delegator.getId());
                }
                LinkedList unsentGuars = null;
                Object object2 = this.m_delegator.getSyncObj();
                synchronized (object2) {
                    unsentGuars = this.m_delegator.getOutQueue().saveUnsentGuarsInPending(unsentForwards);
                }
                if (unsentGuars != null) {
                    for (IMgram m : unsentGuars) {
                        this.saveMgram(m, m.isSuccessor(), false);
                    }
                }
            }
            finally {
                this.m_delegator.getProxyingHandle().unfreezeProxy();
            }
        }
    }

    private void saveMgram(IMgram m, boolean jms_redelivery, boolean inDoubt) {
        if (this.m_delegator.isGroupSubscriptionMember()) {
            this.getGroupSubscriptionCC().processGroupMemberMgram(m, null, this.m_delegator, jms_redelivery, inDoubt, true);
        } else if (!m.getBrokerHandle().isFromDB()) {
            this.m_delegator.notifySave(m, true);
            s_reg.getMsgSaver().save(m, (IClientContext)this.m_delegator, jms_redelivery, inDoubt, true);
        }
    }

    @Override
    public IClientContext getCWADSActiveBroker() {
        return this.m_CWADSActiveBroker;
    }

    @Override
    public final void handleNormalAck(long tracking, boolean txnCommit, IMgram ack, IMgram ackedMgram) {
        if (!(ackedMgram == null || ackedMgram.getBrokerHandle().isFromDB() || ack != null && ack.getAckHandle().isSubjectAck())) {
            int count = 1;
            int size = 0;
            if (ackedMgram.getType() == 27) {
                count = ackedMgram.getBatchHandle().getBatchSize();
                size = ackedMgram.getBatchHandle().getDurableBatchSerializedLength();
            } else {
                count = 1;
                size = ackedMgram.getBrokerHandle().getTrackedSize();
            }
            this.getDurableCCTracker().messageRemoved(count, size);
        }
        this.m_delegate.handleNormalAck(tracking, txnCommit, ack, ackedMgram);
    }

    @Override
    public IMgram removeMsgPendingAck(long tracking) {
        IMgram ret = this.m_delegate.removeMsgPendingAck(tracking);
        this.removeInDoubtProxyMessage(tracking);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeInDoubtProxyMessage(long tracking) {
        if (!Config.ENABLE_INTERBROKER) {
            return;
        }
        boolean checkStartRestore = false;
        boolean updateProxyDoubtStatus = false;
        InDoubtProxyMessageTracker inDoubtProxyMessageTracker = this.m_inDoubtProxyTracker;
        synchronized (inDoubtProxyMessageTracker) {
            updateProxyDoubtStatus = this.m_inDoubtProxyTracker.removeMessage(tracking);
            if (updateProxyDoubtStatus && !this.m_inDoubtProxyTracker.hasInDoubtMessages()) {
                checkStartRestore = true;
            }
        }
        if (updateProxyDoubtStatus) {
            this.m_delegator.lock();
            try {
                this.setProxyDoubtStatus();
            }
            finally {
                this.m_delegator.unlock();
            }
        }
        if (checkStartRestore) {
            this.checkDeferredStartDelivery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNewPreviousBrokerNotification(long senderID) throws InterruptedException {
        if (this.DEBUG0) {
            this.debug("handleNewPreviousBrokerNotification entering from:" + this.getBrokerFromCC(senderID) + " previous: " + this.getBrokerFromCC(this.m_CWADSPreviousBroker));
        }
        this.m_delegator.getProxyingHandle().lockProxy();
        DurableSMOUpdateEvt evt = null;
        try {
            IClientContext newPreviousBrokerCC = null;
            try {
                newPreviousBrokerCC = AgentRegistrar.getAgentRegistrar().getClient(senderID);
            }
            catch (EClientNotRegistered ecnr) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ecnr, 2);
                this.m_delegator.getProxyingHandle().unlockProxy();
                return;
            }
            if (this.m_CWADSPreviousBroker != null && this.m_CWADSPreviousBroker.getId() != senderID) {
                if (this.DEBUG0) {
                    this.debug("Ignoring new previous broker notification from: " + this.getBrokerFromCC(newPreviousBrokerCC) + " because it is not our previous");
                }
                return;
            }
            this.m_CWADSRestoringBroker = null;
            if (this.isLocallyConnected()) {
                this.m_CWADSPreviousBroker = this.m_delegator;
                this.m_CWADSRestoringBroker = newPreviousBrokerCC;
            }
            long previousId = this.m_CWADSPreviousBroker != null ? this.m_CWADSPreviousBroker.getId() : -1L;
            long restoringId = this.m_CWADSRestoringBroker != null ? this.m_CWADSRestoringBroker.getId() : -1L;
            evt = new DurableSMOUpdateEvt(this.m_delegator.getId(), previousId, restoringId);
            BrokerSubscription bs = this.getDurableBrokerSubscription();
            if (bs != null) {
                bs.setPreviousBrokerCID(previousId);
                bs.setRestoreToBrokerCID(restoringId);
            }
            if (this.isLocallyConnected()) {
                s_reg.getCWADSMsgHandler().sendCWADSUpdate(this.m_delegator);
            }
        }
        finally {
            this.m_delegator.getProxyingHandle().unlockProxy();
        }
        if (evt != null) {
            s_reg.getAgentRegistrar().logDurableSubscriptionSMOUpdate(true, this.m_delegator, evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoteRestoreDone() throws InterruptedException {
        if (this.DEBUG0) {
            this.debug("handleRemoteRestoreDone called");
        }
        boolean logDurableSMOUpdateEvt = false;
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            BrokerSubscription bs = this.getDurableBrokerSubscription();
            if (bs != null && bs.getDurableStrictMessageOrder()) {
                s_reg.getCWADSMsgHandler().sendNewPreviousBrokerNotification(this.m_delegator);
                if (this.m_CWADSRestoringBroker != null) {
                    logDurableSMOUpdateEvt = true;
                    IClientContext restoring = this.m_CWADSRestoringBroker;
                    this.m_delegator.setCWADSRestoringBroker(null);
                    Object object2 = this.m_rrdWaitLock;
                    synchronized (object2) {
                        this.m_rrdWaitLock.notifyAll();
                        if (this.DEBUG1) {
                            this.debug("Notifying m_rrdWaitLock handleRemoteRestoreDone()");
                        }
                    }
                    if (this.isLocallyConnected()) {
                        if (this.DEBUG1) {
                            this.debug("handleRemoteRestoreDone: m_CWADSRestoringBroker = " + this.getBrokerFromCC(restoring) + "  need to send to all neighbors a CWADS_UPDATE now.");
                        }
                        s_reg.getCWADSMsgHandler().sendCWADSUpdate(this.m_delegator);
                    } else if (this.DEBUG1) {
                        this.debug("handleRemoteRestoreDone: skipping  m_CWADSRestoringBroker = " + this.getBrokerFromCC(restoring) + " need to send to all neighbors except restoring the CWADS_UPDATE now.");
                    }
                }
            }
        }
        if (logDurableSMOUpdateEvt) {
            DurableSMOUpdateEvt evt = new DurableSMOUpdateEvt(this.m_delegator.getId(), this.m_delegator.getCWADSPreviousBroker().getId(), -1L);
            s_reg.getAgentRegistrar().logDurableSubscriptionSMOUpdate(true, this.m_delegator, evt);
        }
    }

    @Override
    public void cancelMsgRestore() {
        s_reg.getRemoteRestoreManager().cancelRemoteRestore(this.m_delegator);
        this.m_delegate.cancelMsgRestore();
    }

    @Override
    public boolean redirectToProxy() {
        return this.m_sendingLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDelivery(Envelope req) {
        BrokerSubscription bs;
        if (this.DEBUG1) {
            this.debug("start delivery called.");
        }
        if ((bs = this.getDurableBrokerSubscription()) == null) {
            s_reg.getRemoteRestoreManager().cancelRemoteRestore(this.m_delegator);
            return false;
        }
        if (InterbrokerHook.isSet() && !bs.getDurableStrictMessageOrder() && this.isLocallyConnected()) {
            if (this.DEBUG0) {
                this.debug(" non-SMO and locally connected so must propagate CWADS_STARTDELIVERY to everyone.");
            }
            AgentRegistrar.getAgentRegistrar().getCWADSMsgHandler().sendCWADSStartDelivery(this);
        }
        try {
            this.flushProxyDoubtStatus();
        }
        catch (InterruptedException ie) {
            s_reg.getRemoteRestoreManager().remoteRestoreDone(this.m_delegator);
            return false;
        }
        if (InterbrokerHook.isSet() && !bs.getDurableStrictMessageOrder()) {
            InDoubtProxyMessageTracker inDoubtProxyMessageTracker = this.m_inDoubtProxyTracker;
            synchronized (inDoubtProxyMessageTracker) {
                if (!this.m_inDoubtProxyTracker.okToStartDelivery()) {
                    this.m_restoreDeferred = true;
                    this.m_restoreDeferredForProxyAcks = true;
                }
                if (this.m_restoreDeferredForProxyAcks) {
                    s_reg.getRemoteRestoreManager().remoteRestoreDone(this.m_delegator);
                    return true;
                }
                if (this.m_inDoubtProxyTracker.hasInDoubtProxies()) {
                    this.m_restoreDeferred = true;
                    this.trySwitchLive(new IStateSwitcher(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void doStateChangeOp(Object arg) {
                            Object object = DurableClientContext.this.m_delegate.getSyncObj();
                            synchronized (object) {
                                DurableClientContext.this.m_delegate.setState(8);
                                DurableClientContext.this.m_delegate.getSyncObj().notifyAll();
                            }
                        }
                    }, null);
                    s_reg.getRemoteRestoreManager().remoteRestoreDone(this.m_delegator);
                    return true;
                }
            }
        }
        return this.m_delegate.startDelivery(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stopDelivery() {
        if (InterbrokerHook.isSet()) {
            try {
                InDoubtProxyMessageTracker inDoubtProxyMessageTracker = this.m_inDoubtProxyTracker;
                synchronized (inDoubtProxyMessageTracker) {
                    this.m_restoreDeferred = false;
                    this.m_restoreDeferredForProxyAcks = false;
                }
                s_reg.getRemoteRestoreManager().cancelRemoteRestore(this.m_delegator);
                this.m_delegator.getProxyingHandle().freezeProxy();
                if (this.isRemotelyConnected()) {
                    try {
                        s_reg.getMsgProc().lockPubDispatch();
                        boolean sendNotification = false;
                        this.m_delegator.cancelMsgRestore();
                        Object object = this.m_dispatchSwitchLock;
                        synchronized (object) {
                            if (this.DEBUG0) {
                                this.debug("Stopping delivery.");
                            }
                            this.m_delegate.stopDelivery();
                            if (this.m_sendingLive) {
                                if (this.DEBUG0) {
                                    this.debug("resetting sending live flag.");
                                }
                                this.m_sendingLive = false;
                                sendNotification = true;
                            }
                        }
                        if (!sendNotification) return;
                        this.m_CWADSActiveBroker.waitForPubDispatches();
                        this.m_delegator.waitForPubDispatches();
                        if (this.DEBUG0) {
                            this.debug("Sending last message notification");
                        }
                        this.m_CWADSActiveBroker.sendPriorityPush(MgramFactory.getMgramFactory().buildLastMessageNotification(this.m_delegator.getId()), 0, 9);
                        return;
                    }
                    finally {
                        s_reg.getMsgProc().unlockPubDispatch();
                    }
                }
                this.m_delegate.stopDelivery();
                return;
            }
            finally {
                this.m_delegator.getProxyingHandle().unfreezeProxy();
            }
        }
        this.m_delegate.stopDelivery();
    }

    @Override
    public IClientContext getCWADSPreviousBroker() {
        return this.m_CWADSPreviousBroker;
    }

    @Override
    public void setCWADSPreviousBroker(IClientContext prevBroker) {
        if (this.DEBUG0) {
            this.debug("Setting previous broker to : " + this.getBrokerFromCC(prevBroker) + "\n current value prev broker is: " + this.getBrokerFromCC(this.m_CWADSPreviousBroker));
        }
        this.m_CWADSPreviousBroker = prevBroker;
        BrokerSubscription bs = this.getDurableBrokerSubscription();
        if (bs != null) {
            bs.setPreviousBrokerCID(prevBroker != null ? prevBroker.getId() : -1L);
        }
    }

    @Override
    public void setCWADSRestoringBroker(IClientContext brokercc) {
        if (this.DEBUG0) {
            this.debug("Setting restoring broker to : " + this.getBrokerFromCC(brokercc) + "\n current value prev broker is: " + this.getBrokerFromCC(this.m_CWADSRestoringBroker));
        }
        this.m_CWADSRestoringBroker = brokercc;
        BrokerSubscription bs = this.getDurableBrokerSubscription();
        if (bs != null) {
            bs.setRestoreToBrokerCID(brokercc != null ? brokercc.getId() : -1L);
        }
    }

    @Override
    public final void recoveryComplete() {
        if (this.DEBUG1) {
            this.debug("Recovery Complete start isResumable: " + this.m_delegator.isResumable() + "active: " + this.getBrokerFromCC(this.m_CWADSActiveBroker) + " previous: " + this.getBrokerFromCC(this.m_CWADSPreviousBroker) + " restoring: " + this.getBrokerFromCC(this.m_CWADSRestoringBroker) + " state: " + this.m_delegator.getState());
        }
        this.m_delegate.recoveryComplete();
        if (this.m_delegate.isResumable() && Config.ENABLE_INTERBROKER) {
            this.m_CWADSActiveBroker = this.m_delegator;
        }
        if (this.DEBUG1) {
            this.debug("Recovery Complete end: isResumable: " + this.m_delegator.isResumable() + "active: " + this.getBrokerFromCC(this.m_CWADSActiveBroker) + " previous: " + this.getBrokerFromCC(this.m_CWADSPreviousBroker) + " restoring: " + this.getBrokerFromCC(this.m_CWADSRestoringBroker) + " state: " + this.m_delegator.getState());
        }
    }

    @Override
    public void resumePreempted() {
        if (Config.ENABLE_INTERBROKER && this.m_delegate.isResumable()) {
            try {
                this.lockProxy();
                this.setCWADSActiveBroker(null, false);
            }
            finally {
                this.unlockProxy();
            }
        }
        this.m_delegate.resumePreempted();
    }

    @Override
    public void setDisconnectAfterFinalRemoteRestore(boolean flag) {
        this.m_disconnectAfterFinalRemoteRestore = flag;
        if (flag) {
            this.m_delegator.setDisconnecting(false);
        }
    }

    @Override
    public boolean getDisconnectAfterFinalRemoteRestore() {
        return this.m_disconnectAfterFinalRemoteRestore;
    }

    @Override
    public IClientContext getCWADSRestoringBroker() {
        return this.m_CWADSRestoringBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int forward(IMgram m, Label opts, PublishLimiter pubLimiter) {
        if (this.DEBUG) {
            this.debug("Forwarding message: GUAR=" + m.getGuarenteedTrackingNum() + "STATE=" + this.m_delegator.getState() + " CWADSAct State=" + this.m_CWADSActiveBroker.getState());
        }
        switch (this.m_delegator.getState()) {
            case -1: {
                return 2;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.DEBUG) {
                    this.debug("forwading message GUAR=" + m.getGuarenteedTrackingNum() + " STATE= " + this.m_delegator.getState() + " active broker " + this.getBrokerFromCC(this.m_CWADSActiveBroker) + " State=" + this.m_CWADSActiveBroker.getState());
                }
            }
            case 6: {
                if (opts.isNonStop()) {
                    Object object = this.m_CWADSActiveBroker.getSyncObj();
                    synchronized (object) {
                        this.proxyForwardInternal(m, null);
                    }
                    return 0;
                }
                if (m.isDiscardable()) {
                    return 2;
                }
                if (this.DEBUG) {
                    this.debug(this + " Deferring msg: GUAR=" + m.getGuarenteedTrackingNum());
                }
                return 3;
            }
            case 7: {
                if (m.isDiscardable()) {
                    if (this.DEBUG1) {
                        this.debug("Discarding mgram in FINAL_RESTORE, GUAR=" + m.getGuarenteedTrackingNum());
                    }
                    return 2;
                }
                if (opts.isNonStop()) {
                    Object object = this.m_CWADSActiveBroker.getSyncObj();
                    synchronized (object) {
                        this.proxyForwardInternal(m, null);
                    }
                    return 0;
                }
                if (this.DEBUG) {
                    this.debug("Adding message to wait queue in forward GUAR=" + m.getGuarenteedTrackingNum());
                }
                try {
                    if (this.CALLBACK) {
                        this.callback("DurableClientContext", 201, new Object[]{this.m_CWADSActiveBroker.getConnection(), m});
                    }
                    this.m_delegate.getOutQueue().enqueueWait(m, pubLimiter);
                }
                catch (EDuplicateKey edk) {
                    EAssertFailure t = new EAssertFailure(this + ": Duplicate message enqueue attempt on wait queue!");
                    BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
                }
                return 0;
            }
            case 8: {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage(this + ": forwarding message. STATE=STARTED, GUAR=" + m.getGuarenteedTrackingNum(), 3);
                }
                Object object = this.m_CWADSActiveBroker.getSyncObj();
                synchronized (object) {
                    this.proxyForwardInternal(m, pubLimiter);
                }
                return 0;
            }
            case 0: 
            case 1: {
                if (m.isDiscardable()) {
                    return 2;
                }
                return 1;
            }
        }
        throw new EAssertFailure("Invalid state for forward attempt: " + this.m_delegator.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forwardRestored(IMgram msg) throws InterruptedException, EDuplicateKey {
        GroupSubscriptionClientContext groupcc;
        if (!(InterbrokerHook.isSet() && this.isRemotelyConnected() && this.inRestoringState())) {
            return false;
        }
        if (this.DEBUG) {
            this.debug("Forwarding Restored Message: GUAR: " + msg.getGuarenteedTrackingNum() + " PROXY=" + this.getBrokerFromCC(this.m_CWADSActiveBroker));
        }
        if ((groupcc = this.m_delegate.getGroupSubscriptionCC()) != null) {
            if (this.DEBUG_UNEXPECTED) {
                this.debug("Sending forward restored message back to group: " + msg.getGuarenteedTrackingNum());
            }
            groupcc.processGroupMemberMgram(msg, null, this.m_delegator, false, false, false);
        } else {
            Object object = this.m_CWADSActiveBroker.getSyncObj();
            synchronized (object) {
                if (this.CALLBACK) {
                    this.callback("DurableClientContext", 200, new Object[]{this.m_CWADSActiveBroker.getConnection(), msg});
                }
                this.proxyForwardInternal(msg, null);
            }
        }
        return true;
    }

    private final boolean inRestoringState() {
        switch (this.m_delegator.getState()) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                return !this.m_CWADSActiveBroker.isDisconnecting() && this.m_CWADSActiveBroker.isConnected();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean waitForRestoreSpace(IMgram m) throws InterruptedException {
        Object object;
        if (!InterbrokerHook.isSet()) return this.m_delegate.waitForRestoreSpace(m);
        if (!this.isRemotelyConnected()) {
            return this.m_delegate.waitForRestoreSpace(m);
        }
        try {
            object = this.m_delegate.getSyncObj();
            synchronized (object) {
                while (!this.m_delegate.getOutQueue().hasRoomForPendingGuar(m)) {
                    if (!this.inRestoringState()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.m_waitingForRestoreSpace = true;
                    this.m_delegate.getSyncObj().wait();
                }
            }
        }
        finally {
            this.m_waitingForRestoreSpace = false;
        }
        try {
            object = this.m_CWADSActiveBroker.getSyncObj();
            synchronized (object) {
                while (!this.m_CWADSActiveBroker.getOutQueue().hasRoomForForward(m)) {
                    if (!this.inRestoringState()) {
                        boolean bl = false;
                        return bl;
                    }
                    this.m_waitingForRestoreSpace = true;
                    this.m_CWADSActiveBroker.getSyncObj().wait();
                }
                return true;
            }
        }
        finally {
            this.m_waitingForRestoreSpace = false;
        }
    }

    @Override
    public boolean isWaitingForRestoreSpace() {
        return this.m_waitingForRestoreSpace || this.m_delegate.isWaitingForRestoreSpace();
    }

    private void proxyForwardInternal(IMgram msg, PublishLimiter pubLimiter) {
        ISubjectFilter sf2;
        if (msg.getType() == 27 && !msg.getBatchHandle().isAtomic()) {
            Iterator it = msg.getBatchHandle().getBatchIterator();
            while (it.hasNext()) {
                IMgram subMgram = (IMgram)it.next();
                this.proxyForwardInternal(subMgram, pubLimiter);
            }
            return;
        }
        IMgram fwdMsg = MgramFactory.getMgramFactory().buildSingleTargetMessage(this.m_delegate.getId(), msg);
        if (!msg.hasSubject()) {
            BrokerComponent.getBrokerComponent();
            BrokerComponent.logMessage("Unable to forward message without subject: " + MgramTrace.diagnosticString("DurableClientContext", null, msg), new EAssertFailure("Unable to forward message without subject"), BrokerComponent.getLevelWarning());
            return;
        }
        if (msg.getSubject().isMultiSubject() && (sf2 = msg.getBrokerHandle().getSubjectFilter(this.m_delegator.getSubjectFilterId())) != null) {
            fwdMsg.getBrokerHandle().addSubjectFilter(this.m_CWADSActiveBroker.getSubjectFilterId(), sf2);
        }
        if (this.DEBUG) {
            this.debug("Enqueueing forwarded msg GUAR=" + msg.getGuarenteedTrackingNum() + " PROXY=" + this.getBrokerFromCC(this.m_CWADSActiveBroker));
        }
        if (msg.isGuarenteed()) {
            try {
                this.m_delegator.getOutQueue().setFwdGuarMsgPending(msg, pubLimiter);
            }
            catch (EDuplicateKey sf2) {
                // empty catch block
            }
        }
        this.m_CWADSActiveBroker.getOutQueue().enqueueForward(fwdMsg, pubLimiter);
        AgentConnection conn = this.m_CWADSActiveBroker.getConnection();
        if (conn != null) {
            conn.getAgentSender().notifyEnqueue(this.m_CWADSActiveBroker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rcvdSingleTargetMsg(IMgram msg) {
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            long sender = msg.getBrokerHandle().getSenderID();
            if (this.isProxyRestoreComplete(sender)) {
                // empty if block
            }
            msg.getBrokerHandle().setTargeted(true);
            msg.getBrokerHandle().setRedirectAckTarget(this.m_delegator.getId());
        }
    }

    @Override
    public void restoreComplete(MsgRestorePos pos) {
        if (this.DEBUG1) {
            this.debug("restore complete.");
        }
        this.trySwitchLive(new IStateSwitcher(){

            @Override
            public void doStateChangeOp(Object arg) {
                DurableClientContext.this.m_delegate.restoreComplete((MsgRestorePos)arg);
            }
        }, pos);
        s_reg.getRemoteRestoreManager().remoteRestoreDone(this.m_delegator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void trySwitchLive(IStateSwitcher switcher, Object arg) {
        if (InterbrokerHook.isSet()) {
            try {
                this.m_delegator.getProxyingHandle().freezeProxy();
                if (this.isRemotelyConnected()) {
                    try {
                        s_reg.getMsgProc().lockPubDispatch();
                        if (this.DEBUG1) {
                            this.debug("Attempting to go live.");
                        }
                        boolean sendNotification = false;
                        Object object = this.m_dispatchSwitchLock;
                        synchronized (object) {
                            if (this.m_CWADSActiveBroker.getState() == 8 && !this.m_sendingLive) {
                                this.m_sendingLive = true;
                                sendNotification = true;
                            } else if (this.DEBUG1) {
                                this.debug("Switch to live deferred.... active state: " + this.m_CWADSActiveBroker.getState() + ", sendingLive: " + this.m_sendingLive);
                            }
                            switcher.doStateChangeOp(arg);
                        }
                        if (!sendNotification) return;
                        this.m_delegate.waitForPubDispatches();
                        this.m_CWADSActiveBroker.waitForPubDispatches();
                        if (this.DEBUG1) {
                            BrokerComponent.getComponentContext().logMessage(this + " restore complete. Sending first message notification", 3);
                        }
                        this.m_CWADSActiveBroker.sendPriorityPush(MgramFactory.getMgramFactory().buildFirstMessageNotification(this.m_delegator.getId()), 0, 9);
                        return;
                    }
                    finally {
                        s_reg.getMsgProc().unlockPubDispatch();
                    }
                }
                switcher.doStateChangeOp(arg);
                return;
            }
            finally {
                this.m_delegator.getProxyingHandle().unfreezeProxy();
            }
        }
        switcher.doStateChangeOp(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyProxyRestoreComplete(IClientContext proxy) {
        boolean sendNotification = false;
        Object object = this.m_dispatchSwitchLock;
        synchronized (object) {
            if (this.m_delegator.getState() == 8 && !this.m_sendingLive) {
                this.m_sendingLive = true;
                sendNotification = true;
            }
        }
        if (sendNotification) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage(this + " proxy restore complete ... sending FIRST_MSG_NOTIFICATION to " + proxy, 3);
            }
            this.m_delegator.waitForPubDispatches();
            if (this.DEBUG1) {
                this.debug("Sending first message notification");
            }
            this.m_CWADSActiveBroker.sendPriorityPush(MgramFactory.getMgramFactory().buildFirstMessageNotification(this.m_delegator.getId()), 0, 9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePendingReconnectGuars(boolean onlyFromRemote) {
        if (InterbrokerHook.isSet()) {
            if (this.isRemotelyConnected()) {
                Iterator prGuars = null;
                prGuars = !onlyFromRemote ? this.m_delegator.getOutQueue().clearPendingReconnectGuars().values().iterator() : this.m_delegator.getOutQueue().getPendingReconnectGuars();
                IMgram m = null;
                ICCGuarDoubtManager dm = this.m_delegator.getGuarDoubtManager();
                GroupSubscriptionClientContext groupcc = this.m_delegator.getGroupSubscriptionCC();
                while (prGuars.hasNext()) {
                    m = (IMgram)prGuars.next();
                    if (onlyFromRemote && !m.getBrokerHandle().isFromRemoteBroker()) {
                        if (!this.DEBUG1) continue;
                        this.debug("Skipping release of non remote message during full release.");
                        continue;
                    }
                    prGuars.remove();
                    m = dm.makeSuccessorClone(m);
                    if (groupcc != null) {
                        if (this.DEBUG_UNEXPECTED) {
                            this.debug("Sending forward PRQ message back to group: " + m.getGuarenteedTrackingNum());
                        }
                        groupcc.processGroupMemberMgram(m, null, this.m_delegator, false, false, false);
                        continue;
                    }
                    Object object = this.m_CWADSActiveBroker.getSyncObj();
                    synchronized (object) {
                        if (this.DEBUG1) {
                            this.debug("releasePendingReconnectGuars straight to active's proxy when remotely connected guarTrkNum: " + m.getGuarenteedTrackingNum() + " released from PRQ, succ=" + m.isSuccessor() + " senderID " + m.getBrokerHandle().getSenderID());
                        }
                        this.proxyForwardInternal(m, null);
                    }
                }
            } else {
                this.m_delegate.releasePendingReconnectGuars(onlyFromRemote);
            }
        } else {
            this.m_delegate.releasePendingReconnectGuars(onlyFromRemote);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseWaitQueue() {
        if (InterbrokerHook.isSet()) {
            if (this.isRemotelyConnected()) {
                PriorityQueue waitQ = this.m_delegator.getOutQueue().clearWaitQueue();
                IMgram m = null;
                GroupSubscriptionClientContext groupcc = this.m_delegator.getGroupSubscriptionCC();
                while (waitQ.getEnqueued() > 0) {
                    m = (IMgram)waitQ.dequeue();
                    if (groupcc != null) {
                        if (this.DEBUG_UNEXPECTED) {
                            this.debug("Sending forwarded wait q message back to group: " + m.getGuarenteedTrackingNum());
                        }
                        groupcc.processGroupMemberMgram(m, null, this.m_delegator, false, false, false);
                        continue;
                    }
                    Object object = this.m_CWADSActiveBroker.getSyncObj();
                    synchronized (object) {
                        this.proxyForwardInternal(m, null);
                    }
                }
            } else {
                this.m_delegate.releaseWaitQueue();
            }
        } else {
            this.m_delegate.releaseWaitQueue();
        }
    }

    @Override
    public void sendPriorityPush(IMgram msg, int prio, int pushPrio) {
        if (this.isRemotelyConnected()) {
            if (this.DEBUG1) {
                this.debug("Set priority push on m_CWADSActiveBroker: " + this.getBrokerFromCC(this.m_CWADSActiveBroker));
            }
            this.m_CWADSActiveBroker.sendPriorityPush(msg, prio, pushPrio);
        } else {
            if (this.DEBUG1) {
                this.debug("Set priority push on m_delegate: " + this.getBrokerFromCC(this.m_delegate));
            }
            this.m_delegate.sendPriorityPush(msg, prio, pushPrio);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareToSend(IMgram mg, Label label, boolean targeted, long dispatchId, ISubject matchSubject) {
        if (!this.m_delegate.isGroupSubscriptionMember() && !targeted && InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(mg.getBrokerHandle().getSenderID()) && !SessionConfig.isSystemSubject(mg.getSubject())) {
            HashSet hashSet = this.m_liveInboundProxies;
            synchronized (hashSet) {
                if (!this.m_liveInboundProxies.contains(new Long(mg.getBrokerHandle().getSenderID()))) {
                    if (this.DEBUG) {
                        this.debug("Dropping message from unrestored proxy client: GUAR=" + mg.getGuarenteedTrackingNum());
                    }
                    return false;
                }
            }
        }
        if (this.CALLBACK) {
            this.callback("DurableClientContext", 202, new Object[]{this.m_delegate, mg});
        }
        return this.m_delegate.prepareToSend(mg, label, targeted, dispatchId, matchSubject);
    }

    @Override
    public void onInboundProxyDisconnect(IClientContext inboundProxy) {
        this.m_delegator.getProxyingHandle().removeLiveInboundProxy(inboundProxy.getId());
        this.m_delegator.getProxyingHandle().removeStartedInboundProxy(inboundProxy.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStartedInboundProxy(long clientID) {
        HashSet hashSet = this.m_startedInboundProxies;
        synchronized (hashSet) {
            this.m_startedInboundProxies.add(new Long(clientID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStartedInboundProxy(long clientID) {
        HashSet hashSet = this.m_startedInboundProxies;
        synchronized (hashSet) {
            if (this.DEBUG1) {
                this.debug("Removing started inbound proxy: ID=" + this.getBrokerFromCC(clientID));
            }
            this.removeAndNotify(this.m_startedInboundProxies, clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLiveInboundProxy(long clientID) {
        HashSet hashSet = this.m_liveInboundProxies;
        synchronized (hashSet) {
            if (this.DEBUG1) {
                this.debug("adding restored proxy client: " + this.getBrokerFromCC(clientID));
            }
            this.m_liveInboundProxies.add(new Long(clientID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLiveInboundProxy(long clientID) {
        HashSet hashSet = this.m_liveInboundProxies;
        synchronized (hashSet) {
            if (this.DEBUG1) {
                this.debug("removing restored proxy client: " + this.getBrokerFromCC(clientID));
            }
            this.removeAndNotify(this.m_liveInboundProxies, clientID);
        }
    }

    private void removeAndNotify(HashSet m_liveInboundProxies, long clientID) {
        m_liveInboundProxies.remove(new Long(clientID));
        if (m_liveInboundProxies.isEmpty()) {
            m_liveInboundProxies.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerSubscription getSelectorSubscription() {
        BrokerSubscription sub = null;
        SubscriptionsTable subscriptionsTable = this.m_delegator.getSubscriptions();
        synchronized (subscriptionsTable) {
            Enumeration subs = this.m_delegator.getSubscriptions().elements();
            while (subs.hasMoreElements()) {
                sub = (BrokerSubscription)subs.nextElement();
                if (!sub.hasSelector()) continue;
                return sub;
            }
        }
        return sub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProxyRestoreComplete(long clientID) {
        HashSet hashSet = this.m_liveInboundProxies;
        synchronized (hashSet) {
            return this.m_liveInboundProxies.contains(new Long(clientID));
        }
    }

    @Override
    public String toString() {
        return "DurableCCWrapper for: " + this.m_delegate;
    }

    private final boolean isLocallyConnected() {
        IClientContext activeCC = this.m_CWADSActiveBroker;
        return activeCC != null && activeCC.getId() == this.m_delegator.getId();
    }

    private boolean isRemotelyConnected() {
        IClientContext activeCC = this.m_CWADSActiveBroker;
        return activeCC != null && activeCC.getId() != this.m_delegator.getId();
    }

    private boolean isPreviousBroker() {
        IClientContext previousCC = this.m_CWADSPreviousBroker;
        return previousCC != null && previousCC.getId() == this.m_delegator.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IClientContext preDisconnect(boolean proxyDisconnect) {
        if (!InterbrokerHook.isSet()) {
            return null;
        }
        if (proxyDisconnect) {
            return null;
        }
        IClientContext proxy = null;
        boolean interrupted = false;
        try {
            while (true) {
                Object object;
                if ((proxy = this.getCWADSActiveBroker()) != null && proxy.getProxyHandle() != null) {
                    object = proxy.getSyncObj();
                    synchronized (object) {
                        if (proxy.isDisconnecting()) {
                            if (this.DEBUG0) {
                                this.debug("Waiting for proxy disconnect " + this.getBrokerFromCC(proxy));
                            }
                            try {
                                proxy.getSyncObj().wait();
                            }
                            catch (InterruptedException ex1) {
                                interrupted = true;
                            }
                        }
                    }
                }
                object = this.m_disconnectingProxies;
                synchronized (object) {
                    while (!this.m_disconnectingProxies.isEmpty()) {
                        try {
                            if (this.DEBUG0) {
                                this.debug("Waiting on disconnecting proxies " + this.getBrokerFromCC(proxy));
                            }
                            this.m_disconnectingProxies.wait();
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                        }
                    }
                }
                this.lockProxy();
                try {
                    proxy = this.getCWADSActiveBroker();
                    if (proxy == null || this.isLocallyConnected()) {
                        object = null;
                        return object;
                    }
                    if (proxy == null || proxy.getProxyHandle() == null || !proxy.getProxyHandle().prepareProxyingDisconnect(this.getProxyingHandle())) continue;
                    proxy.getProxyHandle().registerDisconnectNotication(this.getProxyingHandle());
                    proxy.getProxyHandle().proxyUnregister(this.m_delegator);
                    object = proxy;
                    return object;
                }
                finally {
                    this.unlockProxy();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void postDisconnect(boolean proxyDisconnect, IClientContext proxy) {
        if (!InterbrokerHook.isSet()) {
            return;
        }
        if (proxy == null) {
            return;
        }
        boolean unregister = false;
        if (!this.m_inDoubtProxyTracker.hasInDoubtMessages(proxy)) {
            unregister = true;
        }
        if (unregister) {
            proxy.getProxyHandle().unregisterDisconnectNotication(this.getProxyingHandle());
        }
        proxy.getProxyHandle().proxyingDisconnectComplete(this.getProxyingHandle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(AgentConnection conn, boolean isInterbroker, short ackMode) throws EConnectFailure {
        block8: {
            this.m_delegate.connect(conn, isInterbroker, ackMode);
            this.freezeProxy();
            try {
                if (!this.isRemotelyConnected()) break block8;
                try {
                    this.m_CWADSActiveBroker.getProxyHandle().proxyRegister(this.m_delegator);
                }
                catch (ENotConnected ex1) {
                    if (this.DEBUG0) {
                        this.debug("Proxy register failed due to Neighbor disconnect.", ex1);
                    }
                    throw new EConnectFailure(-1, "Proxy registration failed due to Neighbor disconnect.");
                }
                catch (InterruptedException ie) {
                    if (this.DEBUG0) {
                        this.debug("Interrupted duiring proxy register");
                    }
                    Thread.currentThread().interrupt();
                    throw new EConnectFailure(-1, "Proxy registration failed due to Interrupt.");
                }
            }
            finally {
                this.unfreezeProxy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean sync) {
        if (this.DEBUG && InterbrokerHook.isSet() && this.m_CWADSActiveBroker == null) {
            EAssertFailure t = new EAssertFailure("CWADS_DEBUG: disconnect with no active broker!");
            BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
        }
        boolean wasLocal = this.isLocallyConnected();
        IClientContext previousActive = null;
        this.m_delegator.stopDelivery();
        this.m_delegate.disconnect(sync);
        if (InterbrokerHook.isSet()) {
            try {
                this.m_delegator.getProxyingHandle().lockProxy();
                previousActive = this.m_delegator.getCWADSActiveBroker();
                this.m_delegator.setCWADSActiveBroker(null, false);
            }
            finally {
                this.m_delegator.getProxyingHandle().unlockProxy();
            }
            try {
                if (wasLocal) {
                    s_reg.getCWADSMsgHandler().sendCWADSDisconnect(this);
                } else if (previousActive != null && !previousActive.isDisconnecting()) {
                    previousActive.sendPriorityPush(MgramFactory.getMgramFactory().buildDeliveryFinished(this.m_delegator.getId()), 0, 9);
                }
            }
            catch (EGeneralCWADSException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        this.logDisconnect();
    }

    @Override
    public void resume(AgentConnection conn, boolean isInterbroker, short ackMode) throws EAssertFailure, InterruptedException, EConnectionNotResumable {
        this.m_delegate.resume(conn, isInterbroker, ackMode);
    }

    @Override
    public boolean postponeDisconnect() {
        boolean result = this.m_delegate.postponeDisconnect();
        if (result && this.isLocallyConnected()) {
            s_reg.getCWADSMsgHandler().sendCWADSStopDelivery(this);
        }
        return result;
    }

    @Override
    public void pingIfIdle(long preemptingRootId) throws InterruptedException {
        if (InterbrokerHook.isSet()) {
            IClientContext active = this.m_delegator.getCWADSActiveBroker();
            if (active == null) {
                return;
            }
            IClientContext restoring = this.m_delegator.getCWADSRestoringBroker();
            if (active.getId() != this.m_delegator.getId()) {
                if (restoring != null && restoring.getId() == this.m_delegator.getId()) {
                    return;
                }
                try {
                    s_reg.getCWADSMsgHandler().sendCWADSPingRequest(this.m_delegate.getId(), active, preemptingRootId);
                }
                catch (EGeneralCWADSException e) {
                    try {
                        s_reg.prepareDisconnect(this.m_delegate.getId());
                        s_reg.disconnect(this.m_delegate.getId(), true, false, null);
                    }
                    catch (EClientNotRegistered eClientNotRegistered) {
                        // empty catch block
                    }
                }
                return;
            }
            this.m_delegate.pingIfIdle(preemptingRootId);
        } else {
            this.m_delegate.pingIfIdle(preemptingRootId);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void pingReplyRcvd() {
        if (InterbrokerHook.isSet()) {
            IClientContext active = this.m_delegator.getCWADSActiveBroker();
            if (active == null) {
                return;
            }
            if (active.getId() == this.m_delegator.getId()) {
                this.m_delegate.pingReplyRcvd();
                return;
            }
            if (active.getId() == this.m_delegator.getId()) return;
            return;
        } else {
            this.m_delegate.pingReplyRcvd();
        }
    }

    @Override
    public final void setDurableBrokerSubscription(BrokerSubscription bs) {
        this.m_durableSubscription = bs;
    }

    @Override
    public final BrokerSubscription getDurableBrokerSubscription() {
        return this.m_durableSubscription;
    }

    @Override
    public boolean setState(int currentState) {
        BrokerSubscription bs;
        int previousState = this.m_delegate.getState();
        boolean result = this.m_delegate.setState(currentState);
        if (currentState == 0) {
            if (previousState != 0 && this.m_delegator.getLastConnectedTime() == -1L) {
                this.m_delegator.setLastConnectedTime(System.currentTimeMillis());
            }
        } else if (currentState != -1) {
            this.m_delegator.setLastConnectedTime(-1L);
        }
        if (InterbrokerHook.isSet() && currentState == 6 && this.isLocallyConnected() && (bs = this.getDurableBrokerSubscription()) != null && bs.getDurableStrictMessageOrder()) {
            if (this.DEBUG1) {
                this.debug("Sending CWADS_STARTDELIVERY to all neighbors on transition to INIT_RESTORE");
            }
            AgentRegistrar.getAgentRegistrar().getCWADSMsgHandler().sendCWADSStartDelivery(this.m_delegator);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDisconnect() {
        DurableDisconnectEvt discEvt = null;
        if (Config.ENABLE_INTERBROKER) {
            InDoubtProxyMessageTracker inDoubtProxyMessageTracker = this.m_inDoubtProxyTracker;
            synchronized (inDoubtProxyMessageTracker) {
                boolean inDoubt = this.m_inDoubtProxyTracker.hasInDoubtProxies() || this.m_inDoubtProxyTracker.hasInDoubtMessages();
                discEvt = new DurableDisconnectEvt(this.m_delegator.getId(), this.getLastConnectedTime(), inDoubt);
                this.setProxyDoubtStatus();
                if (this.DEBUG1) {
                    this.debug("Logging disconnect, inDoubt=" + inDoubt);
                }
            }
        } else {
            discEvt = new DurableDisconnectEvt(this.m_delegator.getId(), this.getLastConnectedTime(), false);
        }
        AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(discEvt, true);
    }

    private void setProxyDoubtStatus() {
        s_reg.setProxyDoubtStatus(this.m_delegator, this.m_inDoubtProxyTracker.getIndoubtProxyIds());
    }

    @Override
    public void notifyProxyDoubtResolved(IClientContext proxy) {
        if (!Config.ENABLE_INTERBROKER) {
            return;
        }
        if (this.DEBUG0) {
            this.debug("Proxy doubt resolved PROXY=" + this.getBrokerFromCC(proxy));
        }
        try {
            this.m_delegator.lock();
            this.m_inDoubtProxyTracker.notifyProxyDoubtResolved(proxy);
        }
        finally {
            this.m_delegator.unlock();
        }
        this.checkDeferredStartDelivery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkDeferredStartDelivery() {
        if (!Config.ENABLE_INTERBROKER) {
            return;
        }
        boolean startDeferredRestore = false;
        InDoubtProxyMessageTracker inDoubtProxyMessageTracker = this.m_inDoubtProxyTracker;
        synchronized (inDoubtProxyMessageTracker) {
            if (!this.m_restoreDeferred) {
                return;
            }
            if (this.m_inDoubtProxyTracker.hasInDoubtMessages()) {
                return;
            }
            if (!this.m_inDoubtProxyTracker.hasInDoubtProxies()) {
                if (this.DEBUG0) {
                    this.debug("Starting delivery after proxy doubt resolved.");
                }
                this.m_restoreDeferred = false;
                startDeferredRestore = true;
            } else {
                if (this.DEBUG0) {
                    this.debug("Switching to live delivery after removing last in doubg message.");
                }
                this.trySwitchLive(new IStateSwitcher(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void doStateChangeOp(Object arg) {
                        Object object = DurableClientContext.this.m_delegate.getSyncObj();
                        synchronized (object) {
                            DurableClientContext.this.m_delegate.setState(8);
                            DurableClientContext.this.m_delegate.getSyncObj().notifyAll();
                        }
                    }
                }, null);
            }
            if (this.m_restoreDeferredForProxyAcks) {
                this.m_restoreDeferredForProxyAcks = false;
            }
        }
        if (startDeferredRestore) {
            if (this.DEBUG0) {
                this.debug("Starting deferred restore.");
            }
            this.m_delegator.stopDelivery();
            if (this.isRemotelyConnected()) {
                s_reg.getRemoteRestoreManager().enqueueRemoteRestore(this);
            } else {
                this.m_delegator.startDelivery(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyProxyInDoubt(IClientContext proxy) {
        if (!Config.ENABLE_INTERBROKER) {
            return;
        }
        if (this.DEBUG0) {
            this.debug("setting indoubt proxy: " + this.getBrokerFromCC(proxy));
        }
        if (proxy.getProxyHandle() == null) {
            return;
        }
        try {
            this.m_delegator.lock();
            Object object = proxy.getSyncObj();
            synchronized (object) {
                this.m_inDoubtProxyTracker.notifyProxyInDoubt(proxy);
            }
        }
        finally {
            this.m_delegator.unlock();
        }
    }

    @Override
    public void addInDoubtProxyMessages(IClientContext proxy, IndexedList messages) {
        if (!Config.ENABLE_INTERBROKER) {
            return;
        }
        if (messages.count() <= 0) {
            return;
        }
        this.m_inDoubtProxyTracker.addInDoubtMessages(messages, proxy);
    }

    @Override
    public void lockProxy() {
        this.m_proxyLock.lock();
    }

    @Override
    public void unlockProxy() {
        this.m_proxyLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeProxy() {
        try {
            this.m_proxyLock.lock();
            Lock lock = this.m_proxyLock;
            synchronized (lock) {
                if (this.DEBUG_UNEXPECTED) {
                    Thread t = Thread.currentThread();
                    LongHolder lh = (LongHolder)this.m_proxyFreezeHolders.get(t);
                    if (lh == null) {
                        lh = new LongHolder(1L);
                        this.m_proxyFreezeHolders.put(t, lh);
                    } else {
                        lh.set(lh.get() + 1L);
                    }
                }
                ++this.m_proxyFreezeCount;
            }
            if (this.DEBUG && this.checkDebugFlags(256)) {
                this.debug(Thread.currentThread().getName() + ": Freezing proxy");
            }
        }
        finally {
            this.m_proxyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unfreezeProxy() {
        try {
            this.m_proxyLock.lock();
            Lock lock = this.m_proxyLock;
            synchronized (lock) {
                Object t;
                if (this.DEBUG_UNEXPECTED) {
                    t = Thread.currentThread();
                    LongHolder lh = (LongHolder)this.m_proxyFreezeHolders.get(t);
                    if (lh == null) {
                        EAssertFailure throwable = new EAssertFailure("Negative proxy freeze count!");
                        BrokerComponent.getComponentContext().logMessage((Throwable)throwable, 1);
                    } else {
                        long l = lh.get();
                        if (l == 1L) {
                            this.m_proxyFreezeHolders.remove(t);
                        } else {
                            lh.set(l - 1L);
                        }
                    }
                }
                --this.m_proxyFreezeCount;
                if (this.m_proxyFreezeCount < 0) {
                    t = new EAssertFailure("Negative proxy freeze count!");
                    BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
                }
                if (this.DEBUG && this.checkDebugFlags(256)) {
                    this.debug(Thread.currentThread().getName() + ": Unfreezing proxy");
                }
                this.m_proxyLock.notifyAll();
            }
        }
        finally {
            this.m_proxyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForProxyUnfreeze() {
        boolean interrupted = false;
        boolean didWait = false;
        if (this.m_proxyFreezeCount > 0 && this.DEBUG0) {
            this.debug(Thread.currentThread().getName() + ": Waiting for proxy unfreeze. cnt:" + this.m_proxyFreezeCount);
        }
        long start = 0L;
        if (this.DEBUG_UNEXPECTED) {
            start = System.currentTimeMillis();
        }
        while (this.m_proxyFreezeCount > 0) {
            didWait = true;
            this.m_proxyLock.unlock();
            try {
                Lock lock = this.m_proxyLock;
                synchronized (lock) {
                    if (this.m_proxyFreezeCount > 0) {
                        if (this.DEBUG_UNEXPECTED) {
                            while (this.m_proxyFreezeCount > 0) {
                                this.m_proxyLock.wait(60000L);
                                long now = System.currentTimeMillis();
                                long waited = now - start;
                                if (waited >= 60000L) {
                                    this.debug("Unsuccessfully waited " + waited / 1000L + " seconds for proxy lock release. If this situation continues please take a thread dump");
                                    for (Thread t : this.m_proxyFreezeHolders.keySet()) {
                                        LongHolder lh = (LongHolder)this.m_proxyFreezeHolders.get(t);
                                        this.debug("Lock Holder: " + t + " count: " + lh.get());
                                    }
                                }
                                start = now;
                            }
                        } else {
                            this.m_proxyLock.wait();
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
            this.m_proxyLock.lock();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (didWait && this.DEBUG0) {
            this.debug(Thread.currentThread().getName() + ": Done waiting for proxy unfreeze.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForRemoteRestoreDone() throws InterruptedException {
        if (this.m_delegator.getCWADSActiveBroker() != null && this.m_delegator.getCWADSActiveBroker().getId() == this.m_delegator.getId() && this.m_delegator.getCWADSRestoringBroker() != null) {
            if (this.DEBUG0) {
                this.debug("Need to wait for CWADS_REMOTE_RESTORE_DONE during remote restore");
            }
            Object object = this.m_rrdWaitLock;
            synchronized (object) {
                this.m_rrdWaitLock.wait();
            }
        } else if (this.DEBUG1) {
            this.debug("Does not need to wait for CWADS_REMOTE_RESTORE_DONE during remote restore");
        }
        this.m_delegate.waitForRemoteRestoreDone();
    }

    @Override
    public IProxyingHandle getProxyingHandle() {
        return this;
    }

    @Override
    public IActivityMonitorHandle getActivityMonitorHandle() {
        return this.m_activityTracker;
    }

    @Override
    public void waitToStartRestore() throws InterruptedException {
        if (this.DEBUG1) {
            this.debug("Waiting to start initial restore.");
        }
        if (Config.ENABLE_INTERBROKER) {
            this.m_inDoubtProxyTracker.waitForDoubtResolution();
            this.flushProxyDoubtStatus();
        }
        this.m_delegate.waitToStartRestore();
        if (this.DEBUG1) {
            this.debug("Starting initial restore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialRemoteRestoreComplete(MsgRestorePos pos) throws InterruptedException {
        Object object;
        BrokerSubscription bs;
        if (this.DEBUG1) {
            this.debug("called initialRemoteRestoreComplete(pos) pos: " + pos);
        }
        if ((bs = this.m_delegator.getDurableBrokerSubscription()) != null && bs.getDurableStrictMessageOrder() && this.isRemotelyConnected()) {
            object = this.m_startedInboundProxies;
            synchronized (object) {
                while (!this.m_startedInboundProxies.isEmpty()) {
                    if (this.DEBUG0) {
                        this.debug("Waiting for delivery to stop before starting FINAL_REMOTE_RESTORE. STARTED:" + this.m_startedInboundProxies);
                    }
                    this.m_startedInboundProxies.wait();
                }
            }
        }
        object = this.m_delegator.getSyncObj();
        synchronized (object) {
            switch (this.m_delegator.getState()) {
                case 3: {
                    if (this.DEBUG1) {
                        this.debug("initial remote restore complete");
                    }
                    this.m_delegate.initialRemoteRestoreComplete(pos);
                    break;
                }
                default: {
                    if (this.DEBUG0) {
                        this.debug("WARNING: Completing INIT_REMOTE_RESTORE state without ever entering the state.");
                    }
                    this.m_delegator.getSyncObj().notifyAll();
                }
            }
        }
        if (this.m_delegator.isGroupSubscriptionMember()) {
            this.m_delegator.getGroupSubscriptionCC().notifyGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finalRemoteRestoreComplete(MsgRestorePos pos) throws InterruptedException {
        if (this.DEBUG1) {
            this.debug("called finalRemoteRestoreComplete(pos) pos: " + pos);
        }
        try {
            boolean disconnectAfterFinalRemoteRestore;
            if (this.m_delegator.getProxyingHandle() != null) {
                this.m_delegator.getProxyingHandle().freezeProxy();
            }
            DurableSMOUpdateEvt evt = null;
            Object object = this.m_delegator.getSyncObj();
            synchronized (object) {
                switch (this.m_delegator.getState()) {
                    case 4: {
                        this.m_delegate.finalRemoteRestoreComplete(pos);
                        if (this.m_CWADSRestoringBroker != null && this.m_CWADSRestoringBroker.getId() == this.m_delegator.getId()) {
                            if (this.DEBUG1) {
                                this.debug("Restoring broker needs to send CWADS_REMOTE_RESTORE_DONE to new active broker ");
                            }
                            evt = new DurableSMOUpdateEvt(this.m_delegator.getId(), this.m_CWADSPreviousBroker.getId(), -1L);
                            if (!this.isLocallyConnected()) {
                                if (this.m_delegator.getProxyingHandle() != null) {
                                    if (this.DEBUG1) {
                                        this.debug("waitForProxyAcks before sending remote restore done");
                                    }
                                    this.m_delegator.getProxyingHandle().waitForProxyAcks();
                                    if (this.m_delegator.getOutQueue().countPending() > 0) {
                                        throw new InterruptedException("Messages still pending acknowledgement");
                                    }
                                }
                                s_reg.getCWADSMsgHandler().sendRemoteRestorePhasesDone(this.m_CWADSActiveBroker, this.m_delegator);
                            } else if (this.DEBUG0) {
                                this.debug("FINAL REMOTE RESTORE COMPLETE WITH ACTIVE BROKER AS RESTORING BROKER:\n A: " + this.getBrokerFromCC(this.m_CWADSActiveBroker) + "\n P: " + this.getBrokerFromCC(this.m_CWADSPreviousBroker) + "\n R: " + this.getBrokerFromCC(this.m_CWADSRestoringBroker));
                            }
                            this.m_CWADSRestoringBroker = null;
                            break;
                        }
                        if (!this.DEBUG1) break;
                        this.debug("The new active broker does not need to send anything during finalRemoteRestoreComplete");
                        break;
                    }
                    default: {
                        if (!this.DEBUG0) break;
                        this.debug("WARNING: Completing FINAL_REMOTE_RESTORE state without ever entering the state. unless a disconnect maybe?");
                    }
                }
                disconnectAfterFinalRemoteRestore = this.m_disconnectAfterFinalRemoteRestore;
                this.m_disconnectAfterFinalRemoteRestore = false;
            }
            if (evt != null) {
                s_reg.getAgentRegistrar().logDurableSubscriptionSMOUpdate(false, this.m_delegator, evt);
            }
            boolean bl = disconnectAfterFinalRemoteRestore;
            return bl;
        }
        finally {
            if (this.m_delegator.getProxyingHandle() != null) {
                this.m_delegator.getProxyingHandle().unfreezeProxy();
            }
        }
    }

    private void flushProxyDoubtStatus() throws InterruptedException {
        while (this.isRemotelyConnected() && this.m_lastSubscribeEvt != null) {
            SubscribeEvt last = this.m_lastSubscribeEvt;
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage(this + ": Flushing proxy doubt status: " + last, 3);
            }
            if (last == null) continue;
            s_reg.getLogManager().beginFlush();
            s_reg.getLogManager().waitForFlush(last);
        }
    }

    @Override
    public void waitToStartFinalRemoteRestore() throws InterruptedException {
        this.m_delegate.waitToStartFinalRemoteRestore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitToStartFinalRestore() throws InterruptedException {
        HashSet hashSet = this.m_disconnectingProxies;
        synchronized (hashSet) {
            while (!this.m_disconnectingProxies.isEmpty()) {
                if (this.DEBUG0) {
                    this.debug("Waiting for proxy disconnects: " + this.m_disconnectingProxies.size());
                }
                this.m_disconnectingProxies.wait();
            }
        }
        this.m_delegate.waitToStartFinalRestore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDisconnectingProxy(IClientContext proxy) {
        if (!Config.ENABLE_INTERBROKER) {
            return;
        }
        Object object = this.m_disconnectingProxies;
        synchronized (object) {
            this.m_disconnectingProxies.add(new Long(proxy.getId()));
        }
        object = this.m_delegate.getSyncObj();
        synchronized (object) {
            this.m_delegate.getSyncObj().notifyAll();
        }
        boolean setGeneralInDoubt = false;
        if (this.m_inDoubtProxyTracker.hasInDoubtMessages(proxy)) {
            setGeneralInDoubt = true;
        }
        if (setGeneralInDoubt) {
            this.notifyProxyInDoubt(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDisconnectingProxy(IClientContext proxy) {
        HashSet hashSet = this.m_disconnectingProxies;
        synchronized (hashSet) {
            this.m_disconnectingProxies.remove(new Long(proxy.getId()));
            if (this.m_disconnectingProxies.isEmpty()) {
                this.m_disconnectingProxies.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscribeEvt(SubscribeEvt se) {
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            if (this.m_lastSubscribeEvt == null || se.getSeqNo() > this.m_lastSubscribeEvt.getSeqNo()) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage(this + " Adding SubscribeEvt: " + se, 3);
                }
                this.m_lastSubscribeEvt = se;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscribeEvt(SubscribeEvt se) {
        Object object = this.m_delegator.getSyncObj();
        synchronized (object) {
            if (this.m_lastSubscribeEvt != null && se.getSeqNo() >= this.m_lastSubscribeEvt.getSeqNo()) {
                this.m_lastSubscribeEvt = null;
            }
        }
    }

    @Override
    public DurableCCTracker getDurableCCTracker() {
        if (this.m_delegator.isGroupSubscriptionMember()) {
            return this.m_delegator.getGroupSubscriptionCC().getDurableCCTracker();
        }
        return this.m_tracker;
    }

    @Override
    public final boolean recheckRestoredMgram(IMgram m) {
        boolean match;
        if (!this.m_delegate.recheckRestoredMgram(m)) {
            return false;
        }
        BrokerSubscription bs = this.m_delegator.getDurableBrokerSubscription();
        if (bs == null) {
            return true;
        }
        if (bs.hasSelectors() && bs.getUnfiltered() && bs.getSelectorAtBroker() && !(match = bs.isMessageForSubscription(m))) {
            if (this.DEBUG1) {
                this.debug("Message didn't pass the selector, tracking is " + m.getGuarenteedTrackingNum());
            }
            this.m_delegator.handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
            return false;
        }
        return !m.hasSubject() || m.getSubject().isSystem() || !m.isGuarenteed() || bs.matchAndFilterSubject(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean beginRegistryUpdate() {
        if (!InterbrokerHook.isSet()) {
            return true;
        }
        Object object = this.m_registryUpdateMutex;
        synchronized (object) {
            if (this.m_regUpdateThread == null) {
                this.m_regUpdateThread = Thread.currentThread();
                this.m_regUpdateCount = 0;
            }
            if (this.m_regUpdateThread == Thread.currentThread()) {
                ++this.m_regUpdateCount;
                return true;
            }
            this.m_delegator.unlock();
            try {
                this.m_registryUpdateMutex.wait();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForRegistryUpdate() throws InterruptedException {
        if (!InterbrokerHook.isSet()) {
            return false;
        }
        Object object = this.m_registryUpdateMutex;
        synchronized (object) {
            if (this.m_regUpdateThread == null || this.m_regUpdateThread == Thread.currentThread()) {
                return false;
            }
            this.m_delegator.unlock();
            this.m_registryUpdateMutex.wait();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endRegistryUpdate() {
        if (!InterbrokerHook.isSet()) {
            return;
        }
        Object object = this.m_registryUpdateMutex;
        synchronized (object) {
            if (this.m_regUpdateThread != Thread.currentThread()) {
                throw new IllegalMonitorStateException("endRegistry update with no begin!");
            }
            --this.m_regUpdateCount;
            if (this.m_regUpdateCount == 0) {
                this.m_regUpdateThread = null;
                Object object2 = this.m_registryUpdateMutex;
                synchronized (object2) {
                    this.m_registryUpdateMutex.notifyAll();
                }
            }
        }
        s_reg.checkUnregister(this.m_delegator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean okToUnregister() {
        if (InterbrokerHook.isSet()) {
            Object object = this.m_registryUpdateMutex;
            synchronized (object) {
                if (this.m_regUpdateCount > 0) {
                    if (this.DEBUG0) {
                        this.debug("okToUnregister is false because registry update is in progress");
                    }
                    return false;
                }
            }
        }
        return this.m_delegate.okToUnregister();
    }

    @Override
    public ICCSizeTracker getCCSizeTracker() {
        return this.getDurableCCTracker();
    }

    private String getBrokerFromCC(long id) {
        return "" + id;
    }

    private String getBrokerFromCC(IClientContext cc) {
        if (cc == null) {
            return "NONE";
        }
        if (cc.getId() == this.getId()) {
            return "LOCAL";
        }
        if (!cc.isInterbroker()) {
            return "!!!" + cc.getUid() + "/" + cc.getAppid() + "!!!";
        }
        return cc.getUid();
    }

    @Override
    protected String getDebugMessagePrefix() {
        return this.getAppid() + "-";
    }

    class ActivityTracker
    implements IActivityMonitorHandle {
        private boolean m_firstTime;
        private boolean m_active;

        ActivityTracker() {
        }

        @Override
        public boolean isActivityMonitoringEnabled() {
            boolean result = Config.ACKNOWLEDGE_MONITOR_INTERVAL > 0 && (DurableClientContext.this.getAckMode() == 4 || DurableClientContext.this.getAckMode() == 6 || DurableClientContext.this.getAckMode() == 5);
            return result;
        }

        @Override
        public void startActivityMonitoring() {
            if (this.isActivityMonitoringEnabled()) {
                this.reset();
                BaseClientContextWrapper.s_reg.getPollingThread().register(DurableClientContext.this.m_activityTracker);
            }
        }

        @Override
        public void stopActivityMonitoring() {
            BaseClientContextWrapper.s_reg.getPollingThread().unregister(DurableClientContext.this.m_activityTracker);
        }

        @Override
        public synchronized void setActive() {
            this.m_active = true;
        }

        @Override
        public synchronized void reset() {
            this.m_firstTime = true;
            this.m_active = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEndInterval() {
            ActivityTracker activityTracker = this;
            synchronized (activityTracker) {
                if (this.m_firstTime) {
                    this.m_firstTime = false;
                    this.m_active = false;
                    return;
                }
                if (this.m_active) {
                    this.m_active = false;
                    return;
                }
            }
            boolean ccinactive = this.checkIfApparentlyInactive();
            if (ccinactive) {
                this.reportCCInactive();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkIfApparentlyInactive() {
            Object object = DurableClientContext.this.getSyncObj();
            synchronized (object) {
                if (this.isInMessageReceiveState() && DurableClientContext.this.getPendingGuarCount() > 0 && DurableClientContext.this.isMgramQueueEmpty() && (DurableClientContext.this.hasStoppedPublishers() || DurableClientContext.this.isWaitingForRestoreSpace() || !DurableClientContext.this.getOutQueue().getOffloadedPubSubQueue().isEmpty())) {
                    if (DurableClientContext.this.DEBUG0) {
                        DurableClientContext.this.debug("checkIfApparentlyInactive (2) state= " + DurableClientContext.this.getState() + " guarCount= " + DurableClientContext.this.getPendingGuarCount() + " queueEmpty=  " + DurableClientContext.this.isMgramQueueEmpty() + " stoppedPubs= " + DurableClientContext.this.hasStoppedPublishers() + " waitForRestoreSpace= " + DurableClientContext.this.isWaitingForRestoreSpace() + " ftd= " + !DurableClientContext.this.getOutQueue().getOffloadedPubSubQueue().isEmpty() + " ****Appears Inactive " + this);
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean isInMessageReceiveState() {
            switch (DurableClientContext.this.getState()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }

        private void reportCCInactive() {
            if (DurableClientContext.this.DEBUG0) {
                DurableClientContext.this.debug("***** reportCCInactive: Sending notification ");
            }
            BrokerManagementNotificationsHelper.sendAcknowledgmentPauseNotification(Config.BROKER_NAME, Config.ROUTING_NODE_NAME, DurableClientContext.this.getUid(), this.getConnectId(), SessionConfig.getDurableJMSClientIDFromAppid(DurableClientContext.this.getAppid()), SessionConfig.getDurableSubNameFromAppid(DurableClientContext.this.getAppid()));
        }

        private String getConnectId() {
            String connectID = null;
            AgentConnection ac = DurableClientContext.this.getConnection();
            AgentListener al = null;
            String chan0AppID = null;
            if (ac != null) {
                al = ac.getAgentListener();
            }
            if (al != null) {
                chan0AppID = al.getChan0Appid();
            }
            if (chan0AppID != null) {
                connectID = chan0AppID.substring(0, chan0AppID.indexOf("$CONNECTION$"));
            }
            if (connectID == null) {
                connectID = "";
            }
            return connectID;
        }

        public String toString() {
            return "ActivityTracker for " + DurableClientContext.this;
        }
    }

    private class InDoubtProxyMessageTracker {
        LongHashTable m_inDoubtTrackingTable = new LongHashTable();
        LongHashTable m_inDountProxyMessages = new LongHashTable();
        private HashSet m_inDoubtProxies = new HashSet();

        private InDoubtProxyMessageTracker() {
        }

        private final synchronized void addInDoubtMessages(IndexedList messages, IClientContext proxy) {
            Enumeration enu = messages.elements();
            LongHashTable<IMgram> proxyMessages = (LongHashTable<IMgram>)this.m_inDountProxyMessages.get(proxy.getId());
            if (proxyMessages == null) {
                proxyMessages = new LongHashTable<IMgram>();
                this.m_inDountProxyMessages.put(proxy.getId(), proxyMessages);
            }
            while (enu.hasMoreElements()) {
                IClientContext alreadyIndoubt;
                IMgram m = (IMgram)enu.nextElement();
                long tracking = m.getGuarenteedTrackingNum();
                if (DurableClientContext.this.DEBUG) {
                    BrokerComponent.getBrokerComponent();
                    BrokerComponent.logMessage("Adding in doubt proxy message: trk=" + tracking, BrokerComponent.getLevelInfo());
                }
                if ((alreadyIndoubt = this.m_inDoubtTrackingTable.put(tracking, proxy)) != null) {
                    if (alreadyIndoubt.getId() == proxy.getId()) continue;
                    throw new EAssertFailure("Message indoubt against multiple neighbors: " + proxy + " and " + alreadyIndoubt);
                }
                proxyMessages.put(tracking, m);
            }
        }

        final synchronized boolean removeMessage(long tracking) {
            IClientContext proxy = (IClientContext)this.m_inDoubtTrackingTable.remove(tracking);
            if (proxy == null) {
                return false;
            }
            LongHashTable proxyMessages = (LongHashTable)this.m_inDountProxyMessages.get(proxy.getId());
            if (proxyMessages == null) {
                throw new EAssertFailure("In doubt message for a proxy with no message association");
            }
            proxyMessages.remove(tracking);
            if (DurableClientContext.this.DEBUG) {
                BrokerComponent.getBrokerComponent();
                BrokerComponent.logMessage("Removing in doubt proxy message: trk=" + tracking, BrokerComponent.getLevelInfo());
            }
            if (proxyMessages.isEmpty()) {
                this.m_inDountProxyMessages.remove(proxy.getId());
                this.notifyAll();
                if (DurableClientContext.this.m_restoreDeferredForProxyAcks) {
                    Object[] args = new Object[]{DurableSubscriptionUtil.getJMSClientID(DurableClientContext.this.m_delegator.getAppid()), proxy.getUid()};
                    if (DurableClientContext.this.DEBUG) {
                        BrokerComponent.getBrokerComponent();
                        BrokerComponent.logMessage(MessageFormat.format(prAccessor.getString("DURABLE_NO_LONGER_WAITING_FOR_ACKS"), args), BrokerComponent.getLevelInfo());
                    }
                }
                return true;
            }
            return false;
        }

        final boolean hasInDoubtMessages() {
            return !this.m_inDountProxyMessages.isEmpty();
        }

        final synchronized boolean hasInDoubtMessages(IClientContext proxy) {
            return this.m_inDountProxyMessages.containsKey(proxy.getId());
        }

        final boolean okToStartDelivery() {
            if (this.m_inDountProxyMessages.isEmpty()) {
                return true;
            }
            Enumeration<Long> keys = this.m_inDountProxyMessages.keys();
            String inDoubtBrokers = null;
            while (keys.hasMoreElements()) {
                Long cid = keys.nextElement();
                try {
                    IClientContext cc = BaseClientContextWrapper.s_reg.getClient(cid);
                    if (inDoubtBrokers == null) {
                        inDoubtBrokers = cc.getUid();
                        continue;
                    }
                    inDoubtBrokers = inDoubtBrokers + "," + cc.getUid();
                }
                catch (EClientNotRegistered ecnr) {
                    this.clearProxyDoubtMessages(cid);
                }
            }
            if (inDoubtBrokers != null) {
                Object[] args = new Object[]{DurableSubscriptionUtil.getJMSClientID(DurableClientContext.this.m_delegator.getAppid()), inDoubtBrokers};
                if (DurableClientContext.this.DEBUG) {
                    BrokerComponent.getBrokerComponent();
                    BrokerComponent.logMessage(MessageFormat.format(prAccessor.getString("DURABLE_RESTORE_WAITING_FOR_ACKS"), args), BrokerComponent.getLevelWarning());
                }
                return false;
            }
            return true;
        }

        final synchronized HashSet getIndoubtProxyIds() {
            HashSet ret = (HashSet)this.m_inDoubtProxies.clone();
            if (!this.m_inDountProxyMessages.isEmpty()) {
                ISizedEnumeration<Long> enu = this.m_inDountProxyMessages.keyList();
                while (enu.hasMoreElements()) {
                    ret.add(enu.nextElement());
                }
            }
            return ret;
        }

        final boolean clearProxyDoubtMessages(long proxyId) {
            LongHashTable proxyMessages = (LongHashTable)this.m_inDountProxyMessages.remove(proxyId);
            if (proxyMessages == null) {
                return false;
            }
            ISizedEnumeration<Long> enu = proxyMessages.keyList();
            while (enu.hasMoreElements()) {
                IMgram m;
                Long tracking = (Long)enu.nextElement();
                if (DurableClientContext.this.DEBUG0) {
                    DurableClientContext.this.debug("Cleared in doubt message: " + tracking + " ");
                }
                this.m_inDoubtTrackingTable.remove(tracking);
                if (!DurableClientContext.this.m_delegator.isGroupSubscriptionMember() || (m = (IMgram)proxyMessages.get(tracking)) == null) continue;
                if (DurableClientContext.this.DEBUG0) {
                    DurableClientContext.this.debug(MgramTrace.diagnosticString("RETURNING IN DOUBT MESSAGE TO GROUP:", null, m));
                }
                DurableClientContext.this.m_delegator.getGroupSubscriptionCC().processGroupMemberMgram(m, null, DurableClientContext.this.m_delegator, true, true, true);
            }
            return true;
        }

        private synchronized void waitForDoubtResolution() throws InterruptedException {
            while (!this.m_inDoubtProxies.isEmpty()) {
                if (DurableClientContext.this.DEBUG0) {
                    DurableClientContext.this.debug("Waiting for in doubt resolution before starting initial restore: " + this.m_inDoubtProxies);
                }
                this.wait();
            }
        }

        private synchronized void notifyProxyInDoubt(IClientContext proxy) {
            if (!DurableClientContext.this.m_delegator.isGroupSubscriptionMember()) {
                this.clearProxyDoubtMessages(proxy.getId());
            }
            if (this.m_inDoubtProxies.add(new Long(proxy.getId()))) {
                DurableClientContext.this.setProxyDoubtStatus();
            }
            proxy.getProxyHandle().registerInDoubt(DurableClientContext.this.m_delegator);
        }

        private synchronized void notifyProxyDoubtResolved(IClientContext proxy) {
            boolean doubtCleared = false;
            if (this.m_inDoubtProxies.remove(new Long(proxy.getId()))) {
                doubtCleared = true;
            }
            if (this.clearProxyDoubtMessages(proxy.getId())) {
                doubtCleared = true;
            }
            if (doubtCleared) {
                DurableClientContext.this.setProxyDoubtStatus();
            }
            proxy.getProxyHandle().unregisterInDoubt(DurableClientContext.this.m_delegator);
            this.notifyAll();
        }

        private boolean hasInDoubtProxies() {
            return !this.m_inDoubtProxies.isEmpty();
        }
    }

    private static interface IStateSwitcher {
        public void doStateChangeOp(Object var1);
    }
}

