/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Optional;
import java.util.Vector;
import progress.message.broker.FlowControlListener;
import progress.message.broker.gs.GSManager;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.SessionConfig;

public class FlowControlManager
extends DebugObject {
    private Hashtable m_destinationTable = null;
    static final String ROUTING_QUEUE_ADDR = "$Q.SonicMQ.routingQueue";

    FlowControlManager() {
        super(DebugState.GLOBAL_DEBUG_ON ? "FlowControlManager" : null);
        if (this.DEBUG) {
            this.debug("Initializing");
        }
        this.m_destinationTable = new Hashtable();
    }

    void onSpaceAvailable(String localDestination, long size) {
        this.onSpaceAvailable(localDestination, null, size, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSpaceAvailable(String localDestination, String route, long size, boolean canceledResume) {
        Object object;
        long availablesize = size;
        if (this.DEBUG) {
            this.debug("Notified " + availablesize + " available on " + localDestination);
        }
        BlockedClientList blockedClients = (BlockedClientList)this.m_destinationTable.get(localDestination);
        Vector listenerList = null;
        int numProcessed = 0;
        int numResumed = 0;
        if (blockedClients != null) {
            object = blockedClients;
            synchronized (object) {
                long prevAvailableSize;
                listenerList = blockedClients.m_listenerList;
                Iterator iter = listenerList.iterator();
                if (canceledResume && route == null && (prevAvailableSize = blockedClients.m_availableSize) != -1L) {
                    availablesize += prevAvailableSize;
                    if (this.DEBUG) {
                        this.debug("Added previous available size " + prevAvailableSize + ", new available size is " + availablesize);
                    }
                }
                if (this.DEBUG) {
                    this.debug("Listener list contains " + listenerList.size() + " elements.");
                }
                while (iter.hasNext() && availablesize > 0L) {
                    BlockedClient bc = (BlockedClient)iter.next();
                    if (route != null) {
                        if (bc.m_blockedRoutes == null) continue;
                        boolean hasMoreBlocked = false;
                        for (int ii = 0; ii < bc.m_blockedRoutes.length; ++ii) {
                            if (bc.m_blockedRoutes[ii] == null) continue;
                            if (route.equals(bc.m_blockedRoutes[ii])) {
                                bc.m_blockedRoutes[ii] = null;
                                continue;
                            }
                            hasMoreBlocked = true;
                        }
                        if (hasMoreBlocked) continue;
                    }
                    long sz = bc.m_size;
                    if (route != null || sz <= availablesize) {
                        Optional<Boolean> onQueueResumeResult;
                        int resumedSize = route == null ? bc.m_size : 0;
                        if (this.DEBUG) {
                            this.debug("Resuming " + bc.m_listener + " size= " + resumedSize);
                        }
                        if (!(onQueueResumeResult = this.onQueueResume(localDestination, bc, resumedSize)).isPresent()) continue;
                        if (onQueueResumeResult.get().booleanValue()) {
                            if (route == null) {
                                availablesize -= sz;
                            }
                            ++numResumed;
                        }
                    } else if (bc.m_listener.isConnected()) break;
                    iter.remove();
                    ++numProcessed;
                }
                if (route == null) {
                    blockedClients.m_availableSize = availablesize;
                }
                if (this.DEBUG) {
                    this.debug("Resumed " + numResumed + " clients; available= " + availablesize + " numProcessed= " + numProcessed);
                }
            }
        } else if (this.DEBUG) {
            this.debug("Listener list did not exist. No blocked clients to try to resume");
        }
        blockedClients = null;
        if (numProcessed > 0) {
            object = this.m_destinationTable;
            synchronized (object) {
                this.removeDestination(localDestination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Boolean> onQueueResume(String localDestination, BlockedClient bc, int resumedSize) {
        boolean isGSRequestSender = bc.m_listener instanceof GSManager.GSRequestSender;
        boolean lockSuccessful = false;
        try {
            if (isGSRequestSender && !(lockSuccessful = ((GSManager.GSRequestSender)bc.m_listener).lock())) {
                SessionConfig.logMessage("LocalDestination:" + localDestination + ", key: " + bc.m_key + ". Fail to acquire GSRequestSender's lock. Most likely deadlock situation happened. Assumed not able to queue resume.", SessionConfig.getLevelWarning());
                Optional<Boolean> optional = Optional.empty();
                return optional;
            }
            Optional<Boolean> optional = Optional.of(bc.m_listener.onQueueResume(bc.m_key, localDestination, resumedSize));
            return optional;
        }
        finally {
            if (isGSRequestSender && lockSuccessful) {
                ((GSManager.GSRequestSender)bc.m_listener).unlock();
            }
        }
    }

    void queueResumeCancelled(String destination, int size) {
        if (size == 0) {
            return;
        }
        long sz = size;
        this.onSpaceAvailable(destination, null, sz, true);
    }

    public void onRemoteNodeAvailable(String route) {
        String localDestination = ROUTING_QUEUE_ADDR;
        if (this.DEBUG) {
            this.debug("Notified remote node " + route + " available");
        }
        this.onSpaceAvailable(localDestination, route, 1L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existBlockedClients(String route) {
        if (route == null) {
            return false;
        }
        String localDestination = ROUTING_QUEUE_ADDR;
        BlockedClientList blockedClients = (BlockedClientList)this.m_destinationTable.get(localDestination);
        Vector listenerList = null;
        if (blockedClients != null) {
            BlockedClient bc = null;
            BlockedClientList blockedClientList = blockedClients;
            synchronized (blockedClientList) {
                listenerList = blockedClients.m_listenerList;
                for (int ii = 0; ii < listenerList.size(); ++ii) {
                    bc = (BlockedClient)listenerList.elementAt(ii);
                    if (bc.m_blockedRoutes == null) continue;
                    for (int jj = 0; jj < bc.m_blockedRoutes.length; ++jj) {
                        if (bc.m_blockedRoutes[jj] == null || !route.equals(bc.m_blockedRoutes[jj])) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFlowControlListener(FlowControlListener l, String localDestination, Object key, int size, String[] blockedRoutes) {
        Vector<BlockedClient> listenerList = null;
        BlockedClientList blockedClients = null;
        Hashtable hashtable = this.m_destinationTable;
        synchronized (hashtable) {
            blockedClients = (BlockedClientList)this.m_destinationTable.get(localDestination);
            if (blockedClients == null) {
                listenerList = new Vector<BlockedClient>();
                blockedClients = new BlockedClientList(listenerList, -1);
                if (this.DEBUG) {
                    this.debug("Creating new listener list for " + localDestination);
                }
                this.m_destinationTable.put(localDestination, blockedClients);
            } else {
                listenerList = blockedClients.m_listenerList;
            }
            BlockedClientList blockedClientList = blockedClients;
            synchronized (blockedClientList) {
                if (this.DEBUG) {
                    this.debug("Adding request to " + listenerList + " of size " + size + " for " + l + "...");
                }
                listenerList.addElement(new BlockedClient(l, size, key, blockedRoutes));
                if (this.DEBUG) {
                    this.debug("Done. Added to listenerList " + localDestination + " contains " + listenerList.size());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFlowControlListener(FlowControlListener l, String destinationParam, Object key) {
        String destination = destinationParam;
        Vector listenerList = null;
        BlockedClientList blockedClients = null;
        Object object = this.m_destinationTable;
        synchronized (object) {
            blockedClients = (BlockedClientList)this.m_destinationTable.get(destination);
            if (blockedClients == null) {
                destination = ROUTING_QUEUE_ADDR;
                blockedClients = (BlockedClientList)this.m_destinationTable.get(destination);
            }
        }
        if (blockedClients != null) {
            object = blockedClients;
            synchronized (object) {
                listenerList = blockedClients.m_listenerList;
                for (int i = 0; i < listenerList.size(); ++i) {
                    BlockedClient bc = (BlockedClient)listenerList.elementAt(i);
                    if (bc.m_listener != l || !bc.m_key.equals(key)) continue;
                    if (this.DEBUG) {
                        this.debug("Removing " + bc.m_size + " for " + l);
                    }
                    listenerList.removeElementAt(i);
                    break;
                }
            }
            object = this.m_destinationTable;
            synchronized (object) {
                blockedClients = (BlockedClientList)this.m_destinationTable.get(destination);
                this.removeListeners(blockedClients, destination);
            }
        }
    }

    public boolean isDestinationGloballyBlocked(String localDestination) {
        if (this.DEBUG) {
            this.debug("Checking if destination " + localDestination + " is blocked on the FCM... if it is get in line.");
        }
        Vector listenerList = null;
        BlockedClientList blockedClients = (BlockedClientList)this.m_destinationTable.get(localDestination);
        if (blockedClients == null) {
            return false;
        }
        listenerList = blockedClients.m_listenerList;
        return !listenerList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onQueueDelete(String localDestination) {
        Object object;
        if (this.DEBUG) {
            this.debug("onQueueDelete: Destination " + localDestination + " was deleted. Resume all blocked clients.");
        }
        Vector listenerList = null;
        BlockedClientList blockedClients = (BlockedClientList)this.m_destinationTable.get(localDestination);
        if (blockedClients != null) {
            object = blockedClients;
            synchronized (object) {
                listenerList = blockedClients.m_listenerList;
                if (this.DEBUG) {
                    this.debug("onQueueDelete: about to resume" + listenerList.size() + " elements for destination " + localDestination);
                }
                while (!listenerList.isEmpty()) {
                    BlockedClient bc = (BlockedClient)listenerList.firstElement();
                    if (this.DEBUG) {
                        this.debug("Resuming " + bc.m_listener);
                    }
                    bc.m_listener.onQueueResume(bc.m_key, localDestination, bc.m_size);
                    listenerList.removeElementAt(0);
                }
            }
        }
        blockedClients = null;
        object = this.m_destinationTable;
        synchronized (object) {
            this.removeDestination(localDestination);
        }
    }

    private void removeDestination(String localDestination) {
        Object listenerList = null;
        BlockedClientList blockedClients = (BlockedClientList)this.m_destinationTable.get(localDestination);
        this.removeListeners(blockedClients, localDestination);
    }

    private void removeListeners(BlockedClientList blockedClients, String localDestination) {
        Vector listenerList = null;
        if (blockedClients != null && (listenerList = blockedClients.m_listenerList).isEmpty()) {
            this.m_destinationTable.remove(localDestination);
        }
    }

    private static final class BlockedClientList {
        Vector m_listenerList = null;
        long m_availableSize;

        BlockedClientList(Vector listenerList, int availableSize) {
            this.m_listenerList = listenerList;
            this.m_availableSize = availableSize;
        }
    }

    private static final class BlockedClient {
        FlowControlListener m_listener = null;
        int m_size;
        Object m_key;
        String[] m_blockedRoutes;

        BlockedClient(FlowControlListener l, int size, Object key, String[] blockedRoutes) {
            this.m_listener = l;
            this.m_size = size;
            this.m_key = key;
            this.m_blockedRoutes = blockedRoutes;
        }

        public String toString() {
            return "(" + this.m_listener + "," + this.m_size + "," + this.m_key + ")";
        }
    }
}

