/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.HTTPDirectOutboundEntry;
import progress.message.broker.IRoutingConfigListener;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.db.EDatabaseException;
import progress.message.gr.HttpOutboundHelper;
import progress.message.util.AutoVec;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class RoutingConfiguration
extends DebugObject {
    private Hashtable m_connectionsByNodeName;
    private AutoVec m_listeners = new AutoVec();
    private transient AgentRegistrar m_reg;
    private long m_startTime = 0L;

    RoutingConfiguration(AgentRegistrar reg, Vector routes) throws EDatabaseException {
        super(DebugState.GLOBAL_DEBUG_ON ? "RoutingConfiguration" : null);
        this.m_reg = reg;
        this.m_startTime = this.m_reg.getLogTime();
        this.addRoutingConfigListener(this.m_reg.getSubjectSpace());
        this.m_connectionsByNodeName = new Hashtable();
        if (routes != null) {
            Enumeration entries = routes.elements();
            while (entries.hasMoreElements()) {
                RoutingConnectionInfo r = (RoutingConnectionInfo)entries.nextElement();
                this.setRoutingConnection(r);
            }
            routes.clear();
        }
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    synchronized RoutingConnectionInfo updateCache(RoutingConnectionInfo r) {
        return this.m_connectionsByNodeName.put(r.getRoutingNodeName(), r);
    }

    public final boolean setRoutingConnection(RoutingConnectionInfo newRouting) {
        return this.setRoutingConnection(newRouting, null);
    }

    public boolean setRoutingConnection(RoutingConnectionInfo route, HTTPDirectOutboundEntry httpEntry) {
        RoutingConnectionInfo newRouting = (RoutingConnectionInfo)route.clone();
        RoutingConnectionInfo oldRouting = this.updateCache(newRouting);
        this.fireRoutingConfigEvent(newRouting, oldRouting);
        if (this.DEBUG) {
            this.debug("Routing Node ==> " + newRouting.getRoutingNodeName() + " is set");
        }
        if (httpEntry != null) {
            this.getHttpHelper().dynamicAddHttpOutboundEntry(httpEntry, newRouting.getRouteType());
        }
        return oldRouting == null;
    }

    public synchronized boolean deleteRoutingConnection(String routingNodeName) {
        boolean success = false;
        RoutingConnectionInfo oldRouting = (RoutingConnectionInfo)this.m_connectionsByNodeName.get(routingNodeName);
        if (oldRouting == null) {
            success = false;
        } else {
            this.m_connectionsByNodeName.remove(routingNodeName);
            this.fireRoutingConfigEvent(null, oldRouting);
            if (oldRouting.getRouteType() != RoutingConnectionInfo.ROUTE_TYPE_SONIC) {
                this.getHttpHelper().deleteHttpOutboundEntry(routingNodeName, oldRouting.getRouteType());
            }
            success = true;
            if (this.DEBUG) {
                this.debug("Routing Node ==> " + routingNodeName + " is deleted");
            }
        }
        return success;
    }

    public synchronized boolean existsRoutingConnection(String routingNodeName) {
        return this.m_connectionsByNodeName.get(routingNodeName) != null;
    }

    public synchronized RoutingConnectionInfo getRoutingConnection(String routingNodeName) {
        RoutingConnectionInfo r = (RoutingConnectionInfo)this.m_connectionsByNodeName.get(routingNodeName);
        if (r == null) {
            return null;
        }
        return (RoutingConnectionInfo)r.clone();
    }

    public synchronized Vector getRoutingConnections() {
        Vector routings = new Vector(this.m_connectionsByNodeName.size(), 1);
        Enumeration entries = this.m_connectionsByNodeName.elements();
        while (entries.hasMoreElements()) {
            routings.addElement(entries.nextElement());
        }
        return routings;
    }

    public synchronized void serialize(DataOutput output) throws IOException {
        Enumeration entries = this.m_connectionsByNodeName.elements();
        output.writeLong(this.m_startTime);
        output.writeInt(this.m_connectionsByNodeName.size());
        while (entries.hasMoreElements()) {
            ((RoutingConnectionInfo)entries.nextElement()).serialize(output);
        }
    }

    public synchronized void unserialize(DataInput input) throws IOException {
        RoutingConnectionInfo routing = null;
        this.m_startTime = input.readLong();
        int size = input.readInt();
        this.m_connectionsByNodeName = new Hashtable(Math.max(size, 101));
        for (int i = 0; i < size; ++i) {
            routing = new RoutingConnectionInfo();
            routing.unserialize(input);
            this.setRoutingConnection(routing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRoutingConfigListener(IRoutingConfigListener listener) {
        int index = -1;
        AutoVec autoVec = this.m_listeners;
        synchronized (autoVec) {
            index = this.m_listeners.getFirstEmpty();
            this.m_listeners.setElementAt(listener, index);
        }
        listener.setRoutingConfigIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoutingConfigListener(IRoutingConfigListener listener) {
        int index = listener.getRoutingConfigIndex();
        AutoVec autoVec = this.m_listeners;
        synchronized (autoVec) {
            if (index < 0) {
                return;
            }
            if (index >= this.m_listeners.size() || !listener.equals((IRoutingConfigListener)this.m_listeners.elementAt(index))) {
                throw new EAssertFailure("Removing routing configuration listener - wrong index (" + index + ")");
            }
            this.m_listeners.setElementAt(null, index);
        }
        listener.setRoutingConfigIndex(-1);
    }

    private void fireRoutingConfigEvent(RoutingConnectionInfo newRouting, RoutingConnectionInfo oldRouting) {
        IRoutingConfigListener listener = null;
        int count = this.m_listeners.size();
        for (int i = 0; i < count; ++i) {
            listener = (IRoutingConfigListener)this.m_listeners.elementAt(i);
            if (listener == null) continue;
            listener.IRoutingConfigChanged(newRouting, oldRouting);
        }
    }

    private HttpOutboundHelper getHttpHelper() {
        return this.m_reg.getRouterManager().getHttpHelper();
    }
}

