/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.List;
import progress.message.broker.IClientContext;
import progress.message.zclient.ITimeOnBufferTracker;

public class SubscriberTimeOnBufferTracker
implements ITimeOnBufferTracker {
    IClientContext m_cc;
    private final List<SubscriberBufferListener> m_limiterListeners;

    public SubscriberTimeOnBufferTracker(IClientContext cc) {
        this.m_cc = cc;
        this.m_limiterListeners = new ArrayList<SubscriberBufferListener>();
    }

    @Override
    public long getAndResetMaxTimeMs() {
        long max = 0L;
        for (SubscriberBufferListener listener : this.m_limiterListeners) {
            long currMax = listener.getMaxTimeMs();
            max = currMax > max ? currMax : max;
            listener.reset();
        }
        return max;
    }

    public ITimeOnBufferTracker.IBufferListener createListener() {
        SubscriberBufferListener listener = new SubscriberBufferListener();
        this.m_limiterListeners.add(listener);
        return listener;
    }

    public class SubscriberBufferListener
    implements ITimeOnBufferTracker.IBufferListener {
        volatile long m_maxTimeAtHeadMs = 0L;
        long m_currentMsgEnqueueTime = 0L;

        @Override
        public void onNewMessageAtHead() {
            long now = System.currentTimeMillis();
            this.updateMaxTimeMs(now);
            this.m_currentMsgEnqueueTime = now;
        }

        @Override
        public void onEmpty() {
            long now = System.currentTimeMillis();
            this.updateMaxTimeMs(now);
            this.m_currentMsgEnqueueTime = 0L;
        }

        public long getMaxTimeMs() {
            this.updateMaxTimeMs(System.currentTimeMillis());
            return this.m_maxTimeAtHeadMs;
        }

        public void reset() {
            this.m_maxTimeAtHeadMs = 0L;
        }

        private void updateMaxTimeMs(long now) {
            long currentMessageTimeAtHeadMs = 0L;
            if (this.m_currentMsgEnqueueTime > 0L) {
                currentMessageTimeAtHeadMs = now - this.m_currentMsgEnqueueTime;
            }
            if (currentMessageTimeAtHeadMs > this.m_maxTimeAtHeadMs) {
                this.m_maxTimeAtHeadMs = currentMessageTimeAtHeadMs;
            }
        }
    }
}

