/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import progress.message.broker.Config;
import progress.message.db.DBVersionInfo;
import progress.message.db.Db;
import progress.message.db.EBrokerNameTooLong;
import progress.message.db.EDatabaseException;
import progress.message.db.EDatabaseNotExists;
import progress.message.db.jdbc.IColumnDef;
import progress.message.db.jdbc.SyncLock;
import progress.message.db.prAccessor;
import progress.message.dbsc.ISchemaDef;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public final class JDBCDatabase
extends Db {
    private static final int ORACLE_ALREADY_INDEXED = 1408;
    private static final String TRUE = "true";
    private static final String ZERO_STR = "0";
    private static final String HUNDRED_STR = "100";
    private static final String STORAGE_PAGE_SIZE = "16384";
    private static final String COM_CLOUDSCAPE_CORE_JDBCDRIVER = "COM.cloudscape.core.JDBCDriver";
    private static final String CLOUDSCAPE_DATABASE_FORCE_DATABASE_LOCK = "cloudscape.database.forceDatabaseLock";
    private static final String CLOUDSCAPE_LANGUAGE_STATEMENT_CACHE_SIZE = "cloudscape.language.statementCacheSize";
    private static final String SYBASE_11 = "Sybase 11";
    private static final String MS_SQL_SERVER = "MS SQL Server";
    private static final String COM_IBM_DB_2_J_JDBC_DB_2_J_DRIVER = "com.ibm.db2j.jdbc.DB2jDriver";
    private static final String DB_2_J_DATABASE_FORCE_DATABASE_LOCK = "db2j.database.forceDatabaseLock";
    private static final String DB_2_J_LANGUAGE_STATEMENT_CACHE_SIZE = "db2j.language.statementCacheSize";
    private static final String DB_2_J_LANGUAGE_BULK_FETCH_DEFAULT = "db2j.language.bulkFetchDefault";
    private static final String DB_2_J_STORAGE_PAGE_SIZE = "db2j.storage.pageSize";
    private static final String DB_2_J_INFOLOG_APPEND = "db2j.infolog.append";
    private static final String COM_BORLAND_DATASTORE_JDBC_DATA_STORE_DRIVER = "com.borland.datastore.jdbc.DataStoreDriver";
    private static final String LOCK_WAIT_TIME = "lockWaitTime";
    private static final String LOCK_WAIT_TIME_VALUE = "300000";
    private static final String MAX_ROW_LOCKS = "maxRowLocks";
    private static final String COM_MICROSOFT_JDBC_SQLSERVER_SQLSERVER_DRIVER = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    private static final String SELECT_METHOD = "SelectMethod";
    private static final String CURSOR = "cursor";
    Hashtable m_jdbcConns = new Hashtable();
    private Connection m_internalConn;
    private SyncLock m_connLock = new SyncLock();
    public String m_url;
    public String m_driver;
    public Properties m_connectInfo;
    public String DB_NAME;
    public String DB_DATE;
    public String DB_TIME;
    public Boolean DB_SETBYTES;
    public String DB_TABLE_NOT_FOUND;
    public String DB_UNIQUE_CONSTRAINT_ERROR;
    public String DB_DUPLICATE_KEY_ERROR;
    public Boolean DB_SET_EMPTYSTRING;
    private String m_versionTableName;
    private String m_dupDetectTableName;
    private ISchemaDef m_schemaDef;
    private PreparedStatement m_pingDatabase;
    private static Object m_syncObj = new Object();
    private static boolean m_cloudscapeShutdownRequired = false;
    private static boolean m_db2jShutdownRequired = false;
    boolean m_started = false;
    private TypeMapping m_types;
    private volatile boolean m_closed = false;
    public boolean m_dbsetbytes = true;
    public boolean m_dbsettstamp = true;
    public boolean m_dbsetnull = true;
    public boolean m_dbdatenull = true;
    public boolean m_dbsetEmptyString = true;
    public Timestamp m_null_timestamp = null;
    public Date m_null_date = null;
    boolean DEBUG1 = false;
    private char[] zero_array_24 = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    public JDBCDatabase(String url, String brokerInstance, Properties connectInfo, String driver, Properties dbprops) throws EDatabaseException {
        super(brokerInstance);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("JDBCDatabase " + driver);
        }
        boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        if (this.DEBUG1) {
            this.debug("driver is: " + driver);
        }
        if (this.DEBUG1) {
            this.debug("url is: " + url);
        }
        this.m_url = url;
        this.m_connectInfo = connectInfo;
        this.m_driver = driver;
        if (this.m_url == null || this.m_url.trim().isEmpty() || this.m_driver == null || this.m_driver.isEmpty()) {
            throw new EDatabaseException(prAccessor.getString("INVALID_DB_PARAMS"));
        }
        this.configConstants(dbprops);
        this.m_dbsetEmptyString = this.DB_SET_EMPTYSTRING;
        this.m_dbsetbytes = this.DB_SETBYTES;
        this.m_types = new TypeMapping(dbprops);
        if (this.DB_NAME.contains(SYBASE_11)) {
            this.m_dbsettstamp = false;
            this.m_dbsetnull = false;
        }
        if (this.DB_NAME.contains(MS_SQL_SERVER)) {
            this.m_dbsetnull = false;
        }
        if (!this.m_dbdatenull) {
            this.m_null_timestamp = new Timestamp(1101, 11, 31, 0, 0, 0, 0);
            this.m_null_date = new Date(1101, 11, 31);
            if (this.DEBUG1) {
                this.debug("m_null_timestamp is: " + this.m_null_timestamp + " and m_null_date is: " + this.m_null_date);
            }
        }
        this.configDatabases();
    }

    private void configConstants(Properties dbprops) {
        this.DB_DATE = dbprops.getProperty("DB_DATE");
        this.DB_TIME = dbprops.getProperty("DB_TIME");
        this.DB_NAME = dbprops.getProperty("DB_NAME");
        this.DB_SETBYTES = Boolean.valueOf(dbprops.getProperty("DB_SETBYTES"));
        this.DB_TABLE_NOT_FOUND = dbprops.getProperty("DB_TABLE_NOT_FOUND");
        this.DB_UNIQUE_CONSTRAINT_ERROR = dbprops.getProperty("DB_UNIQUE_CONSTRAINT_ERROR");
        this.DB_DUPLICATE_KEY_ERROR = dbprops.getProperty("DB_DUPLICATE_KEY_ERROR");
        if (dbprops.getProperty("DB_SET_EMPTYSTRING") != null) {
            this.DB_SET_EMPTYSTRING = Boolean.valueOf(dbprops.getProperty("DB_SET_EMPTYSTRING"));
        }
        if (this.DEBUG1) {
            this.debug("DB_DATE is: " + this.DB_DATE);
            this.debug("DB_TIME is: " + this.DB_TIME);
            this.debug("DB_NAME is: " + this.DB_NAME);
            this.debug("DB_SETBYTES is: " + this.DB_SETBYTES);
            this.debug("DB_TABLE_NOT_FOUND is: " + this.DB_TABLE_NOT_FOUND);
            this.debug("DB_UNIQUE_CONSTRAINT_ERROR is: " + this.DB_UNIQUE_CONSTRAINT_ERROR);
            this.debug("DB_DUPLICATE_KEY_ERROR is: " + this.DB_DUPLICATE_KEY_ERROR);
            this.debug("DB_SET_EMPTYSTRING is: " + this.DB_SET_EMPTYSTRING);
        }
    }

    private void configDatabases() throws EDatabaseException {
        try {
            if (COM_CLOUDSCAPE_CORE_JDBCDRIVER.equals(this.m_driver)) {
                Properties properties = System.getProperties();
                properties.put(CLOUDSCAPE_DATABASE_FORCE_DATABASE_LOCK, TRUE);
                properties.put(CLOUDSCAPE_LANGUAGE_STATEMENT_CACHE_SIZE, ZERO_STR);
                m_cloudscapeShutdownRequired = true;
            }
            if (COM_IBM_DB_2_J_JDBC_DB_2_J_DRIVER.equals(this.m_driver)) {
                Properties p = System.getProperties();
                p.put(DB_2_J_DATABASE_FORCE_DATABASE_LOCK, TRUE);
                p.put(DB_2_J_LANGUAGE_STATEMENT_CACHE_SIZE, ZERO_STR);
                p.put(DB_2_J_LANGUAGE_BULK_FETCH_DEFAULT, HUNDRED_STR);
                p.put(DB_2_J_STORAGE_PAGE_SIZE, STORAGE_PAGE_SIZE);
                p.put(DB_2_J_INFOLOG_APPEND, TRUE);
                m_db2jShutdownRequired = true;
            }
            if (COM_BORLAND_DATASTORE_JDBC_DATA_STORE_DRIVER.equals(this.m_driver)) {
                this.m_connectInfo.put(LOCK_WAIT_TIME, LOCK_WAIT_TIME_VALUE);
                int maxLocks = Math.max(Config.PTP_DB_QUEUE_SIZE / 2 / 100, Config.PS_DB_QUEUE_SIZE / 2 / 100);
                maxLocks = Math.max(maxLocks, Config.DB_COMMIT_BATCH_SIZE);
                maxLocks = Math.max(maxLocks * 2, 1024);
                this.m_connectInfo.put(MAX_ROW_LOCKS, String.valueOf(maxLocks));
                if (this.DEBUG1) {
                    this.debug("maxRowLocks=" + maxLocks);
                }
            }
            if (COM_MICROSOFT_JDBC_SQLSERVER_SQLSERVER_DRIVER.equals(this.m_driver)) {
                this.m_connectInfo.put(SELECT_METHOD, CURSOR);
            }
            Class.forName(this.m_driver).newInstance();
            if (this.DEBUG) {
                this.debug("Constructed");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new EDatabaseException(e);
        }
    }

    public void setVersionTableName(String name) {
        this.m_versionTableName = name;
    }

    public void setDupDetectTableName(String name) {
        this.m_dupDetectTableName = name;
    }

    @Override
    public String getDDName() {
        return this.m_dupDetectTableName;
    }

    public void setSchemaDef(ISchemaDef sch) {
        this.m_schemaDef = sch;
    }

    @Override
    public ISchemaDef getSchemaDef() {
        return this.m_schemaDef;
    }

    @Override
    public void start() throws EDatabaseException, EDatabaseNotExists {
        if (!this.m_started) {
            try {
                this.m_internalConn = this.newConnection();
                this.m_internalConn.setAutoCommit(true);
                this.m_started = true;
                if (this.DEBUG1) {
                    DatabaseMetaData dbinfo = this.m_internalConn.getMetaData();
                    this.debug("Database Product Name= " + dbinfo.getDatabaseProductName());
                    this.debug("Database Product Version= " + dbinfo.getDatabaseProductVersion());
                    this.debug("Driver Name= " + dbinfo.getDriverName());
                    this.debug("Driver Version= " + dbinfo.getDriverVersion());
                }
            }
            catch (SQLException e) {
                this.handleSQLException(e);
            }
        }
    }

    @Override
    public void createNewDb() throws EDatabaseException {
    }

    @Override
    public void close() throws EDatabaseException {
        this.m_closed = true;
        Enumeration conns = this.m_jdbcConns.elements();
        while (conns.hasMoreElements()) {
            Connection conn = (Connection)conns.nextElement();
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        this.m_started = false;
        if (this.DEBUG) {
            this.debug("Close completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShutdown() {
        Object object = m_syncObj;
        synchronized (object) {
            if (m_cloudscapeShutdownRequired) {
                try {
                    if (COM_CLOUDSCAPE_CORE_JDBCDRIVER.equals(this.m_driver)) {
                        DriverManager.getConnection("jdbc:cloudscape:;shutdown=true");
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                m_cloudscapeShutdownRequired = false;
            }
            if (m_db2jShutdownRequired) {
                try {
                    if (COM_IBM_DB_2_J_JDBC_DB_2_J_DRIVER.equals(this.m_driver)) {
                        DriverManager.getConnection("jdbc:db2j:;shutdown=true");
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                m_db2jShutdownRequired = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(String tableNameSuffix, Vector columns) throws EBrokerNameTooLong, EDatabaseException {
        this.checkDBObjNameLength(tableNameSuffix);
        StringBuffer stmt = new StringBuffer("create table " + this.table(tableNameSuffix));
        stmt.append(" (");
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                stmt.append(", ");
            }
            ColumnDef col = (ColumnDef)columns.elementAt(i);
            JDBCDatabase.appendColumnData(stmt, col);
        }
        stmt.append(')');
        Connection con = this.acquireInternalConnection();
        PreparedStatement s = null;
        try {
            String query = stmt.toString();
            if (this.DEBUG) {
                this.debug("stmt.toString() is: " + query);
            }
            s = this.prepareStatement(con, query);
            s.executeUpdate();
            this.closeS(s);
        }
        catch (SQLException e) {
            this.handleSQLException(e);
        }
        finally {
            this.closeS(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String tableNameSuffix) {
        Connection con = this.acquireInternalConnection();
        try {
            String dropStmt = "drop table " + this.table(tableNameSuffix);
            PreparedStatement s = this.prepareStatement(con, dropStmt);
            if (this.DEBUG) {
                this.debug("dropTable stmt is: " + dropStmt);
            }
            s.executeUpdate();
            s.close();
        }
        catch (SQLException e) {
            if (this.DEBUG) {
                this.showSQLExceptions(e);
            }
        }
        finally {
            this.releaseInternalConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTable(String tableNameSuffix, Vector mods) throws EDatabaseException {
        Connection con = this.acquireInternalConnection();
        try {
            for (int i = 0; i < mods.size(); ++i) {
                Object mod = mods.elementAt(i);
                String stmt = null;
                String pkName = null;
                String colname = null;
                if (mod instanceof ColumnMod && this.DB_NAME.indexOf(MS_SQL_SERVER) != -1) {
                    ColumnMod colmod = (ColumnMod)mod;
                    if (colmod.m_primaryKey) {
                        pkName = this.dropPKConstraintMSSQLSrv(this.table(tableNameSuffix), colmod.m_name);
                        colname = colmod.m_name;
                    }
                }
                if (this.DB_NAME.indexOf("Cloudscape") != -1) {
                    stmt = this.constructAlterTableStmtCloudscape(this.table(tableNameSuffix), mod);
                } else if (this.DB_NAME.indexOf(MS_SQL_SERVER) != -1) {
                    stmt = this.constructAlterTableStmtMSSQLSrv(this.table(tableNameSuffix), mod);
                } else if (this.DB_NAME.indexOf("Oracle") != -1) {
                    stmt = this.constructAlterTableStmtOracle(this.table(tableNameSuffix), mod);
                } else {
                    throw new EAssertFailure("alterTable not implemented for " + this.DB_NAME);
                }
                PreparedStatement s = this.prepareStatement(con, stmt);
                if (this.DEBUG) {
                    this.debug("alterTable: stmt is: " + stmt);
                }
                s.executeUpdate();
                s.close();
                if (this.DB_NAME.indexOf(MS_SQL_SERVER) == -1 || pkName == null) continue;
                this.addPKConstraintMSSQLSrv(this.table(tableNameSuffix), colname, pkName);
            }
        }
        catch (SQLException e) {
            this.handleSQLException(e);
        }
        finally {
            this.releaseInternalConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsTable(String tableNameSuffix) throws EDatabaseException {
        if (!this.m_started) {
            throw new EAssertFailure("Database has not been started " + this.m_url);
        }
        String query = "select count(*) from " + this.table(tableNameSuffix);
        boolean result = false;
        Connection con = this.acquireInternalConnection();
        try {
            PreparedStatement s = this.prepareStatement(con, query);
            ResultSet r = s.executeQuery();
            r.close();
            s.close();
            result = true;
        }
        catch (SQLException e) {
            if (this.DEBUG) {
                this.showSQLExceptions(e);
                this.debug("DB_TABLE_NOT_FOUND = " + this.DB_TABLE_NOT_FOUND + " sqlState= " + e.getSQLState());
            }
            if (this.isTableNotFoundException(e)) {
                result = false;
            } else {
                this.handleSQLException(e);
            }
        }
        finally {
            this.releaseInternalConnection();
        }
        if (this.DEBUG) {
            this.debug("existsTable " + tableNameSuffix + " returning " + result);
        }
        return result;
    }

    @Override
    public boolean seemsConfigured() throws EDatabaseException {
        return this.checkExists(this.m_versionTableName);
    }

    @Override
    public boolean seemsConfiguredDD() throws EDatabaseException {
        return this.checkExists(this.m_dupDetectTableName);
    }

    private boolean checkExists(String tableName) throws EDatabaseException {
        if (tableName == null) {
            return false;
        }
        return this.existsTable(tableName);
    }

    public boolean createIndex(String indexNameSuffix, String tableNameSuffix, String columnName1, String columnName2) throws EDatabaseException {
        String[] cols = null;
        cols = "".equals(columnName2) ? new String[]{columnName1} : new String[]{columnName1, columnName2};
        return this.createIndex(indexNameSuffix, tableNameSuffix, cols, false);
    }

    public boolean createIndex(String indexNameSuffix, String tableNameSuffix, String[] columnNames) throws EDatabaseException {
        return this.createIndex(indexNameSuffix, tableNameSuffix, columnNames, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndex(String indexNameSuffix, String tableNameSuffix, String[] columnNames, boolean unique) throws EDatabaseException {
        String stmt = null;
        StringBuffer indexComps = new StringBuffer();
        String s_unique = " ";
        if (unique) {
            s_unique = "unique ";
        }
        boolean created = false;
        for (int i = 0; i < columnNames.length; ++i) {
            if (i > 0) {
                indexComps.append(", ");
            }
            indexComps.append(columnNames[i]);
        }
        stmt = "create " + s_unique + "index " + this.table(indexNameSuffix) + " on " + this.table(tableNameSuffix) + " (" + indexComps.toString() + ")";
        if (this.DEBUG) {
            this.debug("createIndex stmt is: " + stmt);
        }
        Connection con = this.acquireInternalConnection();
        PreparedStatement s = null;
        try {
            s = this.prepareStatement(con, stmt);
            s.executeUpdate();
            created = true;
        }
        catch (SQLException e) {
            if (this.m_driver.indexOf("oracle") == -1 || e.getErrorCode() != 1408) {
                this.handleSQLException(e);
            }
        }
        finally {
            this.closeS(s);
        }
        return created;
    }

    private void closeS(PreparedStatement s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.releaseInternalConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(String indexSuffix, String tableSuffix) {
        String indexName = this.table(indexSuffix);
        String stmt = null;
        stmt = this.DB_NAME.indexOf(MS_SQL_SERVER) != -1 ? "drop index " + this.table(tableSuffix) + "." + indexName : "drop index " + indexName;
        if (this.DEBUG) {
            this.debug("dropIndex stmt is: " + stmt);
        }
        Connection con = this.acquireInternalConnection();
        try {
            PreparedStatement s = this.prepareStatement(con, stmt);
            s.executeUpdate();
            s.close();
        }
        catch (SQLException e) {
            if (this.DEBUG) {
                this.showSQLExceptions(e);
            }
        }
        finally {
            this.releaseInternalConnection();
        }
    }

    @Override
    protected DBVersionInfo getDBVersionInfo() throws EDatabaseException {
        if (this.m_versionTableName == null) {
            throw new EAssertFailure("getDBVersionInfo: No version table configured for Db");
        }
        return this.getDBVersionInfo(this.m_versionTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBVersionInfo getDBVersionInfo(String tablename) throws EDatabaseException {
        DBVersionInfo versObj;
        block12: {
            versObj = new DBVersionInfo();
            versObj.m_version_in_database = prAccessor.getString("NONE");
            Connection con = this.acquireInternalConnection();
            try {
                boolean pre20005 = false;
                int colNum = 0;
                if (!this.existsTable(tablename)) break block12;
                PreparedStatement stmt = this.prepareStatement(con, "select AbsDBVersion, BuildNumber, ReleaseName, MajorVersion, MinorVersion, RelDBVersion from " + this.table(tablename));
                ResultSet rs = null;
                try {
                    rs = stmt.executeQuery();
                }
                catch (SQLException e) {
                    pre20005 = true;
                }
                if (pre20005) {
                    rs = stmt.executeQuery("select MajorVersion, MinorVersion, RelDBVersion, AbsDBVersion from " + this.table(tablename));
                }
                if (rs.next()) {
                    colNum = 1;
                    if (pre20005) {
                        colNum = JDBCDatabase.configVersObjVersions(colNum, rs, versObj);
                        versObj.m_version_in_database = versObj.m_major_version_in_database + "." + versObj.m_minor_version_in_database + "." + versObj.m_rel_tables_version_in_database;
                    }
                    versObj.m_abs_tables_version_in_database = rs.getInt(colNum++);
                    if (!pre20005) {
                        versObj.m_build_number_in_database = rs.getInt(colNum++);
                        versObj.m_release_name_in_database = rs.getString(colNum++);
                        colNum = JDBCDatabase.configVersObjVersions(colNum, rs, versObj);
                        versObj.m_version_in_database = Db.buildDbVersionString(versObj.m_release_name_in_database, versObj.m_build_number_in_database);
                    }
                    if (this.DEBUG) {
                        this.debug("Absolute version of " + tablename + " in database is " + versObj.m_abs_tables_version_in_database);
                    }
                }
                rs.close();
                stmt.close();
            }
            catch (SQLException e) {
                this.handleSQLException(e);
            }
            finally {
                this.releaseInternalConnection();
            }
        }
        return versObj;
    }

    private static int configVersObjVersions(int colNumParam, ResultSet rs, DBVersionInfo versObj) throws SQLException {
        int colNum = colNumParam;
        versObj.m_major_version_in_database = rs.getInt(colNum++);
        versObj.m_minor_version_in_database = rs.getInt(colNum++);
        versObj.m_rel_tables_version_in_database = rs.getInt(colNum++);
        return colNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setDBVersionInfo(DBVersionInfo vers) throws EDatabaseException {
        if (this.m_versionTableName == null) {
            throw new EAssertFailure("setDBVersionInfo: No version table configured for Db");
        }
        Connection con = this.acquireInternalConnection();
        try {
            PreparedStatement pstmt = this.prepareStatement(con, "delete from " + this.table(this.m_versionTableName));
            pstmt.executeUpdate();
            pstmt.close();
            pstmt = con.prepareStatement("insert into " + this.table(this.m_versionTableName) + " values(?, ?, ?, ?, ?, ?)");
            pstmt.setInt(1, vers.m_major_version_in_database);
            pstmt.setInt(2, vers.m_minor_version_in_database);
            pstmt.setInt(3, vers.m_rel_tables_version_in_database);
            pstmt.setInt(4, vers.m_abs_tables_version_in_database);
            pstmt.setInt(5, vers.m_build_number_in_database);
            pstmt.setString(6, vers.m_release_name_in_database);
            pstmt.executeUpdate();
            pstmt.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e);
        }
        finally {
            this.releaseInternalConnection();
        }
    }

    @Override
    public int getLatestSupportedDbVersion() {
        return 700000;
    }

    @Override
    public boolean isUpgradable(int vers) {
        return vers == 600001;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dropPKConstraintMSSQLSrv(String tableName, String columnName) throws EDatabaseException {
        Connection conn = this.acquireInternalConnection();
        String pkName = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getPrimaryKeys(null, null, tableName);
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                if (colName == null || !colName.equalsIgnoreCase(columnName) || (pkName = rs.getString("PK_NAME")) == null || pkName.length() == 0) continue;
                String statement = "alter table " + tableName + " drop constraint " + pkName;
                this.executeStatementAndClose(conn, statement);
                String string = pkName;
                return string;
            }
        }
        catch (SQLException e) {
            this.handleSQLException(e);
        }
        finally {
            this.releaseInternalConnection();
        }
        return pkName;
    }

    @Override
    public void initPingDatabase() throws EDatabaseException {
        if (this.m_versionTableName == null) {
            throw new EAssertFailure("initPingDatabase: No version table configured for Db");
        }
        if (this.DEBUG) {
            this.debug("initPingDatabase called");
        }
        Connection con = this.acquireInternalConnection();
        try {
            this.m_pingDatabase = con.prepareStatement("select count(*) from " + this.table(this.m_versionTableName));
        }
        catch (SQLException sqle) {
            this.handleSQLException(sqle);
        }
        finally {
            this.releaseInternalConnection();
        }
    }

    @Override
    public void pingDatabase() throws EDatabaseException {
        if (this.m_pingDatabase == null) {
            throw new EAssertFailure("Ping statement not prepared");
        }
        Connection con = this.acquireInternalConnection();
        try {
            ResultSet result = null;
            if (this.DEBUG) {
                this.debug("pingDatabase called");
            }
            result = this.m_pingDatabase.executeQuery();
            result.close();
        }
        catch (SQLException sqle) {
            this.handleSQLException(sqle);
        }
        finally {
            this.releaseInternalConnection();
        }
    }

    @Override
    public boolean isRemoteDb() {
        if (COM_CLOUDSCAPE_CORE_JDBCDRIVER.equals(this.m_driver)) {
            return false;
        }
        if (COM_IBM_DB_2_J_JDBC_DB_2_J_DRIVER.equals(this.m_driver)) {
            return false;
        }
        return this.m_url.indexOf("jdbc:borland:dslocal") == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPKConstraintMSSQLSrv(String tableName, String columnName, String pkName) throws EDatabaseException {
        Connection conn = this.acquireInternalConnection();
        try {
            String statement = "alter table " + tableName + " add constraint " + pkName + " PRIMARY KEY (" + columnName + ")";
            this.executeStatementAndClose(conn, statement);
        }
        catch (SQLException e) {
            this.handleSQLException(e);
        }
        finally {
            this.releaseInternalConnection();
        }
    }

    private void executeStatementAndClose(Connection conn, String statement) throws SQLException {
        if (this.DEBUG) {
            this.debug(statement);
        }
        PreparedStatement s = this.prepareStatement(conn, statement);
        s.executeUpdate();
        s.close();
    }

    public Connection newConnection() throws EDatabaseException {
        if (this.DEBUG1) {
            this.debug("Creating a database connection ...  to " + this.DB_NAME + " " + this.m_url);
        }
        Connection conn = null;
        try {
            String localUrl = null;
            localUrl = "com.progress.sql.jdbc.JdbcProgressDriver".equals(this.m_driver) ? this.m_url + ";Workarounds=536870912" : this.m_url;
            conn = DriverManager.getConnection(localUrl, this.m_connectInfo);
            conn.setTransactionIsolation(2);
            this.m_jdbcConns.put(conn, conn);
        }
        catch (SQLException e) {
            SQLException next_e;
            if (this.DB_NAME.indexOf("Cloudscape") != -1 && "XJ040".equals(e.getSQLState()) && "XSDB9".equals((next_e = e.getNextException()).getSQLState())) {
                throw new EDatabaseException(prAccessor.getString("STR002"));
            }
            this.handleSQLException(e);
        }
        if (this.DEBUG) {
            this.debug("Database connection created to " + this.DB_NAME);
        }
        return conn;
    }

    public boolean isUniqueConstraintException(SQLException e) {
        String err;
        if (e.getSQLState() == null) {
            return false;
        }
        boolean result = false;
        if (e.getSQLState().equals(this.DB_UNIQUE_CONSTRAINT_ERROR) || e.getSQLState().equals(this.DB_DUPLICATE_KEY_ERROR)) {
            result = true;
        } else if (this.DB_NAME.indexOf("JDataStore") != -1 && (err = e.getMessage()) != null && (err.indexOf(this.DB_UNIQUE_CONSTRAINT_ERROR) != -1 || err.indexOf(this.DB_DUPLICATE_KEY_ERROR) != -1)) {
            result = true;
        }
        return result;
    }

    public boolean isTableNotFoundException(SQLException e) {
        String err;
        boolean result = false;
        String sqlState = e.getSQLState();
        if (sqlState != null && sqlState.equals(this.DB_TABLE_NOT_FOUND)) {
            result = true;
        } else if (this.DB_NAME.indexOf("JDataStore") != -1 && (err = e.getMessage()) != null && err.indexOf(this.DB_TABLE_NOT_FOUND) != -1) {
            result = true;
        }
        return result;
    }

    public void handleSQLException(SQLException se) throws EDatabaseException {
        if (!this.m_closed) {
            se.printStackTrace();
            this.showSQLExceptions(se);
        }
        throw new EDatabaseException(se);
    }

    public void showSQLExceptions(SQLException seParam) {
        for (SQLException se = seParam; se != null; se = se.getNextException()) {
            System.err.println("SQLException(SQLState=" + se.getSQLState() + ", errorCode=" + se.getErrorCode() + "): " + se.getMessage());
        }
    }

    public Connection acquireInternalConnection() {
        this.m_connLock.acquire();
        return this.m_internalConn;
    }

    public void releaseInternalConnection() {
        this.m_connLock.release();
    }

    private String constructAlterTableStmtMSSQLSrv(String tableName, Object mod) {
        StringBuffer stmt = new StringBuffer("alter table " + tableName);
        if (mod instanceof ColumnDef) {
            stmt.append(" add ");
            JDBCDatabase.appendColdefDetails(mod, stmt);
        } else if (mod instanceof ColumnMod) {
            stmt.append(" alter column ");
            ColumnMod colmod = JDBCDatabase.appendColModDetails(mod, stmt);
            if (colmod.m_extra != null) {
                stmt.append(' ');
                stmt.append(colmod.m_extra);
            }
        } else if (mod instanceof ColumnDrop) {
            stmt.append(" drop column ");
            ColumnDrop coldrop = (ColumnDrop)mod;
            stmt.append(coldrop.m_name);
        }
        return stmt.toString();
    }

    private String constructAlterTableStmtCloudscape(String tableName, Object mod) {
        StringBuffer stmt = new StringBuffer("alter table " + tableName);
        if (mod instanceof ColumnDef) {
            stmt.append(" add column ");
            JDBCDatabase.appendColdefDetails(mod, stmt);
        } else if (mod instanceof ColumnMod) {
            stmt.append(" modify ");
            ColumnMod columnMod = JDBCDatabase.appendColModDetails(mod, stmt);
        } else if (mod instanceof ColumnDrop) {
            stmt.append(" drop column ");
            ColumnDrop coldrop = (ColumnDrop)mod;
            stmt.append(coldrop.m_name);
        }
        return stmt.toString();
    }

    private String constructAlterTableStmtOracle(String tableName, Object mod) {
        StringBuffer stmt = new StringBuffer("alter table " + tableName);
        if (mod instanceof ColumnDef) {
            stmt.append(" add (");
            JDBCDatabase.appendColdefDetails(mod, stmt);
            stmt.append(") ");
        } else if (mod instanceof ColumnMod) {
            stmt.append(" modify (");
            ColumnMod colmod = JDBCDatabase.appendColModDetails(mod, stmt);
            stmt.append(") ");
        } else if (mod instanceof ColumnDrop) {
            stmt.append(" drop ( ");
            ColumnDrop coldrop = (ColumnDrop)mod;
            stmt.append(coldrop.m_name);
            stmt.append(") ");
        }
        return stmt.toString();
    }

    private static void appendColdefDetails(Object mod, StringBuffer stmt) {
        ColumnDef coldef = (ColumnDef)mod;
        JDBCDatabase.appendColumnData(stmt, coldef);
    }

    private static void appendColumnData(StringBuffer stmt, ColumnDef col) {
        stmt.append(col.m_name);
        stmt.append(' ');
        stmt.append(col.m_type);
        if (col.m_extra != null) {
            stmt.append(' ');
            stmt.append(col.m_extra);
        }
    }

    private static ColumnMod appendColModDetails(Object mod, StringBuffer stmt) {
        ColumnMod colmod = (ColumnMod)mod;
        stmt.append(colmod.m_name);
        stmt.append(' ');
        stmt.append(colmod.m_type);
        return colmod;
    }

    public String convertTrackingString(String original_string) {
        return (new String(this.zero_array_24, 0, 24 - original_string.length()) + original_string.substring(0, original_string.length())).substring(0, 24);
    }

    public String makeType(int typeValue) {
        return this.m_types.getTypeName(typeValue);
    }

    public String makeType(int typeValue, int parameter) {
        String rawType = this.makeType(typeValue);
        return rawType + "(" + parameter + ")";
    }

    public Properties getDefaultSettings() {
        Properties defaultSettings = new Properties();
        defaultSettings.put(new Integer(-7).toString(), "char(1)");
        defaultSettings.put(new Integer(-5).toString(), "varchar(24)");
        defaultSettings.put(new Integer(-4).toString(), "LONG RAW");
        defaultSettings.put(new Integer(-1).toString(), "LONG");
        defaultSettings.put(new Integer(-3).toString(), "RAW");
        defaultSettings.put(new Integer(-2).toString(), "binary");
        defaultSettings.put(new Integer(4).toString(), "integer");
        defaultSettings.put(new Integer(12).toString(), "varchar");
        defaultSettings.put(new Integer(93).toString(), "DATE");
        defaultSettings.put(new String("DB_DATE"), new String("DATE"));
        defaultSettings.put(new String("DB_TIME"), new String("{ fn curtime() }"));
        defaultSettings.put(new String("DB_NAME"), new String("Oracle 7.x"));
        defaultSettings.put(new String("DB_SETBYTES"), new String(TRUE));
        defaultSettings.put(new String("DB_TABLE_NOT_FOUND"), new String("S0002"));
        defaultSettings.put(new String("DB_UNIQUE_CONSTRAINT_ERROR"), new String("23000"));
        defaultSettings.put(new String("DB_DUPLICATE_KEY_ERROR"), new String("23000"));
        defaultSettings.put(new String("DB_SET_EMPTYSTRING"), new String(TRUE));
        return defaultSettings;
    }

    public Object makeColumnDef(String colName, String colType, String extras) {
        return new ColumnDef(colName, colType, extras);
    }

    public Object makeColumnDef(String colName, String colType) {
        return new ColumnDef(colName, colType);
    }

    public Object makeColumnMod(String colName, String colType, String extras) {
        return new ColumnMod(colName, colType, extras);
    }

    public Object makeColumnMod(String colName, String colType) {
        return new ColumnMod(colName, colType);
    }

    public Object makeColumnMod(String colName, String colType, String extras, boolean primaryKey) {
        return new ColumnMod(colName, colType, extras, primaryKey);
    }

    public Object makeColumnDrop(String colName) {
        return new ColumnDrop(colName);
    }

    @Override
    public String toString() {
        return "JDBCDatabase for " + this.m_driver + "; " + this.m_url;
    }

    private PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    class TypeMapping
    extends DebugObject {
        private Vector m_types;

        TypeMapping(Properties p) {
            super(DebugState.GLOBAL_DEBUG_ON ? "TypeMapping" : null);
            this.m_types = new Vector(20);
            String type_name = p.getProperty(new Integer(-7).toString());
            TypeMap map = new TypeMap(-7, type_name);
            this.insert(map);
            type_name = p.getProperty(new Integer(-5).toString());
            map = new TypeMap(-5, type_name);
            this.insert(map);
            type_name = p.getProperty(new Integer(-4).toString());
            map = new TypeMap(-4, type_name);
            this.insert(map);
            type_name = p.getProperty(new Integer(-1).toString());
            map = new TypeMap(-1, type_name);
            this.insert(map);
            type_name = p.getProperty(new Integer(-3).toString());
            map = new TypeMap(-3, type_name);
            this.insert(map);
            type_name = p.getProperty(new Integer(-2).toString());
            map = new TypeMap(-2, type_name);
            this.insert(map);
            type_name = p.getProperty(new Integer(4).toString());
            map = new TypeMap(4, type_name);
            this.insert(map);
            type_name = p.getProperty(new Integer(12).toString());
            map = new TypeMap(12, type_name);
            this.insert(map);
            type_name = p.getProperty(new Integer(93).toString());
            map = new TypeMap(93, type_name);
            this.insert(map);
        }

        private void insert(TypeMap map) {
            this.m_types.addElement(map);
        }

        String getTypeName(int typeValue) {
            if (this.DEBUG) {
                this.debug("typeValue is: " + typeValue);
            }
            for (int i = 0; i < this.m_types.size(); ++i) {
                TypeMap map = (TypeMap)this.m_types.elementAt(i);
                if (map.m_typeValue == typeValue) {
                    if (this.DEBUG) {
                        this.debug("Match: map.m_typeName is: " + map.m_typeName);
                    }
                    return map.m_typeName;
                }
                if (!this.DEBUG) continue;
                this.debug("NOMATCH: map.m_typeName is: " + map.m_typeName + "&& map.m_typeValue is: " + map.m_typeValue);
            }
            return null;
        }
    }

    class ColumnDef
    implements IColumnDef {
        public String m_name;
        public String m_type;
        public String m_extra;

        ColumnDef(String name, String type, String extra) {
            this.m_name = name;
            this.m_type = type;
            this.m_extra = extra;
        }

        ColumnDef(String name, String type) {
            this.m_name = name;
            this.m_type = type;
            this.m_extra = null;
        }

        @Override
        public String getColumnName() {
            return this.m_name;
        }
    }

    class ColumnMod {
        public String m_name;
        public String m_type;
        public String m_extra;
        public boolean m_primaryKey;

        ColumnMod(String name, String type, String extra) {
            this.m_name = name;
            this.m_type = type;
            this.m_extra = extra;
            this.m_primaryKey = false;
        }

        ColumnMod(String name, String type, String extra, boolean pkey) {
            this.m_name = name;
            this.m_type = type;
            this.m_extra = extra;
            this.m_primaryKey = pkey;
        }

        ColumnMod(String name, String type) {
            this.m_name = name;
            this.m_type = type;
            this.m_extra = null;
            this.m_primaryKey = false;
        }
    }

    class ColumnDrop {
        public String m_name;

        ColumnDrop(String name) {
            this.m_name = name;
        }
    }

    class TypeMap {
        public int m_typeValue;
        public String m_typeName;

        TypeMap(int typeValue, String typeName) {
            this.m_typeValue = typeValue;
            this.m_typeName = typeName;
        }
    }
}

