/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.IReplicateableSaverOp;
import progress.message.broker.SubscribeEvt;
import progress.message.ft.ClientContextDescriptor;
import progress.message.ft.DupDetectionDynSyncer;
import progress.message.ft.DurableMsgDynSyncer;
import progress.message.ft.DynamicSyncRoutesReplicationOp;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.QueueMsgDynSyncer;
import progress.message.ft.RBRegistryDynSyncer;
import progress.message.ft.RBRegistrySyncOp;
import progress.message.ft.RemoteBrokerDescriptor;
import progress.message.ft.ReplicationManager;
import progress.message.ft.StandbyDBQMsgs;
import progress.message.ft.SubscriptionDynSyncer;
import progress.message.ft.TransactionDynSyncer;
import progress.message.ft.TransactionSyncOp;
import progress.message.ft.UserIDMappingDynSyncer;
import progress.message.ft.UserIDMappingSyncOp;
import progress.message.gr.RemoteBroker;
import progress.message.gr.RouteInfo;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;

public class DynamicSyncManager
extends DebugObject {
    static final int ACTIVE_ROLE = 1;
    static final int STANDBY_ROLE = 2;
    static final int UNKNOWN_ROLE = -1;
    private int m_role = -1;
    private boolean m_inDynSync = false;
    private boolean m_started = false;
    private DynamicSyncMgrThread m_dsmThread = null;
    private Object m_syncObj = null;
    private volatile boolean m_queueSnapshotComplete = false;
    private volatile boolean m_pubSubSnapshotComplete = false;
    private ReplicationManager m_rm = null;
    private DupDetectionDynSyncer m_dupDetectDynSyncer = null;
    private DurableMsgDynSyncer m_durMsgDynSyncer = null;
    private QueueMsgDynSyncer m_qMsgDynSyncer = null;
    private RBRegistryDynSyncer m_rbRegistryDynSyncer = null;
    private SubscriptionDynSyncer m_subscriptionDynSyncer = null;
    private TransactionDynSyncer m_transactionDynSyncer = null;
    private UserIDMappingDynSyncer m_userIDDynSyncer = null;
    private boolean m_activeSyncpointComplete = false;
    private boolean m_standbySyncpointComplete = false;
    static final int RESET_SYNC_STATUS = 0;
    private int m_status = 0;
    static final int DUP_DET_SYNC_DONE = 1;
    static final int DUR_MSG_SYNC_DONE = 2;
    static final int Q_MSG_SYNC_DONE = 4;
    static final int RB_REG_SYNC_DONE = 8;
    static final int SUB_SYNC_DONE = 16;
    static final int USERID_SYNC_DONE = 32;
    static final int ROUTES_SYNC_DONE = 64;
    static final int PRE_TXN_SYNC_COMPLETE = 127;
    static final int TXN_SYNC_DONE = 128;
    static final int DYN_SYNC_COMPLETE = 255;

    synchronized void setStatus(int status) {
        if (this.m_role == -1 || !this.m_inDynSync) {
            return;
        }
        switch (status) {
            case 32: {
                this.m_rm.getReplicationDemultiplexer().getDSRecoveryController().setClientRegistrySyncComplete();
                break;
            }
            case 16: {
                this.m_rm.getReplicationDemultiplexer().getDSRecoveryController().setSubscriptionSyncComplete();
            }
        }
        if (this.DEBUG) {
            this.debug("setStatus pre-applying of status: " + status + " m_status" + this.m_status);
        }
        this.m_status |= status;
        if (this.DEBUG) {
            this.debug("setStatus post-applying of status: " + status + " m_status" + this.m_status);
        }
        this.notifyAll();
    }

    synchronized void onDynamicSyncComplete() {
        this.m_inDynSync = false;
        this.m_started = false;
        this.resetStatus();
    }

    private synchronized void resetStatus() {
        this.m_role = -1;
        this.m_status = 0;
        this.m_activeSyncpointComplete = false;
        this.m_standbySyncpointComplete = false;
        this.m_pubSubSnapshotComplete = false;
        this.m_queueSnapshotComplete = false;
    }

    private synchronized void waitUntilAllComponentsDone() throws InterruptedException {
        while (!this.allDone()) {
            this.wait();
        }
        if (this.DEBUG) {
            this.debug("Done waiting for all dynamic sync components to finish m_status:" + this.m_status);
        }
    }

    private synchronized void waitUntilPreTxnComponentsDone() throws InterruptedException {
        while (!this.allPreTxnComponentsDone()) {
            this.wait();
        }
        if (this.DEBUG) {
            this.debug("Done waitForPreTxnSyncComponents  to finish m_status:" + this.m_status);
        }
    }

    private boolean allDone() {
        return (this.m_status & 0xFF) == 255;
    }

    private boolean allPreTxnComponentsDone() {
        return (this.m_status & 0x7F) == 127;
    }

    public DynamicSyncManager(ReplicationManager rm) throws Exception {
        super(DebugState.GLOBAL_DEBUG_ON ? "DynamicSyncManager" : null);
        this.m_rm = rm;
        this.m_syncObj = new Object();
    }

    public ReplicationManager getReplicationManager() {
        return this.m_rm;
    }

    void acknowledge(long trackingNum) {
        this.m_rm.acknowledge(trackingNum);
    }

    synchronized void beginActiveSync() {
        if (this.DEBUG) {
            this.debug("beginActiveSync called");
        }
        this.m_inDynSync = true;
        this.m_started = false;
        this.m_role = 1;
        this.setupActiveDynSyncThreads();
    }

    synchronized void beginStandbySync() {
        if (this.DEBUG) {
            this.debug("beginStandbySync called");
        }
        this.m_inDynSync = true;
        this.m_started = false;
        this.m_role = 2;
        this.m_rm.clearStandbyDataPreDynSync();
        this.setupStandbyDynSyncThreads();
        this.startDynSyncThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUserIDMappingSyncOp(UserIDMappingSyncOp uIdSyncOp) {
        DynamicSyncManager dynamicSyncManager = this;
        synchronized (dynamicSyncManager) {
            if (this.m_userIDDynSyncer != null) {
                this.m_userIDDynSyncer.addWorkItem(uIdSyncOp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRBRegistrySyncOp(RBRegistrySyncOp rbRegistrySyncOp) {
        DynamicSyncManager dynamicSyncManager = this;
        synchronized (dynamicSyncManager) {
            if (this.m_rbRegistryDynSyncer != null) {
                this.m_rbRegistryDynSyncer.addWorkItem(rbRegistrySyncOp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTransactionSyncOp(TransactionSyncOp txnSyncOp) {
        DynamicSyncManager dynamicSyncManager = this;
        synchronized (dynamicSyncManager) {
            if (this.m_transactionDynSyncer != null) {
                this.m_transactionDynSyncer.addWorkItem(txnSyncOp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeQDynamicSync(long lastTracking) {
        DynamicSyncManager dynamicSyncManager = this;
        synchronized (dynamicSyncManager) {
            if (this.m_qMsgDynSyncer != null) {
                this.m_qMsgDynSyncer.endStandbyDynamicSync(lastTracking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDynamicSync() throws InterruptedException {
        DynamicSyncManager dynamicSyncManager = this;
        synchronized (dynamicSyncManager) {
            if (!this.m_inDynSync) {
                return;
            }
            this.m_inDynSync = false;
        }
        boolean throwIE = false;
        InterruptedException caughtIE = null;
        try {
            this.m_dsmThread = this.shutdownAndJoin(this.m_dsmThread);
        }
        catch (InterruptedException ie) {
            throwIE = true;
            caughtIE = ie;
        }
        try {
            this.m_dupDetectDynSyncer = this.shutdownAndJoin(this.m_dupDetectDynSyncer);
        }
        catch (InterruptedException ie) {
            throwIE = true;
            caughtIE = ie;
        }
        try {
            this.m_durMsgDynSyncer = this.shutdownAndJoin(this.m_durMsgDynSyncer);
        }
        catch (InterruptedException ie) {
            throwIE = true;
            caughtIE = ie;
        }
        try {
            this.m_qMsgDynSyncer = this.shutdownAndJoin(this.m_qMsgDynSyncer);
        }
        catch (InterruptedException ie) {
            throwIE = true;
            caughtIE = ie;
        }
        try {
            this.m_rbRegistryDynSyncer = this.shutdownAndJoin(this.m_rbRegistryDynSyncer);
        }
        catch (InterruptedException ie) {
            throwIE = true;
            caughtIE = ie;
        }
        try {
            if (this.m_role == 1) {
                this.m_subscriptionDynSyncer.shutdown();
                this.m_subscriptionDynSyncer.join();
                this.m_subscriptionDynSyncer = null;
            }
        }
        catch (InterruptedException ie) {
            throwIE = true;
            caughtIE = ie;
        }
        try {
            this.m_transactionDynSyncer = this.shutdownAndJoin(this.m_transactionDynSyncer);
        }
        catch (InterruptedException ie) {
            throwIE = true;
            caughtIE = ie;
        }
        try {
            this.m_userIDDynSyncer = this.shutdownAndJoin(this.m_userIDDynSyncer);
        }
        catch (InterruptedException ie) {
            throwIE = true;
            caughtIE = ie;
        }
        if (throwIE) {
            throw caughtIE;
        }
        DynamicSyncManager dynamicSyncManager2 = this;
        synchronized (dynamicSyncManager2) {
            this.m_started = false;
        }
        this.resetStatus();
    }

    private <T0 extends DebugThread> T0 shutdownAndJoin(T0 m_dupDetectDynSyncerParam) throws InterruptedException {
        T0 m_dupDetectDynSyncer = m_dupDetectDynSyncerParam;
        if (m_dupDetectDynSyncer != null) {
            m_dupDetectDynSyncer.shutdown();
            m_dupDetectDynSyncer.join();
            m_dupDetectDynSyncer = null;
        }
        return m_dupDetectDynSyncer;
    }

    void setupActiveDynSyncThreads() {
        this.m_dsmThread = new DynamicSyncMgrThread();
        this.m_dupDetectDynSyncer = new DupDetectionDynSyncer(this, this.m_role);
        this.m_durMsgDynSyncer = new DurableMsgDynSyncer(this, this.m_role);
        this.m_qMsgDynSyncer = new QueueMsgDynSyncer(this, this.m_role);
        this.m_rbRegistryDynSyncer = new RBRegistryDynSyncer(this.m_rm, this, this.m_role);
        this.m_subscriptionDynSyncer = new SubscriptionDynSyncer(this, this.m_role);
        this.m_transactionDynSyncer = new TransactionDynSyncer(this, this.m_role);
        this.m_userIDDynSyncer = new UserIDMappingDynSyncer(this, this.m_role);
    }

    void setupStandbyDynSyncThreads() {
        this.m_dsmThread = new DynamicSyncMgrThread();
        DurableMsgDynSyncer.initRequestHandler();
        this.m_qMsgDynSyncer = new QueueMsgDynSyncer(this, this.m_role);
        this.m_rbRegistryDynSyncer = new RBRegistryDynSyncer(this.m_rm, this, this.m_role);
        this.m_transactionDynSyncer = new TransactionDynSyncer(this, this.m_role);
        this.m_userIDDynSyncer = new UserIDMappingDynSyncer(this, this.m_role);
    }

    synchronized void startActiveSyncBrokerThreads() {
        if (this.m_role == 1) {
            this.startDynSyncThreads();
        }
    }

    void startDynSyncThreads() {
        if (this.m_inDynSync && !this.m_started) {
            this.m_started = true;
            this.m_dsmThread.start();
            this.m_userIDDynSyncer.start();
            this.m_qMsgDynSyncer.start();
            this.m_rbRegistryDynSyncer.start();
            if (this.m_role == 1) {
                this.m_dupDetectDynSyncer.start();
                this.m_durMsgDynSyncer.start();
                this.m_subscriptionDynSyncer.start();
            }
            this.m_transactionDynSyncer.start();
        }
    }

    private boolean isActiveRole() {
        return this.m_role == 1;
    }

    private boolean isStandbyRole() {
        return this.m_role == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean onSyncpointComplete() {
        boolean replicateEndSyncpointOp;
        block12: {
            replicateEndSyncpointOp = false;
            if (this.m_inDynSync) {
                replicateEndSyncpointOp = false;
                switch (this.m_role) {
                    case 1: {
                        Object object = this.m_syncObj;
                        synchronized (object) {
                            this.m_activeSyncpointComplete = true;
                            this.m_syncObj.notifyAll();
                            break block12;
                        }
                    }
                    case 2: {
                        Object object = this.m_syncObj;
                        synchronized (object) {
                            this.m_standbySyncpointComplete = true;
                            this.m_syncObj.notifyAll();
                            break block12;
                        }
                    }
                    case -1: {
                        throw new EAssertFailure("Unsupported role in DynamicSyncManager during a syncpoint m_role: " + this.m_role);
                    }
                    default: {
                        throw new EAssertFailure("Unsupported role in DynamicSyncManager m_role: " + this.m_role);
                    }
                }
            }
            replicateEndSyncpointOp = true;
        }
        return replicateEndSyncpointOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replicateAllInMemoryClientContexts() {
        DynamicSyncClientInfo dyncSyncClientInfo = this.m_rm.getAllInMemoryClientContexts();
        ArrayList clientDescs = DynamicSyncClientInfo.m_clients;
        ArrayList subscribes = DynamicSyncClientInfo.m_subscribes;
        DynamicSyncManager dynamicSyncManager = this;
        synchronized (dynamicSyncManager) {
            if (this.m_subscriptionDynSyncer != null) {
                this.m_subscriptionDynSyncer.addSubscriptions(subscribes);
            }
        }
        ClientContextDescriptor ccd = null;
        int currentChunkSize = 0;
        int size = clientDescs.size();
        ArrayList<ClientContextDescriptor> chunkedClients = new ArrayList<ClientContextDescriptor>(size);
        boolean lastClient = false;
        IMgram m = null;
        if (size == 0) {
            lastClient = true;
            m = FTMgramFactory.createUserIdMappingSyncOp(chunkedClients, lastClient);
            if (this.DEBUG) {
                this.debug("Sending EMPTY UserIdMappingSyncOp  with lastClient: " + lastClient);
            }
            this.m_rm.replicateDynamicSyncData(m, true);
        } else {
            for (int i = 0; i < size; ++i) {
                ccd = (ClientContextDescriptor)clientDescs.get(i);
                chunkedClients.add(ccd);
                boolean bl = lastClient = i == clientDescs.size() - 1;
                if ((currentChunkSize += ccd.length()) < this.m_rm.getReplicationChunkSize() && !lastClient) continue;
                m = FTMgramFactory.createUserIdMappingSyncOp(chunkedClients, lastClient);
                if (this.DEBUG) {
                    this.debug("Sending UserIdMappingSyncOp with chunkedClients.size(): " + chunkedClients.size() + " with lastClient: " + lastClient);
                }
                this.m_rm.replicateDynamicSyncData(m, true);
                chunkedClients = new ArrayList(chunkedClients.size());
                currentChunkSize = 0;
            }
        }
    }

    void replicateSubscriptions(ArrayList subscribes) {
        if (this.DEBUG) {
            this.debug("create SUBSCRIPTION_SYNC_OP mgrams in REPLICATION_CHUNK_SIZE ");
        }
        SubscribeEvt subEvt = null;
        int currentChunkSize = 0;
        int size = subscribes.size();
        ArrayList<SubscribeEvt> chunkedSubscribeEvts = new ArrayList<SubscribeEvt>(size);
        boolean lastSubscribeEvt = false;
        IMgram m = null;
        if (size == 0) {
            lastSubscribeEvt = true;
            m = FTMgramFactory.createSubscriptionSyncOp(chunkedSubscribeEvts, lastSubscribeEvt);
            if (this.DEBUG) {
                this.debug("Sending EMPTY SubcribeSyncOp  with lastSubscribeEvt: " + lastSubscribeEvt);
            }
            this.m_rm.replicateDynamicSyncData(m, true);
        } else {
            for (int i = 0; i < size; ++i) {
                subEvt = (SubscribeEvt)subscribes.get(i);
                currentChunkSize += subEvt.length();
                if (this.DEBUG) {
                    this.debug("currentChunkSize: " + currentChunkSize + " subEvt.length(): " + subEvt.length());
                }
                chunkedSubscribeEvts.add(subEvt);
                boolean bl = lastSubscribeEvt = i == subscribes.size() - 1;
                if (currentChunkSize < this.m_rm.getReplicationChunkSize() && !lastSubscribeEvt) continue;
                m = FTMgramFactory.createSubscriptionSyncOp(chunkedSubscribeEvts, lastSubscribeEvt);
                if (this.DEBUG) {
                    this.debug("Sending SubcribeSyncOp with chunkedSubscribeEvts.size(): " + chunkedSubscribeEvts.size() + " with lastSubscribeEvt: " + lastSubscribeEvt);
                }
                this.m_rm.replicateDynamicSyncData(m, true);
                chunkedSubscribeEvts = new ArrayList(chunkedSubscribeEvts.size());
                currentChunkSize = 0;
            }
        }
    }

    void replicateFileBasedTxns() throws InterruptedException {
        ArrayList fileBasedTxns = this.m_rm.snapshotFileBasedTxns();
        if (this.CALLBACK) {
            this.callback("Txn Snapshot taken", 1, new Integer(fileBasedTxns.size()));
        }
        Iterator it = fileBasedTxns.iterator();
        this.waitUntilPreTxnComponentsDone();
        while (it.hasNext()) {
            int tid = (Integer)it.next();
            this.m_rm.replicateFileBasedTxn(tid);
            if (!this.CALLBACK) continue;
            this.callback("Online Sync'd File Based Txn", 2, new Integer(tid));
        }
        IMgram txnDynSyncCompleteOp = FTMgramFactory.createTxnDynSyncCompleteOp();
        this.m_rm.replicateDynamicSyncData(txnDynSyncCompleteOp, true);
    }

    void replicateRoutes(Vector routes) {
        if (this.CALLBACK) {
            this.callback("Entered Replicate Routes", 6, null);
        }
        int currentChunkSize = 0;
        int size = routes.size();
        ArrayList<RouteInfo> chunkedRoutes = new ArrayList<RouteInfo>(size);
        boolean lastRoute = false;
        IMgram m = null;
        if (size == 0) {
            lastRoute = true;
            m = FTMgramFactory.createRouteInfosSyncOp(chunkedRoutes, lastRoute);
            if (this.DEBUG) {
                this.debug("Sending EMPTY RouteInfosSyncOp  with lastRoute: " + lastRoute);
            }
            this.m_rm.replicateDynamicSyncData(m, true);
            if (this.CALLBACK) {
                this.callback("Sent Empty Route Info Op", 5, null);
            }
        } else {
            RouteInfo ri = null;
            while (!routes.isEmpty()) {
                ri = (RouteInfo)routes.remove(0);
                chunkedRoutes.add(ri);
                lastRoute = routes.isEmpty();
                if ((currentChunkSize += ri.length()) < this.m_rm.getReplicationChunkSize() && !lastRoute) continue;
                m = FTMgramFactory.createRouteInfosSyncOp(chunkedRoutes, lastRoute);
                if (this.DEBUG) {
                    this.debug("Sending RouteInfosSyncOp with chunkedRoutes.size(): " + chunkedRoutes.size() + " with lastRoute: " + lastRoute);
                }
                this.m_rm.replicateDynamicSyncData(m, true);
                if (this.CALLBACK) {
                    this.callback("Sent Route Info Op", 4, null);
                }
                chunkedRoutes = new ArrayList(chunkedRoutes.size());
                currentChunkSize = 0;
            }
        }
        this.setStatus(64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replicateRBRegistry() {
        Object object = this.m_rm.getRBRegistrySyncObj();
        synchronized (object) {
            Enumeration remoteBrokers = this.m_rm.getRBRegistry();
            RemoteBroker rb = null;
            RemoteBrokerDescriptor rbd = null;
            ArrayList<RemoteBrokerDescriptor> rbds = new ArrayList<RemoteBrokerDescriptor>();
            while (remoteBrokers.hasMoreElements()) {
                rb = (RemoteBroker)remoteBrokers.nextElement();
                rbd = new RemoteBrokerDescriptor();
                rbd.setClientId(rb.getClientID());
                rbd.setUrl(rb.getConnectURL());
                rbd.setFtPeerUrl(rb.getStandbyConnectURL());
                rbd.setUser(rb.getUser());
                rbd.setPassword(rb.getPassword());
                rbd.setBroker(rb.getBrokerName());
                rbd.setNode(rb.getNodeName());
                if (this.DEBUG) {
                    this.debug("Created rbd for replication rbd : " + rbd);
                }
                rbds.add(rbd);
            }
            int currentChunkSize = 0;
            int size = rbds.size();
            ArrayList<RemoteBrokerDescriptor> chunkedRBs = new ArrayList<RemoteBrokerDescriptor>(size);
            boolean lastRB = false;
            IMgram m = null;
            if (size == 0) {
                lastRB = true;
                m = FTMgramFactory.createRBRegistrySyncOp(chunkedRBs, lastRB);
                if (this.DEBUG) {
                    this.debug("Sending EMPTY RBRegistrySyncOp  with lastRB: " + lastRB);
                }
                this.m_rm.replicateDynamicSyncData(m, true);
                if (this.CALLBACK) {
                    this.callback("Sent Empty RBRegistry Op", 9, null);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    rbd = (RemoteBrokerDescriptor)rbds.get(i);
                    chunkedRBs.add(rbd);
                    boolean bl = lastRB = i == rbds.size() - 1;
                    if ((currentChunkSize += rbd.length()) < this.m_rm.getReplicationChunkSize() && !lastRB) continue;
                    m = FTMgramFactory.createRBRegistrySyncOp(chunkedRBs, lastRB);
                    if (this.DEBUG) {
                        this.debug("Sending RBRegistrySyncOp with chunkedRBs.size(): " + chunkedRBs.size() + " with lastRB: " + lastRB);
                    }
                    this.m_rm.replicateDynamicSyncData(m, true);
                    if (this.CALLBACK) {
                        this.callback("SentRBRegistry Op", 8, null);
                    }
                    chunkedRBs = new ArrayList(chunkedRBs.size());
                    currentChunkSize = 0;
                }
            }
        }
    }

    public StandbyDBQMsgs getStandbyDBQMsgs() {
        return this.m_rm.getReplicationDemultiplexer().getStandbyDBQMsgs();
    }

    public void queueSnapshotComplete() {
        this.m_queueSnapshotComplete = true;
    }

    public void pubSubSnapshotComplete() {
        this.m_pubSubSnapshotComplete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean okToReplicate(IReplicateableSaverOp op) {
        switch (op.getType()) {
            case 0: 
            case 1: {
                DynamicSyncManager dynamicSyncManager = this;
                synchronized (dynamicSyncManager) {
                    if (this.m_inDynSync) {
                        if (!this.m_queueSnapshotComplete) {
                            return false;
                        }
                        return this.m_qMsgDynSyncer.getDynamicSyncDBQTracker().okToReplicate(op);
                    }
                    return true;
                }
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return !this.m_inDynSync || this.m_pubSubSnapshotComplete;
    }

    class DynamicSyncMgrThread
    extends DebugThread {
        DynamicSyncMgrThread() {
            super("DynamicSyncMgrThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            try {
                if (this.DEBUG) {
                    this.debug("starting DynamicSyncManager thread m_role = " + DynamicSyncManager.this.m_role);
                }
                if (DynamicSyncManager.this.isActiveRole()) {
                    AgentRegistrar.getAgentRegistrar().getRouterManager().getRouteForwarder().getRouteSaver().enqueueNoLimiterWait(new DynamicSyncRoutesReplicationOp(AgentRegistrar.getAgentRegistrar()));
                    DynamicSyncManager.this.waitUntilAllComponentsDone();
                    Object object = DynamicSyncManager.this.m_syncObj;
                    synchronized (object) {
                        while (!DynamicSyncManager.this.m_activeSyncpointComplete) {
                            if (this.DEBUG) {
                                this.debug("waiting for syncpoint to complete on the active DynamicSyncManager thread m_role = " + DynamicSyncManager.this.m_role);
                            }
                            DynamicSyncManager.this.m_syncObj.wait();
                        }
                    }
                    IMgram endSyncpoint = FTMgramFactory.createEndSyncpointOp();
                    DynamicSyncManager.this.m_rm.replicateMgram(endSyncpoint);
                    return;
                }
                if (DynamicSyncManager.this.isStandbyRole()) {
                    DynamicSyncManager.this.waitUntilAllComponentsDone();
                    Object endSyncpoint = DynamicSyncManager.this.m_syncObj;
                    synchronized (endSyncpoint) {
                        while (!DynamicSyncManager.this.m_standbySyncpointComplete) {
                            if (this.DEBUG) {
                                this.debug("waiting for syncpoint to complete on the standby DynamicSyncManager thread m_role = " + DynamicSyncManager.this.m_role);
                            }
                            DynamicSyncManager.this.m_syncObj.wait();
                        }
                    }
                    DynamicSyncManager.this.m_rm.onStandbyDynamicSyncDone();
                    return;
                }
                if (this.DEBUG) {
                    this.debug("DynamicSyncThread started but not in active or standby role..exiting DynamicSyncManager thread m_role = " + DynamicSyncManager.this.m_role);
                }
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    public static class DynamicSyncClientInfo {
        public static ArrayList m_clients;
        public static ArrayList m_subscribes;
    }
}

