/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.broker.GuarAckDoneEvt;
import progress.message.broker.GuarAckXchgEvt;
import progress.message.broker.GuarQAckDoneEvt;
import progress.message.broker.GuarQAckXchgEvt;
import progress.message.broker.IAckTracker;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IMinEnqueuePriorityListener;
import progress.message.broker.INeighbor;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.InDoubtQMsgReenqueueEvt;
import progress.message.broker.PeerInfoHolder;
import progress.message.broker.PublishLimiterNotify;
import progress.message.client.EBrokerVersionMismatchNoSSL;
import progress.message.client.EConnectFailure;
import progress.message.client.EGeneralException;
import progress.message.client.EUserAlreadyConnected;
import progress.message.gr.RemoteBrokerHelper;
import progress.message.interbroker.CollectiveConnect;
import progress.message.interbroker.CollectiveGroup;
import progress.message.interbroker.GuarAckExchanger;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.prAccessor;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.util.ISizedEnumeration;
import progress.message.util.IndexedList;
import progress.message.util.ListNode;
import progress.message.util.LongHashTable;
import progress.message.util.VersionData;
import progress.message.zclient.BrokerURL;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Label;
import progress.message.zclient.SessionConfig;

final class Neighbor
extends DebugObject
implements INeighbor,
IRemoteBroker,
Runnable {
    static final int DISCONNECTED = 0;
    static final int PASSIVE_CONNECT = 1;
    static final int PASSIVE_CONVERT = 2;
    static final int CONVERT_IN_PROGRESS = 3;
    static final int ACTIVE_CONNECT = 4;
    static final int ACTIVE = 5;
    static final int ACTIVE_SECONDARY = 6;
    public static final String s_IB_NUM_ACCEPTORS = "IB_NUM_ACCEPTORS";
    public static final String s_IB_PEER_ACCEPTOR_NAME = "IB_PEER_ACCEPTOR_NAME";
    public static final String s_IB_PEER_INTERBROKER_ACCEPTOR_URL = "IB_PEER_INTERBROKER_ACCEPTOR_URL";
    public static final String s_IB_PEER_PRIMARY_ACCEPTOR_URL = "IB_PEER_PRIMARY_ACCEPTOR_URL";
    private static final int RETRY_DELAY = Config.CLUSTER_RECONNECT_INTERVAL;
    private static final int CONVERT_REQ_TIMEOUT = 30;
    private static final long KNUTH = 2654435761L;
    private static long s_token;
    private static Random s_random;
    private static Interbroker s_ib;
    private String m_name;
    private String m_connectUrl = null;
    private boolean m_passivelyConnected = false;
    boolean m_usingPrimaryBroker = true;
    boolean m_usingPrimaryAcceptor = false;
    boolean m_channelSwitchInitiated = false;
    boolean m_activeConnectFailure = false;
    private PeerAcceptor m_primaryPeerAcceptor;
    private PeerAcceptor m_backupPeerAcceptor;
    private long m_id;
    private long m_connectId;
    private CollectiveGroup m_group;
    private Thread m_connectThread;
    private long m_convertToken;
    private GuarAckExchanger m_guarAckXchanger;
    private long m_inDoubtTime;
    private boolean m_invalid;
    private int m_state;
    private final boolean m_delayCollisionConnect;
    private final LongHashTable m_rcvdXOnceTrackNums = new LongHashTable();
    private final LongHashTable m_redirectXOnceTrackNums = new LongHashTable();
    private final LongHashTable m_guarAcks = new LongHashTable();
    private AgentRegistrar m_reg = null;
    private static Label s_label;
    private LongHashTable m_guarQAcks = new LongHashTable();
    private LongHashTable m_rcvdXOnceQTrackNums = new LongHashTable();
    private IndexedList m_inDoubtQTrackNums = new IndexedList();
    private Object m_tableSyncObj = new Object();
    private static final String cDebug;
    private Object m_dynamicHostBindingSync = new Object();
    private boolean m_isNeighborAddressUnknown = Config.USE_DYNAMIC_HOST_BINDING;
    private static final int EARLIEST_CONNECTION_COUNT_LOAD_BALANCING_MAJOR_VERS = 10;
    private static final int CONNECTION_COUNT_NORMAL = 0;
    private static final int CONNECTION_COUNT_INDOUBT = 1;
    private static final int CONNECTION_COUNT_SUSPENDED = 2;
    private final ConnectionCounter m_connectionCounter;
    private int m_sessionCount = -1;
    private int m_durableSubscribersCount = -1;
    private int m_nonDurableSubscribersCount = -1;
    private int m_queueReceiversCount = -1;
    private int m_queueBrowsersCount = -1;

    Neighbor(String name, FTPairPeerInfoHolder info) {
        this.debugName("Neighbor " + name);
        if (cDebug != null) {
            if (cDebug.toUpperCase().indexOf(name.toUpperCase()) >= 0) {
                this.debug(true);
                this.debugFlags |= 0x3FF;
            } else {
                System.out.println("No connect debug specified for " + name);
            }
        }
        this.m_name = name;
        this.m_id = AddrUtil.stringToClientId(name, "Broker");
        this.m_connectId = AddrUtil.stringToClientId(name, "Broker connect");
        this.m_reg = AgentRegistrar.getAgentRegistrar();
        this.m_inDoubtTime = 0L;
        this.setPeerInfo(info);
        this.m_usingPrimaryBroker = true;
        this.m_usingPrimaryAcceptor = true;
        this.m_connectUrl = this.m_primaryPeerAcceptor.getPrimaryHostPort();
        this.m_delayCollisionConnect = Config.BROKER_NAME.compareTo(this.m_name) > 0;
        this.m_connectionCounter = new ConnectionCounter();
    }

    private final PeerAcceptor getActivePeerAcceptor() {
        if (this.m_usingPrimaryBroker) {
            return this.m_primaryPeerAcceptor;
        }
        return this.m_backupPeerAcceptor;
    }

    final void setPassiveConnectInfo(boolean primaryBroker, boolean primaryAcceptor) {
        this.m_usingPrimaryBroker = primaryBroker;
        this.m_usingPrimaryAcceptor = primaryAcceptor;
    }

    public final void setPeerInfo(FTPairPeerInfoHolder info) {
        this.setPeerInfo(info, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPeerInfo(FTPairPeerInfoHolder info, boolean refreshAcceptors) {
        ArrayList pUrls = info.getPrimaryIBConnectUrls();
        ArrayList bUrls = info.getBackupIBConnectUrls();
        ArrayList IBAcceptors = new ArrayList();
        if (pUrls != null && !pUrls.isEmpty()) {
            IBAcceptors.addAll(pUrls);
            if (this.DEBUG) {
                this.debug("Got peer info primary acceptor: " + info.getPrimaryIBConnectUrls());
            }
            if (refreshAcceptors || this.m_primaryPeerAcceptor == null) {
                this.m_primaryPeerAcceptor = new PeerAcceptor(this.m_name, info, true);
            } else {
                this.m_primaryPeerAcceptor.setHostPort(info);
            }
        } else {
            this.m_primaryPeerAcceptor = null;
        }
        if (bUrls != null && !bUrls.isEmpty()) {
            IBAcceptors.addAll(bUrls);
            if (this.DEBUG) {
                this.debug("Got peer info backup acceptor: " + info.getBackupIBConnectUrls());
            }
            if (refreshAcceptors || this.m_backupPeerAcceptor == null) {
                this.m_backupPeerAcceptor = new PeerAcceptor(this.m_name, info, false);
            } else {
                this.m_backupPeerAcceptor.setHostPort(info);
            }
        } else {
            this.m_backupPeerAcceptor = null;
        }
        if (Config.USE_DYNAMIC_HOST_BINDING && this.m_isNeighborAddressUnknown && !IBAcceptors.isEmpty()) {
            Iterator acceptors = IBAcceptors.iterator();
            while (acceptors.hasNext()) {
                String host = null;
                try {
                    BrokerURL brokerURL = new BrokerURL((String)acceptors.next());
                    host = brokerURL.getBrokerHostName();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (host == null || host.trim().length() <= 0) continue;
                this.m_isNeighborAddressUnknown = false;
                break;
            }
            if (!this.m_isNeighborAddressUnknown) {
                Object object = this.m_dynamicHostBindingSync;
                synchronized (object) {
                    this.m_dynamicHostBindingSync.notifyAll();
                }
            }
        }
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public final String getHostPort() {
        return this.m_connectUrl;
    }

    @Override
    public final String getDefaultHostPort() {
        return this.getActivePeerAcceptor().getDefaultHostPort();
    }

    @Override
    public final String getAcceptorURLs(String acceptorName) {
        return this.getActivePeerAcceptor().getHostPorts(acceptorName);
    }

    @Override
    public final int getWeight() {
        return this.getActivePeerAcceptor().getWeight();
    }

    final long getID() {
        return this.m_id;
    }

    final long getConnectID() {
        return this.m_connectId;
    }

    @Override
    public final String getCollectiveName() {
        return this.getGroup().getName();
    }

    final CollectiveGroup getGroup() {
        return this.m_group;
    }

    final synchronized boolean isActive() {
        return this.isConnected();
    }

    final void setGroup(CollectiveGroup g) {
        this.m_group = g;
    }

    final synchronized long getToken() {
        return this.m_convertToken;
    }

    final synchronized void setToken(long token) {
        this.m_convertToken = token;
    }

    final synchronized void passiveConnect(AgentConnection conn) throws EConnectFailure {
        if (this.m_state != 0 || this.m_invalid) {
            if (this.DEBUG) {
                this.debug("rejected passive connect, state is " + this.m_state);
            }
            if (this.m_invalid) {
                throw new EConnectFailure(179, SessionConfig.IB_CONNECT_REFUSED);
            }
            if (this.m_state == 6) {
                String primaryUrl = (String)InterbrokerConfig.INTERBROKER_IB_CONNECT_INFO.getPrimaryIBConnectUrls().get(0);
                if (conn.getAcceptorUrl().equalsIgnoreCase(primaryUrl)) {
                    this.m_channelSwitchInitiated = true;
                }
            }
            throw new EUserAlreadyConnected(this.toString());
        }
        byte negotiatedSessionVer = conn.getAgentListener().getClientSessionVer();
        if (this.DEBUG) {
            this.debug("Validating Neighbor SessionVer (passive side) " + negotiatedSessionVer);
        }
        this.validateSessionVer(negotiatedSessionVer);
        if (this.DEBUG) {
            this.debug("Validated Neighbor SessionVer (passive side) " + negotiatedSessionVer);
        }
        this.m_state = 1;
        this.m_usingPrimaryAcceptor = true;
        this.m_usingPrimaryBroker = true;
        this.m_connectUrl = conn.getAcceptorUrl();
        this.m_passivelyConnected = true;
        if (this.DEBUG) {
            this.debug("state changed to PASSIVE_CONNECT by thread " + Thread.currentThread());
        }
        this.stopConnectThread();
    }

    final synchronized long passiveConvert() {
        if (this.m_invalid || this.m_state != 1 && this.m_state != 2) {
            if (this.DEBUG) {
                this.debug("attempted passive convert rejected, thread " + Thread.currentThread());
            }
            return 0L;
        }
        long token = 0L;
        while ((token = Neighbor.generateToken()) == 0L) {
        }
        this.m_convertToken = token;
        try {
            this.m_guarAckXchanger = new GuarAckExchanger(s_ib.getIBSession(), s_ib.getAgentRegistrar().getId(), this.m_id, token, false);
        }
        catch (EGeneralException e) {
            if (this.DEBUG) {
                this.debug("passive convert rejected: could not set up GuarAckExchanger: " + e);
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            return 0L;
        }
        this.m_state = 2;
        if (this.DEBUG) {
            this.debug("state changed to PASSIVE_CONVERT by thread " + Thread.currentThread());
        }
        return token;
    }

    final synchronized boolean okToConvert(long token) {
        if (!this.m_invalid && this.m_state == 2 && token == this.m_convertToken) {
            if (this.DEBUG) {
                this.debug("state changed to CONVERT_IN_PROGRESS by thread " + Thread.currentThread());
            }
            this.m_state = 3;
            try {
                this.m_guarAckXchanger.doExchange();
            }
            catch (EGeneralException e) {
                if (this.DEBUG) {
                    this.debug("okToConvert() returning false due to exception in guar ack exchange, thread " + Thread.currentThread());
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                return false;
            }
            return true;
        }
        if (this.DEBUG) {
            this.debug("okToConvert() returned false for thread " + Thread.currentThread() + ", state is " + this.m_state);
        }
        return false;
    }

    final synchronized void activate() {
        VersionData remoteV;
        AgentConnection ac;
        if (this.DEBUG) {
            this.debug("state changed to ACTIVE by thread " + Thread.currentThread());
        }
        if (this.m_state != 3 && this.m_state != 4) {
            throw new EAssertFailure(prAccessor.getString("STR054") + this + ", " + this.m_state);
        }
        this.m_state = !this.m_usingPrimaryAcceptor ? 6 : 5;
        this.notifyAll();
        String bname = this.m_name;
        VersionData thisV = SessionConfig.getCurrentVersionData();
        IClientContext cc = this.getClient();
        if (cc != null && (ac = cc.getConnection()) != null && !thisV.equals(remoteV = ac.getPartnerProductVersion())) {
            String vers = " (" + VersionData.getReleaseAndBuildString(remoteV, "Release Unknown") + ")";
            bname = bname + vers;
        }
        if (this.m_group != null) {
            String clusterName = this.m_group.getName();
            Object[] obj = new Object[]{bname, this.m_connectUrl, clusterName, this.m_usingPrimaryAcceptor ? "" : prAccessor.getString("SECONDARY_NETWORK_PATH")};
            if (this.m_passivelyConnected) {
                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("STR055B"), obj), 3);
            } else {
                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("STR055A"), obj), 3);
            }
        } else {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR055") + this.m_name, 3);
        }
    }

    final synchronized void invalidate() {
        if (this.DEBUG) {
            this.debug("invalidating, state is " + this.m_state);
        }
        boolean interrupted = false;
        while (!this.isConnected() && this.m_state != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.resolveInDoubtGroupSends();
        this.m_invalid = true;
        this.stopConnectThread();
        if (this.DEBUG) {
            this.debug("invalidated");
        }
    }

    final synchronized boolean isInvalid() {
        return this.m_invalid;
    }

    final synchronized void disconnect() {
        String clusterName;
        if (this.m_state == 3) {
            return;
        }
        if (this.m_state == 2) {
            this.m_guarAckXchanger.abort();
        }
        if (this.DEBUG) {
            this.debug("state changed to DISCONNECTED by thread " + Thread.currentThread());
        }
        if (this.m_state == 4 && !this.m_activeConnectFailure) {
            throw new EAssertFailure(prAccessor.getString("STR056") + this);
        }
        this.m_activeConnectFailure = false;
        this.m_state = 0;
        this.m_connectionCounter.updateNeighborConnectionInfo(0, false, false);
        this.notifyAll();
        if (!this.m_channelSwitchInitiated) {
            if (this.m_group != null) {
                clusterName = this.m_group.getName();
                Object[] obj = new Object[]{this.m_name, this.m_connectUrl, clusterName, this.m_usingPrimaryAcceptor ? "" : prAccessor.getString("SECONDARY_NETWORK_PATH")};
                if (!this.m_passivelyConnected) {
                    BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("STR057A"), obj), 2);
                } else {
                    BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("STR057B"), obj), 2);
                }
            } else {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR057") + this, 2);
            }
        } else {
            this.m_channelSwitchInitiated = false;
            if (this.m_group != null) {
                clusterName = this.m_group.getName();
                Object[] obj = new Object[]{this.m_name, clusterName};
                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("NEIGHBOR_CHANNEL_SWITCH"), obj), 3);
            } else {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR057") + this.m_name, 2);
            }
        }
        RemoteBrokerHelper rbh = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper();
        rbh.wakeUpConnectThread();
        AgentRegistrar.getAgentRegistrar().getDurableManager().cancelJobs(this);
        if (this.CALLBACK) {
            this.callback("NeighborClientContext", 100002, new Object[0]);
        }
        if (!this.m_invalid) {
            this.startConnectThread();
        }
    }

    final synchronized void abortConvert() {
        if (this.DEBUG) {
            this.debug("state changed to DISCONNECTED (abortConvert) by thread " + Thread.currentThread());
        }
        if (this.m_state != 3) {
            throw new EAssertFailure(this + prAccessor.getString("STR058") + this.m_state);
        }
        this.m_state = 0;
        this.notifyAll();
        this.startConnectThread();
    }

    final void startConnectThread() {
        if (!Broker.isInShutdown()) {
            this.m_connectThread = new Thread((Runnable)this, "IB Connect Thread for " + this.m_name);
            this.m_connectThread.start();
        }
    }

    final void stopConnectThread() {
        Thread connectThread = this.m_connectThread;
        this.m_connectThread = null;
        if (connectThread != null && Broker.exiting && connectThread.isAlive()) {
            connectThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void xOnceMsgReceived(long tracking, IAckTracker tracker) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            if (tracker.getRedirectAckClient() != -1L) {
                LongHashTable<IAckTracker> redirectTrackers = (LongHashTable<IAckTracker>)this.m_redirectXOnceTrackNums.get(tracking);
                if (redirectTrackers == null) {
                    redirectTrackers = new LongHashTable<IAckTracker>();
                    this.m_redirectXOnceTrackNums.put(tracking, redirectTrackers);
                }
                redirectTrackers.put(tracker.getRedirectAckClient(), tracker);
                if (this.CALLBACK) {
                    IClientContext cc = this.retrieveClientContext();
                    if (cc == null) {
                        throw new NullPointerException("'cc' is null at " + Neighbor.class.getName() + ".xOnceMsgReceived(long tracking, IAckTracker tracker)");
                    }
                    this.callback("Neighbor", 100000, new Object[]{cc.getConnection(), tracker.getEvent() == null ? null : tracker.getEvent().getMessage()});
                }
            } else {
                this.m_rcvdXOnceTrackNums.put(tracking, tracker);
                if (this.CALLBACK) {
                    IClientContext cc = this.retrieveClientContext();
                    if (cc == null) {
                        throw new NullPointerException("'cc' is null at " + Neighbor.class.getName() + ".xOnceMsgReceived(long tracking, IAckTracker tracker)");
                    }
                    this.callback("Neighbor", 100001, new Object[]{cc.getConnection(), tracker.getEvent() == null ? null : tracker.getEvent().getMessage()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addGuarAck(long ackTracking, long msgTracking) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_guarAcks.put(ackTracking, new Long(msgTracking));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean handleAckAck(IMgram ack) {
        IAckTracker tracker = null;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Long msgTracking = (Long)this.m_guarAcks.remove(ack.getAckHandle().getTrackingNumber());
            if (msgTracking == null) return false;
            if (ack.getAckHandle().getClientID() != -1L && ack.getAckHandle().getClientID() != this.m_id) {
                LongHashTable redirectTrackers = (LongHashTable)this.m_redirectXOnceTrackNums.get(msgTracking);
                if (redirectTrackers == null) return true;
                tracker = (IAckTracker)redirectTrackers.remove(ack.getAckHandle().getClientID());
                if (redirectTrackers.isEmpty()) {
                    this.m_redirectXOnceTrackNums.remove(msgTracking);
                }
            } else {
                tracker = (IAckTracker)this.m_rcvdXOnceTrackNums.remove(msgTracking);
            }
        }
        if (tracker == null) return true;
        if (!tracker.guarAckDone()) return true;
        GuarAckDoneEvt evt = new GuarAckDoneEvt(tracker.getTracking());
        evt.setReplicateOnly(tracker.isReplicateOnly());
        this.m_reg.getLogManager().addEvent(evt, true);
        return true;
    }

    @Override
    public final int getInDoubtQMsgsCount() {
        return this.m_inDoubtQTrackNums.count();
    }

    @Override
    public final int getPendingQMsgsCount() {
        IClientContext cc = this.getClient();
        if (cc != null) {
            return cc.getPendingQCount();
        }
        return 0;
    }

    @Override
    public final IRemoteBroker getAsRemoteBroker() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Vector getXOnceMsgTrackNums() {
        Vector<Long> expandedList = new Vector<Long>();
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Enumeration<Long> baseTrackingNums = this.m_rcvdXOnceTrackNums.keys();
            while (baseTrackingNums.hasMoreElements()) {
                Long baseNum = baseTrackingNums.nextElement();
                AgentGuarMsgTracker tracker = (AgentGuarMsgTracker)this.m_rcvdXOnceTrackNums.get(baseNum);
                expandedList.addElement(baseNum);
                if (!tracker.isBatchMessage()) continue;
                int batchSize = tracker.getBatchSize();
                long base = baseNum;
                for (int i = 1; i <= batchSize; ++i) {
                    expandedList.addElement(new Long(base + (long)i));
                }
            }
        }
        return expandedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LongHashTable getXOnceRedirectTrkNums() {
        LongHashTable<LongHashTable> redirectXOnceTrackNumsDeepClone = null;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            redirectXOnceTrackNumsDeepClone = new LongHashTable<LongHashTable>();
            Enumeration<Long> redirectXOnceTrackNumsKeys = this.m_redirectXOnceTrackNums.keys();
            while (redirectXOnceTrackNumsKeys.hasMoreElements()) {
                LongHashTable redirectTrackersClone = null;
                Long redirectXOnceTrackNumsKey = redirectXOnceTrackNumsKeys.nextElement();
                LongHashTable redirectTrackers = (LongHashTable)this.m_redirectXOnceTrackNums.get(redirectXOnceTrackNumsKey);
                if (redirectTrackers != null) {
                    redirectTrackersClone = (LongHashTable)redirectTrackers.clone();
                }
                redirectXOnceTrackNumsDeepClone.put(redirectXOnceTrackNumsKey, redirectTrackersClone);
            }
        }
        LongHashTable expandedTable = new LongHashTable();
        Enumeration<Long> baseTrackingNums = redirectXOnceTrackNumsDeepClone.keys();
        while (baseTrackingNums.hasMoreElements()) {
            AgentGuarMsgTracker tracker;
            Long baseNum = baseTrackingNums.nextElement();
            long baseTracking = baseNum;
            Object trackerTable = redirectXOnceTrackNumsDeepClone.get(baseTracking);
            expandedTable.put(baseTracking, trackerTable);
            boolean isBatchTracker = false;
            int batchSize = 0;
            Enumeration clientTrackers = ((LongHashTable)trackerTable).elements();
            if (clientTrackers.hasMoreElements() && (isBatchTracker = (tracker = (AgentGuarMsgTracker)clientTrackers.nextElement()).isBatchMessage())) {
                batchSize = tracker.getBatchSize();
            }
            if (!isBatchTracker) continue;
            for (int i = 1; i <= batchSize; ++i) {
                expandedTable.put(baseTracking + (long)i, trackerTable);
            }
        }
        return expandedTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void allXOnceAcksDone() {
        this.resolveInDoubtGroupSends();
        GuarAckXchgEvt replOnlyEvt = new GuarAckXchgEvt();
        GuarAckXchgEvt evt = new GuarAckXchgEvt();
        int replOnlyCt = 0;
        int ct = 0;
        LongHashTable rcvdXOnceTrackNumsClone = null;
        LongHashTable redirectXOnceTrackNumsClone = null;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            rcvdXOnceTrackNumsClone = (LongHashTable)this.m_rcvdXOnceTrackNums.clone();
            redirectXOnceTrackNumsClone = (LongHashTable)this.m_redirectXOnceTrackNums.clone();
            this.m_rcvdXOnceTrackNums.clear();
            this.m_redirectXOnceTrackNums.clear();
            this.m_guarAcks.clear();
        }
        Enumeration enu = rcvdXOnceTrackNumsClone.elements();
        while (enu.hasMoreElements()) {
            IAckTracker tracker = (IAckTracker)enu.nextElement();
            long ourTracking = tracker.getTracking();
            tracker.guarAckDone();
            if (tracker.isReplicateOnly()) {
                ++replOnlyCt;
                replOnlyEvt.addTracking(ourTracking);
                continue;
            }
            ++ct;
            evt.addTracking(ourTracking);
        }
        Enumeration redirects = redirectXOnceTrackNumsClone.elements();
        while (redirects.hasMoreElements()) {
            Enumeration trackers = ((LongHashTable)redirects.nextElement()).elements();
            while (trackers.hasMoreElements()) {
                IAckTracker tracker = (IAckTracker)trackers.nextElement();
                tracker.guarAckDone();
                if (tracker.isReplicateOnly()) {
                    ++replOnlyCt;
                    replOnlyEvt.addTracking(tracker.getTracking());
                    continue;
                }
                ++ct;
                evt.addTracking(tracker.getTracking());
            }
        }
        if (replOnlyCt > 0) {
            replOnlyEvt.setReplicateOnly(true);
            this.m_reg.getLogManager().addEvent(replOnlyEvt, false);
        }
        if (ct > 0) {
            evt.setReplicateOnly(false);
            this.m_reg.getLogManager().addEvent(evt, false);
        }
    }

    private void resolveInDoubtGroupSends() {
        IClientContext cc = this.getClient();
        if (cc != null) {
            cc.onInDoubtXOGroupSendsResolved();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        DebugObject con;
        while (this.m_isNeighborAddressUnknown) {
            Object object = this.m_dynamicHostBindingSync;
            synchronized (object) {
                try {
                    this.m_dynamicHostBindingSync.wait(RETRY_DELAY * 1000);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
        int connectAttempts = 0;
        if ((this.debugFlags & 0x20) > 0) {
            this.debug("Connect Thread starting: " + this.m_name);
        }
        this.m_usingPrimaryAcceptor = true;
        while (true) {
            int delay;
            block65: {
                PeerAcceptor acceptor = null;
                Neighbor neighbor = this;
                synchronized (neighbor) {
                    if (this.m_state != 0 || this.m_connectThread != Thread.currentThread() || Broker.isInShutdown()) {
                        return;
                    }
                    this.m_state = 4;
                    acceptor = this.m_usingPrimaryBroker ? this.m_primaryPeerAcceptor : this.m_backupPeerAcceptor;
                    this.m_connectUrl = this.m_usingPrimaryAcceptor ? acceptor.getPrimaryHostPort() : acceptor.getSecondaryHostPort();
                    this.m_passivelyConnected = false;
                    if (this.DEBUG) {
                        this.debug("state changed to ACTIVE_CONNECT by thread " + Thread.currentThread());
                    }
                }
                delay = RETRY_DELAY * 1000;
                con = null;
                try {
                    con = new CollectiveConnect(this);
                    ++connectAttempts;
                    if ((this.debugFlags & 0x20) > 0) {
                        this.debug("Connecting to (" + (this.m_usingPrimaryBroker ? "primary" : "backup") + ") " + this.m_name + " " + this.m_connectUrl + (this.m_usingPrimaryAcceptor ? "" : "(SECONDARY URL)") + " ct= " + connectAttempts);
                    }
                    if (((CollectiveConnect)con).convertToCollective(this.m_connectUrl, 30, this.m_usingPrimaryAcceptor)) {
                        if ((this.debugFlags & 0x20) > 0) {
                            this.debug("Connected to (" + (this.m_usingPrimaryBroker ? "primary" : "backup") + ") " + this.m_name + " " + this.m_connectUrl + (this.m_usingPrimaryAcceptor ? "" : "(SECONDARY URL)") + " ct= " + connectAttempts);
                        }
                        if (this.m_state == 6) {
                            Thread.currentThread().setName("IB Primary Acceptor Connect Thread for " + this.m_name);
                            break;
                        }
                        return;
                    }
                }
                catch (EUserAlreadyConnected e) {
                    if (!this.m_delayCollisionConnect) {
                        delay = 100;
                    }
                    if (this.DEBUG) {
                        this.debug("connect collision: " + delay, e);
                    }
                }
                catch (EGeneralException ege) {
                    if (this.m_usingPrimaryAcceptor && acceptor.getSecondaryHostPort() != null) {
                        if (this.DEBUG) {
                            this.debug("Primary acceptor connect failed, attempting secondary connect: primary broker: " + this.m_usingPrimaryBroker + ", Primary Acceptor: " + this.m_usingPrimaryAcceptor, ege);
                        }
                        this.m_usingPrimaryAcceptor = false;
                        delay = 0;
                    } else if (this.m_usingPrimaryBroker && this.m_backupPeerAcceptor != null && this.m_backupPeerAcceptor.getPrimaryHostPort() != null) {
                        if (this.DEBUG) {
                            this.debug("Primary neighbor connect failed, attempting backup connect: primary broker: " + this.m_usingPrimaryBroker + ", Primary Acceptor: " + this.m_usingPrimaryAcceptor, ege);
                        }
                        this.m_usingPrimaryAcceptor = true;
                        this.m_usingPrimaryBroker = false;
                        delay = 0;
                    } else {
                        if (this.DEBUG) {
                            this.debug("Neighbor connect failed, attempting primary reconnect: primary broker: " + this.m_usingPrimaryBroker + ", Primary Acceptor: " + this.m_usingPrimaryAcceptor, ege);
                        }
                        this.m_usingPrimaryBroker = true;
                        this.m_usingPrimaryAcceptor = true;
                    }
                    if (!this.DEBUG) break block65;
                    this.debug("failed to connect: " + ege);
                }
            }
            boolean disconnect = false;
            Neighbor neighbor = this;
            synchronized (neighbor) {
                if (con == null) {
                    throw new NullPointerException("'con' is null at " + Neighbor.class.getName() + ".run()");
                }
                if (((CollectiveConnect)con).getActivated() && this.isConnected()) {
                    if (this.DEBUG) {
                        this.debug("Connect failed after Neighbor activation in state " + this.m_state + " initiating disconnect.");
                    }
                    disconnect = true;
                    this.m_activeConnectFailure = true;
                } else {
                    if (this.m_state != 4) {
                        throw new EAssertFailure(prAccessor.getString("STR059") + this + ", " + this.m_state);
                    }
                    this.m_state = 0;
                    this.notifyAll();
                    if (this.DEBUG) {
                        this.debug("state changed back to DISCONNECTED by thread " + Thread.currentThread());
                    }
                }
            }
            if (disconnect) {
                this.m_reg.disconnect(this.m_id, false);
            }
            try {
                if ((this.debugFlags & 0x20) > 0) {
                    this.debug("Sleeping for " + delay);
                }
                if (delay <= 0) continue;
                Thread.sleep(delay);
            }
            catch (InterruptedException e2) {
                return;
            }
        }
        int delay = RETRY_DELAY * 1000;
        String primaryUrl = this.m_usingPrimaryBroker ? this.m_primaryPeerAcceptor.getPrimaryHostPort() : this.m_backupPeerAcceptor.getPrimaryHostPort();
        while (true) {
            con = this;
            synchronized (con) {
                if (this.m_state != 6 || this.m_connectThread != Thread.currentThread() || Broker.isInShutdown()) {
                    if (this.DEBUG) {
                        this.debug(this + "Aborting secondary connect: " + this.m_state + " - " + (this.m_connectThread != Thread.currentThread()));
                    }
                    return;
                }
            }
            con = null;
            try {
                con = new CollectiveConnect(this);
                ((Connection)con).connect(primaryUrl);
                try {
                    ((Connection)con).disconnect(false);
                }
                catch (Throwable thrown) {
                    if (this.DEBUG) {
                        this.debug("Error closing successful primary reconnect connection" + thrown.getMessage(), thrown);
                    }
                    Neighbor.connectionCleanup((CollectiveConnect)con);
                }
                finally {
                    this.stopConnectThread();
                    this.startConnectThread();
                }
                return;
            }
            catch (EUserAlreadyConnected e) {
                AgentConnection ac;
                if (this.DEBUG) {
                    this.debug(this + "Primary acceptor connection succeeded, killing secondary connection", e);
                }
                Neighbor e2 = this;
                synchronized (e2) {
                    this.m_channelSwitchInitiated = true;
                }
                IClientContext cc = this.getClient();
                if (cc != null && (ac = cc.getConnection()) != null) {
                    ac.close();
                }
                Neighbor.connectionCleanup((CollectiveConnect)con);
                return;
            }
            catch (EGeneralException ege) {
                if (this.DEBUG) {
                    this.debug("Unabled to reconnect to primary neighbor acceptor will try again in " + delay + "ms", ege);
                }
                Neighbor.connectionCleanup((CollectiveConnect)con);
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    private static void connectionCleanup(CollectiveConnect con) {
        if (con != null) {
            con.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long generateToken() {
        Random random = s_random;
        synchronized (random) {
            while ((s_token *= 2654435761L) == 0L) {
            }
            return s_token;
        }
    }

    @Override
    public final String toString() {
        return this.m_name + "@" + this.getHostPort() + (this.m_usingPrimaryAcceptor ? "" : " (secondary network path)");
    }

    @Override
    public final boolean isNeighbor() {
        return true;
    }

    @Override
    public final boolean isHttp() {
        return false;
    }

    @Override
    public final void sendThrough(IMgram m) {
        IClientContext cc = this.retrieveClientContext();
        if (cc == null) {
            throw new NullPointerException("'cc' is null at " + Neighbor.class.getName() + ".sendThrough( IMgram m )");
        }
        cc.sendThrough(m);
    }

    private IClientContext retrieveClientContext() {
        IClientContext cc = null;
        try {
            cc = this.m_reg.getClient(this.m_id);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        return cc;
    }

    @Override
    public final boolean send(IMgram m) throws InterruptedException {
        IClientContext ncc = this.getClient();
        boolean successfulDelivery = false;
        int status = ncc != null ? ncc.xOnceQSend(m, s_label, false) : 1;
        switch (status) {
            case 0: 
            case 2: {
                successfulDelivery = true;
                break;
            }
        }
        if (m.isJMSPersistent()) {
            switch (status) {
                case 0: 
                case 2: {
                    break;
                }
                default: {
                    String queueName = m.getBrokerHandle().getLocalQueueName();
                    if (queueName.equals("SonicMQ.routingQueue")) {
                        if (this.DEBUG) {
                            this.debug(this + ": Rerouting: " + m + " to routing queue.");
                        }
                        RemoteBrokerHelper rbh = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper();
                        rbh.rerouteUnacknowledged(m);
                        break;
                    }
                    IAgentQueue iaq = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(queueName);
                    if (iaq != null) {
                        IndexedList<IMgram> mgrams = new IndexedList<IMgram>();
                        mgrams.appendNoDup(0, m);
                        iaq.restore(mgrams, true, false);
                        if (!this.DEBUG) break;
                        this.debug("renqueued mgram: " + m + " to queueName = " + queueName);
                        break;
                    }
                    this.debugNotRestoreMgrams(queueName);
                }
            }
        }
        return successfulDelivery;
    }

    public final String getUserID() {
        return "";
    }

    @Override
    public final long getClientID() {
        return this.m_id;
    }

    @Override
    public final IClientContext getClient() {
        try {
            return this.m_reg.getClient(this.m_id);
        }
        catch (EClientNotRegistered ecnr) {
            return null;
        }
    }

    @Override
    public final String getNodeName() {
        return Config.ROUTING_NODE_NAME;
    }

    @Override
    public final String getPendingQueueName() {
        return Config.ROUTING_NODE_NAME + "$" + this.m_name;
    }

    @Override
    public final String getBrokerName() {
        return this.m_name;
    }

    @Override
    public final String getConnectURL() {
        throw new EAssertFailure("");
    }

    @Override
    public final boolean isConnected() {
        return this.m_state == 5 || this.m_state == 6;
    }

    @Override
    public final boolean isConnecting() {
        return !this.isConnected() && this.m_state != 0;
    }

    @Override
    public final boolean isOkToDispatch(IMinEnqueuePriorityListener iMinEnqPrioListener) {
        if (!this.isConnected()) {
            return false;
        }
        IClientContext cc = this.getClient();
        if (cc == null) {
            return false;
        }
        return cc.okToDispatch(iMinEnqPrioListener);
    }

    @Override
    public final boolean isOkToSend(PublishLimiterNotify notifyLimiter) {
        IClientContext cc = this.getClient();
        if (cc != null && !cc.okToDispatchRemote()) {
            return false;
        }
        int prio = this.getMinSendPriority(notifyLimiter);
        return prio <= 9;
    }

    @Override
    public final int getMinSendPriority(PublishLimiterNotify notifyLimiter) {
        if (!this.isConnected()) {
            return 10;
        }
        IClientContext cc = this.locateClientContextForNeighbour();
        if (cc == null) {
            return 10;
        }
        return cc.getMinSendPriority(notifyLimiter);
    }

    @Override
    public final void expireSent() throws InterruptedException {
        if (!this.isConnected()) {
            return;
        }
        IClientContext cc = this.locateClientContextForNeighbour();
        if (cc == null) {
            return;
        }
        cc.clearExpiredMsgs();
    }

    private IClientContext locateClientContextForNeighbour() {
        IClientContext cc = null;
        try {
            cc = this.m_reg.getClient(this.m_id);
        }
        catch (EClientNotRegistered e) {
            cc = null;
        }
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getInDoubtTime() {
        Neighbor neighbor = this;
        synchronized (neighbor) {
            return this.m_inDoubtTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setInDoubtTime(long time) {
        Neighbor neighbor = this;
        synchronized (neighbor) {
            this.m_inDoubtTime = time;
        }
    }

    private void validateSessionVer(byte negotiatedSessionVer) throws EBrokerVersionMismatchNoSSL {
        if (!SessionConfig.isIBSessionVersionSupported(negotiatedSessionVer)) {
            if (this.checkDebugFlags(64)) {
                this.debug("validateSessionVer (passive side); SessionVer not supported " + negotiatedSessionVer);
            }
            throw new EBrokerVersionMismatchNoSSL(prAccessor.getString("IB_BROKER_VERSION_MISMATCH"), (int)negotiatedSessionVer, 32);
        }
    }

    byte selectSessionVer(byte defaultSessionVer, byte serverSessionVer) {
        byte selectedVer = 0;
        if (!SessionConfig.isIBSessionVersionSupported(serverSessionVer)) {
            selectedVer = SessionConfig.getLatestSupportedIBSessionVers();
            if (this.checkDebugFlags(64)) {
                this.debug("validateSessionVer (initiating side); SessionVer not supported " + serverSessionVer + " returning " + selectedVer);
            }
        } else {
            selectedVer = serverSessionVer;
        }
        return selectedVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasInDoubtState() {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            if (!this.m_rcvdXOnceQTrackNums.isEmpty()) {
                if (this.DEBUG) {
                    this.debug("Has pending state; expecting " + this.m_rcvdXOnceQTrackNums.size() + " responses to guaranteed acks");
                }
                return true;
            }
            Enumeration enu = this.m_inDoubtQTrackNums.elements();
            if (enu.hasMoreElements()) {
                if (this.DEBUG) {
                    int count = 0;
                    while (enu.hasMoreElements()) {
                        enu.nextElement();
                        ++count;
                    }
                    this.debug("Has pending state; expects " + count + " acks to resolve in-doubt messages");
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void xOnceQMsgReceived(long tracking, AgentQueueMsgTracker tracker) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_rcvdXOnceQTrackNums.put(tracking, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addGuarQAck(long ackTracking, long msgTracking) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            this.m_guarQAcks.put(ackTracking, new Long(msgTracking));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setQMsgInDoubt(long tracking) {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            if (this.DEBUG) {
                this.debug("Added to in-doubt list " + tracking);
            }
            this.m_inDoubtQTrackNums.appendNoDup(tracking, new Long(tracking));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleQAckAck(IMgram ack) {
        long acktrk = ack.getAckHandle().getTrackingNumber();
        if (this.DEBUG) {
            this.debug("In handleQAckAck for " + acktrk);
        }
        boolean needEvent = false;
        long ourTrackNum = 0L;
        boolean replicateOnly = false;
        AgentQueueMsgTracker tracker = null;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Long msgTracking = (Long)this.m_guarQAcks.remove(acktrk);
            if (msgTracking == null) {
                return false;
            }
            if (this.DEBUG) {
                this.debug("In handleQAckAck for " + acktrk + " remote's TrackingNum= " + msgTracking);
            }
            tracker = (AgentQueueMsgTracker)this.m_rcvdXOnceQTrackNums.remove(msgTracking);
        }
        if (tracker == null) {
            return true;
        }
        ourTrackNum = tracker.getTracking();
        needEvent = tracker.guarAckDone();
        replicateOnly = tracker.isReplicateOnly();
        if (needEvent) {
            GuarQAckDoneEvt evt = new GuarQAckDoneEvt(ourTrackNum);
            evt.setReplicateOnly(replicateOnly);
            this.m_reg.getLogManager().addEvent(evt, true);
        }
        if (this.DEBUG) {
            this.debug("In handleQAckAck for " + acktrk + " returning true ");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void expireInDoubt() throws InterruptedException {
        IndexedList inDoubtList = null;
        int count = 0;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Enumeration enu = this.m_inDoubtQTrackNums.elements();
            while (enu.hasMoreElements()) {
                ++count;
                long tracking = (Long)enu.nextElement();
                AgentRegistrar.getAgentRegistrar().getQMsgStateMgr().removeInDoubtMsg(tracking);
            }
            if (count == 0) {
                if ((this.debugFlags & 0x40) > 0) {
                    this.debug("Expiring " + count + " in-doubt messages to routing queue");
                }
                return;
            }
            inDoubtList = this.m_inDoubtQTrackNums;
            this.m_inDoubtQTrackNums = new IndexedList();
        }
        Enumeration enu = inDoubtList.elements();
        while (enu.hasMoreElements()) {
            long tracking = (Long)enu.nextElement();
            IMgram m = AgentRegistrar.getAgentRegistrar().getQueueMsgSaver().retrieveMgram(tracking);
            if (m == null) {
                if (!this.DEBUG) continue;
                this.debug("Restoring inDoubt messages to queue: No mgram in db for tracking " + tracking);
                continue;
            }
            AgentRegistrar.getAgentRegistrar().getQueueProc().processUndelivered(m, 6, true);
        }
        if (this.DEBUG) {
            this.debug("Moved " + count + " in-doubt messages to dead message queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void inDoubtQMsgAcknowledged(long tracking) {
        AgentQueueMsgTracker tracker;
        ListNode obj;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            if (this.DEBUG) {
                this.debug("Received ack for " + tracking);
            }
            if ((obj = this.m_inDoubtQTrackNums.remove(tracking)) != null) {
                if (this.DEBUG) {
                    this.debug("Message " + tracking + " foung in in-doubt list");
                }
                AgentRegistrar.getAgentRegistrar().getQMsgStateMgr().removeInDoubtMsg(tracking);
            }
        }
        if (obj != null && (tracker = AgentQueueMsgTracker.getTracker(tracking)) != null) {
            tracker.acknowledged(null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ISizedEnumeration getXOnceQMsgTrackNums() {
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            return this.m_rcvdXOnceQTrackNums.keyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void allXOnceQAcksDone() {
        GuarQAckXchgEvt evt = new GuarQAckXchgEvt();
        int ct = 0;
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Enumeration enu = this.m_rcvdXOnceQTrackNums.elements();
            while (enu.hasMoreElements()) {
                ++ct;
                AgentQueueMsgTracker tracker = (AgentQueueMsgTracker)enu.nextElement();
                long ourTracking = tracker.getTracking();
                tracker.guarAckDone();
                evt.addTracking(ourTracking);
            }
            this.m_rcvdXOnceQTrackNums.clear();
            this.m_guarQAcks.clear();
        }
        if (ct > 0) {
            this.m_reg.getLogManager().addEvent(evt, false);
        }
        if ((this.debugFlags & 0x40) > 0) {
            this.debug("Acks confirmed for " + ct + " messages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void allInDoubtQAcksReceived() throws InterruptedException {
        IndexedList inDoubtList = null;
        int count = 0;
        InDoubtQMsgReenqueueEvt evt = new InDoubtQMsgReenqueueEvt();
        InDoubtQMsgReenqueueEvt replOnlyEvt = new InDoubtQMsgReenqueueEvt();
        replOnlyEvt.setReplicateOnly(true);
        Object object = this.m_tableSyncObj;
        synchronized (object) {
            Enumeration enu = this.m_inDoubtQTrackNums.elements();
            while (enu.hasMoreElements()) {
                ++count;
                long tracking = (Long)enu.nextElement();
                AgentRegistrar.getAgentRegistrar().getQMsgStateMgr().removeInDoubtMsg(tracking);
                AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
                if (this.DEBUG) {
                    this.debug("during recovery neighbor = " + this + " recovering message with tracker.getQueueName() " + tracker.getLocalQueueName() + " tracking = " + tracking);
                }
                if (tracker != null && tracker.isReplicateOnly()) {
                    replOnlyEvt.addTracking(tracking);
                } else {
                    evt.addTracking(tracking);
                }
                if (tracker != null) {
                    tracker.setReceiverId(0L);
                    continue;
                }
                if (!this.DEBUG) continue;
                this.debug("Tracker for " + tracking + " not found");
            }
            if (count == 0) {
                if ((this.debugFlags & 0x40) > 0) {
                    this.debug("Restored " + count + " recovered in-doubt messages to queues");
                }
                AgentRegistrar.getAgentRegistrar().getLogManager().flush();
                return;
            }
            inDoubtList = this.m_inDoubtQTrackNums;
            this.m_inDoubtQTrackNums = new IndexedList();
        }
        this.m_reg.getLogManager().addEvent(replOnlyEvt, false);
        this.m_reg.getLogManager().addEvent(evt, true);
        this.m_reg.getLogManager().waitForFlush(evt);
        Hashtable<String, IndexedList<IMgram>> mgramsbyQueue = new Hashtable<String, IndexedList<IMgram>>();
        String queueName = null;
        IndexedList<IMgram> mgrams = null;
        Enumeration enu = inDoubtList.elements();
        while (enu.hasMoreElements()) {
            long tracking = (Long)enu.nextElement();
            IMgram m = AgentRegistrar.getAgentRegistrar().getQueueMsgSaver().retrieveMgram(tracking);
            if (m == null) {
                if (!this.DEBUG) continue;
                this.debug("Restoring inDoubt messages to queue: No mgram in db for tracking " + tracking);
                continue;
            }
            AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
            queueName = tracker.getLocalQueueName();
            if (mgramsbyQueue.containsKey(queueName)) {
                mgrams = (IndexedList)mgramsbyQueue.get(queueName);
            } else {
                if (this.DEBUG) {
                    this.debug("Adding indexed list of mgrams to restore to queueName = " + queueName);
                }
                mgrams = new IndexedList<IMgram>();
                mgramsbyQueue.put(queueName, mgrams);
            }
            mgrams.appendNoDup(tracking, m);
            if (!this.DEBUG) continue;
            this.debug("appending message to list of messages to restore to queueName = " + queueName + " with tracking = " + tracking);
        }
        Enumeration en = mgramsbyQueue.keys();
        while (en.hasMoreElements()) {
            queueName = (String)en.nextElement();
            mgrams = (IndexedList<IMgram>)mgramsbyQueue.get(queueName);
            if (queueName.equals("SonicMQ.routingQueue")) {
                RemoteBrokerHelper rbh = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper();
                if (this.DEBUG) {
                    this.debug(this + ": Restoring: " + mgrams.count() + " to routing queue.");
                }
                rbh.rerouteUnacknowledged(mgrams.elements(), false);
                continue;
            }
            IAgentQueue iaq = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(queueName);
            if (iaq != null) {
                iaq.restore(mgrams, false, true);
                if (!this.DEBUG) continue;
                this.debug("restored mgrams to queueName = " + queueName);
                continue;
            }
            this.debugNotRestoreMgrams(queueName);
        }
        if ((this.debugFlags & 0x40) > 0) {
            this.debug("Restored " + count + " recovered in-doubt messages to above mentioned queues");
        }
    }

    private void debugNotRestoreMgrams(String queueName) {
        if (this.DEBUG) {
            this.debug("could not restore mgrams to queueName = " + queueName + " b/c queue was not found/deleted. Drop the mgrams");
        }
    }

    public final void updateNeighborConnectionInfo(int total, boolean hasNewConnections, boolean reset) {
        if (this.checkDebugFlags(16384)) {
            this.debug("connection count for " + this.m_name + " = " + total + " (" + (hasNewConnections ? "has" : "no") + " new connections since last ping)");
        }
        this.m_connectionCounter.updateNeighborConnectionInfo(total, hasNewConnections, reset);
    }

    @Override
    public final void incrementNeighborConnectionCount() {
        this.m_connectionCounter.incrementNeighborConnectionCount();
    }

    @Override
    public final int getNeighborConnectionCount() {
        return this.m_connectionCounter.getNeighborConnectionCount();
    }

    @Override
    public final int getSessionCount() {
        return this.m_sessionCount;
    }

    @Override
    public final void setSessionCount(int m_sessionCount) {
        this.m_sessionCount = m_sessionCount;
    }

    @Override
    public final int getDurableSubscribersCount() {
        return this.m_durableSubscribersCount;
    }

    @Override
    public final void setDurableSubscribersCount(int m_durableSubscribersCount) {
        this.m_durableSubscribersCount = m_durableSubscribersCount;
    }

    @Override
    public final int getNonDurableSubscribersCount() {
        return this.m_nonDurableSubscribersCount;
    }

    @Override
    public final void setNonDurableSubscribersCount(int m_nonDurableSubscribersCount) {
        this.m_nonDurableSubscribersCount = m_nonDurableSubscribersCount;
    }

    @Override
    public final int getQueueReceiversCount() {
        return this.m_queueReceiversCount;
    }

    @Override
    public final void setQueueReceiversCount(int m_queueReceiversCount) {
        this.m_queueReceiversCount = m_queueReceiversCount;
    }

    @Override
    public final int getQueueBrowsersCount() {
        return this.m_queueBrowsersCount;
    }

    @Override
    public final void setQueueBrowsersCount(int m_queueBrowsersCount) {
        this.m_queueBrowsersCount = m_queueBrowsersCount;
    }

    static {
        s_ib = Interbroker.getInterbroker();
        s_random = new Random(-System.currentTimeMillis());
        s_token = s_random.nextLong();
        s_token *= System.currentTimeMillis();
        s_label = new Label();
        cDebug = System.getProperty("progress.message.interbroker.Neighbor.debug", null);
    }

    final class PeerAcceptor {
        private final boolean m_primary;
        private String m_primaryIBHostPort;
        private String m_secondaryIBHostPort;
        private String m_primaryAcceptorURL;
        private boolean m_loadBalancingEnabled;
        private int m_loadBalanceWeight;
        private Properties m_acceptors;

        PeerAcceptor(String name, FTPairPeerInfoHolder ftHolder, boolean primary) {
            this.m_primary = primary;
            this.applyFTHolderProperties(ftHolder);
        }

        private final void applyFTHolderProperties(FTPairPeerInfoHolder ftHolder) {
            PeerInfoHolder holder;
            ArrayList ibUrls = null;
            ibUrls = this.m_primary ? ftHolder.getPrimaryIBConnectUrls() : ftHolder.getBackupIBConnectUrls();
            this.m_primaryIBHostPort = (String)ibUrls.get(0);
            if (ibUrls.size() > 1) {
                this.m_secondaryIBHostPort = (String)ibUrls.get(1);
            }
            this.m_acceptors = new Properties();
            PeerInfoHolder peerInfoHolder = holder = this.m_primary ? ftHolder.getPrimaryPeerInfoHolder() : ftHolder.getBackupPeerInfoHolder();
            if (holder != null) {
                this.m_primaryAcceptorURL = holder.getPrimaryAcceptorURL();
                if (this.m_primaryAcceptorURL == null) {
                    this.m_primaryAcceptorURL = this.m_primaryIBHostPort;
                }
                this.m_loadBalancingEnabled = holder.getLoadBalancingEnabled();
                this.m_loadBalanceWeight = holder.getLoadBalanceWeight();
                Hashtable peerTable = holder.getPeerTable();
                if (peerTable != null) {
                    Enumeration names = peerTable.keys();
                    while (names.hasMoreElements()) {
                        String acceptorName = (String)names.nextElement();
                        Vector vec = (Vector)peerTable.get(acceptorName);
                        if (vec == null) continue;
                        StringBuffer sb = new StringBuffer();
                        Enumeration URLs = vec.elements();
                        boolean empty = true;
                        while (URLs.hasMoreElements()) {
                            String URL2 = (String)URLs.nextElement();
                            if (URL2 == null) continue;
                            if (!empty) {
                                sb.append(InterbrokerConfig.HOSTS_SEPARATOR);
                            }
                            sb.append(URL2);
                            empty = false;
                        }
                        this.m_acceptors.put(acceptorName, sb.toString());
                    }
                }
            }
        }

        public final String getPrimaryHostPort() {
            return this.m_primaryIBHostPort;
        }

        public final String getSecondaryHostPort() {
            return this.m_secondaryIBHostPort;
        }

        public final String getDefaultHostPort() {
            return this.m_primaryAcceptorURL;
        }

        public final String getHostPorts(String acceptorName) {
            return this.m_acceptors.getProperty(acceptorName);
        }

        public final int getWeight() {
            return this.m_loadBalanceWeight;
        }

        final void setHostPort(FTPairPeerInfoHolder ftHolder) {
            this.applyFTHolderProperties(ftHolder);
        }
    }

    final class ConnectionCounter {
        private int m_lastReportedTotal = -1;
        private int m_expectedTotal = -1;
        private int m_state = 2;

        ConnectionCounter() {
        }

        synchronized void updateNeighborConnectionInfo(int reportedTotal, boolean hasNewConnections, boolean reset) {
            if (this.m_state == 0) {
                if (this.m_lastReportedTotal >= 0 && this.m_expectedTotal > this.m_lastReportedTotal && !hasNewConnections) {
                    this.m_state = 1;
                    if (Neighbor.this.checkDebugFlags(16384)) {
                        Neighbor.this.debug("WARNING: neighbor reports no new connection while " + (this.m_expectedTotal - this.m_lastReportedTotal) + " connections were redirected to it.");
                    }
                }
                this.m_expectedTotal = this.m_lastReportedTotal = reportedTotal;
            } else if (this.m_state == 1) {
                if (!hasNewConnections) {
                    if (this.m_lastReportedTotal >= 0 && this.m_expectedTotal > this.m_lastReportedTotal) {
                        this.m_state = 2;
                        Object[] obj = new Object[]{Neighbor.this.m_name};
                        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("NEIGHBOR_CONNECTION_COUNT_SUSPENDED"), obj), 2);
                    }
                } else {
                    this.m_state = 0;
                }
                this.m_expectedTotal = this.m_lastReportedTotal = reportedTotal;
            } else if (hasNewConnections || reset) {
                this.m_state = 0;
                if (hasNewConnections) {
                    Object[] obj = new Object[]{Neighbor.this.m_name};
                    BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("NEIGHBOR_CONNECTION_COUNT_NORMAL"), obj), 3);
                }
                this.m_expectedTotal = this.m_lastReportedTotal = reportedTotal;
            }
        }

        synchronized void incrementNeighborConnectionCount() {
            ++this.m_expectedTotal;
        }

        synchronized int getNeighborConnectionCount() {
            return this.m_state == 2 ? -1 : this.m_expectedTotal;
        }
    }
}

