/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import progress.message.client.EGeneralException;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.prAccessor;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.zclient.Envelope;

public class BytesMessage
extends Message
implements progress.message.jclient.BytesMessage {
    public BytesMessage() {
        super((short)2);
    }

    BytesMessage(Envelope envelope) {
        super(envelope);
    }

    private BytesMessage(BytesMessage msg) {
        super(msg);
    }

    public boolean readBoolean() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readBoolean();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public byte readByte() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readByte();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            if (ioe instanceof EOFException) {
                throw new MessageEOFException(ioe.getMessage());
            }
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readUnsignedByte();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public short readShort() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readShort();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readUnsignedShort();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public char readChar() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readChar();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public int readInt() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readInt();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public long readLong() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readLong();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public float readFloat() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readFloat();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public double readDouble() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            return this.m_zenvelope.getMessage().readDouble();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public String readUTF() throws JMSException {
        this.checkIsBodyReadOnly2();
        try {
            if (this.getBooleanProperty("JMS_SonicMQ_CTS_Message")) {
                return this.m_zenvelope.getMessage().readShortUTF();
            }
            return this.m_zenvelope.getMessage().readUTF();
        }
        catch (ESecurityGeneralException sge) {
            throw JMSExceptionUtil.createJMSSecurityException(sge);
        }
        catch (EGeneralException ge) {
            throw JMSExceptionUtil.createJMSException(ge);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkIsBodyReadOnly2();
        if (this.m_zenvelope.getMessage().countUnread() == 0) {
            return -1;
        }
        return this.m_zenvelope.getMessage().read(value, 0, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkIsBodyReadOnly2();
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.m_zenvelope.getMessage().countUnread() == 0) {
            return -1;
        }
        return this.m_zenvelope.getMessage().read(value, 0, length);
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkIsBodyReadOnly();
        this.m_zenvelope.getMessage().writeBoolean(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.checkIsBodyReadOnly();
        this.m_zenvelope.getMessage().writeByte(value);
    }

    public void writeShort(short value) throws JMSException {
        this.checkIsBodyReadOnly();
        this.m_zenvelope.getMessage().writeShort(value);
    }

    public void writeChar(char value) throws JMSException {
        this.checkIsBodyReadOnly();
        this.m_zenvelope.getMessage().writeChar(value);
    }

    public void writeInt(int value) throws JMSException {
        this.checkIsBodyReadOnly();
        this.m_zenvelope.getMessage().writeInt(value);
    }

    public void writeLong(long value) throws JMSException {
        this.checkIsBodyReadOnly();
        this.m_zenvelope.getMessage().writeLong(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.checkIsBodyReadOnly();
        this.m_zenvelope.getMessage().writeFloat(value);
    }

    public void writeDouble(double value) throws JMSException {
        this.checkIsBodyReadOnly();
        this.m_zenvelope.getMessage().writeDouble(value);
    }

    public void writeUTF(String value) throws JMSException {
        this.checkIsBodyReadOnly();
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            this.m_zenvelope.getMessage().writeUTF(value);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkIsBodyReadOnly();
        if (value == null) {
            throw new NullPointerException();
        }
        this.m_zenvelope.getMessage().write(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkIsBodyReadOnly();
        if (value == null || length == 0) {
            throw new NullPointerException();
        }
        this.m_zenvelope.getMessage().write(value, offset, length);
    }

    public void writeObject(Object value) throws JMSException {
        this.checkIsBodyReadOnly();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else {
            if (value == null) {
                throw new NullPointerException();
            }
            throw new MessageFormatException(prAccessor.getString("INVALID_OBJECT_TYPE"));
        }
    }

    private void checkIsBodyReadOnly() throws MessageNotWriteableException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException(prAccessor.getString("MSG_BODY_READ_ONLY"));
        }
    }

    public void reset() throws JMSException {
        try {
            this.m_bodyReadOnly = true;
            if (this.m_zenvelope.getMessage().cap() != 0) {
                this.m_zenvelope.getMessage().gotoByte(0);
            }
        }
        catch (EGeneralException ege) {
            throw JMSExceptionUtil.createJMSException(ege);
        }
        catch (IOException ioe) {
            throw JMSExceptionUtil.createJMSException(ioe);
        }
    }

    @Override
    public Object clone() {
        BytesMessage msg = new BytesMessage(this);
        msg.m_zenvelope = (Envelope)this.m_zenvelope.deepClone();
        return msg;
    }

    @Override
    public Object protectedClone() {
        BytesMessage msg = new BytesMessage(this);
        msg.m_zenvelope = (Envelope)this.m_zenvelope.protectedClone();
        return msg;
    }

    public long getBodyLength() throws JMSException {
        this.checkIsBodyReadOnly2();
        return this.getBodySize();
    }

    private void checkIsBodyReadOnly2() throws MessageNotReadableException {
        if (!this.m_bodyReadOnly) {
            throw new MessageNotReadableException(prAccessor.getString("MSG_BODY_WRITE_ONLY"));
        }
    }

    public static void main(String[] args) {
        BytesMessage message = new BytesMessage();
        System.out.println("Successfully instantiated BytesMessage.");
        try {
            message.writeUTF("It is time for all good men to run");
            System.out.println("Marshalled and Unmarshalled Message String: " + message.readUTF());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

