/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.server.tunnel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Response;
import progress.message.net.ProgressInetAddress;
import progress.message.net.http.client.tunnel.SafeQueue;
import progress.message.net.http.client.tunnel.prAccessor;
import progress.message.net.http.server.SonicHttpServer;

public class HttpConnectionSocket
extends Socket {
    private boolean DEBUG = false;
    static int POOLING_INTERVAL = 10;
    static int POOLING_COUNT = 100;
    static int CLIENT_TIMEOUT = 10000;
    static int READ_TIMEOUT = 50500;
    static int MAX_WRITE = 65536;
    public static int FAIL_STATUS = 400;
    public static int SUCCESS_STATUS = 200;
    public static int NO_DATA_STATUS = 204;
    public static int CLOSING_STATUS = 400;
    public static String READ_SEQ_NUM = "SequenceNumber";
    private HttpServerSocketInputStream m_in = null;
    private HttpServerSocketOutputStream m_out = null;
    private ProgressInetAddress m_InetAddress = null;
    private long m_lastReqTime = -1L;
    private Object m_timeSync = new Object();
    private Boolean m_isClosing = false;
    private final Object lockObj = new Object();
    public boolean m_closedByBroker = false;
    public boolean m_closedByClient = false;
    protected int m_id = -1;
    private Object m_readLock = new Object();

    public static void setClientIdleTimeout(int timeout) {
        CLIENT_TIMEOUT = timeout;
    }

    public static int getClientIdleTimeout() {
        return CLIENT_TIMEOUT;
    }

    public static void setClientReadTimeout(int timeout) {
        READ_TIMEOUT = timeout;
    }

    public static void setMaxWriteSize(int size) {
        if (size <= 65536) {
            MAX_WRITE = size;
        }
    }

    public static void sendReplyCode(HttpServletResponse response, int returncode) {
        HttpConnectionSocket.sendReplyCode(response, returncode, -1);
    }

    public static void sendReplyCode(HttpServletResponse response, int returncode, int cid) {
        block2: {
            try {
                response.setIntHeader("Content-Length", 1);
                response.setStatus(returncode);
                response.getOutputStream().write(new byte[1]);
                response.getOutputStream().flush();
            }
            catch (Exception ex) {
                if (!SonicHttpServer.getDebug()) break block2;
                System.out.println("HTTP Connection " + cid + ": error writing response " + returncode);
                ex.printStackTrace();
            }
        }
    }

    public HttpConnectionSocket(ProgressInetAddress inetAddress, int id) {
        try {
            this.m_out = new HttpServerSocketOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_in = new HttpServerSocketInputStream();
        this.m_InetAddress = inetAddress;
        this.m_id = id;
        this.DEBUG = SonicHttpServer.getDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        if (this.m_closedByBroker && this.m_closedByClient) {
            if (this.DEBUG && this.m_closedByBroker) {
                System.out.println("HTTP Connection " + this.m_id + ": isActive() = closed by the broker");
            }
            if (this.DEBUG && this.m_closedByClient) {
                System.out.println("HTTP Connection " + this.m_id + ": isActive() = closed by the client");
            }
            return false;
        }
        Object object = this.m_timeSync;
        synchronized (object) {
            if (this.m_lastReqTime != 0L && System.currentTimeMillis() - this.m_lastReqTime > (long)CLIENT_TIMEOUT) {
                if (this.DEBUG) {
                    System.out.println("HTTP Connection " + this.m_id + ":  isActive() = client idle timeout expired, last req time = " + this.m_lastReqTime + " and current time = " + System.currentTimeMillis() + " returning false.");
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastReqTime(long time) {
        Object object = this.m_timeSync;
        synchronized (object) {
            if (time > this.m_lastReqTime) {
                this.m_lastReqTime = time;
                if (this.DEBUG) {
                    System.out.println("HTTP Connection " + this.m_id + ": last req time = " + new Date(this.m_lastReqTime) + ", agent = " + Thread.currentThread());
                }
            }
        }
    }

    public int clientWrite(InputStream in, int sequenceNumber) throws IOException {
        if (this.m_in == null) {
            throw new IOException("InputStream is not available.");
        }
        this.setLastReqTime(System.currentTimeMillis());
        return this.m_in.clientWrite(in, sequenceNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clientRead(HttpServletResponse resp) throws IOException {
        if (this.m_out == null) {
            throw new IOException("OutputStream is not available.");
        }
        Object object = this.m_readLock;
        synchronized (object) {
            return this.m_out.clientRead(resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.DEBUG) {
            System.out.println("HTTP Connection " + this.m_id + ": socket closed by " + Thread.currentThread());
        }
        Object object = this.lockObj;
        synchronized (object) {
            if (this.m_isClosing.booleanValue()) {
                return;
            }
            this.m_isClosing = true;
        }
        if (this.m_in != null) {
            try {
                this.m_in.cleanup();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_in = null;
        }
        if (this.m_out != null) {
            this.m_out.brokerClose();
        }
        this.m_closedByBroker = true;
    }

    public void clientClose() throws IOException {
        this.mOutCleanup();
        if (this.m_in != null) {
            this.m_in.clientClose();
        }
        this.m_closedByClient = true;
    }

    public void cleanup() throws IOException {
        this.mOutCleanup();
        this.m_closedByClient = true;
        if (this.m_in != null) {
            try {
                this.m_in.cleanup();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_in = null;
        }
        this.m_closedByBroker = true;
    }

    private void mOutCleanup() {
        if (this.m_out != null) {
            try {
                this.m_out.cleanup();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_out = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.m_closedByBroker) {
            throw new IOException("Socket has been closed.");
        }
        return this.m_in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.m_closedByBroker || this.m_closedByClient) {
            throw new IOException("Socket has been closed.");
        }
        return this.m_out;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.m_InetAddress.getDelegateInetAddress();
    }

    protected void handleError(HttpServletResponse response, boolean clientClose, int status) throws IOException {
        if (clientClose) {
            this.clientClose();
        }
        HttpConnectionSocket.sendReplyCode(response, status, this.m_id);
    }

    protected void prepareClientReadResponseHeader(HttpServletResponse response, int status, int mid, int len) throws IOException {
        response.setIntHeader(READ_SEQ_NUM, mid);
        response.setStatus(status);
        response.setIntHeader("Content-Length", len);
    }

    protected void sendNoDataResponse(HttpServletResponse resp) throws IOException {
        if (this.DEBUG) {
            System.out.println("HTTP Connection " + this.m_id + ": No data. Setting response: " + NO_DATA_STATUS);
        }
        HttpConnectionSocket.sendReplyCode(resp, NO_DATA_STATUS, this.m_id);
    }

    class HttpServerSocketInputStream
    extends InputStream {
        private boolean bClosed = false;
        private LimitedSafeQueue incomingData = new LimitedSafeQueue(1);
        private InputStream currentInputStream = null;
        private int expectedSequenceNumber = 0;

        HttpServerSocketInputStream() {
        }

        synchronized int clientWrite(InputStream in, int sequenceNumber) {
            if (sequenceNumber != this.expectedSequenceNumber) {
                if (HttpConnectionSocket.this.DEBUG) {
                    System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": Skip duplicate message " + sequenceNumber + ", expected sequence number = " + this.expectedSequenceNumber);
                }
                try {
                    return in.available();
                }
                catch (IOException ex) {
                    return 0;
                }
            }
            try {
                int bWritten = in.available();
                this.incomingData.add(in);
                ++this.expectedSequenceNumber;
                if (bWritten == -1) {
                    if (HttpConnectionSocket.this.DEBUG) {
                        System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": No data in the inputstream.");
                    }
                    return 0;
                }
                return bWritten;
            }
            catch (IOException ex) {
                if (HttpConnectionSocket.this.DEBUG) {
                    System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": Caught IOException on available().");
                }
                return 0;
            }
        }

        @Override
        public int read() throws IOException {
            byte[] temp = new byte[1];
            switch (this.read(temp, 0, 1)) {
                case 1: {
                    return temp[0];
                }
            }
            return -1;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.bClosed) {
                throw new IOException("Unable to read from a closed input stream");
            }
            if (this.getCurrentInputStream(true) == null) {
                if (HttpConnectionSocket.this.DEBUG) {
                    System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": broker read " + -1 + " bytes from the input stream. CASE 1");
                }
                return -1;
            }
            int result = this.currentInputStream.read(b, off, len);
            if (result == -1) {
                if (HttpConnectionSocket.this.DEBUG) {
                    System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": broker read " + -1 + " bytes from the input stream. CASE 2");
                }
                try {
                    this.currentInputStream.close();
                }
                catch (IOException e) {
                    if (HttpConnectionSocket.this.DEBUG) {
                        e.printStackTrace();
                    }
                }
                finally {
                    this.currentInputStream = null;
                }
                return this.read(b, off, len);
            }
            if (HttpConnectionSocket.this.DEBUG) {
                System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": broker read " + result + " bytes from the input stream. CASE 3");
            }
            return result;
        }

        private InputStream getCurrentInputStream(boolean bWait) throws IOException {
            if (this.currentInputStream != null) {
                return this.currentInputStream;
            }
            if (bWait) {
                try {
                    this.currentInputStream = (InputStream)this.incomingData.remove();
                }
                catch (InterruptedException ie) {
                    return null;
                }
            } else {
                return null;
            }
            if (this.currentInputStream instanceof EmptyInputStream) {
                HttpConnectionSocket.this.close();
                return null;
            }
            if (this.currentInputStream == null) {
                return this.getCurrentInputStream(bWait);
            }
            return this.currentInputStream;
        }

        @Override
        public int available() throws IOException {
            InputStream in = this.getCurrentInputStream(false);
            if (in == null) {
                return 0;
            }
            return in.available();
        }

        @Override
        public void close() throws IOException {
            if (HttpConnectionSocket.this.DEBUG) {
                System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": Invoking close() on the input stream.");
            }
            this.bClosed = true;
        }

        void cleanup() throws IOException {
            InputStream d;
            if (HttpConnectionSocket.this.DEBUG) {
                System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": Invoking cleanup() on the input stream.");
            }
            if (HttpConnectionSocket.this.m_closedByBroker) {
                return;
            }
            this.bClosed = true;
            if (this.currentInputStream != null) {
                this.currentInputStream.close();
            }
            while ((d = (InputStream)this.incomingData.removeNonBlocking()) != null) {
                d.close();
            }
            this.incomingData.add(new EmptyInputStream());
        }

        void clientClose() throws IOException {
            if (HttpConnectionSocket.this.DEBUG) {
                System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": Invoking clientClose() on the input stream.");
            }
            this.incomingData.add(new EmptyInputStream());
        }
    }

    class HttpServerSocketOutputStream
    extends OutputStream {
        private LimitedSafeQueue outgoingData = null;
        private ByteArrayOutputStream buf = new ByteArrayOutputStream();
        private InputStream currentInputStream = null;
        private boolean bClosed = false;
        private int messageId = 0;

        public HttpServerSocketOutputStream() throws IOException {
            this.outgoingData = new LimitedSafeQueue(1);
        }

        private InputStream getCurrentInputStream(boolean wait) throws IOException {
            if (this.currentInputStream != null) {
                if (this.currentInputStream.available() > 0) {
                    return this.currentInputStream;
                }
                this.currentInputStream.close();
                this.currentInputStream = null;
            }
            if (wait) {
                try {
                    this.currentInputStream = (InputStream)this.outgoingData.remove();
                }
                catch (InterruptedException ie) {
                    return null;
                }
            } else {
                this.currentInputStream = (InputStream)this.outgoingData.removeNonBlocking();
            }
            if (this.currentInputStream instanceof EmptyInputStream) {
                HttpConnectionSocket.this.clientClose();
                throw new IOException("socket closed by the broker");
            }
            return this.currentInputStream;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (HttpConnectionSocket.this.DEBUG) {
                System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": broker writing " + len + " bytes to the output stream.");
            }
            this.checkClosed();
            if (len < MAX_WRITE) {
                this.buf.write(b, off, len);
                if (this.buf.size() >= MAX_WRITE) {
                    this.flush();
                }
            } else {
                int size;
                int total = 0;
                do {
                    size = Math.min(len - total, MAX_WRITE);
                    this.buf.write(b, off + total, size);
                    this.flush();
                } while (len - (total += size) > 0);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.checkClosed();
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            this.checkClosed();
            this.buf.write(b);
        }

        @Override
        public void close() throws IOException {
            if (HttpConnectionSocket.this.DEBUG) {
                System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": Invoking close() on the output stream.");
            }
            this.checkClosed();
            this.flush();
            this.bClosed = true;
        }

        void brokerClose() throws IOException {
            if (HttpConnectionSocket.this.DEBUG) {
                System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": Invoking brokerClose() on the output stream.");
            }
            this.flush();
            this.outgoingData.addNoWait(new EmptyInputStream());
        }

        void cleanup() throws IOException {
            InputStream d;
            if (HttpConnectionSocket.this.DEBUG) {
                System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": Invoking cleanup() on the output stream.");
            }
            if (HttpConnectionSocket.this.m_closedByClient) {
                return;
            }
            this.bClosed = true;
            this.buf.close();
            this.outgoingData.addNoWait(new EmptyInputStream());
            if (this.currentInputStream != null) {
                this.currentInputStream.close();
            }
            while ((d = (InputStream)this.outgoingData.removeNonBlocking()) != null) {
                d.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            this.checkClosed();
            byte[] data = null;
            ByteArrayOutputStream byteArrayOutputStream = this.buf;
            synchronized (byteArrayOutputStream) {
                if (this.buf.size() > 0) {
                    data = this.buf.toByteArray();
                    this.buf.reset();
                }
            }
            if (data != null) {
                this.outgoingData.add(new HttpByteArrayInputStream(data));
                if (HttpConnectionSocket.this.DEBUG) {
                    System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": adding " + data.length + " bytes to the queue, queue length= " + this.outgoingData.getNElements());
                }
            }
        }

        private void checkClosed() throws IOException {
            if (this.bClosed) {
                throw new IOException(prAccessor.getString("STR003"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int clientRead(HttpServletResponse response) throws IOException {
            int n;
            long reqTime = System.currentTimeMillis();
            try {
                HttpConnectionSocket.this.setLastReqTime(0L);
                int size = 0;
                int retry = 0;
                size = this.available();
                if (size <= 0) {
                    long blockedTime = 0L;
                    long waitTime = ++retry * POOLING_INTERVAL;
                    long totalBlockedTime = Math.min(READ_TIMEOUT, CLIENT_TIMEOUT);
                    long startTime = System.currentTimeMillis();
                    if (HttpConnectionSocket.this.DEBUG) {
                        System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": " + Thread.currentThread() + " starts blocking " + totalBlockedTime + " ms for data, " + new Date(startTime));
                    }
                    do {
                        Thread.sleep(waitTime);
                        size = this.available();
                        if (size > 0) break;
                        if (totalBlockedTime < 0L) {
                            waitTime = ++retry * POOLING_INTERVAL;
                            continue;
                        }
                        if ((blockedTime += waitTime) >= totalBlockedTime) break;
                        if ((waitTime = (long)(++retry * POOLING_INTERVAL)) <= totalBlockedTime - blockedTime) continue;
                        waitTime = totalBlockedTime - blockedTime;
                    } while (retry < POOLING_COUNT);
                    if (HttpConnectionSocket.this.DEBUG) {
                        System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": " + Thread.currentThread() + " ends blocking " + (System.currentTimeMillis() - startTime) + " ms for data, " + new Date(System.currentTimeMillis()));
                    }
                    if (size <= 0) {
                        if (HttpConnectionSocket.this.DEBUG) {
                            System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": No data is available for connection ");
                        }
                        HttpConnectionSocket.this.sendNoDataResponse(response);
                        reqTime = System.currentTimeMillis();
                        int n2 = 0;
                        return n2;
                    }
                }
                HttpConnectionSocket.this.prepareClientReadResponseHeader(response, SUCCESS_STATUS, ++this.messageId, size);
                ServletOutputStream out = response.getOutputStream();
                byte[] buf = new byte[size];
                int bRead = 0;
                int total = 0;
                while (bRead != -1) {
                    if (this.currentInputStream.markSupported()) {
                        this.currentInputStream.mark(0);
                    }
                    if ((bRead = this.currentInputStream.read(buf, 0, size)) <= 0) continue;
                    out.write(buf, 0, bRead);
                    total += bRead;
                }
                out.flush();
                if (response instanceof Response) {
                    ((Response)response).completeOutput();
                }
                reqTime = System.currentTimeMillis();
                this.currentInputStream.close();
                this.currentInputStream = null;
                int n3 = total;
                return n3;
            }
            catch (EOFException e) {
                if (HttpConnectionSocket.this.DEBUG) {
                    System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + Thread.currentThread() + " caught " + e);
                }
                HttpConnectionSocket.this.handleError(response, true, FAIL_STATUS);
                n = -1;
                return n;
            }
            catch (SocketException e) {
                this.printData(e);
                if (this.currentInputStream != null && this.currentInputStream.markSupported()) {
                    if (HttpConnectionSocket.this.DEBUG) {
                        System.out.println("HTTP Connection resetting currentInputStream");
                    }
                    this.currentInputStream.reset();
                    --this.messageId;
                }
                n = -1;
                return n;
            }
            catch (IOException e) {
                this.printData(e);
                HttpConnectionSocket.this.handleError(response, false, CLOSING_STATUS);
                n = -1;
                return n;
            }
            catch (Exception e) {
                if (HttpConnectionSocket.this.DEBUG) {
                    System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + " : " + Thread.currentThread() + " caught " + e);
                    if (e instanceof IOException) {
                        System.out.println(e.getMessage());
                    } else {
                        e.printStackTrace();
                    }
                }
                HttpConnectionSocket.this.handleError(response, true, FAIL_STATUS);
                n = -1;
                return n;
            }
            finally {
                HttpConnectionSocket.this.setLastReqTime(reqTime);
            }
        }

        private <T0 extends IOException> void printData(T0 e) {
            if (HttpConnectionSocket.this.DEBUG) {
                System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": " + Thread.currentThread() + " caught " + e);
            }
        }

        private int available() throws IOException {
            if (HttpConnectionSocket.this.m_closedByClient) {
                throw new IOException("Socket closed by the client.");
            }
            InputStream in = this.getCurrentInputStream(false);
            if (in == null) {
                return 0;
            }
            return in.available();
        }

        class HttpByteArrayInputStream
        extends ByteArrayInputStream {
            HttpByteArrayInputStream(byte[] buf) {
                super(buf);
            }

            @Override
            public void mark(int pos) {
                this.mark = pos;
            }

            @Override
            public void reset() {
                this.pos = this.mark;
                this.count = this.buf.length;
            }

            @Override
            public int available() {
                return this.count - this.pos;
            }
        }
    }

    class LimitedSafeQueue
    extends SafeQueue {
        private int size = -1;

        LimitedSafeQueue(int size) {
            this.size = size;
        }

        public void addNoWait(Object o) {
            super.add(o);
        }

        @Override
        public synchronized void add(Object o) {
            if (this.size == -1) {
                super.add(o);
                return;
            }
            while (this.getNElements() > this.size) {
                if (HttpConnectionSocket.this.DEBUG) {
                    System.out.println("HTTP Connection " + HttpConnectionSocket.this.m_id + ": " + Thread.currentThread() + "waiting to enqueue");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            super.add(o);
        }

        @Override
        public synchronized Object remove() throws InterruptedException {
            try {
                Object o;
                Object object = o = super.remove();
                return object;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            finally {
                this.notifyAll();
            }
        }
    }

    class EmptyInputStream
    extends InputStream {
        @Override
        public int read() {
            return -1;
        }
    }
}

