/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.http.server.tunnel;

import java.net.Socket;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import progress.message.broker.Config;
import progress.message.net.http.server.HttpXProtocolHandlerFactory;
import progress.message.net.http.server.IHttpRequestHandler;
import progress.message.net.http.server.SonicHttpServer;
import progress.message.net.http.server.tunnel.HttpTunnelHandler;

public class HttpTunnelHandlerFactory
extends HttpXProtocolHandlerFactory {
    String TUNNEL_PATH = "/SC/";

    public HttpTunnelHandlerFactory(Properties properties, HttpXProtocolHandlerFactory next) {
        super(properties, next);
    }

    @Override
    public IHttpRequestHandler createHandler(HttpServletRequest request, HttpServletResponse response, SonicHttpServer server, Socket socket) {
        String interval = null;
        if (this.m_properties == null || (interval = (String)this.m_properties.get("HTTP_CONNECTION_CLEANUP_INTERVAL")) == null || Integer.parseInt(interval) <= 0) {
            this.m_properties = new Properties();
            interval = Config.HTTP_CONNECTION_CLEANUP_INTERVAL;
            if (interval != null && Integer.parseInt(interval) > 0) {
                this.m_properties.put("HTTP_CONNECTION_CLEANUP_INTERVAL", interval);
            } else {
                this.m_properties.remove("HTTP_CONNECTION_CLEANUP_INTERVAL");
            }
        }
        HttpTunnelHandler handler = null;
        String path = request.getRequestURI();
        if (path.startsWith(this.TUNNEL_PATH)) {
            handler = HttpTunnelHandler.getTunnelHandler(this.m_properties);
        }
        return handler;
    }
}

