/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.https.server.tunnel;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import progress.message.net.ProgressInetAddress;
import progress.message.net.http.server.tunnel.HttpConnectionSocket;
import progress.message.net.https.IHttpsSocket;
import progress.message.net.https.server.SonicHttpsServer;
import progress.message.security.cert.X509Certificate;

public class HttpsConnectionSocket
extends HttpConnectionSocket
implements IHttpsSocket {
    private X509Certificate m_clientCert = null;
    private String m_clientDN = null;
    private static int HTTPS_DEFAULT_WRITE_SIZE = 20000;

    public static void sendReplyCode(HttpServletResponse response, int returncode) {
        HttpsConnectionSocket.sendReplyCode(response, returncode, -1);
    }

    private static void commitResponse(HttpServletResponse response) throws IOException {
        if (response instanceof Request) {
            ((Response)response).completeOutput();
        } else {
            response.flushBuffer();
        }
    }

    public static void sendReplyCode(HttpServletResponse response, int returncode, int cid) {
        block2: {
            try {
                response.setIntHeader("Content-Length", 1);
                response.setStatus(returncode);
                response.flushBuffer();
                response.getOutputStream().write(new byte[1]);
                response.getOutputStream().flush();
                HttpsConnectionSocket.commitResponse(response);
            }
            catch (Exception ex) {
                if (!SonicHttpsServer.getDebug()) break block2;
                System.out.println("HTTPS Connection " + cid + ": error writing response " + returncode);
                ex.printStackTrace();
            }
        }
    }

    public HttpsConnectionSocket(ProgressInetAddress addr, int id, X509Certificate cert) {
        super(addr, id);
        HttpsConnectionSocket.setMaxWriteSize(HTTPS_DEFAULT_WRITE_SIZE);
        this.m_clientCert = cert;
        if (cert != null) {
            Principal o = cert.getSubjectDN();
            if (o instanceof Principal) {
                this.m_clientDN = o.getName();
            } else if (o instanceof String) {
                this.m_clientDN = (String)((Object)o);
            }
        }
    }

    @Override
    public X509Certificate getPeerCertificate() {
        return this.m_clientCert;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() {
        return new X509Certificate[]{this.m_clientCert};
    }

    public boolean isClient(X509Certificate cert) {
        if (this.m_clientCert == null) {
            return true;
        }
        String s = null;
        Principal o = cert.getSubjectDN();
        if (o instanceof Principal) {
            s = o.getName();
        } else if (o instanceof String) {
            s = (String)((Object)o);
        }
        return s != null ? s.equalsIgnoreCase(this.m_clientDN) : false;
    }

    @Override
    public void handleError(HttpServletResponse response, boolean closeClient, int status) throws IOException {
        this.clientClose();
        response.setIntHeader("Content-Length", 4);
        response.setStatus(200);
        response.flushBuffer();
        int size = -1;
        this.writeData(response, size);
    }

    @Override
    protected void prepareClientReadResponseHeader(HttpServletResponse response, int status, int mid, int size) throws IOException {
        response.setIntHeader(READ_SEQ_NUM, mid);
        response.setStatus(status);
        response.setIntHeader("Content-Length", size + 4);
        response.flushBuffer();
        OutputStream out = this.retrieveAndWrite(response, size);
    }

    @Override
    protected void sendNoDataResponse(HttpServletResponse response) throws IOException {
        int size = 0;
        response.setIntHeader("Content-Length", 4);
        response.setStatus(200);
        response.flushBuffer();
        this.writeData(response, size);
    }

    private void writeData(HttpServletResponse response, int size) throws IOException {
        OutputStream out = this.retrieveAndWrite(response, size);
        out.flush();
        HttpsConnectionSocket.commitResponse(response);
    }

    private OutputStream retrieveAndWrite(HttpServletResponse response, int size) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        out.write((byte)(size >>> 24 & 0xFF));
        out.write((byte)(size >>> 16 & 0xFF));
        out.write((byte)(size >>> 8 & 0xFF));
        out.write((byte)(size & 0xFF));
        return out;
    }
}

