/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.client.EGeneralException;
import progress.message.util.AutoVec;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IDirectSender;
import progress.message.zclient.xonce.ChannelDoubtResolver;
import progress.message.zclient.xonce.ConnectionSyncResolver;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;
import progress.message.zclient.xonce.SecondaryStateResolver;

public class SocketDoubtResolver
extends DebugObject
implements IDoubtResolver,
IDoubtResolverCompletionListener {
    Vector m_dependents = new Vector();
    IDoubtResolverCompletionListener m_listener = null;
    ConnectionSyncResolver m_connectionSyncResolver = null;
    Connection m_connectionZero = null;
    AutoVec m_channelsToResolve = null;

    public SocketDoubtResolver(Connection connectionZero) {
        super("SocketDoubtResolver");
        this.m_connectionZero = connectionZero;
        this.m_channelsToResolve = this.m_connectionZero.cloneBrethren();
    }

    @Override
    public void onDisconnectDuringResolution() {
        for (int i = 0; i < this.m_channelsToResolve.size(); ++i) {
            Connection c = (Connection)this.m_channelsToResolve.elementAt(i);
            if (c == null || c.getChannel() == 0) continue;
            c.terminateSyncOps(-5, false);
            c.getConnectionInfo().onDisconnectDuringResolution();
        }
    }

    public void initiateSecondaryStateResolution() throws EGeneralException, IOException {
        SecondaryStateResolver ssr;
        this.m_dependents.clear();
        Enumeration e = this.m_channelsToResolve.elements();
        while (e.hasMoreElements()) {
            Connection con = (Connection)e.nextElement();
            if (con == null || !con.isConnected()) continue;
            ssr = new SecondaryStateResolver(con);
            ssr.setCompletionListener(this);
            this.m_dependents.add(ssr);
        }
        Vector v = (Vector)this.m_dependents.clone();
        if (v.isEmpty()) {
            if (this.m_listener != null) {
                this.m_listener.completed(this, 0);
            }
            return;
        }
        e = v.elements();
        while (e.hasMoreElements()) {
            ssr = (SecondaryStateResolver)e.nextElement();
            ssr.initiateResolution();
        }
    }

    @Override
    public void initiateResolution() throws EGeneralException, IOException {
        this.m_connectionZero.performPostConnectOperations(true);
        this.m_connectionSyncResolver = new ConnectionSyncResolver((IDirectSender)((Object)this.m_connectionZero.getSender()), this.m_channelsToResolve);
        this.m_connectionZero.setConnectionSyncHandler(this.m_connectionSyncResolver);
        this.m_connectionSyncResolver.setCompletionListener(this);
        this.m_connectionSyncResolver.initiateResolution();
    }

    private void startChannelIDR() throws EGeneralException, IOException {
        ChannelDoubtResolver cdr;
        Enumeration e = this.m_channelsToResolve.elements();
        while (e.hasMoreElements()) {
            Connection con = (Connection)e.nextElement();
            if (con == null || !con.isConnected()) continue;
            cdr = new ChannelDoubtResolver(con);
            cdr.setCompletionListener(this);
            this.m_dependents.add(cdr);
        }
        Vector v = (Vector)this.m_dependents.clone();
        e = v.elements();
        while (e.hasMoreElements()) {
            cdr = (ChannelDoubtResolver)e.nextElement();
            cdr.initiateResolution();
        }
    }

    @Override
    public void setCompletionListener(IDoubtResolverCompletionListener listener) {
        this.m_listener = listener;
    }

    @Override
    public void failed(IDoubtResolver resolver, IOException ioe) {
        this.m_dependents.clear();
        if (this.m_listener != null) {
            this.m_listener.failed(this, ioe);
        }
    }

    @Override
    public void completed(IDoubtResolver resolver, int status) {
        try {
            if (resolver == this.m_connectionSyncResolver) {
                this.completeDisconnectingChannels();
                this.startChannelIDR();
            } else {
                this.m_dependents.remove(resolver);
            }
        }
        catch (IOException e) {
            if (this.m_listener != null) {
                this.m_listener.failed(this, e);
            }
            return;
        }
        if (this.m_dependents.isEmpty() && this.m_listener != null) {
            this.m_listener.completed(this, status);
        }
    }

    private void completeDisconnectingChannels() {
        for (int i = 0; i < this.m_channelsToResolve.size(); ++i) {
            Connection c = (Connection)this.m_channelsToResolve.elementAt(i);
            if (c == null || !c.removeTunnelIfDisconnecting()) continue;
            this.m_channelsToResolve.setElementAt(null, i);
        }
    }
}

