/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.ITypeCollection;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.AttributeMetaData;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.AttributeSetType;
import com.sonicsw.mf.common.config.impl.DeltaAttributeList;
import com.sonicsw.mf.common.config.impl.ElementNode;
import com.sonicsw.mf.common.config.impl.ICanReplaceRef;
import com.sonicsw.mf.common.config.impl.IChangeRegistration;
import com.sonicsw.mf.common.config.impl.IDelta;
import com.sonicsw.mf.common.config.impl.IDeltaBookKeeper;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.impl.TypeCollection;
import com.sonicsw.mf.common.config.impl.Util;
import com.sonicsw.mf.common.config.query.AttributeName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

final class AttributeList
extends ElementNode
implements IAttributeList,
Serializable,
ICanReplaceRef {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private static final int DELETED_ITEM = 1;
    private static final int MODIFIED_ITEM = 2;
    private TypeCollection m_typeCollection = null;
    private ArrayList m_list = new ArrayList();
    private transient HashMap m_modHistory = null;
    private transient OrdinalMap m_newOldMap = null;

    AttributeList(String name, ElementNode parent) {
        super(name, parent);
    }

    int estimateSize() {
        int estimate = 64;
        if (this.m_typeCollection != null) {
            estimate += this.m_typeCollection.estimateSize();
        }
        return estimate + Util.estimateArrayListSize(this.m_list);
    }

    Object createDelta(AttributeList list) {
        int thatLength;
        int thisLength = this.getCount();
        if (thisLength != (thatLength = list.getCount())) {
            return list;
        }
        for (int i = 0; i < thisLength; ++i) {
            Object thisValue = this.getItem(i);
            Object thatValue = list.getItem(i);
            Object delta = null;
            delta = thisValue instanceof AttributeSet && thatValue instanceof AttributeSet ? AttributeSet.doTypedDelta(thisValue, thatValue, this.getTypeCollection()) : Util.createDelta(thisValue, null, thatValue, null);
            if (delta == null) continue;
            return list;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeObject(this.m_typeCollection);
        s.writeObject(this.m_list);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_typeCollection = (TypeCollection)s.readObject();
        this.m_list = (ArrayList)s.readObject();
        this.m_modHistory = new HashMap();
        this.m_newOldMap = new OrdinalMap(this.m_list.size());
    }

    @Override
    public void addObjectItem(Object value) throws ReadOnlyException {
        this.addItem(value, true);
    }

    void addItem(Object value, boolean checkType) throws ReadOnlyException {
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
        if (value == null) {
            return;
        }
        if (checkType && !Util.validSimpleValue(value)) {
            throw new IllegalArgumentException(value.getClass().getName() + " is an invalid type.");
        }
        this.m_list.add(value);
        if (!this.isNew()) {
            this.markModified(null, false, false);
        }
    }

    private IAttributeSetType modifyAttributeSetType(String typeName, boolean create) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        if (typeName == null || typeName.length() == 0) {
            throw new ConfigException("Attribute name cannot be null or 0 length.");
        }
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
        IAttributeSetType type = null;
        type = create ? this.getTypeCollection().createAttributeSetType(typeName) : this.getTypeCollection().deleteAttributeSetType(typeName);
        if (this.isNew()) {
            return type;
        }
        this.markTreeModified();
        this.removeDeltaHistory();
        return type;
    }

    private TypeCollection getTypeCollection() {
        if (this.m_typeCollection == null) {
            this.m_typeCollection = new TypeCollection();
        }
        return this.m_typeCollection;
    }

    private void setItem(int position, Object value, boolean checkEquality) throws IndexOutOfBoundsException, ReadOnlyException {
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
        this.validatePosition(position);
        if (value == null) {
            this.deleteAttributeItem(position);
        }
        if (checkEquality && Util.atomicAndEqual(value, this.m_list.get(position))) {
            return;
        }
        this.m_list.set(position, value);
        if (!this.isNew()) {
            this.markModified(new Integer(position).toString(), this.m_newOldMap.isOldItem(position), false);
        }
    }

    private void insertItem(int position, Object value) throws IndexOutOfBoundsException, ReadOnlyException {
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
        this.validatePosition(position);
        if (value == null) {
            return;
        }
        this.m_list.add(position, value);
        this.removeDeltaHistory();
    }

    @Override
    void delete() {
    }

    @Override
    Object getNameFromParent(Object listItem) {
        int position = this.m_list.indexOf(listItem);
        if (this.m_newOldMap != null) {
            position = this.m_newOldMap.getOldPosition(position);
        }
        return new Integer(position);
    }

    @Override
    void markModified(String elementNum, boolean oldIsModified, boolean deletion) {
        boolean isAdded;
        if (this.isNew()) {
            return;
        }
        boolean bl = isAdded = elementNum == null;
        if (!isAdded && oldIsModified) {
            int position = new Integer(elementNum);
            int oldPosition = this.m_newOldMap.getOldPosition(position);
            if (deletion) {
                this.m_newOldMap.remove(position);
            }
            this.m_modHistory.put(new Integer(oldPosition), new Integer(deletion ? 1 : 2));
        }
        this.markTreeModified();
    }

    @Override
    public Object getAttribute(AttributeName attributeName) {
        int componentCount = attributeName.getComponentCount();
        if (componentCount == 0) {
            return null;
        }
        Object firstComponenet = attributeName.getComponent(0);
        if (firstComponenet instanceof String) {
            return null;
        }
        Object thisLevel = null;
        try {
            thisLevel = this.getItem((Integer)firstComponenet);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        if (componentCount == 1 || thisLevel == null) {
            return thisLevel;
        }
        AttributeName nextLevelsname = com.sonicsw.mf.common.config.query.impl.Util.removeFirstComponent((AttributeName)attributeName);
        if (thisLevel instanceof AttributeSet) {
            return ((AttributeSet)thisLevel).getAttribute(nextLevelsname);
        }
        if (thisLevel instanceof AttributeList) {
            return ((AttributeList)thisLevel).getAttribute(nextLevelsname);
        }
        return null;
    }

    @Override
    public void removeDeltaHistory() {
        this.m_isNew = true;
        this.m_newOldMap = null;
        this.m_modHistory = null;
        this.m_list.trimToSize();
    }

    private void validatePosition(int position) throws IndexOutOfBoundsException {
        if (position < 0 || position >= this.m_list.size()) {
            throw new IndexOutOfBoundsException(this.getFullName() + " list size is: " + this.m_list.size());
        }
    }

    @Override
    public void applyDelta(IDelta delta) throws AttributeSetTypeException {
        int i;
        if (!(delta instanceof DeltaAttributeList)) {
            throw new Error("Not an attribute list delta.");
        }
        DeltaAttributeList deltaList = (DeltaAttributeList)delta;
        HashMap modifiedItems = deltaList.getModifiedItems();
        int[] deletedItem = deltaList.getDeletedItemNumbers();
        Object[] newItems = deltaList.getNewItems();
        for (int i2 = 0; i2 < newItems.length; ++i2) {
            Object newValue = newItems[i2];
            if (newValue instanceof AttributeSet) {
                ((AttributeSet)newValue).createLocalTypedSet(this.m_typeCollection);
            }
            if (newValue instanceof ElementNode) {
                ((ElementNode)newValue).setNewParent(this);
            }
            this.m_list.add(newValue);
        }
        Set set = modifiedItems.keySet();
        for (Integer position : set) {
            Object newValue = modifiedItems.get(position);
            Object oldValue = this.m_list.get(position);
            if (newValue instanceof IDelta) {
                if (oldValue == null || !(oldValue instanceof IDeltaBookKeeper)) {
                    throw new Error("Cannot apply the delta to the old value.");
                }
                ((IDeltaBookKeeper)oldValue).applyDelta((IDelta)newValue);
                continue;
            }
            if (newValue instanceof AttributeSet) {
                ((AttributeSet)newValue).createLocalTypedSet(this.m_typeCollection);
            }
            if (newValue instanceof ElementNode) {
                ((ElementNode)newValue).setNewParent(this);
            }
            this.m_list.set(position, newValue);
            if (!(oldValue instanceof ElementNode)) continue;
            ((ElementNode)oldValue).delete();
        }
        for (i = 0; i < deletedItem.length; ++i) {
            Object oldValue = this.m_list.set(deletedItem[i], null);
            if (!(oldValue instanceof ElementNode)) continue;
            ((ElementNode)oldValue).delete();
        }
        for (i = this.m_list.size() - 1; i >= 0; --i) {
            if (this.m_list.get(i) != null) continue;
            this.m_list.remove(i);
        }
        this.m_list.trimToSize();
    }

    @Override
    public int getCount() {
        return this.m_list.size();
    }

    @Override
    boolean underModifiedList() {
        if (this.m_isModified) {
            return true;
        }
        return super.underModifiedList();
    }

    @Override
    public IAttributeMetaData getItemMetaData(int position) throws IndexOutOfBoundsException {
        this.getItem(position);
        boolean fromTamplate = this.isNew() || this.m_isModified || this.underModifiedList() ? false : this.checkSubclassingDelta(this.getCompoundName().setNextComponent(position));
        return new AttributeMetaData(fromTamplate);
    }

    @Override
    public Object getItem(int position) throws IndexOutOfBoundsException {
        return this.m_list.get(position);
    }

    @Override
    public IAttributeList setNewAttributeListItem(int position) throws IndexOutOfBoundsException, ReadOnlyException {
        AttributeList newList = new AttributeList(null, this);
        this.setItem(position, newList, false);
        return newList;
    }

    @Override
    public IAttributeList insertAttributeListItem(int position) throws IndexOutOfBoundsException, ReadOnlyException {
        AttributeList newList = new AttributeList(null, this);
        this.insertItem(position, newList);
        return newList;
    }

    @Override
    public IAttributeList addNewAttributeListItem() throws ReadOnlyException {
        int position = this.m_list.size();
        AttributeList newList = new AttributeList(null, this);
        this.addItem(newList, false);
        return newList;
    }

    @Override
    public IAttributeSet setNewAttributeSetItem(int position) throws IndexOutOfBoundsException, ReadOnlyException {
        try {
            return this.setNewAttributeSetItem(position, null);
        }
        catch (AttributeSetTypeException e) {
            throw new Error();
        }
    }

    @Override
    public IAttributeSet insertAttributeSetItem(int position) throws IndexOutOfBoundsException, ReadOnlyException {
        try {
            return this.insertAttributeSetItem(position, null);
        }
        catch (AttributeSetTypeException e) {
            throw new Error();
        }
    }

    @Override
    public IAttributeSet addNewAttributeSetItem() throws ReadOnlyException {
        try {
            return this.addNewAttributeSetItem(null);
        }
        catch (AttributeSetTypeException e) {
            throw new Error();
        }
    }

    @Override
    public IAttributeSet setNewAttributeSetItem(int position, IAttributeSetType type) throws IndexOutOfBoundsException, ReadOnlyException, AttributeSetTypeException {
        if (type != null) {
            this.m_typeCollection.verifyType((AttributeSetType)type, this.getFullName());
        }
        this.setItem(position, "PLACE HOLDER", false);
        AttributeSet set = new AttributeSet(null, (ElementNode)this, (AttributeSetType)type);
        this.m_list.set(position, set);
        return set;
    }

    @Override
    public IAttributeSet insertAttributeSetItem(int position, IAttributeSetType type) throws IndexOutOfBoundsException, ReadOnlyException, AttributeSetTypeException {
        if (type != null) {
            this.m_typeCollection.verifyType((AttributeSetType)type, this.getFullName());
        }
        this.insertItem(position, "PLACE HOLDER");
        AttributeSet set = new AttributeSet(null, (ElementNode)this, (AttributeSetType)type);
        this.m_list.set(position, set);
        return set;
    }

    @Override
    public IAttributeSet addNewAttributeSetItem(IAttributeSetType type) throws ReadOnlyException, AttributeSetTypeException {
        if (type != null) {
            this.m_typeCollection.verifyType((AttributeSetType)type, this.getFullName());
        }
        this.addItem("PLACE HOLDER", false);
        int position = this.m_list.size() - 1;
        AttributeSet set = new AttributeSet(null, (ElementNode)this, (AttributeSetType)type);
        this.m_list.set(position, set);
        return set;
    }

    @Override
    public Object deleteAttributeItem(int position) throws IndexOutOfBoundsException, ReadOnlyException {
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
        this.validatePosition(position);
        Object oldItem = this.m_list.get(position);
        if (!this.isNew()) {
            this.markModified(new Integer(position).toString(), this.m_newOldMap.isOldItem(position), true);
        }
        this.m_list.remove(position);
        if (oldItem instanceof ElementNode) {
            ((ElementNode)oldItem).removeFromTree();
        }
        return oldItem;
    }

    @Override
    public ArrayList getItems() {
        return (ArrayList)this.m_list.clone();
    }

    @Override
    public IDelta createDelta(boolean forSubclassing) {
        if (this.isNew()) {
            throw new Error();
        }
        int[] deletedArray = new int[this.m_newOldMap.getDeletedCount()];
        HashMap<Integer, Object> deltaVals = new HashMap<Integer, Object>();
        Set set = this.m_modHistory.keySet();
        Iterator iterator = set.iterator();
        int deletedIndex = 0;
        while (iterator.hasNext()) {
            Integer oldPosition = (Integer)iterator.next();
            int historyEvent = (Integer)this.m_modHistory.get(oldPosition);
            if (historyEvent == 1) {
                deletedArray[deletedIndex++] = oldPosition;
                continue;
            }
            int newPosition = this.m_newOldMap.getNewPosition(oldPosition);
            Object newValue = this.m_list.get(newPosition);
            if (newValue instanceof IDeltaBookKeeper) {
                IDeltaBookKeeper deltaKeeper = (IDeltaBookKeeper)newValue;
                if (forSubclassing && newValue instanceof AttributeList) {
                    deltaKeeper.removeDeltaHistory();
                }
                if (deltaKeeper.isNew()) {
                    if (deltaKeeper instanceof ElementNode) {
                        deltaKeeper = (IDeltaBookKeeper)((ElementNode)deltaKeeper).cloneWithoutParent();
                    }
                    deltaVals.put(oldPosition, deltaKeeper);
                    continue;
                }
                deltaVals.put(oldPosition, deltaKeeper.createDelta(forSubclassing));
                continue;
            }
            if (newValue instanceof ElementNode) {
                newValue = ((ElementNode)newValue).cloneWithoutParent();
            }
            deltaVals.put(oldPosition, newValue);
        }
        int numNewItems = this.m_list.size() - this.m_newOldMap.numOldLeft();
        Object[] newItems = new Object[numNewItems];
        int newIndex = 0;
        for (int i = this.m_list.size() - numNewItems; i < this.m_list.size(); ++i) {
            newItems[newIndex++] = this.m_list.get(i);
        }
        return new DeltaAttributeList(deletedArray, deltaVals, newItems);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        if (this.m_typeCollection != null) {
            this.m_typeCollection.setReadOnly(readOnly);
        }
        if (readOnly) {
            this.m_list.trimToSize();
        }
        for (int i = 0; i < this.m_list.size(); ++i) {
            Object value = this.m_list.get(i);
            if (!(value instanceof ElementNode)) continue;
            ((ElementNode)value).setReadOnly(readOnly);
        }
    }

    @Override
    public IAttributeSetType createAttributeSetType(String typeName) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        return this.modifyAttributeSetType(typeName, true);
    }

    @Override
    public IAttributeSetType deleteAttributeSetType(String typeName) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        return this.modifyAttributeSetType(typeName, false);
    }

    @Override
    public boolean typesEqual(ITypeCollection c) {
        if (!(c instanceof AttributeList)) {
            return false;
        }
        return this.getTypeCollection().typesEqual(((AttributeList)c).getTypeCollection());
    }

    @Override
    public String[] getAllTypeNames() {
        return this.getTypeCollection().getAllTypeNames();
    }

    @Override
    public IAttributeSetType getAttributeSetType(String typeName) {
        return this.getTypeCollection().getAttributeSetType(typeName);
    }

    @Override
    public void setNewStringItem(int position, String value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.setItem(position, value, true);
    }

    @Override
    public void setNewIntegerItem(int position, Integer value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.setItem(position, value, true);
    }

    @Override
    public void setNewLongItem(int position, Long value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.setItem(position, value, true);
    }

    @Override
    public void setNewDecimalItem(int position, BigDecimal value) throws IndexOutOfBoundsException, ReadOnlyException {
        try {
            if (value != null) {
                value.toString();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.setItem(position, value, true);
    }

    @Override
    public void setNewBytesItem(int position, byte[] value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.setItem(position, value, true);
    }

    @Override
    public void setNewBooleanItem(int position, Boolean value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.setItem(position, value, true);
    }

    @Override
    public void setNewReferenceItem(int position, Reference value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.setItem(position, value, true);
    }

    @Override
    public void setNewDateItem(int position, Date value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.setItem(position, value, true);
    }

    @Override
    public void insertStringItem(int position, String value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.insertItem(position, value);
    }

    @Override
    public void insertIntegerItem(int position, Integer value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.insertItem(position, value);
    }

    @Override
    public void insertLongItem(int position, Long value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.insertItem(position, value);
    }

    @Override
    public void insertDecimalItem(int position, BigDecimal value) throws IndexOutOfBoundsException, ReadOnlyException {
        try {
            if (value != null) {
                value.toString();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.insertItem(position, value);
    }

    @Override
    public void insertBytesItem(int position, byte[] value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.insertItem(position, value);
    }

    @Override
    public void insertBooleanItem(int position, Boolean value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.insertItem(position, value);
    }

    @Override
    public void insertReferenceItem(int position, Reference value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.insertItem(position, value);
    }

    @Override
    public void insertDateItem(int position, Date value) throws IndexOutOfBoundsException, ReadOnlyException {
        this.insertItem(position, value);
    }

    @Override
    public void addStringItem(String value) throws ReadOnlyException {
        this.addItem(value, false);
    }

    @Override
    public void addIntegerItem(Integer value) throws ReadOnlyException {
        this.addItem(value, false);
    }

    @Override
    public void addLongItem(Long value) throws ReadOnlyException {
        this.addItem(value, false);
    }

    @Override
    public void addDecimalItem(BigDecimal value) throws ReadOnlyException {
        try {
            if (value != null) {
                value.toString();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.addItem(value, false);
    }

    @Override
    public void addBytesItem(byte[] value) throws ReadOnlyException {
        this.addItem(value, false);
    }

    @Override
    public void addBooleanItem(Boolean value) throws ReadOnlyException {
        this.addItem(value, false);
    }

    @Override
    public void addReferenceItem(Reference value) throws ReadOnlyException {
        this.addItem(value, false);
    }

    @Override
    public void addDateItem(Date value) throws ReadOnlyException {
        this.addItem(value, false);
    }

    @Override
    public void registerAttributeChangeHandler(Object context, IAttributeChangeHandler handler) {
        this.validateRegistrationContext(context);
        ((IChangeRegistration)context).registerAttributeChangeHandler(this.getCompoundName(), handler);
    }

    @Override
    public void unregisterAttributeChangeHandler(Object context) {
        this.validateRegistrationContext(context);
        ((IChangeRegistration)context).unregisterAttributeChangeHandler(this.getCompoundName());
    }

    @Override
    public void registerAttributeChangeHandler(Object context, int position, IAttributeChangeHandler handler) {
        this.validateRegistrationContext(context);
        this.m_list.get(position);
        ((IChangeRegistration)context).registerAttributeChangeHandler(this.getCompoundName().setNextComponent(position), handler);
    }

    @Override
    public void unregisterAttributeChangeHandler(Object context, int position) {
        this.validateRegistrationContext(context);
        ((IChangeRegistration)context).unregisterAttributeChangeHandler(this.getCompoundName().setNextComponent(position));
    }

    private void validateRegistrationContext(Object context) {
        if (context == null || !(context instanceof IChangeRegistration)) {
            throw new IllegalArgumentException("The context object is invalid.");
        }
    }

    @Override
    public boolean replaceReferences(boolean isSystemAtts, IReplaceRef replaceSrvc) {
        boolean retVal = true;
        for (int i = 0; i < this.getCount(); ++i) {
            Object value = this.getItem(i);
            if (value instanceof ICanReplaceRef) {
                boolean ret = ((ICanReplaceRef)value).replaceReferences(false, replaceSrvc);
                if (ret) continue;
                retVal = false;
                continue;
            }
            if (!(value instanceof Reference)) continue;
            Reference newRef = replaceSrvc.replace((Reference)value);
            if (newRef.getElementName().startsWith("/NO_STORAGE:")) {
                retVal = false;
            }
            this.m_list.set(i, newRef);
        }
        return retVal;
    }

    static class OrdinalMap {
        private ArrayList newToOldMap;
        private int[] oldToNewMap;
        private int lastOldItem;

        OrdinalMap(int sizeofOld) {
            int i;
            this.newToOldMap = new ArrayList(sizeofOld);
            for (i = 0; i < sizeofOld; ++i) {
                this.newToOldMap.add(new Integer(i));
            }
            this.oldToNewMap = new int[sizeofOld];
            for (i = 0; i < sizeofOld; ++i) {
                this.oldToNewMap[i] = i;
            }
            this.lastOldItem = sizeofOld - 1;
        }

        int getOldPosition(int newPosition) {
            return (Integer)this.newToOldMap.get(newPosition);
        }

        int getNewPosition(int oldPosition) {
            return this.oldToNewMap[oldPosition];
        }

        int getDeletedCount() {
            return this.oldToNewMap.length - this.lastOldItem - 1;
        }

        int numOldLeft() {
            return this.oldToNewMap.length - this.getDeletedCount();
        }

        boolean isOldItem(int position) {
            return position <= this.lastOldItem;
        }

        void remove(int position) {
            --this.lastOldItem;
            this.newToOldMap.remove(position);
            boolean deleted = false;
            for (int i = 0; i < this.oldToNewMap.length; ++i) {
                if (deleted) {
                    int n = i;
                    this.oldToNewMap[n] = this.oldToNewMap[n] - 1;
                }
                if (position != this.oldToNewMap[i]) continue;
                this.oldToNewMap[i] = -1;
                deleted = true;
            }
        }
    }
}

