/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IChunkedBlobStreamer;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Blob
implements IBlob,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private static final String IS_LOGICAL_NAME_ATTR = "IS_LOGICAL_NAME";
    IDirElement m_element;
    byte[] m_blob;
    transient IChunkedBlobStreamer m_streamer;
    transient InputStream m_blobStream;
    boolean m_logical = false;

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        try {
            this.storeLogicalFlag();
        }
        catch (Exception e) {
            throw new IOException("Unable to serialize logical flag for blob " + this.m_element.getIdentity().getName() + ": " + e.toString());
        }
        s.writeObject(this.m_element);
        s.writeObject(this.m_blob);
    }

    private void storeLogicalFlag() throws Exception {
        Blob.markBlobState((Element)this.m_element, this.m_logical, IS_LOGICAL_NAME_ATTR);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            throw new IOException("Serialization version mismatch. Serialized object version: " + version + " class version: " + 3);
        }
        this.m_element = (IDirElement)s.readObject();
        this.m_blob = (byte[])s.readObject();
        this.m_logical = this.retrieveLogicalFlag();
    }

    private boolean retrieveLogicalFlag() {
        Boolean logicalObject;
        boolean logical = false;
        IAttributeSet topSet = this.m_element.getAttributes();
        IAttributeSet systemAttributes = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        if (systemAttributes != null && (logicalObject = (Boolean)systemAttributes.getAttribute(IS_LOGICAL_NAME_ATTR)) != null) {
            logical = logicalObject;
        }
        return logical;
    }

    public Blob replaceElement(IDirElement element) {
        return new Blob(element, this.m_blob, this.m_streamer, this.m_logical);
    }

    public static boolean isExpandableFile(File localFile) {
        if (localFile.exists()) {
            try {
                Attributes attrs;
                String expandValue;
                JarFile jarFile = new JarFile(localFile);
                Manifest blobManifest = jarFile.getManifest();
                if (blobManifest != null && (expandValue = (attrs = blobManifest.getMainAttributes()).getValue("SONIC_EXPAND_IN_CACHE")) != null) {
                    jarFile.close();
                    return expandValue.equals("true");
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!"meta-inf/sonic.xml".equalsIgnoreCase(entry.getName())) continue;
                    jarFile.close();
                    return true;
                }
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isIncompleteBlob(IDirElement element) {
        IAttributeSet topSet = element.getAttributes();
        Object systemAttrs = topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        Integer blobState = null;
        if (systemAttrs != null) {
            blobState = (Integer)((IAttributeSet)systemAttrs).getAttribute("LARGE_FILE_STATE");
        }
        return blobState != null && blobState.equals(INCOMPLETE);
    }

    public static void markBlobState(Element element, Object blobState, String attribute) throws Exception {
        boolean readOnly = element.isReadOnly();
        element.setReadOnly(false);
        IAttributeSet topSet = element.getAttributes();
        Object systemAttributes = topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        ((AttributeSet)topSet).setReadOnly(false);
        if (systemAttributes == null) {
            systemAttributes = topSet.createAttributeSet("_MF_SYSTEM_ATTRIBUTES");
        }
        ((AttributeSet)systemAttributes).setReadOnly(false);
        if (blobState instanceof Integer) {
            ((IAttributeSet)systemAttributes).setIntegerAttribute(attribute, (Integer)blobState);
        } else if (blobState instanceof String) {
            ((IAttributeSet)systemAttributes).setStringAttribute(attribute, (String)blobState);
        } else if (blobState instanceof Boolean) {
            ((IAttributeSet)systemAttributes).setBooleanAttribute(attribute, (Boolean)blobState);
        }
        element.setReadOnly(readOnly);
        ((AttributeSet)topSet).setReadOnly(readOnly);
        ((AttributeSet)systemAttributes).setReadOnly(readOnly);
    }

    public static Object getBlobState(Element element, String attribute) {
        IAttributeSet topSet = element.getAttributes();
        if (topSet == null) {
            return null;
        }
        IAttributeSet systemAttributes = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
        if (systemAttributes == null) {
            return null;
        }
        return systemAttributes.getAttribute(attribute);
    }

    public Blob(IDirElement element, byte[] blob, IChunkedBlobStreamer streamer) {
        this.m_element = element;
        this.m_blob = blob;
        this.m_streamer = streamer;
    }

    public Blob(IDirElement element, byte[] blob) {
        this.m_element = element;
        this.m_blob = blob;
        this.m_streamer = null;
    }

    public Blob(IDirElement element, InputStream stream) {
        this.m_element = element;
        this.m_streamer = null;
        this.m_blobStream = stream;
    }

    Blob(IDirElement element, byte[] blob, IChunkedBlobStreamer streamer, boolean logical) {
        this(element, blob, streamer);
        this.m_logical = logical;
    }

    @Override
    public IDirElement getElement() {
        return this.m_element;
    }

    @Override
    public void setLogical(boolean logical) {
        this.m_logical = logical;
    }

    @Override
    public boolean isLogicalName() {
        return this.m_logical;
    }

    @Override
    public InputStream getBlobStream() {
        if (this.m_blobStream != null) {
            return this.m_blobStream;
        }
        if (this.m_blob == null) {
            return null;
        }
        return new BlobInputStream(this.m_blob);
    }

    @Override
    public byte[] getBlobBytes() {
        if (this.m_blob == null) {
            return null;
        }
        return this.m_blob;
    }

    class BlobInputStream
    extends InputStream {
        int m_chunkIndex = 0;
        int m_pos = 0;
        int m_count;
        byte[] m_buf;

        BlobInputStream(byte[] bytes) {
            this.m_buf = bytes;
            this.m_count = this.m_buf.length;
        }

        @Override
        public int available() {
            return this.m_count - this.m_pos;
        }

        @Override
        public int read() {
            this.nextChunkIfNeeded();
            if (this.eof()) {
                return -1;
            }
            int r = this.m_buf[this.m_pos++] & 0xFF;
            return r;
        }

        private void nextChunkIfNeeded() throws Error {
            try {
                if (Blob.this.m_streamer != null && this.m_pos == 1000000) {
                    ++this.m_chunkIndex;
                    IBlob blob = Blob.this.m_logical ? Blob.this.m_streamer.getFSBlob(Blob.this.m_element.getIdentity().getName(), false, this.m_chunkIndex * this.m_pos) : Blob.this.m_streamer.getBlob(Blob.this.m_element.getIdentity().getName(), false, this.m_chunkIndex * this.m_pos);
                    this.m_buf = blob.getBlobBytes();
                    this.m_pos = 0;
                    this.m_count = this.m_buf.length;
                }
            }
            catch (Exception dirE) {
                throw new Error(dirE.toString());
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.nextChunkIfNeeded();
            if (this.eof()) {
                return -1;
            }
            int read = Math.min(len, this.available());
            System.arraycopy(this.m_buf, this.m_pos, b, off, read);
            this.m_pos += read;
            return read;
        }

        private boolean eof() {
            return this.m_buf == null || this.m_pos == this.m_count;
        }
    }
}

