/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.runtime.impl;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.common.runtime.ISubComponentState;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ComponentIdentity;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;

public final class SubComponentState
implements ISubComponentState,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final short m_serialVersion = 0;
    private IComponentIdentity m_componentID;
    private String m_subComponentName;
    private String m_subComponentType;
    private short m_state;

    public SubComponentState(CanonicalName componentName, IElementIdentity componentConfigID, String subComponentName, String subComponentType, short state) {
        this.m_componentID = new ComponentIdentity(componentName, componentConfigID);
        this.m_subComponentName = subComponentName;
        this.m_subComponentType = subComponentType;
        this.m_state = state;
    }

    @Override
    public IIdentity getRuntimeIdentity() {
        return this.m_componentID;
    }

    @Override
    public String getSubComponentName() {
        return this.m_subComponentName;
    }

    @Override
    public String getSubComponentType() {
        return this.m_subComponentType;
    }

    @Override
    public short getState() {
        return this.m_state;
    }

    public void setState(short state) {
        if (state < 0 || state > 4) {
            throw new IllegalArgumentException("Invalid component state: " + state);
        }
        this.m_state = state;
    }

    @Override
    public String getStateString() {
        return ISubComponentState.STATE_TEXT[this.getState()];
    }

    public String toString() {
        return this.getStateString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ISubComponentState)) {
            return false;
        }
        if (!this.getRuntimeIdentity().equals(((IState)object).getRuntimeIdentity())) {
            return false;
        }
        if (!this.getSubComponentName().equals(((ISubComponentState)object).getSubComponentName())) {
            return false;
        }
        return this.getState() == ((ISubComponentState)object).getState();
    }

    public int hashCode() {
        return Objects.hash(this.getRuntimeIdentity(), this.getSubComponentName(), this.getState());
    }

    @Override
    public int compareTo(Object object) throws ClassCastException {
        return this.toString().compareTo(((ISubComponentState)object).toString());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(5);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("componentID");
        stream.writeObject(this.m_componentID);
        stream.writeUTF("subComponentName");
        stream.writeObject(this.m_subComponentName);
        stream.writeUTF("subComponentType");
        stream.writeObject(this.m_subComponentType);
        stream.writeUTF("state");
        stream.writeObject(new Short(this.m_state));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_componentID = (IComponentIdentity)map.get("componentID");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_subComponentName = (String)map.get("subComponentName");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_subComponentType = (String)map.get("subComponentType");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_state = (Short)map.get("state");
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

