/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.jndi.mfcontext;

import com.sonicsw.jndi.mfcontext.MFConnection;
import com.sonicsw.jndi.mfcontext.MFConnectionManager;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mx.jndi.MFNameParser;
import com.sonicsw.mx.jndi.ObjHelper;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;

public class MFContext
implements Context {
    private MFNameParser m_parser = MFNameParser.getInstance();
    Hashtable m_env;
    String m_ctxName;
    String m_fullCtxName;
    private MFConnectionManager m_connMng = null;
    private static final long MF_DEFAULT_IDLETIMEOUT = 300000L;
    private static final long MF_MINIMUM_IDLETIMEOUT = 60000L;
    private static final String MF_DEFAULTDOMAINNAME = "Domain1";
    private static final String CONTEXT_CLASSNAME = Context.class.getName();
    public static final String DOMAIN = "com.sonicsw.jndi.mfcontext.domain";
    public static final String NODE = "com.sonicsw.jndi.mfcontext.node";
    public static final String SECONDARY_PROVIDER_URL = "com.sonicsw.jndi.mfcontext.secondaryProviderURL";
    public static final String SECONDARY_NODE = "com.sonicsw.jndi.mfcontext.secondaryNode";
    public static final String IDLE_TIMEOUT = "com.sonicsw.jndi.mfcontext.idleTimeout";
    public static final String CONNECT_TIMEOUT = "com.sonicsw.jndi.mfcontext.connectTimeout";
    public static final String SOCKET_CONNECT_TIMEOUT = "com.sonicsw.jndi.mfcontext.socketConnectTimeout";
    public static final String REQUEST_TIMEOUT = "com.sonicsw.jndi.mfcontext.requestTimeout";
    private long m_requestTimeout = ConnectorClient.REQUEST_TIMEOUT_DEFAULT;
    public static final String LOOKUP_RETRIES = "com.sonicsw.jndi.mfcontext.lookupRetries";
    private int m_resolveRetries = 0;
    public static final String TRY_BACKUP_ON_FAILURE = "com.sonicsw.jndi.mfcontext.tryBackupOnFailure";
    private static final String VERBOSE_TRACING = "com.sonicsw.jndi.mfcontext.verbose";
    private boolean m_verboseTracing = false;
    public static final String ENABLE_CACHE = "com.sonicsw.jndi.mfcontext.enableCache";
    public static final String CACHE_EXPIRATION_TIMEOUT = "com.sonicsw.jndi.mfcontext.cacheExpirationTimeout";
    public static final String CACHE_NAME = "com.sonicsw.jndi.mfcontext.cacheName";
    public static final String CACHE_SIZE = "com.sonicsw.jndi.mfcontext.cacheSize";
    public static final String USE_LOCK_MANAGER = "com.sonicsw.jndi.mfcontext.useLockManager";
    private LookupStrategy lookupStrategy;

    MFContext(MFContext ctx, String ctxName) {
        this.m_connMng = ctx.m_connMng;
        this.m_env = ctx.m_env;
        this.m_verboseTracing = this.m_env.get(VERBOSE_TRACING) != null ? new Boolean((String)this.m_env.get(VERBOSE_TRACING)) : Boolean.getBoolean(VERBOSE_TRACING);
        if (!ctxName.startsWith("/")) {
            ctxName = '/' + ctxName;
        }
        this.m_fullCtxName = ctx.m_fullCtxName + ctxName;
        try {
            this.m_ctxName = new EntityName(this.m_fullCtxName).getBaseName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_connMng.incRefCount();
        this.setupLookupStrategy();
    }

    private void setupLookupStrategy() {
        this.lookupStrategy = this.isEnterpise() ? new EnterpriseLookupStrategy() : new StandardLookupStrategy();
    }

    boolean isEnterpise() {
        return this.m_connMng.getConnection().isEnterpise();
    }

    public MFContext(String urls, String ctxDirName, Hashtable env) throws NamingException {
        String socketConnectTimeout;
        this.m_verboseTracing = env.get(VERBOSE_TRACING) != null ? new Boolean((String)env.get(VERBOSE_TRACING)) : Boolean.getBoolean(VERBOSE_TRACING);
        String domainName = (String)env.get(DOMAIN);
        if (domainName == null) {
            domainName = MF_DEFAULTDOMAINNAME;
        }
        long idleTimeout = this.getIdleTimeout((String)env.get(IDLE_TIMEOUT));
        String node = (String)env.get(NODE);
        String connectTimeout = (String)env.get(CONNECT_TIMEOUT);
        if (connectTimeout == null) {
            connectTimeout = Long.toString(10000L);
        }
        if ((socketConnectTimeout = (String)env.get(SOCKET_CONNECT_TIMEOUT)) == null) {
            socketConnectTimeout = Long.toString(5000L);
        } else if (new Long(socketConnectTimeout) < 0L) {
            socketConnectTimeout = Long.toString(5000L);
        }
        String requestTimeout = (String)env.get(REQUEST_TIMEOUT);
        if (requestTimeout == null) {
            requestTimeout = Long.toString(ConnectorClient.REQUEST_TIMEOUT_DEFAULT);
        }
        this.m_requestTimeout = Long.parseLong(requestTimeout);
        String lookupRetries = (String)env.get(LOOKUP_RETRIES);
        if (lookupRetries != null) {
            this.m_resolveRetries = Integer.parseInt(lookupRetries);
        }
        boolean useLockManager = env.get(USE_LOCK_MANAGER) == null ? true : ((String)env.get(USE_LOCK_MANAGER)).equalsIgnoreCase("true");
        this.m_connMng = MFConnectionManager.getManager(urls, (String)env.get("java.naming.security.principal"), (String)env.get("java.naming.security.credentials"), node, domainName, idleTimeout, connectTimeout, socketConnectTimeout, requestTimeout, useLockManager);
        this.init(ctxDirName);
        this.m_env = env == null ? new Hashtable(11, 0.75f) : (Hashtable)env.clone();
        this.m_ctxName = ctxDirName;
        this.setupLookupStrategy();
    }

    private void init(String ctxDirName) throws NamingException {
        String ctxName = "/_MFContext" + (ctxDirName.length() == 0 ? "" : '/' + ctxDirName);
        if (!this.checkExistanceofCtxDirectory(ctxName)) {
            throw new NoInitialContextException(ctxDirName + " context doesn't exist");
        }
        this.m_fullCtxName = ctxName;
    }

    private long getIdleTimeout(String timeout) {
        if (timeout == null) {
            return 300000L;
        }
        long idleTimeout = new Long(timeout);
        return idleTimeout < 60000L ? 60000L : idleTimeout;
    }

    private boolean checkExistanceofCtxDirectory(String ctxName) throws NamingException {
        try {
            if (ctxName.equals("/_MFContext")) {
                this.m_connMng.getConnection().listDirectories(ctxName);
                return true;
            }
            String parent = new EntityName(ctxName).getParent();
            IDirIdentity[] list = this.m_connMng.getConnection().listDirectories(parent);
            for (int i = 0; i < list.length; ++i) {
                if (!ctxName.equals(list[i].getName())) continue;
                return true;
            }
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        return false;
    }

    @Override
    public final Object lookup(String name) throws NamingException, NameNotFoundException {
        Object obj = null;
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return this;
        }
        if (!name.startsWith("/")) {
            name = '/' + name;
        }
        int retriesLeft = this.m_resolveRetries;
        long timeoutAt = 0L;
        block7: while (true) {
            try {
                timeoutAt = System.currentTimeMillis() + this.m_requestTimeout;
                String fullDSName = this.m_fullCtxName + name;
                IIdentity identity = this.lookupStrategy.lookupIdentity(name);
                if (identity != null) {
                    if (identity instanceof IDirIdentity) {
                        obj = new MFContext(this, name);
                    } else {
                        IDirElement elmnt = this.getLookupConnection(name).getElement(fullDSName, false);
                        String elmntType = elmnt.getIdentity().getType();
                        if (elmntType.equals("SerializedObject")) {
                            IAttributeSet attrs = elmnt.getAttributes();
                            byte[] bytes = (byte[])attrs.getAttribute("data");
                            obj = ObjHelper.deserializeObject(bytes);
                        } else if (elmntType.equals("ReferenceObject")) {
                            obj = this.getBindedRefObject(elmnt, fullDSName);
                            try {
                                for (Class<?> baseclass = obj.getClass(); baseclass != null; baseclass = baseclass.getSuperclass()) {
                                    if (!baseclass.getName().equals("progress.message.jclient.ConnectionFactory")) continue;
                                    Class[] parameters = new Class[]{Context.class};
                                    Method m = obj.getClass().getMethod("setNamingContext", parameters);
                                    Object[] args = new Object[]{this};
                                    String result = (String)m.invoke(obj, args);
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                            }
                            catch (SecurityException securityException) {}
                        }
                    }
                } else {
                    throw new NameNotFoundException(name + " not found in the specified context");
                }
                return obj;
            }
            catch (Exception ex) {
                Throwable cause;
                if (ex instanceof NamingException && (cause = ex.getCause()) != null && cause instanceof InvokeTimeoutException && (retriesLeft > 0 || this.m_resolveRetries == -1)) {
                    if (this.m_resolveRetries > 0) {
                        --retriesLeft;
                    }
                    if (!(cause instanceof InvokeTimeoutCommsException)) continue;
                    while (true) {
                        if (this.getLookupConnection(name).isConnected() || System.currentTimeMillis() >= timeoutAt) continue block7;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {}
                    }
                }
                this.throwNamingException(ex);
                continue;
            }
            break;
        }
    }

    private MFConnection getLookupConnection(String lookupName) throws NamingException {
        try {
            return this.m_connMng.getConnection();
        }
        catch (NullPointerException e) {
            throw new NamingException("Context has been closed; lookup of " + lookupName + " failed");
        }
    }

    @Override
    public final Object lookup(Name name) throws NamingException, NameNotFoundException {
        return this.lookup(this.m_parser.convertToString(name));
    }

    public static Object elementToReference(IElement element) throws NamingException {
        String elmntType = element.getIdentity().getType();
        if (elmntType.equals("SerializedObject")) {
            IAttributeSet attrs = element.getAttributes();
            byte[] bytes = (byte[])attrs.getAttribute("data");
            return ObjHelper.deserializeObject(bytes);
        }
        if (elmntType.equals("ReferenceObject")) {
            return ObjHelper.convertElementToRef(element, false);
        }
        throw new NameNotFoundException(element.getIdentity().getName() + " is not of a ReferenceObject or a SerializedObject types");
    }

    private Object getBindedRefObject(IDirElement elmnt, String fullDSName) throws NamingException {
        try {
            return NamingManager.getObjectInstance(ObjHelper.convertElementToRef(elmnt, this.m_verboseTracing), this.m_parser.parse(fullDSName), this, this.m_env);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
            return null;
        }
    }

    @Override
    public final void bind(Name name, Object obj) throws NamingException, NameAlreadyBoundException {
        if (name == null || name.toString().length() == 0) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        this.bind(this.m_parser.convertToString(name), obj);
    }

    @Override
    public final void bind(String name, Object obj) throws NamingException, NameAlreadyBoundException {
        if (name.length() == 0) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (obj == null) {
            throw new NamingException("Object can't be null");
        }
        if (!name.startsWith("/")) {
            name = '/' + name;
        }
        try {
            IDirElement elmnt = null;
            obj = NamingManager.getStateToBind(obj, this.m_parser.parse(this.m_fullCtxName + name), this, this.m_env);
            if (obj instanceof Referenceable || obj instanceof Reference) {
                elmnt = MFContext.bindReferenceable(this.m_fullCtxName + name, obj, this.m_verboseTracing);
                this.m_connMng.getConnection().setElement(elmnt.doneUpdate(), null);
                return;
            }
            if (obj instanceof Serializable) {
                elmnt = MFContext.bindSerializable(this.m_fullCtxName + name, obj, this.m_verboseTracing);
                this.m_connMng.getConnection().setElement(elmnt.doneUpdate(), null);
                return;
            }
            throw new OperationNotSupportedException("Can only bind Serializable, References or Referenceable objects");
        }
        catch (VersionOutofSyncException ex) {
            NameAlreadyBoundException e = new NameAlreadyBoundException(name);
            if (this.m_verboseTracing) {
                e.setRootCause(ex);
            }
            throw e;
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
            return;
        }
    }

    public static IDirElement objectToElement(Object obj) throws DirectoryServiceException {
        if (obj == null) {
            throw new DirectoryServiceException("The Object can't be null");
        }
        try {
            if (obj instanceof Referenceable || obj instanceof Reference) {
                return MFContext.bindReferenceable("/NoNameIsNeeded", obj, false);
            }
            if (obj instanceof Serializable) {
                return MFContext.bindSerializable("/NoNameIsNeeded", obj, false);
            }
            throw new DirectoryServiceException("Can only bind Serializable, References or Referenceable objects");
        }
        catch (NamingException e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    private static IDirElement bindSerializable(String s, Object obj, boolean verboseTracing) throws NamingException {
        IDirElement elmnt = null;
        try {
            elmnt = ElementFactory.createElement(s, "SerializedObject", "1.0");
            IAttributeSet elmntAttributes = elmnt.getAttributes();
            elmntAttributes.setBytesAttribute("data", ObjHelper.serializeObject(obj));
            elmntAttributes.setStringAttribute("classname", obj.getClass().getName());
        }
        catch (Exception ex) {
            ObjHelper.throwNamingException(ex, verboseTracing);
        }
        return elmnt;
    }

    private static IDirElement bindReferenceable(String s, Object obj, boolean verboseTracing) throws NamingException {
        IDirElement elmnt = null;
        Reference reference = null;
        if (obj instanceof Referenceable) {
            reference = ((Referenceable)obj).getReference();
        } else if (obj instanceof Reference) {
            reference = (Reference)obj;
        }
        if (reference == null) {
            throw new NamingException("Reference can't be null");
        }
        try {
            int i;
            elmnt = ElementFactory.createElement(s, "ReferenceObject", "1.0");
            IAttributeSet elmntAttributes = elmnt.getAttributes();
            String s1 = reference.getClassName();
            if (s1 == null) {
                throw new NamingException("Reference has no class name");
            }
            elmntAttributes.setStringAttribute("classname", s1);
            s1 = reference.getFactoryClassName();
            if (s1 != null) {
                elmntAttributes.setStringAttribute("factoryclassname", s1);
            }
            if ((s1 = reference.getFactoryClassLocation()) != null) {
                elmntAttributes.setStringAttribute("factorylocation", s1);
            }
            if ((i = reference.size()) > 0) {
                IAttributeList list = elmntAttributes.createAttributeList("RefAdresses");
                for (int j = 0; j < i; ++j) {
                    RefAddr refaddr = reference.get(j);
                    String type = refaddr.getType();
                    Object obj1 = refaddr.getContent();
                    IAttributeSet set = list.addNewAttributeSetItem();
                    if (refaddr instanceof StringRefAddr) {
                        set.setStringAttribute(type, (String)(obj1 != null ? obj1 : ""));
                        continue;
                    }
                    set.setBytesAttribute(type, (byte[])obj1);
                }
            }
        }
        catch (Exception ex) {
            ObjHelper.throwNamingException(ex, verboseTracing);
        }
        return elmnt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void rebind(String name, Object obj) throws NamingException, NameNotFoundException {
        if (name.length() == 0 || name == null) {
            throw new NamingException("Cannot rebind an empty name");
        }
        if (obj == null) {
            throw new NamingException("Object can't be null");
        }
        if (!name.startsWith("/")) {
            name = '/' + name;
        }
        try {
            IBasicElement elmnt = null;
            while (elmnt == null) {
                elmnt = this.m_connMng.getConnection().getElement(this.m_fullCtxName + name, true);
                if (elmnt != null) continue;
                try {
                    this.bind(name, obj);
                    return;
                }
                catch (NameAlreadyBoundException nameAlreadyBoundException) {
                }
            }
            String elmntType = elmnt.getIdentity().getType();
            if (elmntType.equals("SerializedObject")) {
                if (!(obj instanceof Serializable)) throw new NamingException("Can't rebind object of a different type. Object must be a Serializable.");
                IAttributeSet elmntAttributes = elmnt.getAttributes();
                elmntAttributes.setBytesAttribute("data", ObjHelper.serializeObject(obj));
                elmntAttributes.setStringAttribute("classname", obj.getClass().getName());
            } else if (elmntType.equals("ReferenceObject")) {
                if (!(obj instanceof Reference) && !(obj instanceof Referenceable)) throw new NamingException("Can't rebind object of a diffrent type. Object must be a Referenceable/Reference.");
                this.rebindReferenceable(elmnt.getAttributes(), obj);
            }
            this.m_connMng.getConnection().setElement(elmnt.doneUpdate(), null);
            return;
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
    }

    @Override
    public final void rebind(Name name, Object obj) throws NamingException {
        if (name == null || name.isEmpty()) {
            throw new NamingException("Cannot unbind empty name");
        }
        this.rebind(this.m_parser.convertToString(name), obj);
    }

    private void rebindReferenceable(IAttributeSet elmntAttributes, Object obj) throws NamingException {
        Reference reference = null;
        if (obj instanceof Referenceable) {
            reference = ((Referenceable)obj).getReference();
        } else if (obj instanceof Reference) {
            reference = (Reference)obj;
        }
        try {
            IAttributeList list;
            String s1 = reference.getClassName();
            if (s1 == null) {
                throw new NamingException("Reference has no class name");
            }
            elmntAttributes.setStringAttribute("classname", s1);
            s1 = reference.getFactoryClassName();
            if (s1 != null) {
                elmntAttributes.setStringAttribute("factoryclassname", s1);
            }
            if ((s1 = reference.getFactoryClassLocation()) != null) {
                elmntAttributes.setStringAttribute("factorylocation", s1);
            }
            if ((list = (IAttributeList)elmntAttributes.getAttribute("RefAdresses")) == null) {
                list = elmntAttributes.createAttributeList("RefAdresses");
            } else {
                int count = list.getCount();
                for (int i = 0; i < count; ++i) {
                    list.deleteAttributeItem(0);
                }
            }
            int i = reference.size();
            if (i > 0) {
                for (int j = 0; j < i; ++j) {
                    RefAddr refaddr = reference.get(j);
                    String type = refaddr.getType();
                    Object obj1 = refaddr.getContent();
                    IAttributeSet set = list.addNewAttributeSetItem();
                    if (refaddr instanceof StringRefAddr) {
                        set.setStringAttribute(type, (String)(obj1 != null ? obj1 : ""));
                        continue;
                    }
                    set.setBytesAttribute(type, ObjHelper.serializeObject(obj));
                }
            }
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
    }

    @Override
    public final void unbind(String name) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new NamingException("Cannot unbind empty name");
        }
        if (!name.startsWith("/")) {
            name = '/' + name;
        }
        try {
            this.m_connMng.getConnection().deleteElement(this.m_fullCtxName + name, null);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
    }

    @Override
    public final void unbind(Name name) throws NamingException {
        if (name == null || name.toString().length() == 0) {
            throw new NamingException("Cannot unbind empty name");
        }
        this.unbind(this.m_parser.convertToString(name));
    }

    @Override
    public final void rename(String oldname, String newname) throws NamingException {
        if (oldname.length() == 0 || newname.length() == 0) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        if (!oldname.startsWith("/")) {
            oldname = '/' + oldname;
        }
        if (!newname.startsWith("/")) {
            newname = '/' + newname;
        }
        Object obj = null;
        try {
            IDirElement oldElemnt = this.m_connMng.getConnection().getElement(this.m_fullCtxName + oldname, false);
            String elmntType = oldElemnt.getIdentity().getType();
            if (elmntType.equals("SerializedObject")) {
                IAttributeSet attrs = oldElemnt.getAttributes();
                obj = ObjHelper.deserializeObject((byte[])attrs.getAttribute("data"));
            } else if (elmntType.equals("ReferenceObject")) {
                obj = this.getBindedRefObject(oldElemnt, this.m_fullCtxName + oldname);
            }
            this.bind(newname, obj);
            this.m_connMng.getConnection().deleteElement(this.m_fullCtxName + oldname, null);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
    }

    @Override
    public final void rename(Name oldname, Name newname) throws NamingException {
        if (oldname == null || newname == null) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        this.rename(this.m_parser.convertToString(oldname), this.m_parser.convertToString(newname));
    }

    public final NamingEnumeration list(String name) throws NamingException {
        String dsName;
        if (name.length() == 0) {
            dsName = this.m_fullCtxName;
        } else {
            if (!name.startsWith("/")) {
                name = '/' + name;
            }
            dsName = this.m_fullCtxName + name;
        }
        IDirIdentity[] contextList = null;
        IDirElement[] objectList = null;
        try {
            contextList = this.m_connMng.getConnection().getAllDirectories(dsName);
            objectList = this.m_connMng.getConnection().getAllElements(dsName, false);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        return new BindingEnumeration(contextList, objectList);
    }

    public final NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Name object cannot be null");
        }
        return this.list(name.toString());
    }

    public final NamingEnumeration listBindings(String name) throws NamingException {
        String dsName;
        if (name.length() == 0) {
            dsName = this.m_fullCtxName;
        } else {
            if (!name.startsWith("/")) {
                name = '/' + name;
            }
            dsName = this.m_fullCtxName + name;
        }
        IDirIdentity[] contextList = null;
        IDirElement[] objectList = null;
        try {
            contextList = this.m_connMng.getConnection().getAllDirectories(dsName);
            objectList = this.m_connMng.getConnection().getAllElements(dsName, false);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        return new ObjectBindingEnumeration(contextList, objectList);
    }

    public final NamingEnumeration listBindings(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Name object cannot be null");
        }
        return this.listBindings(this.m_parser.convertToString(name));
    }

    @Override
    public final void destroySubcontext(String name) throws NamingException, ContextNotEmptyException {
        if (name == null || name.length() == 0) {
            throw new NamingException("Cannot destroy subcontext with an empty name");
        }
        if (!name.startsWith("/")) {
            name = '/' + name;
        }
        try {
            String fullname = this.m_fullCtxName + name;
            if (this.m_connMng.getConnection().listDirectories(fullname).length > 0) {
                throw new ContextNotEmptyException(fullname);
            }
            if (this.m_connMng.getConnection().getAllElements(fullname, false).length > 0) {
                throw new ContextNotEmptyException(fullname);
            }
            this.m_connMng.getConnection().deleteDirectory(fullname);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
    }

    @Override
    public final void destroySubcontext(Name name) throws NamingException {
        if (name == null || name.toString().length() == 0) {
            throw new NamingException("Cannot destroy subcontext with an empty name");
        }
        this.destroySubcontext(this.m_parser.convertToString(name));
    }

    @Override
    public final Context createSubcontext(Name name) throws NamingException, NameAlreadyBoundException, CommunicationException {
        if (name == null || name.toString().length() == 0) {
            throw new NamingException("Cannot create subcontext with an empty name");
        }
        return this.createSubcontext(this.m_parser.convertToString(name));
    }

    @Override
    public final Context createSubcontext(String name) throws NamingException, NameAlreadyBoundException, CommunicationException {
        MFContext subcontext = null;
        if (!name.startsWith("/")) {
            name = '/' + name;
        }
        try {
            String fullname = this.m_fullCtxName + name;
            String parentDir = fullname.substring(0, fullname.lastIndexOf(47));
            IDirIdentity[] dirs = this.m_connMng.getConnection().listDirectories(parentDir);
            for (int i = 0; i < dirs.length; ++i) {
                if (!dirs[i].getName().equals(fullname)) continue;
                throw new NameAlreadyBoundException(fullname);
            }
            if (this.m_connMng.getConnection().getElement(fullname, false) != null) {
                throw new NameAlreadyBoundException(fullname);
            }
            this.m_connMng.getConnection().createDirectory(fullname);
            subcontext = new MFContext(this, name);
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
        return subcontext;
    }

    @Override
    public final Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public final Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(this.m_parser.convertToString(name));
    }

    @Override
    public final NameParser getNameParser(String name) throws NamingException {
        return this.m_parser;
    }

    @Override
    public final NameParser getNameParser(Name name) throws NamingException {
        return this.m_parser;
    }

    @Override
    public final String composeName(String name, String prefix) throws NamingException {
        if (name.length() == 0 || prefix.length() == 0) {
            throw new NamingException("Names can't be empty");
        }
        return this.composeName(this.m_parser.parse(name), this.m_parser.parse(prefix)).toString();
    }

    @Override
    public final Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null || prefix == null) {
            throw new NamingException("Names can't be empty");
        }
        Name composition = (Name)prefix.clone();
        composition.addAll(name);
        return composition;
    }

    @Override
    public final Object addToEnvironment(String propName, Object propVal) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("addToEnvironment");
    }

    @Override
    public final Object removeFromEnvironment(String propName) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("addToEnvironment");
    }

    public final Hashtable getEnvironment() throws NamingException {
        if (this.m_env == null) {
            return new Hashtable();
        }
        return this.m_env;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (this.m_fullCtxName.equals("/_MFContext")) {
            return "";
        }
        return this.m_fullCtxName.substring(1 + "_MFContext".length() + 1);
    }

    @Override
    public synchronized void close() throws NamingException {
        if (this.m_connMng != null) {
            this.m_connMng.close();
            this.m_connMng = null;
        }
    }

    public String resolveURL(String url) throws URISyntaxException, IOException {
        Object obj = null;
        if (url == null) {
            return null;
        }
        if (url.length() == 0) {
            return "";
        }
        if (!url.startsWith("sonicrn:///")) {
            throw new URISyntaxException(url, "Not a sonicrn:/// URL", 0);
        }
        if (url.length() <= "sonicrn:///".length()) {
            throw new URISyntaxException(url, "No routing node specified", 0);
        }
        int retriesLeft = this.m_resolveRetries;
        long timeoutAt = 0L;
        block6: while (true) {
            try {
                timeoutAt = System.currentTimeMillis() + this.m_requestTimeout;
                return this.getLookupConnection("").resolveURL(url);
            }
            catch (Exception ex) {
                Throwable cause;
                if (ex instanceof NamingException && (cause = ex.getCause()) != null && cause instanceof InvokeTimeoutException && (retriesLeft > 0 || this.m_resolveRetries == -1)) {
                    if (this.m_resolveRetries > 0) {
                        --retriesLeft;
                    }
                    if (!(cause instanceof InvokeTimeoutCommsException)) continue;
                    try {
                        while (true) {
                            if (this.getLookupConnection("").isConnected() || System.currentTimeMillis() >= timeoutAt) continue block6;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (NamingException namingException) {
                        continue;
                    }
                }
                IOException ioException = new IOException("Failed to resolve " + url + ", see cause...");
                ioException.initCause(ex instanceof NamingException ? ex.getCause() : ex);
                throw ioException;
            }
            break;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private void throwNamingException(Exception e) throws NamingException {
        ObjHelper.throwNamingException(e, this.m_verboseTracing);
    }

    private class StandardLookupStrategy
    implements LookupStrategy {
        private StandardLookupStrategy() {
        }

        @Override
        public IIdentity lookupIdentity(String name) throws NamingException, DirectoryServiceException, ConfigException {
            IIdentity[] list;
            String parent = new EntityName(name).getParent();
            String fullDSName = MFContext.this.m_fullCtxName + name;
            for (IIdentity identity : list = MFContext.this.getLookupConnection(name).listAll(MFContext.this.m_fullCtxName + parent)) {
                if (!fullDSName.equals(identity.getName())) continue;
                return identity;
            }
            return null;
        }
    }

    private class EnterpriseLookupStrategy
    implements LookupStrategy {
        private EnterpriseLookupStrategy() {
        }

        @Override
        public IIdentity lookupIdentity(String name) throws NamingException, DirectoryServiceException {
            String fullDSName = MFContext.this.m_fullCtxName + name;
            return MFContext.this.getLookupConnection(name).lookupIdentity(fullDSName);
        }
    }

    private static interface LookupStrategy {
        public IIdentity lookupIdentity(String var1) throws NamingException, DirectoryServiceException, ConfigException;
    }

    final class ObjectBindingEnumeration
    implements NamingEnumeration {
        HashSet set = new HashSet();
        Iterator m_iterator;

        ObjectBindingEnumeration(IDirIdentity[] contextList, IDirElement[] objectList) {
            this.init(contextList, objectList);
            this.m_iterator = this.set.iterator();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public Object nextElement() {
            return this.m_iterator.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_iterator.hasNext();
        }

        @Override
        public void close() {
            this.set.clear();
        }

        private void init(IDirIdentity[] contextList, IDirElement[] objectList) {
            String fullname;
            int i;
            for (i = 0; i < contextList.length; ++i) {
                fullname = contextList[i].getName();
                try {
                    this.set.add(new NameClassPair(new EntityName(fullname).getBaseName(), CONTEXT_CLASSNAME));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (i = 0; i < objectList.length; ++i) {
                fullname = objectList[i].getIdentity().getName();
                String elmntType = objectList[i].getIdentity().getType();
                IAttributeSet attrs = objectList[i].getAttributes();
                String className = (String)attrs.getAttribute("classname");
                Object obj = null;
                try {
                    if (elmntType.equals("SerializedObject")) {
                        obj = ObjHelper.deserializeObject((byte[])attrs.getAttribute("data"));
                    } else if (elmntType.equals("ReferenceObject")) {
                        obj = MFContext.this.getBindedRefObject(objectList[i], fullname);
                    }
                    this.set.add(new Binding(new EntityName(fullname).getBaseName(), className, obj));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    final class BindingEnumeration
    implements NamingEnumeration {
        HashSet set = new HashSet();
        Iterator m_iterator;

        BindingEnumeration(IDirIdentity[] contextList, IDirElement[] objectList) {
            this.init(contextList, objectList);
            this.m_iterator = this.set.iterator();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_iterator.hasNext();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public Object nextElement() {
            return this.m_iterator.next();
        }

        @Override
        public void close() {
            this.set.clear();
        }

        private void init(IDirIdentity[] contextList, IDirElement[] objectList) {
            String fullname;
            int i;
            for (i = 0; i < contextList.length; ++i) {
                fullname = contextList[i].getName();
                try {
                    this.set.add(new NameClassPair(new EntityName(fullname).getBaseName(), CONTEXT_CLASSNAME));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (i = 0; i < objectList.length; ++i) {
                fullname = objectList[i].getIdentity().getName();
                IAttributeSet attrs = objectList[i].getAttributes();
                String className = (String)attrs.getAttribute("classname");
                try {
                    this.set.add(new NameClassPair(new EntityName(fullname).getBaseName(), className));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

