/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.impl.IDictionary;
import com.sonicsw.mf.common.config.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

final class UntypedAttSet
implements IDictionary,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private HashMap m_table = new HashMap();
    private transient Set m_set = this.m_table.keySet();

    UntypedAttSet(String user, byte[] password) {
        this();
        try {
            if (user != null) {
                this.put("USER_NAME", user);
            }
            if (password != null) {
                this.put("PASSWORD", password);
            }
        }
        catch (AttributeSetTypeException e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    UntypedAttSet() {
    }

    @Override
    public int estimateSize() {
        return 16 + Util.estimateHashMapSize(this.m_table);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeObject(this.m_table);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_table = (HashMap)s.readObject();
        this.m_set = this.m_table.keySet();
    }

    @Override
    public int size() {
        return this.m_table.size();
    }

    @Override
    public String[] attributes() {
        int count = this.m_table.size();
        String[] result = new String[count];
        Iterator iterator = this.m_set.iterator();
        for (int i = 0; i < count; ++i) {
            result[i] = (String)iterator.next();
        }
        return result;
    }

    @Override
    public Object[] values() {
        int count = this.m_table.size();
        Object[] result = new Object[count];
        Iterator iterator = this.m_set.iterator();
        for (int i = 0; i < count; ++i) {
            result[i] = iterator.next();
        }
        return result;
    }

    @Override
    public Object get(String attName) throws AttributeSetTypeException {
        return this.m_table.get(attName);
    }

    @Override
    public Object put(String attName, Object value) throws AttributeSetTypeException {
        return this.m_table.put(attName, value);
    }

    @Override
    public Object remove(String key) throws AttributeSetTypeException {
        return this.m_table.remove(key);
    }

    @Override
    public void delete() {
    }
}

