/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.jndi.mfcontext;

import com.sonicsw.jndi.mfcontext.MFCachedContext;
import com.sonicsw.jndi.mfcontext.MFContext;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public final class MFContextFactory
implements InitialContextFactory {
    private static final String DOMAIN_PARAM = "domain";
    private static final String CONNECT_TIMEOUT_PARAM = "connectTimeout";
    private static final String IDLE_TIMEOUT_PARAM = "idleTimeout";
    private static final String REQUEST_TIMEOUT_PARAM = "requestTimeout";
    private static final String LOOKUP_RETRIES_PARAM = "lookupRetries";
    private static final String SOCKET_CONNECT_TIMEOUT_PARAM = "socketTimeout";
    private static final String NODE_PARAM = "node";
    private static final String ENABLE_CACHE_PARAM = "enableCache";
    private static final String CACHE_EXPIRATION_TIMEOUT_PARAM = "cacheExpirationTimeout";
    private static final String CACHE_NAME_PARAM = "cacheName";
    private static final String CACHE_SIZE_PARAM = "cacheSize";

    public Context getInitialContext(Hashtable env) throws NamingException {
        String providerURL = (String)env.get("java.naming.provider.url");
        HashMap params = this.extractParams(providerURL);
        if (params.containsKey(DOMAIN_PARAM)) {
            env.put("com.sonicsw.jndi.mfcontext.domain", params.get(DOMAIN_PARAM));
        }
        if (params.containsKey(CONNECT_TIMEOUT_PARAM)) {
            env.put("com.sonicsw.jndi.mfcontext.connectTimeout", params.get(CONNECT_TIMEOUT_PARAM));
        }
        if (params.containsKey(IDLE_TIMEOUT_PARAM)) {
            env.put("com.sonicsw.jndi.mfcontext.idleTimeout", params.get(IDLE_TIMEOUT_PARAM));
        }
        if (params.containsKey(REQUEST_TIMEOUT_PARAM)) {
            env.put("com.sonicsw.jndi.mfcontext.requestTimeout", params.get(REQUEST_TIMEOUT_PARAM));
        }
        if (params.containsKey(LOOKUP_RETRIES_PARAM)) {
            env.put("com.sonicsw.jndi.mfcontext.lookupRetries", params.get(LOOKUP_RETRIES_PARAM));
        }
        if (params.containsKey(SOCKET_CONNECT_TIMEOUT_PARAM)) {
            env.put("com.sonicsw.jndi.mfcontext.socketConnectTimeout", params.get(SOCKET_CONNECT_TIMEOUT_PARAM));
        }
        if (params.containsKey(NODE_PARAM)) {
            env.put("com.sonicsw.jndi.mfcontext.node", params.get(NODE_PARAM));
        }
        boolean cacheEnabled = false;
        if (env.containsKey("com.sonicsw.jndi.mfcontext.enableCache")) {
            cacheEnabled = Boolean.parseBoolean((String)env.get("com.sonicsw.jndi.mfcontext.enableCache"));
        }
        if (params.containsKey(ENABLE_CACHE_PARAM)) {
            cacheEnabled = Boolean.parseBoolean((String)params.get(ENABLE_CACHE_PARAM));
            env.put("com.sonicsw.jndi.mfcontext.enableCache", Boolean.toString(cacheEnabled));
        }
        if (cacheEnabled) {
            if (params.containsKey(CACHE_SIZE_PARAM)) {
                env.put("com.sonicsw.jndi.mfcontext.cacheSize", params.get(CACHE_SIZE_PARAM));
            }
            if (params.containsKey(CACHE_EXPIRATION_TIMEOUT_PARAM)) {
                env.put("com.sonicsw.jndi.mfcontext.cacheExpirationTimeout", params.get(CACHE_EXPIRATION_TIMEOUT_PARAM));
            }
            if (params.containsKey(CACHE_NAME_PARAM)) {
                env.put("com.sonicsw.jndi.mfcontext.cacheName", params.get(CACHE_NAME_PARAM));
            }
        }
        StringBuffer connectionURLs = new StringBuffer();
        String initialCtxName = this.getConnectionURLs(providerURL, connectionURLs);
        MFContext context = new MFContext(connectionURLs.toString(), initialCtxName, env);
        return context.isEnterpise() && cacheEnabled ? new MFCachedContext(context, env) : context;
    }

    private HashMap extractParams(String providerURL) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (providerURL == null || providerURL.length() == 0) {
            return params;
        }
        StringTokenizer st = new StringTokenizer(providerURL, ", ");
        String firstURL = st.nextToken();
        if (!firstURL.contains("?")) {
            return params;
        }
        st = new StringTokenizer(firstURL, "?");
        st.nextToken();
        st = new StringTokenizer(st.nextToken(), "=&");
        while (st.hasMoreTokens()) {
            params.put(st.nextToken(), st.nextToken());
        }
        return params;
    }

    private String getConnectionURLs(String providerURL, StringBuffer connectionURLs) throws NamingException {
        String initialCtxName = null;
        if (providerURL == null || providerURL.length() == 0) {
            connectionURLs.append("tcp://localhost:2506");
            initialCtxName = "";
        } else {
            StringTokenizer st = new StringTokenizer(providerURL, ", ");
            while (st.hasMoreTokens()) {
                int ctxSearchStartPosn;
                int ctxPosn;
                String connectionURL = st.nextToken();
                String ctxName = "";
                if ((ctxPosn = connectionURL.indexOf("/", ctxSearchStartPosn += (ctxSearchStartPosn = connectionURL.indexOf("//")) == -1 ? 1 : 2)) >= 0) {
                    ctxName = connectionURL.substring(ctxPosn + 1);
                    ctxName = this.removeParameters(ctxName);
                    connectionURL = connectionURL.substring(0, ctxPosn);
                }
                if (initialCtxName == null) {
                    initialCtxName = ctxName;
                } else if (!ctxName.equals(initialCtxName)) {
                    throw new NamingException("When specifying multiple URLs, each URL must specify the same context.");
                }
                if (connectionURLs.length() > 0) {
                    connectionURLs.append(',');
                }
                connectionURL = this.removeParameters(connectionURL);
                connectionURLs.append(connectionURL);
            }
        }
        return initialCtxName;
    }

    private String removeParameters(String dataParam) {
        String data = dataParam;
        if (data.indexOf(63) > 0) {
            data = data.substring(0, data.indexOf(63));
        }
        return data;
    }
}

