/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeList;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.AttributeList;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.DeltaAttributeSet;
import com.sonicsw.mf.common.config.impl.ICanReplaceRef;
import com.sonicsw.mf.common.config.impl.IDelta;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

final class DeltaAttributeList
implements IDeltaAttributeList,
IDelta,
Serializable,
ICanReplaceRef {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private int[] m_deletedArray;
    private HashMap m_deltaVals;
    private Object[] m_newItems;

    DeltaAttributeList(int[] deletedArray, HashMap deltaVals, Object[] newItems) {
        this.m_deletedArray = deletedArray;
        this.m_deltaVals = deltaVals;
        this.m_newItems = newItems;
    }

    public int estimateSize() {
        int estimate = 64;
        if (this.m_deletedArray != null) {
            estimate += 16 * this.m_deletedArray.length;
        }
        if (this.m_deltaVals != null) {
            estimate += Util.estimateHashMapSize(this.m_deltaVals);
        }
        if (this.m_newItems != null) {
            for (int i = 0; i < this.m_newItems.length; ++i) {
                estimate += Util.estimateSize(this.m_newItems[i]);
            }
        }
        return estimate;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeObject(this.m_deletedArray);
        s.writeObject(this.m_deltaVals);
        s.writeObject(this.m_newItems);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_deletedArray = (int[])s.readObject();
        this.m_deltaVals = (HashMap)s.readObject();
        this.m_newItems = (Object[])s.readObject();
    }

    @Override
    public boolean replaceReferences(boolean isSystemAtts, IReplaceRef replaceSrvc) {
        boolean retVal = true;
        for (int i = 0; i < this.m_newItems.length; ++i) {
            Object value = this.m_newItems[i];
            if (value instanceof ICanReplaceRef) {
                boolean ret = ((ICanReplaceRef)value).replaceReferences(false, replaceSrvc);
                if (ret) continue;
                retVal = false;
                continue;
            }
            if (!(value instanceof Reference)) continue;
            Reference newRef = replaceSrvc.replace((Reference)value);
            if (newRef.getElementName().startsWith("/NO_STORAGE:")) {
                retVal = false;
            }
            this.m_newItems[i] = newRef;
        }
        Set keys = this.m_deltaVals.keySet();
        for (Object key : keys) {
            Object value = this.m_deltaVals.get(key);
            if (value instanceof ICanReplaceRef) {
                boolean ret = ((ICanReplaceRef)value).replaceReferences(false, replaceSrvc);
                if (ret) continue;
                retVal = false;
                continue;
            }
            if (!(value instanceof Reference)) continue;
            Reference newRef = replaceSrvc.replace((Reference)value);
            if (newRef.getElementName().startsWith("/NO_STORAGE:")) {
                retVal = false;
            }
            this.m_deltaVals.put(key, newRef);
        }
        return retVal;
    }

    @Override
    public HashMap getModifiedItems() {
        return this.m_deltaVals;
    }

    @Override
    public int[] getDeletedItemNumbers() {
        return this.m_deletedArray;
    }

    @Override
    public Object[] getNewItems() {
        return this.m_newItems;
    }

    void toAttributeSet(IAttributeSet attributeSet) throws Exception {
        int i;
        attributeSet.setBooleanAttribute("_MF_DELTA_OJECT_IMPL", Boolean.TRUE);
        IAttributeList deletedItems = attributeSet.createAttributeList("DELETED_ITEMS");
        IAttributeList newItems = attributeSet.createAttributeList("NEW_ITEMS");
        IAttributeSet deltaItems = attributeSet.createAttributeSet("DELTA_ITEMS");
        for (i = 0; i < this.m_deletedArray.length; ++i) {
            deletedItems.addIntegerItem(new Integer(this.m_deletedArray[i]));
        }
        for (i = 0; i < this.m_newItems.length; ++i) {
            ((AttributeList)newItems).addItem(this.m_newItems[i], false);
        }
        for (Integer key : this.m_deltaVals.keySet()) {
            IAttributeSet convertedValue;
            Object value = this.m_deltaVals.get(key);
            if (value instanceof DeltaAttributeSet) {
                convertedValue = deltaItems.createAttributeSet(key.toString());
                ((DeltaAttributeSet)value).toAttributeSet(convertedValue);
                continue;
            }
            if (value instanceof IDeltaAttributeList) {
                convertedValue = deltaItems.createAttributeSet(key.toString());
                ((DeltaAttributeList)value).toAttributeSet(convertedValue);
                continue;
            }
            ((AttributeSet)deltaItems).setAttributeObject(key.toString(), value, false);
        }
    }
}

