/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.impl.TypedAttSet;
import com.sonicsw.mf.common.config.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

final class AttributeSetType
extends HashMap
implements IAttributeSetType,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    String m_name;
    private int m_numInstances = 0;
    private int m_currentAttribute;
    private boolean m_readOnly = false;
    private transient Set m_set;

    AttributeSetType(String name) {
        this.m_name = name;
        this.m_currentAttribute = 0;
        this.m_set = this.keySet();
    }

    @Override
    public boolean equals(Object o) {
        int i;
        if (o == null) {
            return false;
        }
        if (!(o instanceof AttributeSetType)) {
            return false;
        }
        AttributeSetType attributeSetType = (AttributeSetType)o;
        if (!attributeSetType.getName().equals(this.m_name)) {
            return false;
        }
        String[] attributeNames = attributeSetType.getAttributeNames();
        String[] thisAttributeNames = this.getAttributeNames();
        for (i = 0; i < attributeNames.length; ++i) {
            if (this.get(attributeNames[i]) != null) continue;
            return false;
        }
        for (i = 0; i < thisAttributeNames.length; ++i) {
            if (attributeSetType.get(thisAttributeNames[i]) != null) continue;
            return false;
        }
        return true;
    }

    int estimateSize() {
        return Util.estimateSize(this.m_name) + 16 + Util.estimateHashMapSize(this);
    }

    @Override
    public int hashCode() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.getName());
        if (this.getAttributeNames() != null && this.getAttributeNames().length > 0) {
            values.addAll(Arrays.asList(this.getAttributeNames()));
        }
        return Objects.hash(values.toArray());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeObject(this.m_name);
        s.writeInt(this.m_numInstances);
        s.writeInt(this.m_currentAttribute);
        s.writeBoolean(this.m_readOnly);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_name = (String)s.readObject();
        this.m_numInstances = s.readInt();
        this.m_currentAttribute = s.readInt();
        this.m_readOnly = s.readBoolean();
        this.m_set = this.keySet();
    }

    void setReadOnly(boolean readOnly) {
        if (this.m_numInstances > 0 && !readOnly) {
            return;
        }
        this.m_readOnly = readOnly;
    }

    String getName() {
        return this.m_name;
    }

    TypedAttSet createTypedSet() {
        return this.createTypedSet(new Object[this.size()]);
    }

    TypedAttSet createTypedSet(Object[] values) {
        TypedAttSet set = new TypedAttSet(this);
        ++this.m_numInstances;
        this.m_readOnly = true;
        set.setValues(values);
        return set;
    }

    void removeTypedSet(TypedAttSet set) {
        --this.m_numInstances;
    }

    boolean hasInstances() {
        return this.m_numInstances > 0;
    }

    @Override
    public void addAttributeName(String name) throws ReadOnlyException {
        if (this.m_readOnly) {
            throw new ReadOnlyException("New attributes cannot be added to type ", this.m_name);
        }
        if (this.containsKey(name)) {
            return;
        }
        this.put(name, new Integer(this.m_currentAttribute++));
    }

    @Override
    public String[] getAttributeNames() {
        int count = this.size();
        String[] result = new String[count];
        Iterator iterator = this.m_set.iterator();
        for (int i = 0; i < count; ++i) {
            result[i] = (String)iterator.next();
        }
        return result;
    }
}

