/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.jndi;

import com.sonicsw.mf.common.MFSecurityException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import javax.naming.BinaryRefAddr;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public final class ObjHelper {
    private ObjHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserializeObject(byte[] bytes) throws NamingException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            try (ObjectInputStream obj = new ObjectInputStream(inputStream);){
                Object obj1;
                Object object = obj1 = obj.readObject();
                return object;
            }
        }
        catch (IOException io_ex) {
            NamingException namingex_2 = new NamingException();
            namingex_2.setRootCause(io_ex);
            throw namingex_2;
        }
    }

    public static byte[] serializeObject(Object obj) throws NamingException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream objOutputStream = new ObjectOutputStream(outputStream);
            objOutputStream.writeObject(obj);
            objOutputStream.close();
            return outputStream.toByteArray();
        }
        catch (IOException io_ex) {
            NamingException naming_ex = new NamingException();
            naming_ex.setRootCause(io_ex);
            throw naming_ex;
        }
    }

    public static Reference convertElementToRef(IElement elmnt, boolean verboseTracing) throws NamingException {
        try {
            IAttributeSet attrs = elmnt.getAttributes();
            String classname = (String)attrs.getAttribute("classname");
            if (classname == null) {
                throw new NameNotFoundException(classname);
            }
            String factoryclassname = (String)attrs.getAttribute("factoryclassname");
            String factorylocation = (String)attrs.getAttribute("factorylocation");
            Reference obj = new Reference(classname, factoryclassname, factorylocation);
            IAttributeList list = (IAttributeList)attrs.getAttribute("RefAdresses");
            if (list != null) {
                for (int j = 0; j < list.getCount(); ++j) {
                    IAttributeSet set = (IAttributeSet)list.getItem(j);
                    HashMap addrs = set.getAttributes();
                    for (String type : addrs.keySet()) {
                        Object addr = addrs.get(type);
                        if (addr instanceof String) {
                            obj.add(new StringRefAddr(type, (String)addr));
                            continue;
                        }
                        obj.add(new BinaryRefAddr(type, (byte[])addr));
                    }
                }
            }
            return obj;
        }
        catch (Exception ex) {
            ObjHelper.throwNamingException(ex, verboseTracing);
            return null;
        }
    }

    public static void throwNamingException(Exception e, boolean verboseTracing) throws NamingException {
        if (e instanceof NamingException) {
            throw (NamingException)e;
        }
        if (e instanceof MFSecurityException) {
            throw new NoPermissionException("Not authorized");
        }
        NamingException namingException = new NamingException(e.getMessage());
        if (e instanceof DirectoryDoesNotExistException) {
            namingException = new NameNotFoundException(e.getMessage());
        }
        if (namingException == null) {
            namingException = new NamingException(e.getMessage());
        }
        if (verboseTracing) {
            namingException.setRootCause(e);
        }
        throw namingException;
    }
}

