/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common;

import com.sonicsw.mf.common.MFRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;

public class MFProxyRuntimeException
extends MFRuntimeException {
    private static final long serialVersionUID = 8192287077613976467L;
    private static final short m_serialVersion = 0;
    private String m_actualClass;
    private String m_actualMessage;
    private String m_actualTrace;

    MFProxyRuntimeException(Exception actualException) {
        super(actualException.getMessage(), actualException);
        this.m_actualClass = actualException.getClass().getName();
        this.m_actualTrace = this.getActualStackTrace(actualException);
    }

    public final Exception getActualException() {
        if (super.getCause() != null) {
            return (Exception)super.getCause();
        }
        return this;
    }

    @Override
    public String toString() {
        if (super.getCause() != null) {
            return super.getCause().toString();
        }
        return this.m_actualMessage != null ? this.m_actualClass + ": " + this.m_actualMessage : this.m_actualClass;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (super.getCause() != null) {
            super.getCause().printStackTrace(s);
        } else {
            s.println(this.m_actualTrace);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (super.getCause() != null) {
            super.getCause().printStackTrace(s);
        } else {
            s.println(this.m_actualTrace);
        }
    }

    private String getActualStackTrace(Exception e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out, true);
        e.printStackTrace(writer);
        byte[] data = out.toByteArray();
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String(data);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(4);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("actualClass");
        stream.writeObject(this.m_actualClass);
        stream.writeUTF("actualMessage");
        stream.writeObject(this.m_actualMessage);
        stream.writeUTF("actualTrace");
        stream.writeObject(this.m_actualTrace);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_actualClass = (String)map.get("actualClass");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_actualMessage = (String)map.get("actualMessage");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_actualTrace = (String)map.get("actualTrace");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

