/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.dirconfig;

import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.common.xml.Validator;
import java.io.StringReader;

public final class ElementFactory {
    public static IDirElement createElement(String elementName, String type, String releaseVersion) {
        return new Element(elementName, type, releaseVersion);
    }

    public static IDirElement createElement(String elementName, String type, String releaseVersion, boolean createTemplate) {
        return new Element(elementName, type, releaseVersion, createTemplate);
    }

    public static IDirElement createInstanceElement(String elementName, String type, String releaseVersion, String templateName) {
        return new Element(elementName, type, releaseVersion, templateName);
    }

    public static IDirElement importFromXML(String XMLDocument, String domainName) throws InvalidXMLException {
        Validator xmlValidator = ElementFactory.validateXmlDocumentAndCreateValidator(XMLDocument);
        ElementFactory.validateXml(xmlValidator, XMLDocument, domainName);
        return xmlValidator.getContentHandler().getElement();
    }

    public static IDirElement[] importElementsFromXML(String XMLDocument, String domainName) throws InvalidXMLException {
        Validator xmlValidator = ElementFactory.validateXmlDocumentAndCreateValidator(XMLDocument);
        xmlValidator.setKeepElements(true);
        ElementFactory.validateXml(xmlValidator, XMLDocument, domainName);
        return xmlValidator.getContentHandler().getElements();
    }

    private static void validateXml(Validator xmlValidator, String XMLDocument, String domainName) throws InvalidXMLException {
        xmlValidator.createSAXParser();
        xmlValidator.setDirectoryService(null);
        xmlValidator.setValidation(true);
        try {
            xmlValidator.parseData();
            xmlValidator.resetXMLData((Object)new StringReader(XMLDocument));
            xmlValidator.setContentHandler(domainName);
            xmlValidator.parseData();
        }
        catch (Exception e) {
            throw new InvalidXMLException(e.getMessage());
        }
    }

    private static Validator validateXmlDocumentAndCreateValidator(String XMLDocument) throws InvalidXMLException {
        if (XMLDocument.length() == 0 || XMLDocument == null) {
            throw new InvalidXMLException("XML file can't be empty");
        }
        Validator xmlValidator = new Validator((Object)new StringReader(XMLDocument));
        return xmlValidator;
    }

    public static IDirElement importElementFromXML(String XMLDocument, String domainName, String elType) throws InvalidXMLException {
        IDirElement[] elements = ElementFactory.importElementsFromXML(XMLDocument, domainName);
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].getIdentity().getType().equals(elType)) continue;
            return elements[i];
        }
        return null;
    }
}

