/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.IDeltaBookKeeper;
import com.sonicsw.mf.common.config.query.AttributeName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

abstract class ElementNode
implements IDeltaBookKeeper,
Serializable {
    private static final long serialVersionUID = 0L;
    private ElementNode m_parent;
    protected String m_name;
    protected boolean m_readOnly;
    protected transient boolean m_isNew;
    protected transient boolean m_isModified;

    ElementNode(String name, ElementNode parent) {
        this(name, parent, true);
    }

    ElementNode(String name, ElementNode parent, boolean isNew) {
        this.m_parent = parent;
        this.m_readOnly = false;
        this.m_isModified = false;
        this.m_isNew = isNew;
        this.m_name = name;
    }

    ElementNode deepClone() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(this);
            byte[] bytes = out.toByteArray();
            objectOut.close();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ObjectInputStream objectIn = new ObjectInputStream(in);
            return (ElementNode)objectIn.readObject();
        }
        catch (Exception e) {
            throw new Error("deepClone failed.");
        }
    }

    protected Object cloneWithoutParent() {
        ElementNode parent = this.m_parent;
        this.m_parent = null;
        ElementNode cloned = this.deepClone();
        this.m_parent = parent;
        return cloned;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.m_parent);
        s.writeObject(this.m_name);
        s.writeBoolean(this.m_readOnly);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.m_parent = (ElementNode)s.readObject();
        this.m_name = (String)s.readObject();
        this.m_readOnly = s.readBoolean();
        this.m_isNew = false;
        this.m_isModified = false;
    }

    String getName() {
        return this.getTypedName().toString();
    }

    Object getTypedName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        if (this.m_parent != null) {
            return this.m_parent.getNameFromParent(this);
        }
        return "?";
    }

    boolean checkSubclassingDelta(AttributeName name) {
        if (this.m_parent != null) {
            return this.m_parent.checkSubclassingDelta(name);
        }
        return false;
    }

    String[] checkSubclassingDeletedAttributes(AttributeName name) {
        if (this.m_parent != null) {
            return this.m_parent.checkSubclassingDeletedAttributes(name);
        }
        return new String[0];
    }

    boolean underModifiedList() {
        if (this.m_parent != null) {
            return this.m_parent.underModifiedList();
        }
        return false;
    }

    String getFullName() {
        String fullParentName = "";
        if (this.m_parent != null) {
            fullParentName = this.m_parent.getFullName();
        }
        return fullParentName + "|" + this.getName();
    }

    public AttributeName getCompoundName() {
        String myNameS;
        if (this.m_parent == null) {
            return new AttributeName(((Element)this).getIdentity().getName(), true);
        }
        AttributeName parentName = this.m_parent.getCompoundName();
        Object myName = this.getTypedName();
        String string = myNameS = myName == null ? null : myName.toString();
        if (myNameS != null && myNameS.equals("|")) {
            return parentName;
        }
        if (myName instanceof Integer) {
            return parentName.setNextComponent((Integer)myName);
        }
        if (myName instanceof String) {
            return parentName.setNextComponent(myNameS);
        }
        throw new Error();
    }

    void setNewParent(ElementNode newParent) {
        this.m_parent = newParent;
    }

    void removeFromTree() {
        this.delete();
        this.setReadOnly(true);
        this.m_parent = null;
    }

    void markTreeModified() {
        if (this.m_isNew) {
            return;
        }
        if (this.m_isModified) {
            return;
        }
        this.m_isModified = true;
        if (this.m_parent != null) {
            this.m_parent.markModified(this.getName(), true, false);
        }
    }

    @Override
    public boolean isNew() {
        return this.m_isNew;
    }

    abstract void delete();

    abstract Object getNameFromParent(Object var1);

    abstract void markModified(String var1, boolean var2, boolean var3);

    abstract void setReadOnly(boolean var1);
}

